/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.detective.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Details about the indicators of compromise which are used to determine if a resource is involved in a security
 * incident.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/IndicatorDetail" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class IndicatorDetail implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * Details about the indicator of compromise.
     * </p>
     */
    private TTPsObservedDetail tTPsObservedDetail;
    /**
     * <p>
     * Identifies unusual and impossible user activity for an account.
     * </p>
     */
    private ImpossibleTravelDetail impossibleTravelDetail;
    /**
     * <p>
     * Suspicious IP addresses that are flagged, which indicates critical or severe threats based on threat intelligence
     * by Detective. This indicator is derived from AWS threat intelligence.
     * </p>
     */
    private FlaggedIpAddressDetail flaggedIpAddressDetail;
    /**
     * <p>
     * Contains details about the new geographic location.
     * </p>
     */
    private NewGeolocationDetail newGeolocationDetail;
    /**
     * <p>
     * Contains details about the new Autonomous System Organization (ASO).
     * </p>
     */
    private NewAsoDetail newAsoDetail;
    /**
     * <p>
     * Contains details about the new user agent.
     * </p>
     */
    private NewUserAgentDetail newUserAgentDetail;
    /**
     * <p>
     * Contains details about related findings.
     * </p>
     */
    private RelatedFindingDetail relatedFindingDetail;
    /**
     * <p>
     * Contains details about related finding groups.
     * </p>
     */
    private RelatedFindingGroupDetail relatedFindingGroupDetail;

    /**
     * <p>
     * Details about the indicator of compromise.
     * </p>
     * 
     * @param tTPsObservedDetail
     *        Details about the indicator of compromise.
     */

    public void setTTPsObservedDetail(TTPsObservedDetail tTPsObservedDetail) {
        this.tTPsObservedDetail = tTPsObservedDetail;
    }

    /**
     * <p>
     * Details about the indicator of compromise.
     * </p>
     * 
     * @return Details about the indicator of compromise.
     */

    public TTPsObservedDetail getTTPsObservedDetail() {
        return this.tTPsObservedDetail;
    }

    /**
     * <p>
     * Details about the indicator of compromise.
     * </p>
     * 
     * @param tTPsObservedDetail
     *        Details about the indicator of compromise.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public IndicatorDetail withTTPsObservedDetail(TTPsObservedDetail tTPsObservedDetail) {
        setTTPsObservedDetail(tTPsObservedDetail);
        return this;
    }

    /**
     * <p>
     * Identifies unusual and impossible user activity for an account.
     * </p>
     * 
     * @param impossibleTravelDetail
     *        Identifies unusual and impossible user activity for an account.
     */

    public void setImpossibleTravelDetail(ImpossibleTravelDetail impossibleTravelDetail) {
        this.impossibleTravelDetail = impossibleTravelDetail;
    }

    /**
     * <p>
     * Identifies unusual and impossible user activity for an account.
     * </p>
     * 
     * @return Identifies unusual and impossible user activity for an account.
     */

    public ImpossibleTravelDetail getImpossibleTravelDetail() {
        return this.impossibleTravelDetail;
    }

    /**
     * <p>
     * Identifies unusual and impossible user activity for an account.
     * </p>
     * 
     * @param impossibleTravelDetail
     *        Identifies unusual and impossible user activity for an account.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public IndicatorDetail withImpossibleTravelDetail(ImpossibleTravelDetail impossibleTravelDetail) {
        setImpossibleTravelDetail(impossibleTravelDetail);
        return this;
    }

    /**
     * <p>
     * Suspicious IP addresses that are flagged, which indicates critical or severe threats based on threat intelligence
     * by Detective. This indicator is derived from AWS threat intelligence.
     * </p>
     * 
     * @param flaggedIpAddressDetail
     *        Suspicious IP addresses that are flagged, which indicates critical or severe threats based on threat
     *        intelligence by Detective. This indicator is derived from AWS threat intelligence.
     */

    public void setFlaggedIpAddressDetail(FlaggedIpAddressDetail flaggedIpAddressDetail) {
        this.flaggedIpAddressDetail = flaggedIpAddressDetail;
    }

    /**
     * <p>
     * Suspicious IP addresses that are flagged, which indicates critical or severe threats based on threat intelligence
     * by Detective. This indicator is derived from AWS threat intelligence.
     * </p>
     * 
     * @return Suspicious IP addresses that are flagged, which indicates critical or severe threats based on threat
     *         intelligence by Detective. This indicator is derived from AWS threat intelligence.
     */

    public FlaggedIpAddressDetail getFlaggedIpAddressDetail() {
        return this.flaggedIpAddressDetail;
    }

    /**
     * <p>
     * Suspicious IP addresses that are flagged, which indicates critical or severe threats based on threat intelligence
     * by Detective. This indicator is derived from AWS threat intelligence.
     * </p>
     * 
     * @param flaggedIpAddressDetail
     *        Suspicious IP addresses that are flagged, which indicates critical or severe threats based on threat
     *        intelligence by Detective. This indicator is derived from AWS threat intelligence.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public IndicatorDetail withFlaggedIpAddressDetail(FlaggedIpAddressDetail flaggedIpAddressDetail) {
        setFlaggedIpAddressDetail(flaggedIpAddressDetail);
        return this;
    }

    /**
     * <p>
     * Contains details about the new geographic location.
     * </p>
     * 
     * @param newGeolocationDetail
     *        Contains details about the new geographic location.
     */

    public void setNewGeolocationDetail(NewGeolocationDetail newGeolocationDetail) {
        this.newGeolocationDetail = newGeolocationDetail;
    }

    /**
     * <p>
     * Contains details about the new geographic location.
     * </p>
     * 
     * @return Contains details about the new geographic location.
     */

    public NewGeolocationDetail getNewGeolocationDetail() {
        return this.newGeolocationDetail;
    }

    /**
     * <p>
     * Contains details about the new geographic location.
     * </p>
     * 
     * @param newGeolocationDetail
     *        Contains details about the new geographic location.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public IndicatorDetail withNewGeolocationDetail(NewGeolocationDetail newGeolocationDetail) {
        setNewGeolocationDetail(newGeolocationDetail);
        return this;
    }

    /**
     * <p>
     * Contains details about the new Autonomous System Organization (ASO).
     * </p>
     * 
     * @param newAsoDetail
     *        Contains details about the new Autonomous System Organization (ASO).
     */

    public void setNewAsoDetail(NewAsoDetail newAsoDetail) {
        this.newAsoDetail = newAsoDetail;
    }

    /**
     * <p>
     * Contains details about the new Autonomous System Organization (ASO).
     * </p>
     * 
     * @return Contains details about the new Autonomous System Organization (ASO).
     */

    public NewAsoDetail getNewAsoDetail() {
        return this.newAsoDetail;
    }

    /**
     * <p>
     * Contains details about the new Autonomous System Organization (ASO).
     * </p>
     * 
     * @param newAsoDetail
     *        Contains details about the new Autonomous System Organization (ASO).
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public IndicatorDetail withNewAsoDetail(NewAsoDetail newAsoDetail) {
        setNewAsoDetail(newAsoDetail);
        return this;
    }

    /**
     * <p>
     * Contains details about the new user agent.
     * </p>
     * 
     * @param newUserAgentDetail
     *        Contains details about the new user agent.
     */

    public void setNewUserAgentDetail(NewUserAgentDetail newUserAgentDetail) {
        this.newUserAgentDetail = newUserAgentDetail;
    }

    /**
     * <p>
     * Contains details about the new user agent.
     * </p>
     * 
     * @return Contains details about the new user agent.
     */

    public NewUserAgentDetail getNewUserAgentDetail() {
        return this.newUserAgentDetail;
    }

    /**
     * <p>
     * Contains details about the new user agent.
     * </p>
     * 
     * @param newUserAgentDetail
     *        Contains details about the new user agent.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public IndicatorDetail withNewUserAgentDetail(NewUserAgentDetail newUserAgentDetail) {
        setNewUserAgentDetail(newUserAgentDetail);
        return this;
    }

    /**
     * <p>
     * Contains details about related findings.
     * </p>
     * 
     * @param relatedFindingDetail
     *        Contains details about related findings.
     */

    public void setRelatedFindingDetail(RelatedFindingDetail relatedFindingDetail) {
        this.relatedFindingDetail = relatedFindingDetail;
    }

    /**
     * <p>
     * Contains details about related findings.
     * </p>
     * 
     * @return Contains details about related findings.
     */

    public RelatedFindingDetail getRelatedFindingDetail() {
        return this.relatedFindingDetail;
    }

    /**
     * <p>
     * Contains details about related findings.
     * </p>
     * 
     * @param relatedFindingDetail
     *        Contains details about related findings.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public IndicatorDetail withRelatedFindingDetail(RelatedFindingDetail relatedFindingDetail) {
        setRelatedFindingDetail(relatedFindingDetail);
        return this;
    }

    /**
     * <p>
     * Contains details about related finding groups.
     * </p>
     * 
     * @param relatedFindingGroupDetail
     *        Contains details about related finding groups.
     */

    public void setRelatedFindingGroupDetail(RelatedFindingGroupDetail relatedFindingGroupDetail) {
        this.relatedFindingGroupDetail = relatedFindingGroupDetail;
    }

    /**
     * <p>
     * Contains details about related finding groups.
     * </p>
     * 
     * @return Contains details about related finding groups.
     */

    public RelatedFindingGroupDetail getRelatedFindingGroupDetail() {
        return this.relatedFindingGroupDetail;
    }

    /**
     * <p>
     * Contains details about related finding groups.
     * </p>
     * 
     * @param relatedFindingGroupDetail
     *        Contains details about related finding groups.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public IndicatorDetail withRelatedFindingGroupDetail(RelatedFindingGroupDetail relatedFindingGroupDetail) {
        setRelatedFindingGroupDetail(relatedFindingGroupDetail);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getTTPsObservedDetail() != null)
            sb.append("TTPsObservedDetail: ").append(getTTPsObservedDetail()).append(",");
        if (getImpossibleTravelDetail() != null)
            sb.append("ImpossibleTravelDetail: ").append(getImpossibleTravelDetail()).append(",");
        if (getFlaggedIpAddressDetail() != null)
            sb.append("FlaggedIpAddressDetail: ").append(getFlaggedIpAddressDetail()).append(",");
        if (getNewGeolocationDetail() != null)
            sb.append("NewGeolocationDetail: ").append(getNewGeolocationDetail()).append(",");
        if (getNewAsoDetail() != null)
            sb.append("NewAsoDetail: ").append(getNewAsoDetail()).append(",");
        if (getNewUserAgentDetail() != null)
            sb.append("NewUserAgentDetail: ").append(getNewUserAgentDetail()).append(",");
        if (getRelatedFindingDetail() != null)
            sb.append("RelatedFindingDetail: ").append(getRelatedFindingDetail()).append(",");
        if (getRelatedFindingGroupDetail() != null)
            sb.append("RelatedFindingGroupDetail: ").append(getRelatedFindingGroupDetail());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof IndicatorDetail == false)
            return false;
        IndicatorDetail other = (IndicatorDetail) obj;
        if (other.getTTPsObservedDetail() == null ^ this.getTTPsObservedDetail() == null)
            return false;
        if (other.getTTPsObservedDetail() != null && other.getTTPsObservedDetail().equals(this.getTTPsObservedDetail()) == false)
            return false;
        if (other.getImpossibleTravelDetail() == null ^ this.getImpossibleTravelDetail() == null)
            return false;
        if (other.getImpossibleTravelDetail() != null && other.getImpossibleTravelDetail().equals(this.getImpossibleTravelDetail()) == false)
            return false;
        if (other.getFlaggedIpAddressDetail() == null ^ this.getFlaggedIpAddressDetail() == null)
            return false;
        if (other.getFlaggedIpAddressDetail() != null && other.getFlaggedIpAddressDetail().equals(this.getFlaggedIpAddressDetail()) == false)
            return false;
        if (other.getNewGeolocationDetail() == null ^ this.getNewGeolocationDetail() == null)
            return false;
        if (other.getNewGeolocationDetail() != null && other.getNewGeolocationDetail().equals(this.getNewGeolocationDetail()) == false)
            return false;
        if (other.getNewAsoDetail() == null ^ this.getNewAsoDetail() == null)
            return false;
        if (other.getNewAsoDetail() != null && other.getNewAsoDetail().equals(this.getNewAsoDetail()) == false)
            return false;
        if (other.getNewUserAgentDetail() == null ^ this.getNewUserAgentDetail() == null)
            return false;
        if (other.getNewUserAgentDetail() != null && other.getNewUserAgentDetail().equals(this.getNewUserAgentDetail()) == false)
            return false;
        if (other.getRelatedFindingDetail() == null ^ this.getRelatedFindingDetail() == null)
            return false;
        if (other.getRelatedFindingDetail() != null && other.getRelatedFindingDetail().equals(this.getRelatedFindingDetail()) == false)
            return false;
        if (other.getRelatedFindingGroupDetail() == null ^ this.getRelatedFindingGroupDetail() == null)
            return false;
        if (other.getRelatedFindingGroupDetail() != null && other.getRelatedFindingGroupDetail().equals(this.getRelatedFindingGroupDetail()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getTTPsObservedDetail() == null) ? 0 : getTTPsObservedDetail().hashCode());
        hashCode = prime * hashCode + ((getImpossibleTravelDetail() == null) ? 0 : getImpossibleTravelDetail().hashCode());
        hashCode = prime * hashCode + ((getFlaggedIpAddressDetail() == null) ? 0 : getFlaggedIpAddressDetail().hashCode());
        hashCode = prime * hashCode + ((getNewGeolocationDetail() == null) ? 0 : getNewGeolocationDetail().hashCode());
        hashCode = prime * hashCode + ((getNewAsoDetail() == null) ? 0 : getNewAsoDetail().hashCode());
        hashCode = prime * hashCode + ((getNewUserAgentDetail() == null) ? 0 : getNewUserAgentDetail().hashCode());
        hashCode = prime * hashCode + ((getRelatedFindingDetail() == null) ? 0 : getRelatedFindingDetail().hashCode());
        hashCode = prime * hashCode + ((getRelatedFindingGroupDetail() == null) ? 0 : getRelatedFindingGroupDetail().hashCode());
        return hashCode;
    }

    @Override
    public IndicatorDetail clone() {
        try {
            return (IndicatorDetail) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.detective.model.transform.IndicatorDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
