/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.iotroborunner;

import javax.annotation.Generated;

import com.amazonaws.services.iotroborunner.model.*;

/**
 * Abstract implementation of {@code AWSIoTRoboRunnerAsync}. Convenient method forms pass through to the corresponding
 * overload that takes a request object and an {@code AsyncHandler}, which throws an
 * {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSIoTRoboRunnerAsync extends AbstractAWSIoTRoboRunner implements AWSIoTRoboRunnerAsync {

    protected AbstractAWSIoTRoboRunnerAsync() {
    }

    @Override
    public java.util.concurrent.Future<CreateDestinationResult> createDestinationAsync(CreateDestinationRequest request) {

        return createDestinationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateDestinationResult> createDestinationAsync(CreateDestinationRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateDestinationRequest, CreateDestinationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateSiteResult> createSiteAsync(CreateSiteRequest request) {

        return createSiteAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateSiteResult> createSiteAsync(CreateSiteRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateSiteRequest, CreateSiteResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateWorkerResult> createWorkerAsync(CreateWorkerRequest request) {

        return createWorkerAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateWorkerResult> createWorkerAsync(CreateWorkerRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateWorkerRequest, CreateWorkerResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateWorkerFleetResult> createWorkerFleetAsync(CreateWorkerFleetRequest request) {

        return createWorkerFleetAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateWorkerFleetResult> createWorkerFleetAsync(CreateWorkerFleetRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateWorkerFleetRequest, CreateWorkerFleetResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteDestinationResult> deleteDestinationAsync(DeleteDestinationRequest request) {

        return deleteDestinationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteDestinationResult> deleteDestinationAsync(DeleteDestinationRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteDestinationRequest, DeleteDestinationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteSiteResult> deleteSiteAsync(DeleteSiteRequest request) {

        return deleteSiteAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteSiteResult> deleteSiteAsync(DeleteSiteRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteSiteRequest, DeleteSiteResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteWorkerResult> deleteWorkerAsync(DeleteWorkerRequest request) {

        return deleteWorkerAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteWorkerResult> deleteWorkerAsync(DeleteWorkerRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteWorkerRequest, DeleteWorkerResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteWorkerFleetResult> deleteWorkerFleetAsync(DeleteWorkerFleetRequest request) {

        return deleteWorkerFleetAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteWorkerFleetResult> deleteWorkerFleetAsync(DeleteWorkerFleetRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteWorkerFleetRequest, DeleteWorkerFleetResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetDestinationResult> getDestinationAsync(GetDestinationRequest request) {

        return getDestinationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetDestinationResult> getDestinationAsync(GetDestinationRequest request,
            com.amazonaws.handlers.AsyncHandler<GetDestinationRequest, GetDestinationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetSiteResult> getSiteAsync(GetSiteRequest request) {

        return getSiteAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetSiteResult> getSiteAsync(GetSiteRequest request,
            com.amazonaws.handlers.AsyncHandler<GetSiteRequest, GetSiteResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetWorkerResult> getWorkerAsync(GetWorkerRequest request) {

        return getWorkerAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetWorkerResult> getWorkerAsync(GetWorkerRequest request,
            com.amazonaws.handlers.AsyncHandler<GetWorkerRequest, GetWorkerResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetWorkerFleetResult> getWorkerFleetAsync(GetWorkerFleetRequest request) {

        return getWorkerFleetAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetWorkerFleetResult> getWorkerFleetAsync(GetWorkerFleetRequest request,
            com.amazonaws.handlers.AsyncHandler<GetWorkerFleetRequest, GetWorkerFleetResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListDestinationsResult> listDestinationsAsync(ListDestinationsRequest request) {

        return listDestinationsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListDestinationsResult> listDestinationsAsync(ListDestinationsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListDestinationsRequest, ListDestinationsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListSitesResult> listSitesAsync(ListSitesRequest request) {

        return listSitesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListSitesResult> listSitesAsync(ListSitesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListSitesRequest, ListSitesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListWorkerFleetsResult> listWorkerFleetsAsync(ListWorkerFleetsRequest request) {

        return listWorkerFleetsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListWorkerFleetsResult> listWorkerFleetsAsync(ListWorkerFleetsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListWorkerFleetsRequest, ListWorkerFleetsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListWorkersResult> listWorkersAsync(ListWorkersRequest request) {

        return listWorkersAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListWorkersResult> listWorkersAsync(ListWorkersRequest request,
            com.amazonaws.handlers.AsyncHandler<ListWorkersRequest, ListWorkersResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateDestinationResult> updateDestinationAsync(UpdateDestinationRequest request) {

        return updateDestinationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateDestinationResult> updateDestinationAsync(UpdateDestinationRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateDestinationRequest, UpdateDestinationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateSiteResult> updateSiteAsync(UpdateSiteRequest request) {

        return updateSiteAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateSiteResult> updateSiteAsync(UpdateSiteRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateSiteRequest, UpdateSiteResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateWorkerResult> updateWorkerAsync(UpdateWorkerRequest request) {

        return updateWorkerAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateWorkerResult> updateWorkerAsync(UpdateWorkerRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateWorkerRequest, UpdateWorkerResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateWorkerFleetResult> updateWorkerFleetAsync(UpdateWorkerFleetRequest request) {

        return updateWorkerFleetAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateWorkerFleetResult> updateWorkerFleetAsync(UpdateWorkerFleetRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateWorkerFleetRequest, UpdateWorkerFleetResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

}
