/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.mainframemodernization.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListDataSets" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListDataSetsRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The unique identifier of the application for which you want to list the associated data sets.
     * </p>
     */
    private String applicationId;
    /**
     * <p>
     * The maximum number of objects to return.
     * </p>
     */
    private Integer maxResults;
    /**
     * <p>
     * Filter dataset name matching the specified pattern. Can use * and % as wild cards.
     * </p>
     */
    private String nameFilter;
    /**
     * <p>
     * A pagination token returned from a previous call to this operation. This specifies the next item to return. To
     * return to the beginning of the list, exclude this parameter.
     * </p>
     */
    private String nextToken;
    /**
     * <p>
     * The prefix of the data set name, which you can use to filter the list of data sets.
     * </p>
     */
    private String prefix;

    /**
     * <p>
     * The unique identifier of the application for which you want to list the associated data sets.
     * </p>
     * 
     * @param applicationId
     *        The unique identifier of the application for which you want to list the associated data sets.
     */

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    /**
     * <p>
     * The unique identifier of the application for which you want to list the associated data sets.
     * </p>
     * 
     * @return The unique identifier of the application for which you want to list the associated data sets.
     */

    public String getApplicationId() {
        return this.applicationId;
    }

    /**
     * <p>
     * The unique identifier of the application for which you want to list the associated data sets.
     * </p>
     * 
     * @param applicationId
     *        The unique identifier of the application for which you want to list the associated data sets.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListDataSetsRequest withApplicationId(String applicationId) {
        setApplicationId(applicationId);
        return this;
    }

    /**
     * <p>
     * The maximum number of objects to return.
     * </p>
     * 
     * @param maxResults
     *        The maximum number of objects to return.
     */

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    /**
     * <p>
     * The maximum number of objects to return.
     * </p>
     * 
     * @return The maximum number of objects to return.
     */

    public Integer getMaxResults() {
        return this.maxResults;
    }

    /**
     * <p>
     * The maximum number of objects to return.
     * </p>
     * 
     * @param maxResults
     *        The maximum number of objects to return.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListDataSetsRequest withMaxResults(Integer maxResults) {
        setMaxResults(maxResults);
        return this;
    }

    /**
     * <p>
     * Filter dataset name matching the specified pattern. Can use * and % as wild cards.
     * </p>
     * 
     * @param nameFilter
     *        Filter dataset name matching the specified pattern. Can use * and % as wild cards.
     */

    public void setNameFilter(String nameFilter) {
        this.nameFilter = nameFilter;
    }

    /**
     * <p>
     * Filter dataset name matching the specified pattern. Can use * and % as wild cards.
     * </p>
     * 
     * @return Filter dataset name matching the specified pattern. Can use * and % as wild cards.
     */

    public String getNameFilter() {
        return this.nameFilter;
    }

    /**
     * <p>
     * Filter dataset name matching the specified pattern. Can use * and % as wild cards.
     * </p>
     * 
     * @param nameFilter
     *        Filter dataset name matching the specified pattern. Can use * and % as wild cards.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListDataSetsRequest withNameFilter(String nameFilter) {
        setNameFilter(nameFilter);
        return this;
    }

    /**
     * <p>
     * A pagination token returned from a previous call to this operation. This specifies the next item to return. To
     * return to the beginning of the list, exclude this parameter.
     * </p>
     * 
     * @param nextToken
     *        A pagination token returned from a previous call to this operation. This specifies the next item to
     *        return. To return to the beginning of the list, exclude this parameter.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * A pagination token returned from a previous call to this operation. This specifies the next item to return. To
     * return to the beginning of the list, exclude this parameter.
     * </p>
     * 
     * @return A pagination token returned from a previous call to this operation. This specifies the next item to
     *         return. To return to the beginning of the list, exclude this parameter.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * A pagination token returned from a previous call to this operation. This specifies the next item to return. To
     * return to the beginning of the list, exclude this parameter.
     * </p>
     * 
     * @param nextToken
     *        A pagination token returned from a previous call to this operation. This specifies the next item to
     *        return. To return to the beginning of the list, exclude this parameter.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListDataSetsRequest withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * <p>
     * The prefix of the data set name, which you can use to filter the list of data sets.
     * </p>
     * 
     * @param prefix
     *        The prefix of the data set name, which you can use to filter the list of data sets.
     */

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    /**
     * <p>
     * The prefix of the data set name, which you can use to filter the list of data sets.
     * </p>
     * 
     * @return The prefix of the data set name, which you can use to filter the list of data sets.
     */

    public String getPrefix() {
        return this.prefix;
    }

    /**
     * <p>
     * The prefix of the data set name, which you can use to filter the list of data sets.
     * </p>
     * 
     * @param prefix
     *        The prefix of the data set name, which you can use to filter the list of data sets.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListDataSetsRequest withPrefix(String prefix) {
        setPrefix(prefix);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getApplicationId() != null)
            sb.append("ApplicationId: ").append(getApplicationId()).append(",");
        if (getMaxResults() != null)
            sb.append("MaxResults: ").append(getMaxResults()).append(",");
        if (getNameFilter() != null)
            sb.append("NameFilter: ").append(getNameFilter()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken()).append(",");
        if (getPrefix() != null)
            sb.append("Prefix: ").append(getPrefix());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListDataSetsRequest == false)
            return false;
        ListDataSetsRequest other = (ListDataSetsRequest) obj;
        if (other.getApplicationId() == null ^ this.getApplicationId() == null)
            return false;
        if (other.getApplicationId() != null && other.getApplicationId().equals(this.getApplicationId()) == false)
            return false;
        if (other.getMaxResults() == null ^ this.getMaxResults() == null)
            return false;
        if (other.getMaxResults() != null && other.getMaxResults().equals(this.getMaxResults()) == false)
            return false;
        if (other.getNameFilter() == null ^ this.getNameFilter() == null)
            return false;
        if (other.getNameFilter() != null && other.getNameFilter().equals(this.getNameFilter()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        if (other.getPrefix() == null ^ this.getPrefix() == null)
            return false;
        if (other.getPrefix() != null && other.getPrefix().equals(this.getPrefix()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getApplicationId() == null) ? 0 : getApplicationId().hashCode());
        hashCode = prime * hashCode + ((getMaxResults() == null) ? 0 : getMaxResults().hashCode());
        hashCode = prime * hashCode + ((getNameFilter() == null) ? 0 : getNameFilter().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        hashCode = prime * hashCode + ((getPrefix() == null) ? 0 : getPrefix().hashCode());
        return hashCode;
    }

    @Override
    public ListDataSetsRequest clone() {
        return (ListDataSetsRequest) super.clone();
    }

}
