/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.pinpointsmsvoicev2;

import javax.annotation.Generated;

import com.amazonaws.services.pinpointsmsvoicev2.model.*;

/**
 * Abstract implementation of {@code AmazonPinpointSMSVoiceV2Async}. Convenient method forms pass through to the
 * corresponding overload that takes a request object and an {@code AsyncHandler}, which throws an
 * {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonPinpointSMSVoiceV2Async extends AbstractAmazonPinpointSMSVoiceV2 implements AmazonPinpointSMSVoiceV2Async {

    protected AbstractAmazonPinpointSMSVoiceV2Async() {
    }

    @Override
    public java.util.concurrent.Future<AssociateOriginationIdentityResult> associateOriginationIdentityAsync(AssociateOriginationIdentityRequest request) {

        return associateOriginationIdentityAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<AssociateOriginationIdentityResult> associateOriginationIdentityAsync(AssociateOriginationIdentityRequest request,
            com.amazonaws.handlers.AsyncHandler<AssociateOriginationIdentityRequest, AssociateOriginationIdentityResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateConfigurationSetResult> createConfigurationSetAsync(CreateConfigurationSetRequest request) {

        return createConfigurationSetAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateConfigurationSetResult> createConfigurationSetAsync(CreateConfigurationSetRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateConfigurationSetRequest, CreateConfigurationSetResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateEventDestinationResult> createEventDestinationAsync(CreateEventDestinationRequest request) {

        return createEventDestinationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateEventDestinationResult> createEventDestinationAsync(CreateEventDestinationRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateEventDestinationRequest, CreateEventDestinationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateOptOutListResult> createOptOutListAsync(CreateOptOutListRequest request) {

        return createOptOutListAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateOptOutListResult> createOptOutListAsync(CreateOptOutListRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateOptOutListRequest, CreateOptOutListResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreatePoolResult> createPoolAsync(CreatePoolRequest request) {

        return createPoolAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreatePoolResult> createPoolAsync(CreatePoolRequest request,
            com.amazonaws.handlers.AsyncHandler<CreatePoolRequest, CreatePoolResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateRegistrationResult> createRegistrationAsync(CreateRegistrationRequest request) {

        return createRegistrationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateRegistrationResult> createRegistrationAsync(CreateRegistrationRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateRegistrationRequest, CreateRegistrationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateRegistrationAssociationResult> createRegistrationAssociationAsync(CreateRegistrationAssociationRequest request) {

        return createRegistrationAssociationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateRegistrationAssociationResult> createRegistrationAssociationAsync(CreateRegistrationAssociationRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateRegistrationAssociationRequest, CreateRegistrationAssociationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateRegistrationAttachmentResult> createRegistrationAttachmentAsync(CreateRegistrationAttachmentRequest request) {

        return createRegistrationAttachmentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateRegistrationAttachmentResult> createRegistrationAttachmentAsync(CreateRegistrationAttachmentRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateRegistrationAttachmentRequest, CreateRegistrationAttachmentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateRegistrationVersionResult> createRegistrationVersionAsync(CreateRegistrationVersionRequest request) {

        return createRegistrationVersionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateRegistrationVersionResult> createRegistrationVersionAsync(CreateRegistrationVersionRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateRegistrationVersionRequest, CreateRegistrationVersionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateVerifiedDestinationNumberResult> createVerifiedDestinationNumberAsync(
            CreateVerifiedDestinationNumberRequest request) {

        return createVerifiedDestinationNumberAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateVerifiedDestinationNumberResult> createVerifiedDestinationNumberAsync(
            CreateVerifiedDestinationNumberRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateVerifiedDestinationNumberRequest, CreateVerifiedDestinationNumberResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteConfigurationSetResult> deleteConfigurationSetAsync(DeleteConfigurationSetRequest request) {

        return deleteConfigurationSetAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteConfigurationSetResult> deleteConfigurationSetAsync(DeleteConfigurationSetRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteConfigurationSetRequest, DeleteConfigurationSetResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteDefaultMessageTypeResult> deleteDefaultMessageTypeAsync(DeleteDefaultMessageTypeRequest request) {

        return deleteDefaultMessageTypeAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteDefaultMessageTypeResult> deleteDefaultMessageTypeAsync(DeleteDefaultMessageTypeRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteDefaultMessageTypeRequest, DeleteDefaultMessageTypeResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteDefaultSenderIdResult> deleteDefaultSenderIdAsync(DeleteDefaultSenderIdRequest request) {

        return deleteDefaultSenderIdAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteDefaultSenderIdResult> deleteDefaultSenderIdAsync(DeleteDefaultSenderIdRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteDefaultSenderIdRequest, DeleteDefaultSenderIdResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteEventDestinationResult> deleteEventDestinationAsync(DeleteEventDestinationRequest request) {

        return deleteEventDestinationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteEventDestinationResult> deleteEventDestinationAsync(DeleteEventDestinationRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteEventDestinationRequest, DeleteEventDestinationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteKeywordResult> deleteKeywordAsync(DeleteKeywordRequest request) {

        return deleteKeywordAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteKeywordResult> deleteKeywordAsync(DeleteKeywordRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteKeywordRequest, DeleteKeywordResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteOptOutListResult> deleteOptOutListAsync(DeleteOptOutListRequest request) {

        return deleteOptOutListAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteOptOutListResult> deleteOptOutListAsync(DeleteOptOutListRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteOptOutListRequest, DeleteOptOutListResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteOptedOutNumberResult> deleteOptedOutNumberAsync(DeleteOptedOutNumberRequest request) {

        return deleteOptedOutNumberAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteOptedOutNumberResult> deleteOptedOutNumberAsync(DeleteOptedOutNumberRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteOptedOutNumberRequest, DeleteOptedOutNumberResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeletePoolResult> deletePoolAsync(DeletePoolRequest request) {

        return deletePoolAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeletePoolResult> deletePoolAsync(DeletePoolRequest request,
            com.amazonaws.handlers.AsyncHandler<DeletePoolRequest, DeletePoolResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteRegistrationResult> deleteRegistrationAsync(DeleteRegistrationRequest request) {

        return deleteRegistrationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteRegistrationResult> deleteRegistrationAsync(DeleteRegistrationRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteRegistrationRequest, DeleteRegistrationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteRegistrationAttachmentResult> deleteRegistrationAttachmentAsync(DeleteRegistrationAttachmentRequest request) {

        return deleteRegistrationAttachmentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteRegistrationAttachmentResult> deleteRegistrationAttachmentAsync(DeleteRegistrationAttachmentRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteRegistrationAttachmentRequest, DeleteRegistrationAttachmentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteRegistrationFieldValueResult> deleteRegistrationFieldValueAsync(DeleteRegistrationFieldValueRequest request) {

        return deleteRegistrationFieldValueAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteRegistrationFieldValueResult> deleteRegistrationFieldValueAsync(DeleteRegistrationFieldValueRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteRegistrationFieldValueRequest, DeleteRegistrationFieldValueResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteTextMessageSpendLimitOverrideResult> deleteTextMessageSpendLimitOverrideAsync(
            DeleteTextMessageSpendLimitOverrideRequest request) {

        return deleteTextMessageSpendLimitOverrideAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteTextMessageSpendLimitOverrideResult> deleteTextMessageSpendLimitOverrideAsync(
            DeleteTextMessageSpendLimitOverrideRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteTextMessageSpendLimitOverrideRequest, DeleteTextMessageSpendLimitOverrideResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteVerifiedDestinationNumberResult> deleteVerifiedDestinationNumberAsync(
            DeleteVerifiedDestinationNumberRequest request) {

        return deleteVerifiedDestinationNumberAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteVerifiedDestinationNumberResult> deleteVerifiedDestinationNumberAsync(
            DeleteVerifiedDestinationNumberRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteVerifiedDestinationNumberRequest, DeleteVerifiedDestinationNumberResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteVoiceMessageSpendLimitOverrideResult> deleteVoiceMessageSpendLimitOverrideAsync(
            DeleteVoiceMessageSpendLimitOverrideRequest request) {

        return deleteVoiceMessageSpendLimitOverrideAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteVoiceMessageSpendLimitOverrideResult> deleteVoiceMessageSpendLimitOverrideAsync(
            DeleteVoiceMessageSpendLimitOverrideRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteVoiceMessageSpendLimitOverrideRequest, DeleteVoiceMessageSpendLimitOverrideResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeAccountAttributesResult> describeAccountAttributesAsync(DescribeAccountAttributesRequest request) {

        return describeAccountAttributesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeAccountAttributesResult> describeAccountAttributesAsync(DescribeAccountAttributesRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeAccountAttributesRequest, DescribeAccountAttributesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeAccountLimitsResult> describeAccountLimitsAsync(DescribeAccountLimitsRequest request) {

        return describeAccountLimitsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeAccountLimitsResult> describeAccountLimitsAsync(DescribeAccountLimitsRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeAccountLimitsRequest, DescribeAccountLimitsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeConfigurationSetsResult> describeConfigurationSetsAsync(DescribeConfigurationSetsRequest request) {

        return describeConfigurationSetsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeConfigurationSetsResult> describeConfigurationSetsAsync(DescribeConfigurationSetsRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeConfigurationSetsRequest, DescribeConfigurationSetsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeKeywordsResult> describeKeywordsAsync(DescribeKeywordsRequest request) {

        return describeKeywordsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeKeywordsResult> describeKeywordsAsync(DescribeKeywordsRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeKeywordsRequest, DescribeKeywordsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeOptOutListsResult> describeOptOutListsAsync(DescribeOptOutListsRequest request) {

        return describeOptOutListsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeOptOutListsResult> describeOptOutListsAsync(DescribeOptOutListsRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeOptOutListsRequest, DescribeOptOutListsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeOptedOutNumbersResult> describeOptedOutNumbersAsync(DescribeOptedOutNumbersRequest request) {

        return describeOptedOutNumbersAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeOptedOutNumbersResult> describeOptedOutNumbersAsync(DescribeOptedOutNumbersRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeOptedOutNumbersRequest, DescribeOptedOutNumbersResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribePhoneNumbersResult> describePhoneNumbersAsync(DescribePhoneNumbersRequest request) {

        return describePhoneNumbersAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribePhoneNumbersResult> describePhoneNumbersAsync(DescribePhoneNumbersRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribePhoneNumbersRequest, DescribePhoneNumbersResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribePoolsResult> describePoolsAsync(DescribePoolsRequest request) {

        return describePoolsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribePoolsResult> describePoolsAsync(DescribePoolsRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribePoolsRequest, DescribePoolsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeRegistrationAttachmentsResult> describeRegistrationAttachmentsAsync(
            DescribeRegistrationAttachmentsRequest request) {

        return describeRegistrationAttachmentsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeRegistrationAttachmentsResult> describeRegistrationAttachmentsAsync(
            DescribeRegistrationAttachmentsRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeRegistrationAttachmentsRequest, DescribeRegistrationAttachmentsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeRegistrationFieldDefinitionsResult> describeRegistrationFieldDefinitionsAsync(
            DescribeRegistrationFieldDefinitionsRequest request) {

        return describeRegistrationFieldDefinitionsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeRegistrationFieldDefinitionsResult> describeRegistrationFieldDefinitionsAsync(
            DescribeRegistrationFieldDefinitionsRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeRegistrationFieldDefinitionsRequest, DescribeRegistrationFieldDefinitionsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeRegistrationFieldValuesResult> describeRegistrationFieldValuesAsync(
            DescribeRegistrationFieldValuesRequest request) {

        return describeRegistrationFieldValuesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeRegistrationFieldValuesResult> describeRegistrationFieldValuesAsync(
            DescribeRegistrationFieldValuesRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeRegistrationFieldValuesRequest, DescribeRegistrationFieldValuesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeRegistrationSectionDefinitionsResult> describeRegistrationSectionDefinitionsAsync(
            DescribeRegistrationSectionDefinitionsRequest request) {

        return describeRegistrationSectionDefinitionsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeRegistrationSectionDefinitionsResult> describeRegistrationSectionDefinitionsAsync(
            DescribeRegistrationSectionDefinitionsRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeRegistrationSectionDefinitionsRequest, DescribeRegistrationSectionDefinitionsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeRegistrationTypeDefinitionsResult> describeRegistrationTypeDefinitionsAsync(
            DescribeRegistrationTypeDefinitionsRequest request) {

        return describeRegistrationTypeDefinitionsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeRegistrationTypeDefinitionsResult> describeRegistrationTypeDefinitionsAsync(
            DescribeRegistrationTypeDefinitionsRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeRegistrationTypeDefinitionsRequest, DescribeRegistrationTypeDefinitionsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeRegistrationVersionsResult> describeRegistrationVersionsAsync(DescribeRegistrationVersionsRequest request) {

        return describeRegistrationVersionsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeRegistrationVersionsResult> describeRegistrationVersionsAsync(DescribeRegistrationVersionsRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeRegistrationVersionsRequest, DescribeRegistrationVersionsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeRegistrationsResult> describeRegistrationsAsync(DescribeRegistrationsRequest request) {

        return describeRegistrationsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeRegistrationsResult> describeRegistrationsAsync(DescribeRegistrationsRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeRegistrationsRequest, DescribeRegistrationsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeSenderIdsResult> describeSenderIdsAsync(DescribeSenderIdsRequest request) {

        return describeSenderIdsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeSenderIdsResult> describeSenderIdsAsync(DescribeSenderIdsRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeSenderIdsRequest, DescribeSenderIdsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeSpendLimitsResult> describeSpendLimitsAsync(DescribeSpendLimitsRequest request) {

        return describeSpendLimitsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeSpendLimitsResult> describeSpendLimitsAsync(DescribeSpendLimitsRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeSpendLimitsRequest, DescribeSpendLimitsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeVerifiedDestinationNumbersResult> describeVerifiedDestinationNumbersAsync(
            DescribeVerifiedDestinationNumbersRequest request) {

        return describeVerifiedDestinationNumbersAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeVerifiedDestinationNumbersResult> describeVerifiedDestinationNumbersAsync(
            DescribeVerifiedDestinationNumbersRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeVerifiedDestinationNumbersRequest, DescribeVerifiedDestinationNumbersResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DisassociateOriginationIdentityResult> disassociateOriginationIdentityAsync(
            DisassociateOriginationIdentityRequest request) {

        return disassociateOriginationIdentityAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DisassociateOriginationIdentityResult> disassociateOriginationIdentityAsync(
            DisassociateOriginationIdentityRequest request,
            com.amazonaws.handlers.AsyncHandler<DisassociateOriginationIdentityRequest, DisassociateOriginationIdentityResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DiscardRegistrationVersionResult> discardRegistrationVersionAsync(DiscardRegistrationVersionRequest request) {

        return discardRegistrationVersionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DiscardRegistrationVersionResult> discardRegistrationVersionAsync(DiscardRegistrationVersionRequest request,
            com.amazonaws.handlers.AsyncHandler<DiscardRegistrationVersionRequest, DiscardRegistrationVersionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListPoolOriginationIdentitiesResult> listPoolOriginationIdentitiesAsync(ListPoolOriginationIdentitiesRequest request) {

        return listPoolOriginationIdentitiesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListPoolOriginationIdentitiesResult> listPoolOriginationIdentitiesAsync(ListPoolOriginationIdentitiesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListPoolOriginationIdentitiesRequest, ListPoolOriginationIdentitiesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListRegistrationAssociationsResult> listRegistrationAssociationsAsync(ListRegistrationAssociationsRequest request) {

        return listRegistrationAssociationsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListRegistrationAssociationsResult> listRegistrationAssociationsAsync(ListRegistrationAssociationsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListRegistrationAssociationsRequest, ListRegistrationAssociationsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {

        return listTagsForResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<PutKeywordResult> putKeywordAsync(PutKeywordRequest request) {

        return putKeywordAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<PutKeywordResult> putKeywordAsync(PutKeywordRequest request,
            com.amazonaws.handlers.AsyncHandler<PutKeywordRequest, PutKeywordResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<PutOptedOutNumberResult> putOptedOutNumberAsync(PutOptedOutNumberRequest request) {

        return putOptedOutNumberAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<PutOptedOutNumberResult> putOptedOutNumberAsync(PutOptedOutNumberRequest request,
            com.amazonaws.handlers.AsyncHandler<PutOptedOutNumberRequest, PutOptedOutNumberResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<PutRegistrationFieldValueResult> putRegistrationFieldValueAsync(PutRegistrationFieldValueRequest request) {

        return putRegistrationFieldValueAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<PutRegistrationFieldValueResult> putRegistrationFieldValueAsync(PutRegistrationFieldValueRequest request,
            com.amazonaws.handlers.AsyncHandler<PutRegistrationFieldValueRequest, PutRegistrationFieldValueResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ReleasePhoneNumberResult> releasePhoneNumberAsync(ReleasePhoneNumberRequest request) {

        return releasePhoneNumberAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ReleasePhoneNumberResult> releasePhoneNumberAsync(ReleasePhoneNumberRequest request,
            com.amazonaws.handlers.AsyncHandler<ReleasePhoneNumberRequest, ReleasePhoneNumberResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ReleaseSenderIdResult> releaseSenderIdAsync(ReleaseSenderIdRequest request) {

        return releaseSenderIdAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ReleaseSenderIdResult> releaseSenderIdAsync(ReleaseSenderIdRequest request,
            com.amazonaws.handlers.AsyncHandler<ReleaseSenderIdRequest, ReleaseSenderIdResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<RequestPhoneNumberResult> requestPhoneNumberAsync(RequestPhoneNumberRequest request) {

        return requestPhoneNumberAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<RequestPhoneNumberResult> requestPhoneNumberAsync(RequestPhoneNumberRequest request,
            com.amazonaws.handlers.AsyncHandler<RequestPhoneNumberRequest, RequestPhoneNumberResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<RequestSenderIdResult> requestSenderIdAsync(RequestSenderIdRequest request) {

        return requestSenderIdAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<RequestSenderIdResult> requestSenderIdAsync(RequestSenderIdRequest request,
            com.amazonaws.handlers.AsyncHandler<RequestSenderIdRequest, RequestSenderIdResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<SendDestinationNumberVerificationCodeResult> sendDestinationNumberVerificationCodeAsync(
            SendDestinationNumberVerificationCodeRequest request) {

        return sendDestinationNumberVerificationCodeAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<SendDestinationNumberVerificationCodeResult> sendDestinationNumberVerificationCodeAsync(
            SendDestinationNumberVerificationCodeRequest request,
            com.amazonaws.handlers.AsyncHandler<SendDestinationNumberVerificationCodeRequest, SendDestinationNumberVerificationCodeResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<SendTextMessageResult> sendTextMessageAsync(SendTextMessageRequest request) {

        return sendTextMessageAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<SendTextMessageResult> sendTextMessageAsync(SendTextMessageRequest request,
            com.amazonaws.handlers.AsyncHandler<SendTextMessageRequest, SendTextMessageResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<SendVoiceMessageResult> sendVoiceMessageAsync(SendVoiceMessageRequest request) {

        return sendVoiceMessageAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<SendVoiceMessageResult> sendVoiceMessageAsync(SendVoiceMessageRequest request,
            com.amazonaws.handlers.AsyncHandler<SendVoiceMessageRequest, SendVoiceMessageResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<SetDefaultMessageTypeResult> setDefaultMessageTypeAsync(SetDefaultMessageTypeRequest request) {

        return setDefaultMessageTypeAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<SetDefaultMessageTypeResult> setDefaultMessageTypeAsync(SetDefaultMessageTypeRequest request,
            com.amazonaws.handlers.AsyncHandler<SetDefaultMessageTypeRequest, SetDefaultMessageTypeResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<SetDefaultSenderIdResult> setDefaultSenderIdAsync(SetDefaultSenderIdRequest request) {

        return setDefaultSenderIdAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<SetDefaultSenderIdResult> setDefaultSenderIdAsync(SetDefaultSenderIdRequest request,
            com.amazonaws.handlers.AsyncHandler<SetDefaultSenderIdRequest, SetDefaultSenderIdResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<SetTextMessageSpendLimitOverrideResult> setTextMessageSpendLimitOverrideAsync(
            SetTextMessageSpendLimitOverrideRequest request) {

        return setTextMessageSpendLimitOverrideAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<SetTextMessageSpendLimitOverrideResult> setTextMessageSpendLimitOverrideAsync(
            SetTextMessageSpendLimitOverrideRequest request,
            com.amazonaws.handlers.AsyncHandler<SetTextMessageSpendLimitOverrideRequest, SetTextMessageSpendLimitOverrideResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<SetVoiceMessageSpendLimitOverrideResult> setVoiceMessageSpendLimitOverrideAsync(
            SetVoiceMessageSpendLimitOverrideRequest request) {

        return setVoiceMessageSpendLimitOverrideAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<SetVoiceMessageSpendLimitOverrideResult> setVoiceMessageSpendLimitOverrideAsync(
            SetVoiceMessageSpendLimitOverrideRequest request,
            com.amazonaws.handlers.AsyncHandler<SetVoiceMessageSpendLimitOverrideRequest, SetVoiceMessageSpendLimitOverrideResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<SubmitRegistrationVersionResult> submitRegistrationVersionAsync(SubmitRegistrationVersionRequest request) {

        return submitRegistrationVersionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<SubmitRegistrationVersionResult> submitRegistrationVersionAsync(SubmitRegistrationVersionRequest request,
            com.amazonaws.handlers.AsyncHandler<SubmitRegistrationVersionRequest, SubmitRegistrationVersionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {

        return tagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {

        return untagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateEventDestinationResult> updateEventDestinationAsync(UpdateEventDestinationRequest request) {

        return updateEventDestinationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateEventDestinationResult> updateEventDestinationAsync(UpdateEventDestinationRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateEventDestinationRequest, UpdateEventDestinationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdatePhoneNumberResult> updatePhoneNumberAsync(UpdatePhoneNumberRequest request) {

        return updatePhoneNumberAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdatePhoneNumberResult> updatePhoneNumberAsync(UpdatePhoneNumberRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdatePhoneNumberRequest, UpdatePhoneNumberResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdatePoolResult> updatePoolAsync(UpdatePoolRequest request) {

        return updatePoolAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdatePoolResult> updatePoolAsync(UpdatePoolRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdatePoolRequest, UpdatePoolResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateSenderIdResult> updateSenderIdAsync(UpdateSenderIdRequest request) {

        return updateSenderIdAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateSenderIdResult> updateSenderIdAsync(UpdateSenderIdRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateSenderIdRequest, UpdateSenderIdResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<VerifyDestinationNumberResult> verifyDestinationNumberAsync(VerifyDestinationNumberRequest request) {

        return verifyDestinationNumberAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<VerifyDestinationNumberResult> verifyDestinationNumberAsync(VerifyDestinationNumberRequest request,
            com.amazonaws.handlers.AsyncHandler<VerifyDestinationNumberRequest, VerifyDestinationNumberResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

}
