/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.qldbsession.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Contains the details of the committed transaction.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qldb-session-2019-07-11/CommitTransactionResult"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CommitTransactionResult implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The transaction ID of the committed transaction.
     * </p>
     */
    private String transactionId;
    /**
     * <p>
     * The commit digest of the committed transaction.
     * </p>
     */
    private java.nio.ByteBuffer commitDigest;
    /**
     * <p>
     * Contains server-side performance information for the command.
     * </p>
     */
    private TimingInformation timingInformation;
    /**
     * <p>
     * Contains metrics about the number of I/O requests that were consumed.
     * </p>
     */
    private IOUsage consumedIOs;

    /**
     * <p>
     * The transaction ID of the committed transaction.
     * </p>
     * 
     * @param transactionId
     *        The transaction ID of the committed transaction.
     */

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    /**
     * <p>
     * The transaction ID of the committed transaction.
     * </p>
     * 
     * @return The transaction ID of the committed transaction.
     */

    public String getTransactionId() {
        return this.transactionId;
    }

    /**
     * <p>
     * The transaction ID of the committed transaction.
     * </p>
     * 
     * @param transactionId
     *        The transaction ID of the committed transaction.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CommitTransactionResult withTransactionId(String transactionId) {
        setTransactionId(transactionId);
        return this;
    }

    /**
     * <p>
     * The commit digest of the committed transaction.
     * </p>
     * <p>
     * The AWS SDK for Java performs a Base64 encoding on this field before sending this request to the AWS service.
     * Users of the SDK should not perform Base64 encoding on this field.
     * </p>
     * <p>
     * Warning: ByteBuffers returned by the SDK are mutable. Changes to the content or position of the byte buffer will
     * be seen by all objects that have a reference to this object. It is recommended to call ByteBuffer.duplicate() or
     * ByteBuffer.asReadOnlyBuffer() before using or reading from the buffer. This behavior will be changed in a future
     * major version of the SDK.
     * </p>
     * 
     * @param commitDigest
     *        The commit digest of the committed transaction.
     */

    public void setCommitDigest(java.nio.ByteBuffer commitDigest) {
        this.commitDigest = commitDigest;
    }

    /**
     * <p>
     * The commit digest of the committed transaction.
     * </p>
     * <p>
     * {@code ByteBuffer}s are stateful. Calling their {@code get} methods changes their {@code position}. We recommend
     * using {@link java.nio.ByteBuffer#asReadOnlyBuffer()} to create a read-only view of the buffer with an independent
     * {@code position}, and calling {@code get} methods on this rather than directly on the returned {@code ByteBuffer}.
     * Doing so will ensure that anyone else using the {@code ByteBuffer} will not be affected by changes to the
     * {@code position}.
     * </p>
     * 
     * @return The commit digest of the committed transaction.
     */

    public java.nio.ByteBuffer getCommitDigest() {
        return this.commitDigest;
    }

    /**
     * <p>
     * The commit digest of the committed transaction.
     * </p>
     * <p>
     * The AWS SDK for Java performs a Base64 encoding on this field before sending this request to the AWS service.
     * Users of the SDK should not perform Base64 encoding on this field.
     * </p>
     * <p>
     * Warning: ByteBuffers returned by the SDK are mutable. Changes to the content or position of the byte buffer will
     * be seen by all objects that have a reference to this object. It is recommended to call ByteBuffer.duplicate() or
     * ByteBuffer.asReadOnlyBuffer() before using or reading from the buffer. This behavior will be changed in a future
     * major version of the SDK.
     * </p>
     * 
     * @param commitDigest
     *        The commit digest of the committed transaction.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CommitTransactionResult withCommitDigest(java.nio.ByteBuffer commitDigest) {
        setCommitDigest(commitDigest);
        return this;
    }

    /**
     * <p>
     * Contains server-side performance information for the command.
     * </p>
     * 
     * @param timingInformation
     *        Contains server-side performance information for the command.
     */

    public void setTimingInformation(TimingInformation timingInformation) {
        this.timingInformation = timingInformation;
    }

    /**
     * <p>
     * Contains server-side performance information for the command.
     * </p>
     * 
     * @return Contains server-side performance information for the command.
     */

    public TimingInformation getTimingInformation() {
        return this.timingInformation;
    }

    /**
     * <p>
     * Contains server-side performance information for the command.
     * </p>
     * 
     * @param timingInformation
     *        Contains server-side performance information for the command.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CommitTransactionResult withTimingInformation(TimingInformation timingInformation) {
        setTimingInformation(timingInformation);
        return this;
    }

    /**
     * <p>
     * Contains metrics about the number of I/O requests that were consumed.
     * </p>
     * 
     * @param consumedIOs
     *        Contains metrics about the number of I/O requests that were consumed.
     */

    public void setConsumedIOs(IOUsage consumedIOs) {
        this.consumedIOs = consumedIOs;
    }

    /**
     * <p>
     * Contains metrics about the number of I/O requests that were consumed.
     * </p>
     * 
     * @return Contains metrics about the number of I/O requests that were consumed.
     */

    public IOUsage getConsumedIOs() {
        return this.consumedIOs;
    }

    /**
     * <p>
     * Contains metrics about the number of I/O requests that were consumed.
     * </p>
     * 
     * @param consumedIOs
     *        Contains metrics about the number of I/O requests that were consumed.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CommitTransactionResult withConsumedIOs(IOUsage consumedIOs) {
        setConsumedIOs(consumedIOs);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getTransactionId() != null)
            sb.append("TransactionId: ").append(getTransactionId()).append(",");
        if (getCommitDigest() != null)
            sb.append("CommitDigest: ").append(getCommitDigest()).append(",");
        if (getTimingInformation() != null)
            sb.append("TimingInformation: ").append(getTimingInformation()).append(",");
        if (getConsumedIOs() != null)
            sb.append("ConsumedIOs: ").append(getConsumedIOs());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CommitTransactionResult == false)
            return false;
        CommitTransactionResult other = (CommitTransactionResult) obj;
        if (other.getTransactionId() == null ^ this.getTransactionId() == null)
            return false;
        if (other.getTransactionId() != null && other.getTransactionId().equals(this.getTransactionId()) == false)
            return false;
        if (other.getCommitDigest() == null ^ this.getCommitDigest() == null)
            return false;
        if (other.getCommitDigest() != null && other.getCommitDigest().equals(this.getCommitDigest()) == false)
            return false;
        if (other.getTimingInformation() == null ^ this.getTimingInformation() == null)
            return false;
        if (other.getTimingInformation() != null && other.getTimingInformation().equals(this.getTimingInformation()) == false)
            return false;
        if (other.getConsumedIOs() == null ^ this.getConsumedIOs() == null)
            return false;
        if (other.getConsumedIOs() != null && other.getConsumedIOs().equals(this.getConsumedIOs()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getTransactionId() == null) ? 0 : getTransactionId().hashCode());
        hashCode = prime * hashCode + ((getCommitDigest() == null) ? 0 : getCommitDigest().hashCode());
        hashCode = prime * hashCode + ((getTimingInformation() == null) ? 0 : getTimingInformation().hashCode());
        hashCode = prime * hashCode + ((getConsumedIOs() == null) ? 0 : getConsumedIOs().hashCode());
        return hashCode;
    }

    @Override
    public CommitTransactionResult clone() {
        try {
            return (CommitTransactionResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.qldbsession.model.transform.CommitTransactionResultMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
