/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.vpclattice;

import javax.annotation.Generated;

import com.amazonaws.services.vpclattice.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AmazonVPCLattice}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonVPCLattice implements AmazonVPCLattice {

    protected AbstractAmazonVPCLattice() {
    }

    @Override
    public BatchUpdateRuleResult batchUpdateRule(BatchUpdateRuleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAccessLogSubscriptionResult createAccessLogSubscription(CreateAccessLogSubscriptionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateListenerResult createListener(CreateListenerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateRuleResult createRule(CreateRuleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateServiceResult createService(CreateServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateServiceNetworkResult createServiceNetwork(CreateServiceNetworkRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateServiceNetworkServiceAssociationResult createServiceNetworkServiceAssociation(CreateServiceNetworkServiceAssociationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateServiceNetworkVpcAssociationResult createServiceNetworkVpcAssociation(CreateServiceNetworkVpcAssociationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateTargetGroupResult createTargetGroup(CreateTargetGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAccessLogSubscriptionResult deleteAccessLogSubscription(DeleteAccessLogSubscriptionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAuthPolicyResult deleteAuthPolicy(DeleteAuthPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteListenerResult deleteListener(DeleteListenerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteResourcePolicyResult deleteResourcePolicy(DeleteResourcePolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteRuleResult deleteRule(DeleteRuleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteServiceResult deleteService(DeleteServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteServiceNetworkResult deleteServiceNetwork(DeleteServiceNetworkRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteServiceNetworkServiceAssociationResult deleteServiceNetworkServiceAssociation(DeleteServiceNetworkServiceAssociationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteServiceNetworkVpcAssociationResult deleteServiceNetworkVpcAssociation(DeleteServiceNetworkVpcAssociationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteTargetGroupResult deleteTargetGroup(DeleteTargetGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeregisterTargetsResult deregisterTargets(DeregisterTargetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAccessLogSubscriptionResult getAccessLogSubscription(GetAccessLogSubscriptionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAuthPolicyResult getAuthPolicy(GetAuthPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetListenerResult getListener(GetListenerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetResourcePolicyResult getResourcePolicy(GetResourcePolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetRuleResult getRule(GetRuleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetServiceResult getService(GetServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetServiceNetworkResult getServiceNetwork(GetServiceNetworkRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetServiceNetworkServiceAssociationResult getServiceNetworkServiceAssociation(GetServiceNetworkServiceAssociationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetServiceNetworkVpcAssociationResult getServiceNetworkVpcAssociation(GetServiceNetworkVpcAssociationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetTargetGroupResult getTargetGroup(GetTargetGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAccessLogSubscriptionsResult listAccessLogSubscriptions(ListAccessLogSubscriptionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListListenersResult listListeners(ListListenersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListRulesResult listRules(ListRulesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListServiceNetworkServiceAssociationsResult listServiceNetworkServiceAssociations(ListServiceNetworkServiceAssociationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListServiceNetworkVpcAssociationsResult listServiceNetworkVpcAssociations(ListServiceNetworkVpcAssociationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListServiceNetworksResult listServiceNetworks(ListServiceNetworksRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListServicesResult listServices(ListServicesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTargetGroupsResult listTargetGroups(ListTargetGroupsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTargetsResult listTargets(ListTargetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutAuthPolicyResult putAuthPolicy(PutAuthPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutResourcePolicyResult putResourcePolicy(PutResourcePolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RegisterTargetsResult registerTargets(RegisterTargetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAccessLogSubscriptionResult updateAccessLogSubscription(UpdateAccessLogSubscriptionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateListenerResult updateListener(UpdateListenerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateRuleResult updateRule(UpdateRuleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateServiceResult updateService(UpdateServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateServiceNetworkResult updateServiceNetwork(UpdateServiceNetworkRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateServiceNetworkVpcAssociationResult updateServiceNetworkVpcAssociation(UpdateServiceNetworkVpcAssociationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateTargetGroupResult updateTargetGroup(UpdateTargetGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
