/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.schemas.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/CreateDiscoverer" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CreateDiscovererRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * A description for the discoverer.
     * </p>
     */
    private String description;
    /**
     * <p>
     * The ARN of the event bus.
     * </p>
     */
    private String sourceArn;
    /**
     * <p>
     * Support discovery of schemas in events sent to the bus from another account. (default: true).
     * </p>
     */
    private Boolean crossAccount;
    /**
     * <p>
     * Tags associated with the resource.
     * </p>
     */
    private java.util.Map<String, String> tags;

    /**
     * <p>
     * A description for the discoverer.
     * </p>
     * 
     * @param description
     *        A description for the discoverer.
     */

    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * <p>
     * A description for the discoverer.
     * </p>
     * 
     * @return A description for the discoverer.
     */

    public String getDescription() {
        return this.description;
    }

    /**
     * <p>
     * A description for the discoverer.
     * </p>
     * 
     * @param description
     *        A description for the discoverer.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateDiscovererRequest withDescription(String description) {
        setDescription(description);
        return this;
    }

    /**
     * <p>
     * The ARN of the event bus.
     * </p>
     * 
     * @param sourceArn
     *        The ARN of the event bus.
     */

    public void setSourceArn(String sourceArn) {
        this.sourceArn = sourceArn;
    }

    /**
     * <p>
     * The ARN of the event bus.
     * </p>
     * 
     * @return The ARN of the event bus.
     */

    public String getSourceArn() {
        return this.sourceArn;
    }

    /**
     * <p>
     * The ARN of the event bus.
     * </p>
     * 
     * @param sourceArn
     *        The ARN of the event bus.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateDiscovererRequest withSourceArn(String sourceArn) {
        setSourceArn(sourceArn);
        return this;
    }

    /**
     * <p>
     * Support discovery of schemas in events sent to the bus from another account. (default: true).
     * </p>
     * 
     * @param crossAccount
     *        Support discovery of schemas in events sent to the bus from another account. (default: true).
     */

    public void setCrossAccount(Boolean crossAccount) {
        this.crossAccount = crossAccount;
    }

    /**
     * <p>
     * Support discovery of schemas in events sent to the bus from another account. (default: true).
     * </p>
     * 
     * @return Support discovery of schemas in events sent to the bus from another account. (default: true).
     */

    public Boolean getCrossAccount() {
        return this.crossAccount;
    }

    /**
     * <p>
     * Support discovery of schemas in events sent to the bus from another account. (default: true).
     * </p>
     * 
     * @param crossAccount
     *        Support discovery of schemas in events sent to the bus from another account. (default: true).
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateDiscovererRequest withCrossAccount(Boolean crossAccount) {
        setCrossAccount(crossAccount);
        return this;
    }

    /**
     * <p>
     * Support discovery of schemas in events sent to the bus from another account. (default: true).
     * </p>
     * 
     * @return Support discovery of schemas in events sent to the bus from another account. (default: true).
     */

    public Boolean isCrossAccount() {
        return this.crossAccount;
    }

    /**
     * <p>
     * Tags associated with the resource.
     * </p>
     * 
     * @return Tags associated with the resource.
     */

    public java.util.Map<String, String> getTags() {
        return tags;
    }

    /**
     * <p>
     * Tags associated with the resource.
     * </p>
     * 
     * @param tags
     *        Tags associated with the resource.
     */

    public void setTags(java.util.Map<String, String> tags) {
        this.tags = tags;
    }

    /**
     * <p>
     * Tags associated with the resource.
     * </p>
     * 
     * @param tags
     *        Tags associated with the resource.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateDiscovererRequest withTags(java.util.Map<String, String> tags) {
        setTags(tags);
        return this;
    }

    /**
     * Add a single Tags entry
     *
     * @see CreateDiscovererRequest#withTags
     * @returns a reference to this object so that method calls can be chained together.
     */

    public CreateDiscovererRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new java.util.HashMap<String, String>();
        }
        if (this.tags.containsKey(key))
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        this.tags.put(key, value);
        return this;
    }

    /**
     * Removes all the entries added into Tags.
     *
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateDiscovererRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getDescription() != null)
            sb.append("Description: ").append(getDescription()).append(",");
        if (getSourceArn() != null)
            sb.append("SourceArn: ").append(getSourceArn()).append(",");
        if (getCrossAccount() != null)
            sb.append("CrossAccount: ").append(getCrossAccount()).append(",");
        if (getTags() != null)
            sb.append("Tags: ").append(getTags());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CreateDiscovererRequest == false)
            return false;
        CreateDiscovererRequest other = (CreateDiscovererRequest) obj;
        if (other.getDescription() == null ^ this.getDescription() == null)
            return false;
        if (other.getDescription() != null && other.getDescription().equals(this.getDescription()) == false)
            return false;
        if (other.getSourceArn() == null ^ this.getSourceArn() == null)
            return false;
        if (other.getSourceArn() != null && other.getSourceArn().equals(this.getSourceArn()) == false)
            return false;
        if (other.getCrossAccount() == null ^ this.getCrossAccount() == null)
            return false;
        if (other.getCrossAccount() != null && other.getCrossAccount().equals(this.getCrossAccount()) == false)
            return false;
        if (other.getTags() == null ^ this.getTags() == null)
            return false;
        if (other.getTags() != null && other.getTags().equals(this.getTags()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getDescription() == null) ? 0 : getDescription().hashCode());
        hashCode = prime * hashCode + ((getSourceArn() == null) ? 0 : getSourceArn().hashCode());
        hashCode = prime * hashCode + ((getCrossAccount() == null) ? 0 : getCrossAccount().hashCode());
        hashCode = prime * hashCode + ((getTags() == null) ? 0 : getTags().hashCode());
        return hashCode;
    }

    @Override
    public CreateDiscovererRequest clone() {
        return (CreateDiscovererRequest) super.clone();
    }

}
