/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.signer.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.signer.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * SigningJob JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class SigningJobJsonUnmarshaller implements Unmarshaller<SigningJob, JsonUnmarshallerContext> {

    public SigningJob unmarshall(JsonUnmarshallerContext context) throws Exception {
        SigningJob signingJob = new SigningJob();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("jobId", targetDepth)) {
                    context.nextToken();
                    signingJob.setJobId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("source", targetDepth)) {
                    context.nextToken();
                    signingJob.setSource(SourceJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("signedObject", targetDepth)) {
                    context.nextToken();
                    signingJob.setSignedObject(SignedObjectJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("signingMaterial", targetDepth)) {
                    context.nextToken();
                    signingJob.setSigningMaterial(SigningMaterialJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("createdAt", targetDepth)) {
                    context.nextToken();
                    signingJob.setCreatedAt(DateJsonUnmarshallerFactory.getInstance("unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("status", targetDepth)) {
                    context.nextToken();
                    signingJob.setStatus(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("isRevoked", targetDepth)) {
                    context.nextToken();
                    signingJob.setIsRevoked(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("profileName", targetDepth)) {
                    context.nextToken();
                    signingJob.setProfileName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("profileVersion", targetDepth)) {
                    context.nextToken();
                    signingJob.setProfileVersion(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("platformId", targetDepth)) {
                    context.nextToken();
                    signingJob.setPlatformId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("platformDisplayName", targetDepth)) {
                    context.nextToken();
                    signingJob.setPlatformDisplayName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("signatureExpiresAt", targetDepth)) {
                    context.nextToken();
                    signingJob.setSignatureExpiresAt(DateJsonUnmarshallerFactory.getInstance("unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("jobOwner", targetDepth)) {
                    context.nextToken();
                    signingJob.setJobOwner(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("jobInvoker", targetDepth)) {
                    context.nextToken();
                    signingJob.setJobInvoker(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return signingJob;
    }

    private static SigningJobJsonUnmarshaller instance;

    public static SigningJobJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new SigningJobJsonUnmarshaller();
        return instance;
    }
}
