/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.greengrassv2.model.transform;

import java.util.List;
import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.greengrassv2.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * InstalledComponentMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class InstalledComponentMarshaller {

    private static final MarshallingInfo<String> COMPONENTNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("componentName").build();
    private static final MarshallingInfo<String> COMPONENTVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("componentVersion").build();
    private static final MarshallingInfo<String> LIFECYCLESTATE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lifecycleState").build();
    private static final MarshallingInfo<String> LIFECYCLESTATEDETAILS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lifecycleStateDetails").build();
    private static final MarshallingInfo<Boolean> ISROOT_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("isRoot").build();
    private static final MarshallingInfo<java.util.Date> LASTSTATUSCHANGETIMESTAMP_BINDING = MarshallingInfo.builder(MarshallingType.DATE)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastStatusChangeTimestamp").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<java.util.Date> LASTREPORTEDTIMESTAMP_BINDING = MarshallingInfo.builder(MarshallingType.DATE)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastReportedTimestamp").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> LASTINSTALLATIONSOURCE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastInstallationSource").build();
    private static final MarshallingInfo<List> LIFECYCLESTATUSCODES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lifecycleStatusCodes").build();

    private static final InstalledComponentMarshaller instance = new InstalledComponentMarshaller();

    public static InstalledComponentMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(InstalledComponent installedComponent, ProtocolMarshaller protocolMarshaller) {

        if (installedComponent == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(installedComponent.getComponentName(), COMPONENTNAME_BINDING);
            protocolMarshaller.marshall(installedComponent.getComponentVersion(), COMPONENTVERSION_BINDING);
            protocolMarshaller.marshall(installedComponent.getLifecycleState(), LIFECYCLESTATE_BINDING);
            protocolMarshaller.marshall(installedComponent.getLifecycleStateDetails(), LIFECYCLESTATEDETAILS_BINDING);
            protocolMarshaller.marshall(installedComponent.getIsRoot(), ISROOT_BINDING);
            protocolMarshaller.marshall(installedComponent.getLastStatusChangeTimestamp(), LASTSTATUSCHANGETIMESTAMP_BINDING);
            protocolMarshaller.marshall(installedComponent.getLastReportedTimestamp(), LASTREPORTEDTIMESTAMP_BINDING);
            protocolMarshaller.marshall(installedComponent.getLastInstallationSource(), LASTINSTALLATIONSOURCE_BINDING);
            protocolMarshaller.marshall(installedComponent.getLifecycleStatusCodes(), LIFECYCLESTATUSCODES_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
