/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.wellarchitected.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * <p>
 * Input for List Share Invitations
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListShareInvitations"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListShareInvitationsRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    private String workloadNamePrefix;
    /**
     * <p>
     * An optional string added to the beginning of each lens name returned in the results.
     * </p>
     */
    private String lensNamePrefix;
    /**
     * <p>
     * The type of share invitations to be returned.
     * </p>
     */
    private String shareResourceType;

    private String nextToken;
    /**
     * <p>
     * The maximum number of results to return for this request.
     * </p>
     */
    private Integer maxResults;
    /**
     * <p>
     * An optional string added to the beginning of each profile name returned in the results.
     * </p>
     */
    private String profileNamePrefix;
    /**
     * <p>
     * An optional string added to the beginning of each review template name returned in the results.
     * </p>
     */
    private String templateNamePrefix;

    /**
     * @param workloadNamePrefix
     */

    public void setWorkloadNamePrefix(String workloadNamePrefix) {
        this.workloadNamePrefix = workloadNamePrefix;
    }

    /**
     * @return
     */

    public String getWorkloadNamePrefix() {
        return this.workloadNamePrefix;
    }

    /**
     * @param workloadNamePrefix
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListShareInvitationsRequest withWorkloadNamePrefix(String workloadNamePrefix) {
        setWorkloadNamePrefix(workloadNamePrefix);
        return this;
    }

    /**
     * <p>
     * An optional string added to the beginning of each lens name returned in the results.
     * </p>
     * 
     * @param lensNamePrefix
     *        An optional string added to the beginning of each lens name returned in the results.
     */

    public void setLensNamePrefix(String lensNamePrefix) {
        this.lensNamePrefix = lensNamePrefix;
    }

    /**
     * <p>
     * An optional string added to the beginning of each lens name returned in the results.
     * </p>
     * 
     * @return An optional string added to the beginning of each lens name returned in the results.
     */

    public String getLensNamePrefix() {
        return this.lensNamePrefix;
    }

    /**
     * <p>
     * An optional string added to the beginning of each lens name returned in the results.
     * </p>
     * 
     * @param lensNamePrefix
     *        An optional string added to the beginning of each lens name returned in the results.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListShareInvitationsRequest withLensNamePrefix(String lensNamePrefix) {
        setLensNamePrefix(lensNamePrefix);
        return this;
    }

    /**
     * <p>
     * The type of share invitations to be returned.
     * </p>
     * 
     * @param shareResourceType
     *        The type of share invitations to be returned.
     * @see ShareResourceType
     */

    public void setShareResourceType(String shareResourceType) {
        this.shareResourceType = shareResourceType;
    }

    /**
     * <p>
     * The type of share invitations to be returned.
     * </p>
     * 
     * @return The type of share invitations to be returned.
     * @see ShareResourceType
     */

    public String getShareResourceType() {
        return this.shareResourceType;
    }

    /**
     * <p>
     * The type of share invitations to be returned.
     * </p>
     * 
     * @param shareResourceType
     *        The type of share invitations to be returned.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ShareResourceType
     */

    public ListShareInvitationsRequest withShareResourceType(String shareResourceType) {
        setShareResourceType(shareResourceType);
        return this;
    }

    /**
     * <p>
     * The type of share invitations to be returned.
     * </p>
     * 
     * @param shareResourceType
     *        The type of share invitations to be returned.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ShareResourceType
     */

    public ListShareInvitationsRequest withShareResourceType(ShareResourceType shareResourceType) {
        this.shareResourceType = shareResourceType.toString();
        return this;
    }

    /**
     * @param nextToken
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * @return
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * @param nextToken
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListShareInvitationsRequest withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * <p>
     * The maximum number of results to return for this request.
     * </p>
     * 
     * @param maxResults
     *        The maximum number of results to return for this request.
     */

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    /**
     * <p>
     * The maximum number of results to return for this request.
     * </p>
     * 
     * @return The maximum number of results to return for this request.
     */

    public Integer getMaxResults() {
        return this.maxResults;
    }

    /**
     * <p>
     * The maximum number of results to return for this request.
     * </p>
     * 
     * @param maxResults
     *        The maximum number of results to return for this request.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListShareInvitationsRequest withMaxResults(Integer maxResults) {
        setMaxResults(maxResults);
        return this;
    }

    /**
     * <p>
     * An optional string added to the beginning of each profile name returned in the results.
     * </p>
     * 
     * @param profileNamePrefix
     *        An optional string added to the beginning of each profile name returned in the results.
     */

    public void setProfileNamePrefix(String profileNamePrefix) {
        this.profileNamePrefix = profileNamePrefix;
    }

    /**
     * <p>
     * An optional string added to the beginning of each profile name returned in the results.
     * </p>
     * 
     * @return An optional string added to the beginning of each profile name returned in the results.
     */

    public String getProfileNamePrefix() {
        return this.profileNamePrefix;
    }

    /**
     * <p>
     * An optional string added to the beginning of each profile name returned in the results.
     * </p>
     * 
     * @param profileNamePrefix
     *        An optional string added to the beginning of each profile name returned in the results.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListShareInvitationsRequest withProfileNamePrefix(String profileNamePrefix) {
        setProfileNamePrefix(profileNamePrefix);
        return this;
    }

    /**
     * <p>
     * An optional string added to the beginning of each review template name returned in the results.
     * </p>
     * 
     * @param templateNamePrefix
     *        An optional string added to the beginning of each review template name returned in the results.
     */

    public void setTemplateNamePrefix(String templateNamePrefix) {
        this.templateNamePrefix = templateNamePrefix;
    }

    /**
     * <p>
     * An optional string added to the beginning of each review template name returned in the results.
     * </p>
     * 
     * @return An optional string added to the beginning of each review template name returned in the results.
     */

    public String getTemplateNamePrefix() {
        return this.templateNamePrefix;
    }

    /**
     * <p>
     * An optional string added to the beginning of each review template name returned in the results.
     * </p>
     * 
     * @param templateNamePrefix
     *        An optional string added to the beginning of each review template name returned in the results.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListShareInvitationsRequest withTemplateNamePrefix(String templateNamePrefix) {
        setTemplateNamePrefix(templateNamePrefix);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getWorkloadNamePrefix() != null)
            sb.append("WorkloadNamePrefix: ").append(getWorkloadNamePrefix()).append(",");
        if (getLensNamePrefix() != null)
            sb.append("LensNamePrefix: ").append(getLensNamePrefix()).append(",");
        if (getShareResourceType() != null)
            sb.append("ShareResourceType: ").append(getShareResourceType()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken()).append(",");
        if (getMaxResults() != null)
            sb.append("MaxResults: ").append(getMaxResults()).append(",");
        if (getProfileNamePrefix() != null)
            sb.append("ProfileNamePrefix: ").append(getProfileNamePrefix()).append(",");
        if (getTemplateNamePrefix() != null)
            sb.append("TemplateNamePrefix: ").append(getTemplateNamePrefix());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListShareInvitationsRequest == false)
            return false;
        ListShareInvitationsRequest other = (ListShareInvitationsRequest) obj;
        if (other.getWorkloadNamePrefix() == null ^ this.getWorkloadNamePrefix() == null)
            return false;
        if (other.getWorkloadNamePrefix() != null && other.getWorkloadNamePrefix().equals(this.getWorkloadNamePrefix()) == false)
            return false;
        if (other.getLensNamePrefix() == null ^ this.getLensNamePrefix() == null)
            return false;
        if (other.getLensNamePrefix() != null && other.getLensNamePrefix().equals(this.getLensNamePrefix()) == false)
            return false;
        if (other.getShareResourceType() == null ^ this.getShareResourceType() == null)
            return false;
        if (other.getShareResourceType() != null && other.getShareResourceType().equals(this.getShareResourceType()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        if (other.getMaxResults() == null ^ this.getMaxResults() == null)
            return false;
        if (other.getMaxResults() != null && other.getMaxResults().equals(this.getMaxResults()) == false)
            return false;
        if (other.getProfileNamePrefix() == null ^ this.getProfileNamePrefix() == null)
            return false;
        if (other.getProfileNamePrefix() != null && other.getProfileNamePrefix().equals(this.getProfileNamePrefix()) == false)
            return false;
        if (other.getTemplateNamePrefix() == null ^ this.getTemplateNamePrefix() == null)
            return false;
        if (other.getTemplateNamePrefix() != null && other.getTemplateNamePrefix().equals(this.getTemplateNamePrefix()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getWorkloadNamePrefix() == null) ? 0 : getWorkloadNamePrefix().hashCode());
        hashCode = prime * hashCode + ((getLensNamePrefix() == null) ? 0 : getLensNamePrefix().hashCode());
        hashCode = prime * hashCode + ((getShareResourceType() == null) ? 0 : getShareResourceType().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        hashCode = prime * hashCode + ((getMaxResults() == null) ? 0 : getMaxResults().hashCode());
        hashCode = prime * hashCode + ((getProfileNamePrefix() == null) ? 0 : getProfileNamePrefix().hashCode());
        hashCode = prime * hashCode + ((getTemplateNamePrefix() == null) ? 0 : getTemplateNamePrefix().hashCode());
        return hashCode;
    }

    @Override
    public ListShareInvitationsRequest clone() {
        return (ListShareInvitationsRequest) super.clone();
    }

}
