/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.securityhub.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.securityhub.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetailsMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetailsMarshaller {

    private static final MarshallingInfo<Boolean> DELETEONTERMINATION_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeleteOnTermination").build();
    private static final MarshallingInfo<Boolean> ENCRYPTED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Encrypted").build();
    private static final MarshallingInfo<Integer> IOPS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Iops").build();
    private static final MarshallingInfo<String> SNAPSHOTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SnapshotId").build();
    private static final MarshallingInfo<Integer> VOLUMESIZE_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VolumeSize").build();
    private static final MarshallingInfo<String> VOLUMETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VolumeType").build();

    private static final AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetailsMarshaller instance = new AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetailsMarshaller();

    public static AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetailsMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails awsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails,
            ProtocolMarshaller protocolMarshaller) {

        if (awsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(awsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails.getDeleteOnTermination(), DELETEONTERMINATION_BINDING);
            protocolMarshaller.marshall(awsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails.getEncrypted(), ENCRYPTED_BINDING);
            protocolMarshaller.marshall(awsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails.getIops(), IOPS_BINDING);
            protocolMarshaller.marshall(awsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails.getSnapshotId(), SNAPSHOTID_BINDING);
            protocolMarshaller.marshall(awsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails.getVolumeSize(), VOLUMESIZE_BINDING);
            protocolMarshaller.marshall(awsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails.getVolumeType(), VOLUMETYPE_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
