/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.chimesdkmessaging;

import javax.annotation.Generated;

import com.amazonaws.services.chimesdkmessaging.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AmazonChimeSDKMessaging}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonChimeSDKMessaging implements AmazonChimeSDKMessaging {

    protected AbstractAmazonChimeSDKMessaging() {
    }

    @Override
    public AssociateChannelFlowResult associateChannelFlow(AssociateChannelFlowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchCreateChannelMembershipResult batchCreateChannelMembership(BatchCreateChannelMembershipRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ChannelFlowCallbackResult channelFlowCallback(ChannelFlowCallbackRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateChannelResult createChannel(CreateChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateChannelBanResult createChannelBan(CreateChannelBanRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateChannelFlowResult createChannelFlow(CreateChannelFlowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateChannelMembershipResult createChannelMembership(CreateChannelMembershipRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateChannelModeratorResult createChannelModerator(CreateChannelModeratorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteChannelResult deleteChannel(DeleteChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteChannelBanResult deleteChannelBan(DeleteChannelBanRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteChannelFlowResult deleteChannelFlow(DeleteChannelFlowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteChannelMembershipResult deleteChannelMembership(DeleteChannelMembershipRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteChannelMessageResult deleteChannelMessage(DeleteChannelMessageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteChannelModeratorResult deleteChannelModerator(DeleteChannelModeratorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeChannelResult describeChannel(DescribeChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeChannelBanResult describeChannelBan(DescribeChannelBanRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeChannelFlowResult describeChannelFlow(DescribeChannelFlowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeChannelMembershipResult describeChannelMembership(DescribeChannelMembershipRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeChannelMembershipForAppInstanceUserResult describeChannelMembershipForAppInstanceUser(
            DescribeChannelMembershipForAppInstanceUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeChannelModeratedByAppInstanceUserResult describeChannelModeratedByAppInstanceUser(DescribeChannelModeratedByAppInstanceUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeChannelModeratorResult describeChannelModerator(DescribeChannelModeratorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateChannelFlowResult disassociateChannelFlow(DisassociateChannelFlowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetChannelMessageResult getChannelMessage(GetChannelMessageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetChannelMessageStatusResult getChannelMessageStatus(GetChannelMessageStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetMessagingSessionEndpointResult getMessagingSessionEndpoint(GetMessagingSessionEndpointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListChannelBansResult listChannelBans(ListChannelBansRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListChannelFlowsResult listChannelFlows(ListChannelFlowsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListChannelMembershipsResult listChannelMemberships(ListChannelMembershipsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListChannelMembershipsForAppInstanceUserResult listChannelMembershipsForAppInstanceUser(ListChannelMembershipsForAppInstanceUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListChannelMessagesResult listChannelMessages(ListChannelMessagesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListChannelModeratorsResult listChannelModerators(ListChannelModeratorsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListChannelsResult listChannels(ListChannelsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListChannelsAssociatedWithChannelFlowResult listChannelsAssociatedWithChannelFlow(ListChannelsAssociatedWithChannelFlowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListChannelsModeratedByAppInstanceUserResult listChannelsModeratedByAppInstanceUser(ListChannelsModeratedByAppInstanceUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RedactChannelMessageResult redactChannelMessage(RedactChannelMessageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SendChannelMessageResult sendChannelMessage(SendChannelMessageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateChannelResult updateChannel(UpdateChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateChannelFlowResult updateChannelFlow(UpdateChannelFlowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateChannelMessageResult updateChannelMessage(UpdateChannelMessageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateChannelReadMarkerResult updateChannelReadMarker(UpdateChannelReadMarkerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
