/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.storagegateway.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * <p>
 * A JSON object containing the following fields:
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeGatewayInformation"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DescribeGatewayInformationResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    private String gatewayARN;
    /**
     * <p>
     * The unique identifier assigned to your gateway during activation. This ID becomes part of the gateway Amazon
     * Resource Name (ARN), which you use as input for other operations.
     * </p>
     */
    private String gatewayId;
    /**
     * <p>
     * The name you configured for your gateway.
     * </p>
     */
    private String gatewayName;
    /**
     * <p>
     * A value that indicates the time zone configured for the gateway.
     * </p>
     */
    private String gatewayTimezone;
    /**
     * <p>
     * A value that indicates the operating state of the gateway.
     * </p>
     */
    private String gatewayState;
    /**
     * <p>
     * A <a>NetworkInterface</a> array that contains descriptions of the gateway network interfaces.
     * </p>
     */
    private com.amazonaws.internal.SdkInternalList<NetworkInterface> gatewayNetworkInterfaces;
    /**
     * <p>
     * The type of the gateway.
     * </p>
     */
    private String gatewayType;
    /**
     * <p>
     * The date on which an update to the gateway is available. This date is in the time zone of the gateway. If the
     * gateway is not available for an update this field is not returned in the response.
     * </p>
     */
    private String nextUpdateAvailabilityDate;
    /**
     * <p>
     * The date on which the last software update was applied to the gateway. If the gateway has never been updated,
     * this field does not return a value in the response.
     * </p>
     */
    private String lastSoftwareUpdate;
    /**
     * <p>
     * The ID of the Amazon EC2 instance that was used to launch the gateway.
     * </p>
     */
    private String ec2InstanceId;
    /**
     * <p>
     * The Amazon Web Services Region where the Amazon EC2 instance is located.
     * </p>
     */
    private String ec2InstanceRegion;
    /**
     * <p>
     * A list of up to 50 tags assigned to the gateway, sorted alphabetically by key name. Each tag is a key-value pair.
     * For a gateway with more than 10 tags assigned, you can view all tags using the <code>ListTagsForResource</code>
     * API operation.
     * </p>
     */
    private com.amazonaws.internal.SdkInternalList<Tag> tags;
    /**
     * <p>
     * The configuration settings for the virtual private cloud (VPC) endpoint for your gateway.
     * </p>
     */
    private String vPCEndpoint;
    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that is used to monitor events in the gateway.
     * </p>
     */
    private String cloudWatchLogGroupARN;
    /**
     * <p>
     * The type of hypervisor environment used by the host.
     * </p>
     */
    private String hostEnvironment;
    /**
     * <p>
     * The type of endpoint for your gateway.
     * </p>
     * <p>
     * Valid Values: <code>STANDARD</code> | <code>FIPS</code>
     * </p>
     */
    private String endpointType;
    /**
     * <p>
     * Date after which this gateway will not receive software updates for new features.
     * </p>
     */
    private String softwareUpdatesEndDate;
    /**
     * <p>
     * Date after which this gateway will not receive software updates for new features and bug fixes.
     * </p>
     */
    private String deprecationDate;
    /**
     * <p>
     * Specifies the size of the gateway's metadata cache.
     * </p>
     */
    private String gatewayCapacity;
    /**
     * <p>
     * A list of the metadata cache sizes that the gateway can support based on its current hardware specifications.
     * </p>
     */
    private com.amazonaws.internal.SdkInternalList<String> supportedGatewayCapacities;

    /**
     * @param gatewayARN
     */

    public void setGatewayARN(String gatewayARN) {
        this.gatewayARN = gatewayARN;
    }

    /**
     * @return
     */

    public String getGatewayARN() {
        return this.gatewayARN;
    }

    /**
     * @param gatewayARN
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeGatewayInformationResult withGatewayARN(String gatewayARN) {
        setGatewayARN(gatewayARN);
        return this;
    }

    /**
     * <p>
     * The unique identifier assigned to your gateway during activation. This ID becomes part of the gateway Amazon
     * Resource Name (ARN), which you use as input for other operations.
     * </p>
     * 
     * @param gatewayId
     *        The unique identifier assigned to your gateway during activation. This ID becomes part of the gateway
     *        Amazon Resource Name (ARN), which you use as input for other operations.
     */

    public void setGatewayId(String gatewayId) {
        this.gatewayId = gatewayId;
    }

    /**
     * <p>
     * The unique identifier assigned to your gateway during activation. This ID becomes part of the gateway Amazon
     * Resource Name (ARN), which you use as input for other operations.
     * </p>
     * 
     * @return The unique identifier assigned to your gateway during activation. This ID becomes part of the gateway
     *         Amazon Resource Name (ARN), which you use as input for other operations.
     */

    public String getGatewayId() {
        return this.gatewayId;
    }

    /**
     * <p>
     * The unique identifier assigned to your gateway during activation. This ID becomes part of the gateway Amazon
     * Resource Name (ARN), which you use as input for other operations.
     * </p>
     * 
     * @param gatewayId
     *        The unique identifier assigned to your gateway during activation. This ID becomes part of the gateway
     *        Amazon Resource Name (ARN), which you use as input for other operations.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeGatewayInformationResult withGatewayId(String gatewayId) {
        setGatewayId(gatewayId);
        return this;
    }

    /**
     * <p>
     * The name you configured for your gateway.
     * </p>
     * 
     * @param gatewayName
     *        The name you configured for your gateway.
     */

    public void setGatewayName(String gatewayName) {
        this.gatewayName = gatewayName;
    }

    /**
     * <p>
     * The name you configured for your gateway.
     * </p>
     * 
     * @return The name you configured for your gateway.
     */

    public String getGatewayName() {
        return this.gatewayName;
    }

    /**
     * <p>
     * The name you configured for your gateway.
     * </p>
     * 
     * @param gatewayName
     *        The name you configured for your gateway.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeGatewayInformationResult withGatewayName(String gatewayName) {
        setGatewayName(gatewayName);
        return this;
    }

    /**
     * <p>
     * A value that indicates the time zone configured for the gateway.
     * </p>
     * 
     * @param gatewayTimezone
     *        A value that indicates the time zone configured for the gateway.
     */

    public void setGatewayTimezone(String gatewayTimezone) {
        this.gatewayTimezone = gatewayTimezone;
    }

    /**
     * <p>
     * A value that indicates the time zone configured for the gateway.
     * </p>
     * 
     * @return A value that indicates the time zone configured for the gateway.
     */

    public String getGatewayTimezone() {
        return this.gatewayTimezone;
    }

    /**
     * <p>
     * A value that indicates the time zone configured for the gateway.
     * </p>
     * 
     * @param gatewayTimezone
     *        A value that indicates the time zone configured for the gateway.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeGatewayInformationResult withGatewayTimezone(String gatewayTimezone) {
        setGatewayTimezone(gatewayTimezone);
        return this;
    }

    /**
     * <p>
     * A value that indicates the operating state of the gateway.
     * </p>
     * 
     * @param gatewayState
     *        A value that indicates the operating state of the gateway.
     */

    public void setGatewayState(String gatewayState) {
        this.gatewayState = gatewayState;
    }

    /**
     * <p>
     * A value that indicates the operating state of the gateway.
     * </p>
     * 
     * @return A value that indicates the operating state of the gateway.
     */

    public String getGatewayState() {
        return this.gatewayState;
    }

    /**
     * <p>
     * A value that indicates the operating state of the gateway.
     * </p>
     * 
     * @param gatewayState
     *        A value that indicates the operating state of the gateway.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeGatewayInformationResult withGatewayState(String gatewayState) {
        setGatewayState(gatewayState);
        return this;
    }

    /**
     * <p>
     * A <a>NetworkInterface</a> array that contains descriptions of the gateway network interfaces.
     * </p>
     * 
     * @return A <a>NetworkInterface</a> array that contains descriptions of the gateway network interfaces.
     */

    public java.util.List<NetworkInterface> getGatewayNetworkInterfaces() {
        if (gatewayNetworkInterfaces == null) {
            gatewayNetworkInterfaces = new com.amazonaws.internal.SdkInternalList<NetworkInterface>();
        }
        return gatewayNetworkInterfaces;
    }

    /**
     * <p>
     * A <a>NetworkInterface</a> array that contains descriptions of the gateway network interfaces.
     * </p>
     * 
     * @param gatewayNetworkInterfaces
     *        A <a>NetworkInterface</a> array that contains descriptions of the gateway network interfaces.
     */

    public void setGatewayNetworkInterfaces(java.util.Collection<NetworkInterface> gatewayNetworkInterfaces) {
        if (gatewayNetworkInterfaces == null) {
            this.gatewayNetworkInterfaces = null;
            return;
        }

        this.gatewayNetworkInterfaces = new com.amazonaws.internal.SdkInternalList<NetworkInterface>(gatewayNetworkInterfaces);
    }

    /**
     * <p>
     * A <a>NetworkInterface</a> array that contains descriptions of the gateway network interfaces.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setGatewayNetworkInterfaces(java.util.Collection)} or
     * {@link #withGatewayNetworkInterfaces(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param gatewayNetworkInterfaces
     *        A <a>NetworkInterface</a> array that contains descriptions of the gateway network interfaces.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeGatewayInformationResult withGatewayNetworkInterfaces(NetworkInterface... gatewayNetworkInterfaces) {
        if (this.gatewayNetworkInterfaces == null) {
            setGatewayNetworkInterfaces(new com.amazonaws.internal.SdkInternalList<NetworkInterface>(gatewayNetworkInterfaces.length));
        }
        for (NetworkInterface ele : gatewayNetworkInterfaces) {
            this.gatewayNetworkInterfaces.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A <a>NetworkInterface</a> array that contains descriptions of the gateway network interfaces.
     * </p>
     * 
     * @param gatewayNetworkInterfaces
     *        A <a>NetworkInterface</a> array that contains descriptions of the gateway network interfaces.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeGatewayInformationResult withGatewayNetworkInterfaces(java.util.Collection<NetworkInterface> gatewayNetworkInterfaces) {
        setGatewayNetworkInterfaces(gatewayNetworkInterfaces);
        return this;
    }

    /**
     * <p>
     * The type of the gateway.
     * </p>
     * 
     * @param gatewayType
     *        The type of the gateway.
     */

    public void setGatewayType(String gatewayType) {
        this.gatewayType = gatewayType;
    }

    /**
     * <p>
     * The type of the gateway.
     * </p>
     * 
     * @return The type of the gateway.
     */

    public String getGatewayType() {
        return this.gatewayType;
    }

    /**
     * <p>
     * The type of the gateway.
     * </p>
     * 
     * @param gatewayType
     *        The type of the gateway.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeGatewayInformationResult withGatewayType(String gatewayType) {
        setGatewayType(gatewayType);
        return this;
    }

    /**
     * <p>
     * The date on which an update to the gateway is available. This date is in the time zone of the gateway. If the
     * gateway is not available for an update this field is not returned in the response.
     * </p>
     * 
     * @param nextUpdateAvailabilityDate
     *        The date on which an update to the gateway is available. This date is in the time zone of the gateway. If
     *        the gateway is not available for an update this field is not returned in the response.
     */

    public void setNextUpdateAvailabilityDate(String nextUpdateAvailabilityDate) {
        this.nextUpdateAvailabilityDate = nextUpdateAvailabilityDate;
    }

    /**
     * <p>
     * The date on which an update to the gateway is available. This date is in the time zone of the gateway. If the
     * gateway is not available for an update this field is not returned in the response.
     * </p>
     * 
     * @return The date on which an update to the gateway is available. This date is in the time zone of the gateway. If
     *         the gateway is not available for an update this field is not returned in the response.
     */

    public String getNextUpdateAvailabilityDate() {
        return this.nextUpdateAvailabilityDate;
    }

    /**
     * <p>
     * The date on which an update to the gateway is available. This date is in the time zone of the gateway. If the
     * gateway is not available for an update this field is not returned in the response.
     * </p>
     * 
     * @param nextUpdateAvailabilityDate
     *        The date on which an update to the gateway is available. This date is in the time zone of the gateway. If
     *        the gateway is not available for an update this field is not returned in the response.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeGatewayInformationResult withNextUpdateAvailabilityDate(String nextUpdateAvailabilityDate) {
        setNextUpdateAvailabilityDate(nextUpdateAvailabilityDate);
        return this;
    }

    /**
     * <p>
     * The date on which the last software update was applied to the gateway. If the gateway has never been updated,
     * this field does not return a value in the response.
     * </p>
     * 
     * @param lastSoftwareUpdate
     *        The date on which the last software update was applied to the gateway. If the gateway has never been
     *        updated, this field does not return a value in the response.
     */

    public void setLastSoftwareUpdate(String lastSoftwareUpdate) {
        this.lastSoftwareUpdate = lastSoftwareUpdate;
    }

    /**
     * <p>
     * The date on which the last software update was applied to the gateway. If the gateway has never been updated,
     * this field does not return a value in the response.
     * </p>
     * 
     * @return The date on which the last software update was applied to the gateway. If the gateway has never been
     *         updated, this field does not return a value in the response.
     */

    public String getLastSoftwareUpdate() {
        return this.lastSoftwareUpdate;
    }

    /**
     * <p>
     * The date on which the last software update was applied to the gateway. If the gateway has never been updated,
     * this field does not return a value in the response.
     * </p>
     * 
     * @param lastSoftwareUpdate
     *        The date on which the last software update was applied to the gateway. If the gateway has never been
     *        updated, this field does not return a value in the response.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeGatewayInformationResult withLastSoftwareUpdate(String lastSoftwareUpdate) {
        setLastSoftwareUpdate(lastSoftwareUpdate);
        return this;
    }

    /**
     * <p>
     * The ID of the Amazon EC2 instance that was used to launch the gateway.
     * </p>
     * 
     * @param ec2InstanceId
     *        The ID of the Amazon EC2 instance that was used to launch the gateway.
     */

    public void setEc2InstanceId(String ec2InstanceId) {
        this.ec2InstanceId = ec2InstanceId;
    }

    /**
     * <p>
     * The ID of the Amazon EC2 instance that was used to launch the gateway.
     * </p>
     * 
     * @return The ID of the Amazon EC2 instance that was used to launch the gateway.
     */

    public String getEc2InstanceId() {
        return this.ec2InstanceId;
    }

    /**
     * <p>
     * The ID of the Amazon EC2 instance that was used to launch the gateway.
     * </p>
     * 
     * @param ec2InstanceId
     *        The ID of the Amazon EC2 instance that was used to launch the gateway.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeGatewayInformationResult withEc2InstanceId(String ec2InstanceId) {
        setEc2InstanceId(ec2InstanceId);
        return this;
    }

    /**
     * <p>
     * The Amazon Web Services Region where the Amazon EC2 instance is located.
     * </p>
     * 
     * @param ec2InstanceRegion
     *        The Amazon Web Services Region where the Amazon EC2 instance is located.
     */

    public void setEc2InstanceRegion(String ec2InstanceRegion) {
        this.ec2InstanceRegion = ec2InstanceRegion;
    }

    /**
     * <p>
     * The Amazon Web Services Region where the Amazon EC2 instance is located.
     * </p>
     * 
     * @return The Amazon Web Services Region where the Amazon EC2 instance is located.
     */

    public String getEc2InstanceRegion() {
        return this.ec2InstanceRegion;
    }

    /**
     * <p>
     * The Amazon Web Services Region where the Amazon EC2 instance is located.
     * </p>
     * 
     * @param ec2InstanceRegion
     *        The Amazon Web Services Region where the Amazon EC2 instance is located.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeGatewayInformationResult withEc2InstanceRegion(String ec2InstanceRegion) {
        setEc2InstanceRegion(ec2InstanceRegion);
        return this;
    }

    /**
     * <p>
     * A list of up to 50 tags assigned to the gateway, sorted alphabetically by key name. Each tag is a key-value pair.
     * For a gateway with more than 10 tags assigned, you can view all tags using the <code>ListTagsForResource</code>
     * API operation.
     * </p>
     * 
     * @return A list of up to 50 tags assigned to the gateway, sorted alphabetically by key name. Each tag is a
     *         key-value pair. For a gateway with more than 10 tags assigned, you can view all tags using the
     *         <code>ListTagsForResource</code> API operation.
     */

    public java.util.List<Tag> getTags() {
        if (tags == null) {
            tags = new com.amazonaws.internal.SdkInternalList<Tag>();
        }
        return tags;
    }

    /**
     * <p>
     * A list of up to 50 tags assigned to the gateway, sorted alphabetically by key name. Each tag is a key-value pair.
     * For a gateway with more than 10 tags assigned, you can view all tags using the <code>ListTagsForResource</code>
     * API operation.
     * </p>
     * 
     * @param tags
     *        A list of up to 50 tags assigned to the gateway, sorted alphabetically by key name. Each tag is a
     *        key-value pair. For a gateway with more than 10 tags assigned, you can view all tags using the
     *        <code>ListTagsForResource</code> API operation.
     */

    public void setTags(java.util.Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }

        this.tags = new com.amazonaws.internal.SdkInternalList<Tag>(tags);
    }

    /**
     * <p>
     * A list of up to 50 tags assigned to the gateway, sorted alphabetically by key name. Each tag is a key-value pair.
     * For a gateway with more than 10 tags assigned, you can view all tags using the <code>ListTagsForResource</code>
     * API operation.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setTags(java.util.Collection)} or {@link #withTags(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param tags
     *        A list of up to 50 tags assigned to the gateway, sorted alphabetically by key name. Each tag is a
     *        key-value pair. For a gateway with more than 10 tags assigned, you can view all tags using the
     *        <code>ListTagsForResource</code> API operation.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeGatewayInformationResult withTags(Tag... tags) {
        if (this.tags == null) {
            setTags(new com.amazonaws.internal.SdkInternalList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of up to 50 tags assigned to the gateway, sorted alphabetically by key name. Each tag is a key-value pair.
     * For a gateway with more than 10 tags assigned, you can view all tags using the <code>ListTagsForResource</code>
     * API operation.
     * </p>
     * 
     * @param tags
     *        A list of up to 50 tags assigned to the gateway, sorted alphabetically by key name. Each tag is a
     *        key-value pair. For a gateway with more than 10 tags assigned, you can view all tags using the
     *        <code>ListTagsForResource</code> API operation.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeGatewayInformationResult withTags(java.util.Collection<Tag> tags) {
        setTags(tags);
        return this;
    }

    /**
     * <p>
     * The configuration settings for the virtual private cloud (VPC) endpoint for your gateway.
     * </p>
     * 
     * @param vPCEndpoint
     *        The configuration settings for the virtual private cloud (VPC) endpoint for your gateway.
     */

    public void setVPCEndpoint(String vPCEndpoint) {
        this.vPCEndpoint = vPCEndpoint;
    }

    /**
     * <p>
     * The configuration settings for the virtual private cloud (VPC) endpoint for your gateway.
     * </p>
     * 
     * @return The configuration settings for the virtual private cloud (VPC) endpoint for your gateway.
     */

    public String getVPCEndpoint() {
        return this.vPCEndpoint;
    }

    /**
     * <p>
     * The configuration settings for the virtual private cloud (VPC) endpoint for your gateway.
     * </p>
     * 
     * @param vPCEndpoint
     *        The configuration settings for the virtual private cloud (VPC) endpoint for your gateway.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeGatewayInformationResult withVPCEndpoint(String vPCEndpoint) {
        setVPCEndpoint(vPCEndpoint);
        return this;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that is used to monitor events in the gateway.
     * </p>
     * 
     * @param cloudWatchLogGroupARN
     *        The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that is used to monitor events in the
     *        gateway.
     */

    public void setCloudWatchLogGroupARN(String cloudWatchLogGroupARN) {
        this.cloudWatchLogGroupARN = cloudWatchLogGroupARN;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that is used to monitor events in the gateway.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that is used to monitor events in the
     *         gateway.
     */

    public String getCloudWatchLogGroupARN() {
        return this.cloudWatchLogGroupARN;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that is used to monitor events in the gateway.
     * </p>
     * 
     * @param cloudWatchLogGroupARN
     *        The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that is used to monitor events in the
     *        gateway.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeGatewayInformationResult withCloudWatchLogGroupARN(String cloudWatchLogGroupARN) {
        setCloudWatchLogGroupARN(cloudWatchLogGroupARN);
        return this;
    }

    /**
     * <p>
     * The type of hypervisor environment used by the host.
     * </p>
     * 
     * @param hostEnvironment
     *        The type of hypervisor environment used by the host.
     * @see HostEnvironment
     */

    public void setHostEnvironment(String hostEnvironment) {
        this.hostEnvironment = hostEnvironment;
    }

    /**
     * <p>
     * The type of hypervisor environment used by the host.
     * </p>
     * 
     * @return The type of hypervisor environment used by the host.
     * @see HostEnvironment
     */

    public String getHostEnvironment() {
        return this.hostEnvironment;
    }

    /**
     * <p>
     * The type of hypervisor environment used by the host.
     * </p>
     * 
     * @param hostEnvironment
     *        The type of hypervisor environment used by the host.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see HostEnvironment
     */

    public DescribeGatewayInformationResult withHostEnvironment(String hostEnvironment) {
        setHostEnvironment(hostEnvironment);
        return this;
    }

    /**
     * <p>
     * The type of hypervisor environment used by the host.
     * </p>
     * 
     * @param hostEnvironment
     *        The type of hypervisor environment used by the host.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see HostEnvironment
     */

    public DescribeGatewayInformationResult withHostEnvironment(HostEnvironment hostEnvironment) {
        this.hostEnvironment = hostEnvironment.toString();
        return this;
    }

    /**
     * <p>
     * The type of endpoint for your gateway.
     * </p>
     * <p>
     * Valid Values: <code>STANDARD</code> | <code>FIPS</code>
     * </p>
     * 
     * @param endpointType
     *        The type of endpoint for your gateway.</p>
     *        <p>
     *        Valid Values: <code>STANDARD</code> | <code>FIPS</code>
     */

    public void setEndpointType(String endpointType) {
        this.endpointType = endpointType;
    }

    /**
     * <p>
     * The type of endpoint for your gateway.
     * </p>
     * <p>
     * Valid Values: <code>STANDARD</code> | <code>FIPS</code>
     * </p>
     * 
     * @return The type of endpoint for your gateway.</p>
     *         <p>
     *         Valid Values: <code>STANDARD</code> | <code>FIPS</code>
     */

    public String getEndpointType() {
        return this.endpointType;
    }

    /**
     * <p>
     * The type of endpoint for your gateway.
     * </p>
     * <p>
     * Valid Values: <code>STANDARD</code> | <code>FIPS</code>
     * </p>
     * 
     * @param endpointType
     *        The type of endpoint for your gateway.</p>
     *        <p>
     *        Valid Values: <code>STANDARD</code> | <code>FIPS</code>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeGatewayInformationResult withEndpointType(String endpointType) {
        setEndpointType(endpointType);
        return this;
    }

    /**
     * <p>
     * Date after which this gateway will not receive software updates for new features.
     * </p>
     * 
     * @param softwareUpdatesEndDate
     *        Date after which this gateway will not receive software updates for new features.
     */

    public void setSoftwareUpdatesEndDate(String softwareUpdatesEndDate) {
        this.softwareUpdatesEndDate = softwareUpdatesEndDate;
    }

    /**
     * <p>
     * Date after which this gateway will not receive software updates for new features.
     * </p>
     * 
     * @return Date after which this gateway will not receive software updates for new features.
     */

    public String getSoftwareUpdatesEndDate() {
        return this.softwareUpdatesEndDate;
    }

    /**
     * <p>
     * Date after which this gateway will not receive software updates for new features.
     * </p>
     * 
     * @param softwareUpdatesEndDate
     *        Date after which this gateway will not receive software updates for new features.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeGatewayInformationResult withSoftwareUpdatesEndDate(String softwareUpdatesEndDate) {
        setSoftwareUpdatesEndDate(softwareUpdatesEndDate);
        return this;
    }

    /**
     * <p>
     * Date after which this gateway will not receive software updates for new features and bug fixes.
     * </p>
     * 
     * @param deprecationDate
     *        Date after which this gateway will not receive software updates for new features and bug fixes.
     */

    public void setDeprecationDate(String deprecationDate) {
        this.deprecationDate = deprecationDate;
    }

    /**
     * <p>
     * Date after which this gateway will not receive software updates for new features and bug fixes.
     * </p>
     * 
     * @return Date after which this gateway will not receive software updates for new features and bug fixes.
     */

    public String getDeprecationDate() {
        return this.deprecationDate;
    }

    /**
     * <p>
     * Date after which this gateway will not receive software updates for new features and bug fixes.
     * </p>
     * 
     * @param deprecationDate
     *        Date after which this gateway will not receive software updates for new features and bug fixes.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeGatewayInformationResult withDeprecationDate(String deprecationDate) {
        setDeprecationDate(deprecationDate);
        return this;
    }

    /**
     * <p>
     * Specifies the size of the gateway's metadata cache.
     * </p>
     * 
     * @param gatewayCapacity
     *        Specifies the size of the gateway's metadata cache.
     * @see GatewayCapacity
     */

    public void setGatewayCapacity(String gatewayCapacity) {
        this.gatewayCapacity = gatewayCapacity;
    }

    /**
     * <p>
     * Specifies the size of the gateway's metadata cache.
     * </p>
     * 
     * @return Specifies the size of the gateway's metadata cache.
     * @see GatewayCapacity
     */

    public String getGatewayCapacity() {
        return this.gatewayCapacity;
    }

    /**
     * <p>
     * Specifies the size of the gateway's metadata cache.
     * </p>
     * 
     * @param gatewayCapacity
     *        Specifies the size of the gateway's metadata cache.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see GatewayCapacity
     */

    public DescribeGatewayInformationResult withGatewayCapacity(String gatewayCapacity) {
        setGatewayCapacity(gatewayCapacity);
        return this;
    }

    /**
     * <p>
     * Specifies the size of the gateway's metadata cache.
     * </p>
     * 
     * @param gatewayCapacity
     *        Specifies the size of the gateway's metadata cache.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see GatewayCapacity
     */

    public DescribeGatewayInformationResult withGatewayCapacity(GatewayCapacity gatewayCapacity) {
        this.gatewayCapacity = gatewayCapacity.toString();
        return this;
    }

    /**
     * <p>
     * A list of the metadata cache sizes that the gateway can support based on its current hardware specifications.
     * </p>
     * 
     * @return A list of the metadata cache sizes that the gateway can support based on its current hardware
     *         specifications.
     * @see GatewayCapacity
     */

    public java.util.List<String> getSupportedGatewayCapacities() {
        if (supportedGatewayCapacities == null) {
            supportedGatewayCapacities = new com.amazonaws.internal.SdkInternalList<String>();
        }
        return supportedGatewayCapacities;
    }

    /**
     * <p>
     * A list of the metadata cache sizes that the gateway can support based on its current hardware specifications.
     * </p>
     * 
     * @param supportedGatewayCapacities
     *        A list of the metadata cache sizes that the gateway can support based on its current hardware
     *        specifications.
     * @see GatewayCapacity
     */

    public void setSupportedGatewayCapacities(java.util.Collection<String> supportedGatewayCapacities) {
        if (supportedGatewayCapacities == null) {
            this.supportedGatewayCapacities = null;
            return;
        }

        this.supportedGatewayCapacities = new com.amazonaws.internal.SdkInternalList<String>(supportedGatewayCapacities);
    }

    /**
     * <p>
     * A list of the metadata cache sizes that the gateway can support based on its current hardware specifications.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setSupportedGatewayCapacities(java.util.Collection)} or
     * {@link #withSupportedGatewayCapacities(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param supportedGatewayCapacities
     *        A list of the metadata cache sizes that the gateway can support based on its current hardware
     *        specifications.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see GatewayCapacity
     */

    public DescribeGatewayInformationResult withSupportedGatewayCapacities(String... supportedGatewayCapacities) {
        if (this.supportedGatewayCapacities == null) {
            setSupportedGatewayCapacities(new com.amazonaws.internal.SdkInternalList<String>(supportedGatewayCapacities.length));
        }
        for (String ele : supportedGatewayCapacities) {
            this.supportedGatewayCapacities.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of the metadata cache sizes that the gateway can support based on its current hardware specifications.
     * </p>
     * 
     * @param supportedGatewayCapacities
     *        A list of the metadata cache sizes that the gateway can support based on its current hardware
     *        specifications.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see GatewayCapacity
     */

    public DescribeGatewayInformationResult withSupportedGatewayCapacities(java.util.Collection<String> supportedGatewayCapacities) {
        setSupportedGatewayCapacities(supportedGatewayCapacities);
        return this;
    }

    /**
     * <p>
     * A list of the metadata cache sizes that the gateway can support based on its current hardware specifications.
     * </p>
     * 
     * @param supportedGatewayCapacities
     *        A list of the metadata cache sizes that the gateway can support based on its current hardware
     *        specifications.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see GatewayCapacity
     */

    public DescribeGatewayInformationResult withSupportedGatewayCapacities(GatewayCapacity... supportedGatewayCapacities) {
        com.amazonaws.internal.SdkInternalList<String> supportedGatewayCapacitiesCopy = new com.amazonaws.internal.SdkInternalList<String>(
                supportedGatewayCapacities.length);
        for (GatewayCapacity value : supportedGatewayCapacities) {
            supportedGatewayCapacitiesCopy.add(value.toString());
        }
        if (getSupportedGatewayCapacities() == null) {
            setSupportedGatewayCapacities(supportedGatewayCapacitiesCopy);
        } else {
            getSupportedGatewayCapacities().addAll(supportedGatewayCapacitiesCopy);
        }
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getGatewayARN() != null)
            sb.append("GatewayARN: ").append(getGatewayARN()).append(",");
        if (getGatewayId() != null)
            sb.append("GatewayId: ").append(getGatewayId()).append(",");
        if (getGatewayName() != null)
            sb.append("GatewayName: ").append(getGatewayName()).append(",");
        if (getGatewayTimezone() != null)
            sb.append("GatewayTimezone: ").append(getGatewayTimezone()).append(",");
        if (getGatewayState() != null)
            sb.append("GatewayState: ").append(getGatewayState()).append(",");
        if (getGatewayNetworkInterfaces() != null)
            sb.append("GatewayNetworkInterfaces: ").append(getGatewayNetworkInterfaces()).append(",");
        if (getGatewayType() != null)
            sb.append("GatewayType: ").append(getGatewayType()).append(",");
        if (getNextUpdateAvailabilityDate() != null)
            sb.append("NextUpdateAvailabilityDate: ").append(getNextUpdateAvailabilityDate()).append(",");
        if (getLastSoftwareUpdate() != null)
            sb.append("LastSoftwareUpdate: ").append(getLastSoftwareUpdate()).append(",");
        if (getEc2InstanceId() != null)
            sb.append("Ec2InstanceId: ").append(getEc2InstanceId()).append(",");
        if (getEc2InstanceRegion() != null)
            sb.append("Ec2InstanceRegion: ").append(getEc2InstanceRegion()).append(",");
        if (getTags() != null)
            sb.append("Tags: ").append(getTags()).append(",");
        if (getVPCEndpoint() != null)
            sb.append("VPCEndpoint: ").append(getVPCEndpoint()).append(",");
        if (getCloudWatchLogGroupARN() != null)
            sb.append("CloudWatchLogGroupARN: ").append(getCloudWatchLogGroupARN()).append(",");
        if (getHostEnvironment() != null)
            sb.append("HostEnvironment: ").append(getHostEnvironment()).append(",");
        if (getEndpointType() != null)
            sb.append("EndpointType: ").append(getEndpointType()).append(",");
        if (getSoftwareUpdatesEndDate() != null)
            sb.append("SoftwareUpdatesEndDate: ").append(getSoftwareUpdatesEndDate()).append(",");
        if (getDeprecationDate() != null)
            sb.append("DeprecationDate: ").append(getDeprecationDate()).append(",");
        if (getGatewayCapacity() != null)
            sb.append("GatewayCapacity: ").append(getGatewayCapacity()).append(",");
        if (getSupportedGatewayCapacities() != null)
            sb.append("SupportedGatewayCapacities: ").append(getSupportedGatewayCapacities());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DescribeGatewayInformationResult == false)
            return false;
        DescribeGatewayInformationResult other = (DescribeGatewayInformationResult) obj;
        if (other.getGatewayARN() == null ^ this.getGatewayARN() == null)
            return false;
        if (other.getGatewayARN() != null && other.getGatewayARN().equals(this.getGatewayARN()) == false)
            return false;
        if (other.getGatewayId() == null ^ this.getGatewayId() == null)
            return false;
        if (other.getGatewayId() != null && other.getGatewayId().equals(this.getGatewayId()) == false)
            return false;
        if (other.getGatewayName() == null ^ this.getGatewayName() == null)
            return false;
        if (other.getGatewayName() != null && other.getGatewayName().equals(this.getGatewayName()) == false)
            return false;
        if (other.getGatewayTimezone() == null ^ this.getGatewayTimezone() == null)
            return false;
        if (other.getGatewayTimezone() != null && other.getGatewayTimezone().equals(this.getGatewayTimezone()) == false)
            return false;
        if (other.getGatewayState() == null ^ this.getGatewayState() == null)
            return false;
        if (other.getGatewayState() != null && other.getGatewayState().equals(this.getGatewayState()) == false)
            return false;
        if (other.getGatewayNetworkInterfaces() == null ^ this.getGatewayNetworkInterfaces() == null)
            return false;
        if (other.getGatewayNetworkInterfaces() != null && other.getGatewayNetworkInterfaces().equals(this.getGatewayNetworkInterfaces()) == false)
            return false;
        if (other.getGatewayType() == null ^ this.getGatewayType() == null)
            return false;
        if (other.getGatewayType() != null && other.getGatewayType().equals(this.getGatewayType()) == false)
            return false;
        if (other.getNextUpdateAvailabilityDate() == null ^ this.getNextUpdateAvailabilityDate() == null)
            return false;
        if (other.getNextUpdateAvailabilityDate() != null && other.getNextUpdateAvailabilityDate().equals(this.getNextUpdateAvailabilityDate()) == false)
            return false;
        if (other.getLastSoftwareUpdate() == null ^ this.getLastSoftwareUpdate() == null)
            return false;
        if (other.getLastSoftwareUpdate() != null && other.getLastSoftwareUpdate().equals(this.getLastSoftwareUpdate()) == false)
            return false;
        if (other.getEc2InstanceId() == null ^ this.getEc2InstanceId() == null)
            return false;
        if (other.getEc2InstanceId() != null && other.getEc2InstanceId().equals(this.getEc2InstanceId()) == false)
            return false;
        if (other.getEc2InstanceRegion() == null ^ this.getEc2InstanceRegion() == null)
            return false;
        if (other.getEc2InstanceRegion() != null && other.getEc2InstanceRegion().equals(this.getEc2InstanceRegion()) == false)
            return false;
        if (other.getTags() == null ^ this.getTags() == null)
            return false;
        if (other.getTags() != null && other.getTags().equals(this.getTags()) == false)
            return false;
        if (other.getVPCEndpoint() == null ^ this.getVPCEndpoint() == null)
            return false;
        if (other.getVPCEndpoint() != null && other.getVPCEndpoint().equals(this.getVPCEndpoint()) == false)
            return false;
        if (other.getCloudWatchLogGroupARN() == null ^ this.getCloudWatchLogGroupARN() == null)
            return false;
        if (other.getCloudWatchLogGroupARN() != null && other.getCloudWatchLogGroupARN().equals(this.getCloudWatchLogGroupARN()) == false)
            return false;
        if (other.getHostEnvironment() == null ^ this.getHostEnvironment() == null)
            return false;
        if (other.getHostEnvironment() != null && other.getHostEnvironment().equals(this.getHostEnvironment()) == false)
            return false;
        if (other.getEndpointType() == null ^ this.getEndpointType() == null)
            return false;
        if (other.getEndpointType() != null && other.getEndpointType().equals(this.getEndpointType()) == false)
            return false;
        if (other.getSoftwareUpdatesEndDate() == null ^ this.getSoftwareUpdatesEndDate() == null)
            return false;
        if (other.getSoftwareUpdatesEndDate() != null && other.getSoftwareUpdatesEndDate().equals(this.getSoftwareUpdatesEndDate()) == false)
            return false;
        if (other.getDeprecationDate() == null ^ this.getDeprecationDate() == null)
            return false;
        if (other.getDeprecationDate() != null && other.getDeprecationDate().equals(this.getDeprecationDate()) == false)
            return false;
        if (other.getGatewayCapacity() == null ^ this.getGatewayCapacity() == null)
            return false;
        if (other.getGatewayCapacity() != null && other.getGatewayCapacity().equals(this.getGatewayCapacity()) == false)
            return false;
        if (other.getSupportedGatewayCapacities() == null ^ this.getSupportedGatewayCapacities() == null)
            return false;
        if (other.getSupportedGatewayCapacities() != null && other.getSupportedGatewayCapacities().equals(this.getSupportedGatewayCapacities()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getGatewayARN() == null) ? 0 : getGatewayARN().hashCode());
        hashCode = prime * hashCode + ((getGatewayId() == null) ? 0 : getGatewayId().hashCode());
        hashCode = prime * hashCode + ((getGatewayName() == null) ? 0 : getGatewayName().hashCode());
        hashCode = prime * hashCode + ((getGatewayTimezone() == null) ? 0 : getGatewayTimezone().hashCode());
        hashCode = prime * hashCode + ((getGatewayState() == null) ? 0 : getGatewayState().hashCode());
        hashCode = prime * hashCode + ((getGatewayNetworkInterfaces() == null) ? 0 : getGatewayNetworkInterfaces().hashCode());
        hashCode = prime * hashCode + ((getGatewayType() == null) ? 0 : getGatewayType().hashCode());
        hashCode = prime * hashCode + ((getNextUpdateAvailabilityDate() == null) ? 0 : getNextUpdateAvailabilityDate().hashCode());
        hashCode = prime * hashCode + ((getLastSoftwareUpdate() == null) ? 0 : getLastSoftwareUpdate().hashCode());
        hashCode = prime * hashCode + ((getEc2InstanceId() == null) ? 0 : getEc2InstanceId().hashCode());
        hashCode = prime * hashCode + ((getEc2InstanceRegion() == null) ? 0 : getEc2InstanceRegion().hashCode());
        hashCode = prime * hashCode + ((getTags() == null) ? 0 : getTags().hashCode());
        hashCode = prime * hashCode + ((getVPCEndpoint() == null) ? 0 : getVPCEndpoint().hashCode());
        hashCode = prime * hashCode + ((getCloudWatchLogGroupARN() == null) ? 0 : getCloudWatchLogGroupARN().hashCode());
        hashCode = prime * hashCode + ((getHostEnvironment() == null) ? 0 : getHostEnvironment().hashCode());
        hashCode = prime * hashCode + ((getEndpointType() == null) ? 0 : getEndpointType().hashCode());
        hashCode = prime * hashCode + ((getSoftwareUpdatesEndDate() == null) ? 0 : getSoftwareUpdatesEndDate().hashCode());
        hashCode = prime * hashCode + ((getDeprecationDate() == null) ? 0 : getDeprecationDate().hashCode());
        hashCode = prime * hashCode + ((getGatewayCapacity() == null) ? 0 : getGatewayCapacity().hashCode());
        hashCode = prime * hashCode + ((getSupportedGatewayCapacities() == null) ? 0 : getSupportedGatewayCapacities().hashCode());
        return hashCode;
    }

    @Override
    public DescribeGatewayInformationResult clone() {
        try {
            return (DescribeGatewayInformationResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
