/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chatbot;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.chatbot.AWSChatbotAsync;
import com.amazonaws.services.chatbot.AWSChatbotAsyncClientBuilder;
import com.amazonaws.services.chatbot.AWSChatbotClient;
import com.amazonaws.services.chatbot.model.CreateChimeWebhookConfigurationRequest;
import com.amazonaws.services.chatbot.model.CreateChimeWebhookConfigurationResult;
import com.amazonaws.services.chatbot.model.CreateMicrosoftTeamsChannelConfigurationRequest;
import com.amazonaws.services.chatbot.model.CreateMicrosoftTeamsChannelConfigurationResult;
import com.amazonaws.services.chatbot.model.CreateSlackChannelConfigurationRequest;
import com.amazonaws.services.chatbot.model.CreateSlackChannelConfigurationResult;
import com.amazonaws.services.chatbot.model.DeleteChimeWebhookConfigurationRequest;
import com.amazonaws.services.chatbot.model.DeleteChimeWebhookConfigurationResult;
import com.amazonaws.services.chatbot.model.DeleteMicrosoftTeamsChannelConfigurationRequest;
import com.amazonaws.services.chatbot.model.DeleteMicrosoftTeamsChannelConfigurationResult;
import com.amazonaws.services.chatbot.model.DeleteMicrosoftTeamsConfiguredTeamRequest;
import com.amazonaws.services.chatbot.model.DeleteMicrosoftTeamsConfiguredTeamResult;
import com.amazonaws.services.chatbot.model.DeleteMicrosoftTeamsUserIdentityRequest;
import com.amazonaws.services.chatbot.model.DeleteMicrosoftTeamsUserIdentityResult;
import com.amazonaws.services.chatbot.model.DeleteSlackChannelConfigurationRequest;
import com.amazonaws.services.chatbot.model.DeleteSlackChannelConfigurationResult;
import com.amazonaws.services.chatbot.model.DeleteSlackUserIdentityRequest;
import com.amazonaws.services.chatbot.model.DeleteSlackUserIdentityResult;
import com.amazonaws.services.chatbot.model.DeleteSlackWorkspaceAuthorizationRequest;
import com.amazonaws.services.chatbot.model.DeleteSlackWorkspaceAuthorizationResult;
import com.amazonaws.services.chatbot.model.DescribeChimeWebhookConfigurationsRequest;
import com.amazonaws.services.chatbot.model.DescribeChimeWebhookConfigurationsResult;
import com.amazonaws.services.chatbot.model.DescribeSlackChannelConfigurationsRequest;
import com.amazonaws.services.chatbot.model.DescribeSlackChannelConfigurationsResult;
import com.amazonaws.services.chatbot.model.DescribeSlackUserIdentitiesRequest;
import com.amazonaws.services.chatbot.model.DescribeSlackUserIdentitiesResult;
import com.amazonaws.services.chatbot.model.DescribeSlackWorkspacesRequest;
import com.amazonaws.services.chatbot.model.DescribeSlackWorkspacesResult;
import com.amazonaws.services.chatbot.model.GetAccountPreferencesRequest;
import com.amazonaws.services.chatbot.model.GetAccountPreferencesResult;
import com.amazonaws.services.chatbot.model.GetMicrosoftTeamsChannelConfigurationRequest;
import com.amazonaws.services.chatbot.model.GetMicrosoftTeamsChannelConfigurationResult;
import com.amazonaws.services.chatbot.model.ListMicrosoftTeamsChannelConfigurationsRequest;
import com.amazonaws.services.chatbot.model.ListMicrosoftTeamsChannelConfigurationsResult;
import com.amazonaws.services.chatbot.model.ListMicrosoftTeamsConfiguredTeamsRequest;
import com.amazonaws.services.chatbot.model.ListMicrosoftTeamsConfiguredTeamsResult;
import com.amazonaws.services.chatbot.model.ListMicrosoftTeamsUserIdentitiesRequest;
import com.amazonaws.services.chatbot.model.ListMicrosoftTeamsUserIdentitiesResult;
import com.amazonaws.services.chatbot.model.UpdateAccountPreferencesRequest;
import com.amazonaws.services.chatbot.model.UpdateAccountPreferencesResult;
import com.amazonaws.services.chatbot.model.UpdateChimeWebhookConfigurationRequest;
import com.amazonaws.services.chatbot.model.UpdateChimeWebhookConfigurationResult;
import com.amazonaws.services.chatbot.model.UpdateMicrosoftTeamsChannelConfigurationRequest;
import com.amazonaws.services.chatbot.model.UpdateMicrosoftTeamsChannelConfigurationResult;
import com.amazonaws.services.chatbot.model.UpdateSlackChannelConfigurationRequest;
import com.amazonaws.services.chatbot.model.UpdateSlackChannelConfigurationResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSChatbotAsyncClient
extends AWSChatbotClient
implements AWSChatbotAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSChatbotAsyncClientBuilder asyncBuilder() {
        return AWSChatbotAsyncClientBuilder.standard();
    }

    AWSChatbotAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSChatbotAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateChimeWebhookConfigurationResult> createChimeWebhookConfigurationAsync(CreateChimeWebhookConfigurationRequest request) {
        return this.createChimeWebhookConfigurationAsync(request, null);
    }

    @Override
    public Future<CreateChimeWebhookConfigurationResult> createChimeWebhookConfigurationAsync(CreateChimeWebhookConfigurationRequest request, final AsyncHandler<CreateChimeWebhookConfigurationRequest, CreateChimeWebhookConfigurationResult> asyncHandler) {
        final CreateChimeWebhookConfigurationRequest finalRequest = (CreateChimeWebhookConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateChimeWebhookConfigurationResult>(){

            @Override
            public CreateChimeWebhookConfigurationResult call() throws Exception {
                CreateChimeWebhookConfigurationResult result = null;
                try {
                    result = AWSChatbotAsyncClient.this.executeCreateChimeWebhookConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateMicrosoftTeamsChannelConfigurationResult> createMicrosoftTeamsChannelConfigurationAsync(CreateMicrosoftTeamsChannelConfigurationRequest request) {
        return this.createMicrosoftTeamsChannelConfigurationAsync(request, null);
    }

    @Override
    public Future<CreateMicrosoftTeamsChannelConfigurationResult> createMicrosoftTeamsChannelConfigurationAsync(CreateMicrosoftTeamsChannelConfigurationRequest request, final AsyncHandler<CreateMicrosoftTeamsChannelConfigurationRequest, CreateMicrosoftTeamsChannelConfigurationResult> asyncHandler) {
        final CreateMicrosoftTeamsChannelConfigurationRequest finalRequest = (CreateMicrosoftTeamsChannelConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateMicrosoftTeamsChannelConfigurationResult>(){

            @Override
            public CreateMicrosoftTeamsChannelConfigurationResult call() throws Exception {
                CreateMicrosoftTeamsChannelConfigurationResult result = null;
                try {
                    result = AWSChatbotAsyncClient.this.executeCreateMicrosoftTeamsChannelConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateSlackChannelConfigurationResult> createSlackChannelConfigurationAsync(CreateSlackChannelConfigurationRequest request) {
        return this.createSlackChannelConfigurationAsync(request, null);
    }

    @Override
    public Future<CreateSlackChannelConfigurationResult> createSlackChannelConfigurationAsync(CreateSlackChannelConfigurationRequest request, final AsyncHandler<CreateSlackChannelConfigurationRequest, CreateSlackChannelConfigurationResult> asyncHandler) {
        final CreateSlackChannelConfigurationRequest finalRequest = (CreateSlackChannelConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateSlackChannelConfigurationResult>(){

            @Override
            public CreateSlackChannelConfigurationResult call() throws Exception {
                CreateSlackChannelConfigurationResult result = null;
                try {
                    result = AWSChatbotAsyncClient.this.executeCreateSlackChannelConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteChimeWebhookConfigurationResult> deleteChimeWebhookConfigurationAsync(DeleteChimeWebhookConfigurationRequest request) {
        return this.deleteChimeWebhookConfigurationAsync(request, null);
    }

    @Override
    public Future<DeleteChimeWebhookConfigurationResult> deleteChimeWebhookConfigurationAsync(DeleteChimeWebhookConfigurationRequest request, final AsyncHandler<DeleteChimeWebhookConfigurationRequest, DeleteChimeWebhookConfigurationResult> asyncHandler) {
        final DeleteChimeWebhookConfigurationRequest finalRequest = (DeleteChimeWebhookConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteChimeWebhookConfigurationResult>(){

            @Override
            public DeleteChimeWebhookConfigurationResult call() throws Exception {
                DeleteChimeWebhookConfigurationResult result = null;
                try {
                    result = AWSChatbotAsyncClient.this.executeDeleteChimeWebhookConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteMicrosoftTeamsChannelConfigurationResult> deleteMicrosoftTeamsChannelConfigurationAsync(DeleteMicrosoftTeamsChannelConfigurationRequest request) {
        return this.deleteMicrosoftTeamsChannelConfigurationAsync(request, null);
    }

    @Override
    public Future<DeleteMicrosoftTeamsChannelConfigurationResult> deleteMicrosoftTeamsChannelConfigurationAsync(DeleteMicrosoftTeamsChannelConfigurationRequest request, final AsyncHandler<DeleteMicrosoftTeamsChannelConfigurationRequest, DeleteMicrosoftTeamsChannelConfigurationResult> asyncHandler) {
        final DeleteMicrosoftTeamsChannelConfigurationRequest finalRequest = (DeleteMicrosoftTeamsChannelConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteMicrosoftTeamsChannelConfigurationResult>(){

            @Override
            public DeleteMicrosoftTeamsChannelConfigurationResult call() throws Exception {
                DeleteMicrosoftTeamsChannelConfigurationResult result = null;
                try {
                    result = AWSChatbotAsyncClient.this.executeDeleteMicrosoftTeamsChannelConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteMicrosoftTeamsConfiguredTeamResult> deleteMicrosoftTeamsConfiguredTeamAsync(DeleteMicrosoftTeamsConfiguredTeamRequest request) {
        return this.deleteMicrosoftTeamsConfiguredTeamAsync(request, null);
    }

    @Override
    public Future<DeleteMicrosoftTeamsConfiguredTeamResult> deleteMicrosoftTeamsConfiguredTeamAsync(DeleteMicrosoftTeamsConfiguredTeamRequest request, final AsyncHandler<DeleteMicrosoftTeamsConfiguredTeamRequest, DeleteMicrosoftTeamsConfiguredTeamResult> asyncHandler) {
        final DeleteMicrosoftTeamsConfiguredTeamRequest finalRequest = (DeleteMicrosoftTeamsConfiguredTeamRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteMicrosoftTeamsConfiguredTeamResult>(){

            @Override
            public DeleteMicrosoftTeamsConfiguredTeamResult call() throws Exception {
                DeleteMicrosoftTeamsConfiguredTeamResult result = null;
                try {
                    result = AWSChatbotAsyncClient.this.executeDeleteMicrosoftTeamsConfiguredTeam(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteMicrosoftTeamsUserIdentityResult> deleteMicrosoftTeamsUserIdentityAsync(DeleteMicrosoftTeamsUserIdentityRequest request) {
        return this.deleteMicrosoftTeamsUserIdentityAsync(request, null);
    }

    @Override
    public Future<DeleteMicrosoftTeamsUserIdentityResult> deleteMicrosoftTeamsUserIdentityAsync(DeleteMicrosoftTeamsUserIdentityRequest request, final AsyncHandler<DeleteMicrosoftTeamsUserIdentityRequest, DeleteMicrosoftTeamsUserIdentityResult> asyncHandler) {
        final DeleteMicrosoftTeamsUserIdentityRequest finalRequest = (DeleteMicrosoftTeamsUserIdentityRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteMicrosoftTeamsUserIdentityResult>(){

            @Override
            public DeleteMicrosoftTeamsUserIdentityResult call() throws Exception {
                DeleteMicrosoftTeamsUserIdentityResult result = null;
                try {
                    result = AWSChatbotAsyncClient.this.executeDeleteMicrosoftTeamsUserIdentity(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteSlackChannelConfigurationResult> deleteSlackChannelConfigurationAsync(DeleteSlackChannelConfigurationRequest request) {
        return this.deleteSlackChannelConfigurationAsync(request, null);
    }

    @Override
    public Future<DeleteSlackChannelConfigurationResult> deleteSlackChannelConfigurationAsync(DeleteSlackChannelConfigurationRequest request, final AsyncHandler<DeleteSlackChannelConfigurationRequest, DeleteSlackChannelConfigurationResult> asyncHandler) {
        final DeleteSlackChannelConfigurationRequest finalRequest = (DeleteSlackChannelConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteSlackChannelConfigurationResult>(){

            @Override
            public DeleteSlackChannelConfigurationResult call() throws Exception {
                DeleteSlackChannelConfigurationResult result = null;
                try {
                    result = AWSChatbotAsyncClient.this.executeDeleteSlackChannelConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteSlackUserIdentityResult> deleteSlackUserIdentityAsync(DeleteSlackUserIdentityRequest request) {
        return this.deleteSlackUserIdentityAsync(request, null);
    }

    @Override
    public Future<DeleteSlackUserIdentityResult> deleteSlackUserIdentityAsync(DeleteSlackUserIdentityRequest request, final AsyncHandler<DeleteSlackUserIdentityRequest, DeleteSlackUserIdentityResult> asyncHandler) {
        final DeleteSlackUserIdentityRequest finalRequest = (DeleteSlackUserIdentityRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteSlackUserIdentityResult>(){

            @Override
            public DeleteSlackUserIdentityResult call() throws Exception {
                DeleteSlackUserIdentityResult result = null;
                try {
                    result = AWSChatbotAsyncClient.this.executeDeleteSlackUserIdentity(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteSlackWorkspaceAuthorizationResult> deleteSlackWorkspaceAuthorizationAsync(DeleteSlackWorkspaceAuthorizationRequest request) {
        return this.deleteSlackWorkspaceAuthorizationAsync(request, null);
    }

    @Override
    public Future<DeleteSlackWorkspaceAuthorizationResult> deleteSlackWorkspaceAuthorizationAsync(DeleteSlackWorkspaceAuthorizationRequest request, final AsyncHandler<DeleteSlackWorkspaceAuthorizationRequest, DeleteSlackWorkspaceAuthorizationResult> asyncHandler) {
        final DeleteSlackWorkspaceAuthorizationRequest finalRequest = (DeleteSlackWorkspaceAuthorizationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteSlackWorkspaceAuthorizationResult>(){

            @Override
            public DeleteSlackWorkspaceAuthorizationResult call() throws Exception {
                DeleteSlackWorkspaceAuthorizationResult result = null;
                try {
                    result = AWSChatbotAsyncClient.this.executeDeleteSlackWorkspaceAuthorization(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeChimeWebhookConfigurationsResult> describeChimeWebhookConfigurationsAsync(DescribeChimeWebhookConfigurationsRequest request) {
        return this.describeChimeWebhookConfigurationsAsync(request, null);
    }

    @Override
    public Future<DescribeChimeWebhookConfigurationsResult> describeChimeWebhookConfigurationsAsync(DescribeChimeWebhookConfigurationsRequest request, final AsyncHandler<DescribeChimeWebhookConfigurationsRequest, DescribeChimeWebhookConfigurationsResult> asyncHandler) {
        final DescribeChimeWebhookConfigurationsRequest finalRequest = (DescribeChimeWebhookConfigurationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeChimeWebhookConfigurationsResult>(){

            @Override
            public DescribeChimeWebhookConfigurationsResult call() throws Exception {
                DescribeChimeWebhookConfigurationsResult result = null;
                try {
                    result = AWSChatbotAsyncClient.this.executeDescribeChimeWebhookConfigurations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeSlackChannelConfigurationsResult> describeSlackChannelConfigurationsAsync(DescribeSlackChannelConfigurationsRequest request) {
        return this.describeSlackChannelConfigurationsAsync(request, null);
    }

    @Override
    public Future<DescribeSlackChannelConfigurationsResult> describeSlackChannelConfigurationsAsync(DescribeSlackChannelConfigurationsRequest request, final AsyncHandler<DescribeSlackChannelConfigurationsRequest, DescribeSlackChannelConfigurationsResult> asyncHandler) {
        final DescribeSlackChannelConfigurationsRequest finalRequest = (DescribeSlackChannelConfigurationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeSlackChannelConfigurationsResult>(){

            @Override
            public DescribeSlackChannelConfigurationsResult call() throws Exception {
                DescribeSlackChannelConfigurationsResult result = null;
                try {
                    result = AWSChatbotAsyncClient.this.executeDescribeSlackChannelConfigurations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeSlackUserIdentitiesResult> describeSlackUserIdentitiesAsync(DescribeSlackUserIdentitiesRequest request) {
        return this.describeSlackUserIdentitiesAsync(request, null);
    }

    @Override
    public Future<DescribeSlackUserIdentitiesResult> describeSlackUserIdentitiesAsync(DescribeSlackUserIdentitiesRequest request, final AsyncHandler<DescribeSlackUserIdentitiesRequest, DescribeSlackUserIdentitiesResult> asyncHandler) {
        final DescribeSlackUserIdentitiesRequest finalRequest = (DescribeSlackUserIdentitiesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeSlackUserIdentitiesResult>(){

            @Override
            public DescribeSlackUserIdentitiesResult call() throws Exception {
                DescribeSlackUserIdentitiesResult result = null;
                try {
                    result = AWSChatbotAsyncClient.this.executeDescribeSlackUserIdentities(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeSlackWorkspacesResult> describeSlackWorkspacesAsync(DescribeSlackWorkspacesRequest request) {
        return this.describeSlackWorkspacesAsync(request, null);
    }

    @Override
    public Future<DescribeSlackWorkspacesResult> describeSlackWorkspacesAsync(DescribeSlackWorkspacesRequest request, final AsyncHandler<DescribeSlackWorkspacesRequest, DescribeSlackWorkspacesResult> asyncHandler) {
        final DescribeSlackWorkspacesRequest finalRequest = (DescribeSlackWorkspacesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeSlackWorkspacesResult>(){

            @Override
            public DescribeSlackWorkspacesResult call() throws Exception {
                DescribeSlackWorkspacesResult result = null;
                try {
                    result = AWSChatbotAsyncClient.this.executeDescribeSlackWorkspaces(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetAccountPreferencesResult> getAccountPreferencesAsync(GetAccountPreferencesRequest request) {
        return this.getAccountPreferencesAsync(request, null);
    }

    @Override
    public Future<GetAccountPreferencesResult> getAccountPreferencesAsync(GetAccountPreferencesRequest request, final AsyncHandler<GetAccountPreferencesRequest, GetAccountPreferencesResult> asyncHandler) {
        final GetAccountPreferencesRequest finalRequest = (GetAccountPreferencesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetAccountPreferencesResult>(){

            @Override
            public GetAccountPreferencesResult call() throws Exception {
                GetAccountPreferencesResult result = null;
                try {
                    result = AWSChatbotAsyncClient.this.executeGetAccountPreferences(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetMicrosoftTeamsChannelConfigurationResult> getMicrosoftTeamsChannelConfigurationAsync(GetMicrosoftTeamsChannelConfigurationRequest request) {
        return this.getMicrosoftTeamsChannelConfigurationAsync(request, null);
    }

    @Override
    public Future<GetMicrosoftTeamsChannelConfigurationResult> getMicrosoftTeamsChannelConfigurationAsync(GetMicrosoftTeamsChannelConfigurationRequest request, final AsyncHandler<GetMicrosoftTeamsChannelConfigurationRequest, GetMicrosoftTeamsChannelConfigurationResult> asyncHandler) {
        final GetMicrosoftTeamsChannelConfigurationRequest finalRequest = (GetMicrosoftTeamsChannelConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetMicrosoftTeamsChannelConfigurationResult>(){

            @Override
            public GetMicrosoftTeamsChannelConfigurationResult call() throws Exception {
                GetMicrosoftTeamsChannelConfigurationResult result = null;
                try {
                    result = AWSChatbotAsyncClient.this.executeGetMicrosoftTeamsChannelConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListMicrosoftTeamsChannelConfigurationsResult> listMicrosoftTeamsChannelConfigurationsAsync(ListMicrosoftTeamsChannelConfigurationsRequest request) {
        return this.listMicrosoftTeamsChannelConfigurationsAsync(request, null);
    }

    @Override
    public Future<ListMicrosoftTeamsChannelConfigurationsResult> listMicrosoftTeamsChannelConfigurationsAsync(ListMicrosoftTeamsChannelConfigurationsRequest request, final AsyncHandler<ListMicrosoftTeamsChannelConfigurationsRequest, ListMicrosoftTeamsChannelConfigurationsResult> asyncHandler) {
        final ListMicrosoftTeamsChannelConfigurationsRequest finalRequest = (ListMicrosoftTeamsChannelConfigurationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListMicrosoftTeamsChannelConfigurationsResult>(){

            @Override
            public ListMicrosoftTeamsChannelConfigurationsResult call() throws Exception {
                ListMicrosoftTeamsChannelConfigurationsResult result = null;
                try {
                    result = AWSChatbotAsyncClient.this.executeListMicrosoftTeamsChannelConfigurations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListMicrosoftTeamsConfiguredTeamsResult> listMicrosoftTeamsConfiguredTeamsAsync(ListMicrosoftTeamsConfiguredTeamsRequest request) {
        return this.listMicrosoftTeamsConfiguredTeamsAsync(request, null);
    }

    @Override
    public Future<ListMicrosoftTeamsConfiguredTeamsResult> listMicrosoftTeamsConfiguredTeamsAsync(ListMicrosoftTeamsConfiguredTeamsRequest request, final AsyncHandler<ListMicrosoftTeamsConfiguredTeamsRequest, ListMicrosoftTeamsConfiguredTeamsResult> asyncHandler) {
        final ListMicrosoftTeamsConfiguredTeamsRequest finalRequest = (ListMicrosoftTeamsConfiguredTeamsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListMicrosoftTeamsConfiguredTeamsResult>(){

            @Override
            public ListMicrosoftTeamsConfiguredTeamsResult call() throws Exception {
                ListMicrosoftTeamsConfiguredTeamsResult result = null;
                try {
                    result = AWSChatbotAsyncClient.this.executeListMicrosoftTeamsConfiguredTeams(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListMicrosoftTeamsUserIdentitiesResult> listMicrosoftTeamsUserIdentitiesAsync(ListMicrosoftTeamsUserIdentitiesRequest request) {
        return this.listMicrosoftTeamsUserIdentitiesAsync(request, null);
    }

    @Override
    public Future<ListMicrosoftTeamsUserIdentitiesResult> listMicrosoftTeamsUserIdentitiesAsync(ListMicrosoftTeamsUserIdentitiesRequest request, final AsyncHandler<ListMicrosoftTeamsUserIdentitiesRequest, ListMicrosoftTeamsUserIdentitiesResult> asyncHandler) {
        final ListMicrosoftTeamsUserIdentitiesRequest finalRequest = (ListMicrosoftTeamsUserIdentitiesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListMicrosoftTeamsUserIdentitiesResult>(){

            @Override
            public ListMicrosoftTeamsUserIdentitiesResult call() throws Exception {
                ListMicrosoftTeamsUserIdentitiesResult result = null;
                try {
                    result = AWSChatbotAsyncClient.this.executeListMicrosoftTeamsUserIdentities(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateAccountPreferencesResult> updateAccountPreferencesAsync(UpdateAccountPreferencesRequest request) {
        return this.updateAccountPreferencesAsync(request, null);
    }

    @Override
    public Future<UpdateAccountPreferencesResult> updateAccountPreferencesAsync(UpdateAccountPreferencesRequest request, final AsyncHandler<UpdateAccountPreferencesRequest, UpdateAccountPreferencesResult> asyncHandler) {
        final UpdateAccountPreferencesRequest finalRequest = (UpdateAccountPreferencesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateAccountPreferencesResult>(){

            @Override
            public UpdateAccountPreferencesResult call() throws Exception {
                UpdateAccountPreferencesResult result = null;
                try {
                    result = AWSChatbotAsyncClient.this.executeUpdateAccountPreferences(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateChimeWebhookConfigurationResult> updateChimeWebhookConfigurationAsync(UpdateChimeWebhookConfigurationRequest request) {
        return this.updateChimeWebhookConfigurationAsync(request, null);
    }

    @Override
    public Future<UpdateChimeWebhookConfigurationResult> updateChimeWebhookConfigurationAsync(UpdateChimeWebhookConfigurationRequest request, final AsyncHandler<UpdateChimeWebhookConfigurationRequest, UpdateChimeWebhookConfigurationResult> asyncHandler) {
        final UpdateChimeWebhookConfigurationRequest finalRequest = (UpdateChimeWebhookConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateChimeWebhookConfigurationResult>(){

            @Override
            public UpdateChimeWebhookConfigurationResult call() throws Exception {
                UpdateChimeWebhookConfigurationResult result = null;
                try {
                    result = AWSChatbotAsyncClient.this.executeUpdateChimeWebhookConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateMicrosoftTeamsChannelConfigurationResult> updateMicrosoftTeamsChannelConfigurationAsync(UpdateMicrosoftTeamsChannelConfigurationRequest request) {
        return this.updateMicrosoftTeamsChannelConfigurationAsync(request, null);
    }

    @Override
    public Future<UpdateMicrosoftTeamsChannelConfigurationResult> updateMicrosoftTeamsChannelConfigurationAsync(UpdateMicrosoftTeamsChannelConfigurationRequest request, final AsyncHandler<UpdateMicrosoftTeamsChannelConfigurationRequest, UpdateMicrosoftTeamsChannelConfigurationResult> asyncHandler) {
        final UpdateMicrosoftTeamsChannelConfigurationRequest finalRequest = (UpdateMicrosoftTeamsChannelConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateMicrosoftTeamsChannelConfigurationResult>(){

            @Override
            public UpdateMicrosoftTeamsChannelConfigurationResult call() throws Exception {
                UpdateMicrosoftTeamsChannelConfigurationResult result = null;
                try {
                    result = AWSChatbotAsyncClient.this.executeUpdateMicrosoftTeamsChannelConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateSlackChannelConfigurationResult> updateSlackChannelConfigurationAsync(UpdateSlackChannelConfigurationRequest request) {
        return this.updateSlackChannelConfigurationAsync(request, null);
    }

    @Override
    public Future<UpdateSlackChannelConfigurationResult> updateSlackChannelConfigurationAsync(UpdateSlackChannelConfigurationRequest request, final AsyncHandler<UpdateSlackChannelConfigurationRequest, UpdateSlackChannelConfigurationResult> asyncHandler) {
        final UpdateSlackChannelConfigurationRequest finalRequest = (UpdateSlackChannelConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateSlackChannelConfigurationResult>(){

            @Override
            public UpdateSlackChannelConfigurationResult call() throws Exception {
                UpdateSlackChannelConfigurationResult result = null;
                try {
                    result = AWSChatbotAsyncClient.this.executeUpdateSlackChannelConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

