/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.chime;

import javax.annotation.Generated;

import com.amazonaws.services.chime.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AmazonChime}. Convenient method forms pass through to the corresponding overload
 * that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonChime implements AmazonChime {

    protected AbstractAmazonChime() {
    }

    @Override
    public AssociatePhoneNumberWithUserResult associatePhoneNumberWithUser(AssociatePhoneNumberWithUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociatePhoneNumbersWithVoiceConnectorResult associatePhoneNumbersWithVoiceConnector(AssociatePhoneNumbersWithVoiceConnectorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociatePhoneNumbersWithVoiceConnectorGroupResult associatePhoneNumbersWithVoiceConnectorGroup(
            AssociatePhoneNumbersWithVoiceConnectorGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociateSigninDelegateGroupsWithAccountResult associateSigninDelegateGroupsWithAccount(AssociateSigninDelegateGroupsWithAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchCreateAttendeeResult batchCreateAttendee(BatchCreateAttendeeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchCreateChannelMembershipResult batchCreateChannelMembership(BatchCreateChannelMembershipRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchCreateRoomMembershipResult batchCreateRoomMembership(BatchCreateRoomMembershipRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchDeletePhoneNumberResult batchDeletePhoneNumber(BatchDeletePhoneNumberRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchSuspendUserResult batchSuspendUser(BatchSuspendUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchUnsuspendUserResult batchUnsuspendUser(BatchUnsuspendUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchUpdatePhoneNumberResult batchUpdatePhoneNumber(BatchUpdatePhoneNumberRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchUpdateUserResult batchUpdateUser(BatchUpdateUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAccountResult createAccount(CreateAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAppInstanceResult createAppInstance(CreateAppInstanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAppInstanceAdminResult createAppInstanceAdmin(CreateAppInstanceAdminRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAppInstanceUserResult createAppInstanceUser(CreateAppInstanceUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAttendeeResult createAttendee(CreateAttendeeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateBotResult createBot(CreateBotRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateChannelResult createChannel(CreateChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateChannelBanResult createChannelBan(CreateChannelBanRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateChannelMembershipResult createChannelMembership(CreateChannelMembershipRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateChannelModeratorResult createChannelModerator(CreateChannelModeratorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateMeetingResult createMeeting(CreateMeetingRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateMeetingDialOutResult createMeetingDialOut(CreateMeetingDialOutRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateMeetingWithAttendeesResult createMeetingWithAttendees(CreateMeetingWithAttendeesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreatePhoneNumberOrderResult createPhoneNumberOrder(CreatePhoneNumberOrderRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateProxySessionResult createProxySession(CreateProxySessionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateRoomResult createRoom(CreateRoomRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateRoomMembershipResult createRoomMembership(CreateRoomMembershipRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSipMediaApplicationResult createSipMediaApplication(CreateSipMediaApplicationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSipMediaApplicationCallResult createSipMediaApplicationCall(CreateSipMediaApplicationCallRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSipRuleResult createSipRule(CreateSipRuleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateUserResult createUser(CreateUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateVoiceConnectorResult createVoiceConnector(CreateVoiceConnectorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateVoiceConnectorGroupResult createVoiceConnectorGroup(CreateVoiceConnectorGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAccountResult deleteAccount(DeleteAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAppInstanceResult deleteAppInstance(DeleteAppInstanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAppInstanceAdminResult deleteAppInstanceAdmin(DeleteAppInstanceAdminRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAppInstanceStreamingConfigurationsResult deleteAppInstanceStreamingConfigurations(DeleteAppInstanceStreamingConfigurationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAppInstanceUserResult deleteAppInstanceUser(DeleteAppInstanceUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAttendeeResult deleteAttendee(DeleteAttendeeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteChannelResult deleteChannel(DeleteChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteChannelBanResult deleteChannelBan(DeleteChannelBanRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteChannelMembershipResult deleteChannelMembership(DeleteChannelMembershipRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteChannelMessageResult deleteChannelMessage(DeleteChannelMessageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteChannelModeratorResult deleteChannelModerator(DeleteChannelModeratorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteEventsConfigurationResult deleteEventsConfiguration(DeleteEventsConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteMeetingResult deleteMeeting(DeleteMeetingRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeletePhoneNumberResult deletePhoneNumber(DeletePhoneNumberRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteProxySessionResult deleteProxySession(DeleteProxySessionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteRoomResult deleteRoom(DeleteRoomRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteRoomMembershipResult deleteRoomMembership(DeleteRoomMembershipRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteSipMediaApplicationResult deleteSipMediaApplication(DeleteSipMediaApplicationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteSipRuleResult deleteSipRule(DeleteSipRuleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteVoiceConnectorResult deleteVoiceConnector(DeleteVoiceConnectorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteVoiceConnectorEmergencyCallingConfigurationResult deleteVoiceConnectorEmergencyCallingConfiguration(
            DeleteVoiceConnectorEmergencyCallingConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteVoiceConnectorGroupResult deleteVoiceConnectorGroup(DeleteVoiceConnectorGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteVoiceConnectorOriginationResult deleteVoiceConnectorOrigination(DeleteVoiceConnectorOriginationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteVoiceConnectorProxyResult deleteVoiceConnectorProxy(DeleteVoiceConnectorProxyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteVoiceConnectorStreamingConfigurationResult deleteVoiceConnectorStreamingConfiguration(DeleteVoiceConnectorStreamingConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteVoiceConnectorTerminationResult deleteVoiceConnectorTermination(DeleteVoiceConnectorTerminationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteVoiceConnectorTerminationCredentialsResult deleteVoiceConnectorTerminationCredentials(DeleteVoiceConnectorTerminationCredentialsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAppInstanceResult describeAppInstance(DescribeAppInstanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAppInstanceAdminResult describeAppInstanceAdmin(DescribeAppInstanceAdminRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAppInstanceUserResult describeAppInstanceUser(DescribeAppInstanceUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeChannelResult describeChannel(DescribeChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeChannelBanResult describeChannelBan(DescribeChannelBanRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeChannelMembershipResult describeChannelMembership(DescribeChannelMembershipRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeChannelMembershipForAppInstanceUserResult describeChannelMembershipForAppInstanceUser(
            DescribeChannelMembershipForAppInstanceUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeChannelModeratedByAppInstanceUserResult describeChannelModeratedByAppInstanceUser(DescribeChannelModeratedByAppInstanceUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeChannelModeratorResult describeChannelModerator(DescribeChannelModeratorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociatePhoneNumberFromUserResult disassociatePhoneNumberFromUser(DisassociatePhoneNumberFromUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociatePhoneNumbersFromVoiceConnectorResult disassociatePhoneNumbersFromVoiceConnector(DisassociatePhoneNumbersFromVoiceConnectorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociatePhoneNumbersFromVoiceConnectorGroupResult disassociatePhoneNumbersFromVoiceConnectorGroup(
            DisassociatePhoneNumbersFromVoiceConnectorGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateSigninDelegateGroupsFromAccountResult disassociateSigninDelegateGroupsFromAccount(
            DisassociateSigninDelegateGroupsFromAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAccountResult getAccount(GetAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAccountSettingsResult getAccountSettings(GetAccountSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAppInstanceRetentionSettingsResult getAppInstanceRetentionSettings(GetAppInstanceRetentionSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAppInstanceStreamingConfigurationsResult getAppInstanceStreamingConfigurations(GetAppInstanceStreamingConfigurationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAttendeeResult getAttendee(GetAttendeeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetBotResult getBot(GetBotRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetChannelMessageResult getChannelMessage(GetChannelMessageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetEventsConfigurationResult getEventsConfiguration(GetEventsConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetGlobalSettingsResult getGlobalSettings(GetGlobalSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetMeetingResult getMeeting(GetMeetingRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetMessagingSessionEndpointResult getMessagingSessionEndpoint(GetMessagingSessionEndpointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetPhoneNumberResult getPhoneNumber(GetPhoneNumberRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetPhoneNumberOrderResult getPhoneNumberOrder(GetPhoneNumberOrderRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetPhoneNumberSettingsResult getPhoneNumberSettings(GetPhoneNumberSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetProxySessionResult getProxySession(GetProxySessionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetRetentionSettingsResult getRetentionSettings(GetRetentionSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetRoomResult getRoom(GetRoomRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSipMediaApplicationResult getSipMediaApplication(GetSipMediaApplicationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSipMediaApplicationLoggingConfigurationResult getSipMediaApplicationLoggingConfiguration(GetSipMediaApplicationLoggingConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSipRuleResult getSipRule(GetSipRuleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetUserResult getUser(GetUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetUserSettingsResult getUserSettings(GetUserSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetVoiceConnectorResult getVoiceConnector(GetVoiceConnectorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetVoiceConnectorEmergencyCallingConfigurationResult getVoiceConnectorEmergencyCallingConfiguration(
            GetVoiceConnectorEmergencyCallingConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetVoiceConnectorGroupResult getVoiceConnectorGroup(GetVoiceConnectorGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetVoiceConnectorLoggingConfigurationResult getVoiceConnectorLoggingConfiguration(GetVoiceConnectorLoggingConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetVoiceConnectorOriginationResult getVoiceConnectorOrigination(GetVoiceConnectorOriginationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetVoiceConnectorProxyResult getVoiceConnectorProxy(GetVoiceConnectorProxyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetVoiceConnectorStreamingConfigurationResult getVoiceConnectorStreamingConfiguration(GetVoiceConnectorStreamingConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetVoiceConnectorTerminationResult getVoiceConnectorTermination(GetVoiceConnectorTerminationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetVoiceConnectorTerminationHealthResult getVoiceConnectorTerminationHealth(GetVoiceConnectorTerminationHealthRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public InviteUsersResult inviteUsers(InviteUsersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAccountsResult listAccounts(ListAccountsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAppInstanceAdminsResult listAppInstanceAdmins(ListAppInstanceAdminsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAppInstanceUsersResult listAppInstanceUsers(ListAppInstanceUsersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAppInstancesResult listAppInstances(ListAppInstancesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAttendeeTagsResult listAttendeeTags(ListAttendeeTagsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAttendeesResult listAttendees(ListAttendeesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListBotsResult listBots(ListBotsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListChannelBansResult listChannelBans(ListChannelBansRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListChannelMembershipsResult listChannelMemberships(ListChannelMembershipsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListChannelMembershipsForAppInstanceUserResult listChannelMembershipsForAppInstanceUser(ListChannelMembershipsForAppInstanceUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListChannelMessagesResult listChannelMessages(ListChannelMessagesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListChannelModeratorsResult listChannelModerators(ListChannelModeratorsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListChannelsResult listChannels(ListChannelsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListChannelsModeratedByAppInstanceUserResult listChannelsModeratedByAppInstanceUser(ListChannelsModeratedByAppInstanceUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListMeetingTagsResult listMeetingTags(ListMeetingTagsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListMeetingsResult listMeetings(ListMeetingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPhoneNumberOrdersResult listPhoneNumberOrders(ListPhoneNumberOrdersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPhoneNumbersResult listPhoneNumbers(ListPhoneNumbersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListProxySessionsResult listProxySessions(ListProxySessionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListRoomMembershipsResult listRoomMemberships(ListRoomMembershipsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListRoomsResult listRooms(ListRoomsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSipMediaApplicationsResult listSipMediaApplications(ListSipMediaApplicationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSipRulesResult listSipRules(ListSipRulesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListUsersResult listUsers(ListUsersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListVoiceConnectorGroupsResult listVoiceConnectorGroups(ListVoiceConnectorGroupsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListVoiceConnectorTerminationCredentialsResult listVoiceConnectorTerminationCredentials(ListVoiceConnectorTerminationCredentialsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListVoiceConnectorsResult listVoiceConnectors(ListVoiceConnectorsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public LogoutUserResult logoutUser(LogoutUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutAppInstanceRetentionSettingsResult putAppInstanceRetentionSettings(PutAppInstanceRetentionSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutAppInstanceStreamingConfigurationsResult putAppInstanceStreamingConfigurations(PutAppInstanceStreamingConfigurationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutEventsConfigurationResult putEventsConfiguration(PutEventsConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutRetentionSettingsResult putRetentionSettings(PutRetentionSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutSipMediaApplicationLoggingConfigurationResult putSipMediaApplicationLoggingConfiguration(PutSipMediaApplicationLoggingConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutVoiceConnectorEmergencyCallingConfigurationResult putVoiceConnectorEmergencyCallingConfiguration(
            PutVoiceConnectorEmergencyCallingConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutVoiceConnectorLoggingConfigurationResult putVoiceConnectorLoggingConfiguration(PutVoiceConnectorLoggingConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutVoiceConnectorOriginationResult putVoiceConnectorOrigination(PutVoiceConnectorOriginationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutVoiceConnectorProxyResult putVoiceConnectorProxy(PutVoiceConnectorProxyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutVoiceConnectorStreamingConfigurationResult putVoiceConnectorStreamingConfiguration(PutVoiceConnectorStreamingConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutVoiceConnectorTerminationResult putVoiceConnectorTermination(PutVoiceConnectorTerminationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutVoiceConnectorTerminationCredentialsResult putVoiceConnectorTerminationCredentials(PutVoiceConnectorTerminationCredentialsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RedactChannelMessageResult redactChannelMessage(RedactChannelMessageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RedactConversationMessageResult redactConversationMessage(RedactConversationMessageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RedactRoomMessageResult redactRoomMessage(RedactRoomMessageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RegenerateSecurityTokenResult regenerateSecurityToken(RegenerateSecurityTokenRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ResetPersonalPINResult resetPersonalPIN(ResetPersonalPINRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RestorePhoneNumberResult restorePhoneNumber(RestorePhoneNumberRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchAvailablePhoneNumbersResult searchAvailablePhoneNumbers(SearchAvailablePhoneNumbersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SendChannelMessageResult sendChannelMessage(SendChannelMessageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagAttendeeResult tagAttendee(TagAttendeeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagMeetingResult tagMeeting(TagMeetingRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagAttendeeResult untagAttendee(UntagAttendeeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagMeetingResult untagMeeting(UntagMeetingRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAccountResult updateAccount(UpdateAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAccountSettingsResult updateAccountSettings(UpdateAccountSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAppInstanceResult updateAppInstance(UpdateAppInstanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAppInstanceUserResult updateAppInstanceUser(UpdateAppInstanceUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateBotResult updateBot(UpdateBotRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateChannelResult updateChannel(UpdateChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateChannelMessageResult updateChannelMessage(UpdateChannelMessageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateChannelReadMarkerResult updateChannelReadMarker(UpdateChannelReadMarkerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateGlobalSettingsResult updateGlobalSettings(UpdateGlobalSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdatePhoneNumberResult updatePhoneNumber(UpdatePhoneNumberRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdatePhoneNumberSettingsResult updatePhoneNumberSettings(UpdatePhoneNumberSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateProxySessionResult updateProxySession(UpdateProxySessionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateRoomResult updateRoom(UpdateRoomRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateRoomMembershipResult updateRoomMembership(UpdateRoomMembershipRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateSipMediaApplicationResult updateSipMediaApplication(UpdateSipMediaApplicationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateSipRuleResult updateSipRule(UpdateSipRuleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateUserResult updateUser(UpdateUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateUserSettingsResult updateUserSettings(UpdateUserSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateVoiceConnectorResult updateVoiceConnector(UpdateVoiceConnectorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateVoiceConnectorGroupResult updateVoiceConnectorGroup(UpdateVoiceConnectorGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
