/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p>
 * Amazon Chime is a communications service that transforms online meetings with a secure, easy-to-use application that
 * you can trust. Amazon Chime works seamlessly across your devices so that you can stay connected. You can use Amazon
 * Chime for online meetings, video conferencing, calls, and chat. You can also share content, both inside and outside
 * your organization. Amazon Chime frees you to work productively from anywhere.
 * </p>
 * <p>
 * The Amazon Chime API is designed for administrators to use to perform key tasks, such as creating and managing Amazon
 * Chime accounts and users. This guide provides detailed information about the Amazon Chime API.
 * </p>
 * <p>
 * Use host name <code>service.chime.aws.amazon.com</code> when working with the Amazon Chime API.
 * </p>
 */
package com.amazonaws.services.chime;

