/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chimesdkmessaging.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.chimesdkmessaging.model.MessagingDataType;
import com.amazonaws.services.chimesdkmessaging.model.transform.StreamingConfigurationMarshaller;
import java.io.Serializable;

public class StreamingConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String dataType;
    private String resourceArn;

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getDataType() {
        return this.dataType;
    }

    public StreamingConfiguration withDataType(String dataType) {
        this.setDataType(dataType);
        return this;
    }

    public StreamingConfiguration withDataType(MessagingDataType dataType) {
        this.dataType = dataType.toString();
        return this;
    }

    public void setResourceArn(String resourceArn) {
        this.resourceArn = resourceArn;
    }

    public String getResourceArn() {
        return this.resourceArn;
    }

    public StreamingConfiguration withResourceArn(String resourceArn) {
        this.setResourceArn(resourceArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDataType() != null) {
            sb.append("DataType: ").append(this.getDataType()).append(",");
        }
        if (this.getResourceArn() != null) {
            sb.append("ResourceArn: ").append(this.getResourceArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamingConfiguration)) {
            return false;
        }
        StreamingConfiguration other = (StreamingConfiguration)obj;
        if (other.getDataType() == null ^ this.getDataType() == null) {
            return false;
        }
        if (other.getDataType() != null && !other.getDataType().equals(this.getDataType())) {
            return false;
        }
        if (other.getResourceArn() == null ^ this.getResourceArn() == null) {
            return false;
        }
        return other.getResourceArn() == null || other.getResourceArn().equals(this.getResourceArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDataType() == null ? 0 : this.getDataType().hashCode());
        hashCode = 31 * hashCode + (this.getResourceArn() == null ? 0 : this.getResourceArn().hashCode());
        return hashCode;
    }

    public StreamingConfiguration clone() {
        try {
            return (StreamingConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StreamingConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

