/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.chimesdkmessaging.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/ListSubChannels"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListSubChannelsResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * The ARN of elastic channel.
     * </p>
     */
    private String channelArn;
    /**
     * <p>
     * The information about each sub-channel.
     * </p>
     */
    private java.util.List<SubChannelSummary> subChannels;
    /**
     * <p>
     * The token passed by previous API calls until all requested sub-channels are returned.
     * </p>
     */
    private String nextToken;

    /**
     * <p>
     * The ARN of elastic channel.
     * </p>
     * 
     * @param channelArn
     *        The ARN of elastic channel.
     */

    public void setChannelArn(String channelArn) {
        this.channelArn = channelArn;
    }

    /**
     * <p>
     * The ARN of elastic channel.
     * </p>
     * 
     * @return The ARN of elastic channel.
     */

    public String getChannelArn() {
        return this.channelArn;
    }

    /**
     * <p>
     * The ARN of elastic channel.
     * </p>
     * 
     * @param channelArn
     *        The ARN of elastic channel.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListSubChannelsResult withChannelArn(String channelArn) {
        setChannelArn(channelArn);
        return this;
    }

    /**
     * <p>
     * The information about each sub-channel.
     * </p>
     * 
     * @return The information about each sub-channel.
     */

    public java.util.List<SubChannelSummary> getSubChannels() {
        return subChannels;
    }

    /**
     * <p>
     * The information about each sub-channel.
     * </p>
     * 
     * @param subChannels
     *        The information about each sub-channel.
     */

    public void setSubChannels(java.util.Collection<SubChannelSummary> subChannels) {
        if (subChannels == null) {
            this.subChannels = null;
            return;
        }

        this.subChannels = new java.util.ArrayList<SubChannelSummary>(subChannels);
    }

    /**
     * <p>
     * The information about each sub-channel.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setSubChannels(java.util.Collection)} or {@link #withSubChannels(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param subChannels
     *        The information about each sub-channel.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListSubChannelsResult withSubChannels(SubChannelSummary... subChannels) {
        if (this.subChannels == null) {
            setSubChannels(new java.util.ArrayList<SubChannelSummary>(subChannels.length));
        }
        for (SubChannelSummary ele : subChannels) {
            this.subChannels.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The information about each sub-channel.
     * </p>
     * 
     * @param subChannels
     *        The information about each sub-channel.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListSubChannelsResult withSubChannels(java.util.Collection<SubChannelSummary> subChannels) {
        setSubChannels(subChannels);
        return this;
    }

    /**
     * <p>
     * The token passed by previous API calls until all requested sub-channels are returned.
     * </p>
     * 
     * @param nextToken
     *        The token passed by previous API calls until all requested sub-channels are returned.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * The token passed by previous API calls until all requested sub-channels are returned.
     * </p>
     * 
     * @return The token passed by previous API calls until all requested sub-channels are returned.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * The token passed by previous API calls until all requested sub-channels are returned.
     * </p>
     * 
     * @param nextToken
     *        The token passed by previous API calls until all requested sub-channels are returned.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListSubChannelsResult withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getChannelArn() != null)
            sb.append("ChannelArn: ").append(getChannelArn()).append(",");
        if (getSubChannels() != null)
            sb.append("SubChannels: ").append(getSubChannels()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append("***Sensitive Data Redacted***");
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListSubChannelsResult == false)
            return false;
        ListSubChannelsResult other = (ListSubChannelsResult) obj;
        if (other.getChannelArn() == null ^ this.getChannelArn() == null)
            return false;
        if (other.getChannelArn() != null && other.getChannelArn().equals(this.getChannelArn()) == false)
            return false;
        if (other.getSubChannels() == null ^ this.getSubChannels() == null)
            return false;
        if (other.getSubChannels() != null && other.getSubChannels().equals(this.getSubChannels()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getChannelArn() == null) ? 0 : getChannelArn().hashCode());
        hashCode = prime * hashCode + ((getSubChannels() == null) ? 0 : getSubChannels().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public ListSubChannelsResult clone() {
        try {
            return (ListSubChannelsResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
