/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.cleanrooms;

import javax.annotation.Generated;

import com.amazonaws.services.cleanrooms.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSCleanRooms}. Convenient method forms pass through to the corresponding overload
 * that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSCleanRooms implements AWSCleanRooms {

    protected AbstractAWSCleanRooms() {
    }

    @Override
    public BatchGetSchemaResult batchGetSchema(BatchGetSchemaRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateCollaborationResult createCollaboration(CreateCollaborationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateConfiguredTableResult createConfiguredTable(CreateConfiguredTableRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateConfiguredTableAnalysisRuleResult createConfiguredTableAnalysisRule(CreateConfiguredTableAnalysisRuleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateConfiguredTableAssociationResult createConfiguredTableAssociation(CreateConfiguredTableAssociationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateMembershipResult createMembership(CreateMembershipRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteCollaborationResult deleteCollaboration(DeleteCollaborationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteConfiguredTableResult deleteConfiguredTable(DeleteConfiguredTableRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteConfiguredTableAnalysisRuleResult deleteConfiguredTableAnalysisRule(DeleteConfiguredTableAnalysisRuleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteConfiguredTableAssociationResult deleteConfiguredTableAssociation(DeleteConfiguredTableAssociationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteMemberResult deleteMember(DeleteMemberRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteMembershipResult deleteMembership(DeleteMembershipRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetCollaborationResult getCollaboration(GetCollaborationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetConfiguredTableResult getConfiguredTable(GetConfiguredTableRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetConfiguredTableAnalysisRuleResult getConfiguredTableAnalysisRule(GetConfiguredTableAnalysisRuleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetConfiguredTableAssociationResult getConfiguredTableAssociation(GetConfiguredTableAssociationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetMembershipResult getMembership(GetMembershipRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetProtectedQueryResult getProtectedQuery(GetProtectedQueryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSchemaResult getSchema(GetSchemaRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSchemaAnalysisRuleResult getSchemaAnalysisRule(GetSchemaAnalysisRuleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCollaborationsResult listCollaborations(ListCollaborationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListConfiguredTableAssociationsResult listConfiguredTableAssociations(ListConfiguredTableAssociationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListConfiguredTablesResult listConfiguredTables(ListConfiguredTablesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListMembersResult listMembers(ListMembersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListMembershipsResult listMemberships(ListMembershipsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListProtectedQueriesResult listProtectedQueries(ListProtectedQueriesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSchemasResult listSchemas(ListSchemasRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartProtectedQueryResult startProtectedQuery(StartProtectedQueryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateCollaborationResult updateCollaboration(UpdateCollaborationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateConfiguredTableResult updateConfiguredTable(UpdateConfiguredTableRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateConfiguredTableAnalysisRuleResult updateConfiguredTableAnalysisRule(UpdateConfiguredTableAnalysisRuleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateConfiguredTableAssociationResult updateConfiguredTableAssociation(UpdateConfiguredTableAssociationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateMembershipResult updateMembership(UpdateMembershipRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateProtectedQueryResult updateProtectedQuery(UpdateProtectedQueryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
