/*
 * Copyright 2012-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.clouddirectory.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.clouddirectory.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * TypedAttributeValueRangeMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class TypedAttributeValueRangeMarshaller {

    private static final MarshallingInfo<String> STARTMODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("StartMode").build();
    private static final MarshallingInfo<StructuredPojo> STARTVALUE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartValue").build();
    private static final MarshallingInfo<String> ENDMODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("EndMode").build();
    private static final MarshallingInfo<StructuredPojo> ENDVALUE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndValue").build();

    private static final TypedAttributeValueRangeMarshaller instance = new TypedAttributeValueRangeMarshaller();

    public static TypedAttributeValueRangeMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(TypedAttributeValueRange typedAttributeValueRange, ProtocolMarshaller protocolMarshaller) {

        if (typedAttributeValueRange == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(typedAttributeValueRange.getStartMode(), STARTMODE_BINDING);
            protocolMarshaller.marshall(typedAttributeValueRange.getStartValue(), STARTVALUE_BINDING);
            protocolMarshaller.marshall(typedAttributeValueRange.getEndMode(), ENDMODE_BINDING);
            protocolMarshaller.marshall(typedAttributeValueRange.getEndValue(), ENDVALUE_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
