/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.clouddirectory.model.transform;

import java.io.ByteArrayInputStream;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.Request;
import com.amazonaws.DefaultRequest;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.clouddirectory.model.*;
import com.amazonaws.transform.Marshaller;

import com.amazonaws.util.StringUtils;

import com.amazonaws.protocol.json.*;

/**
 * ListAttachedIndicesRequest Marshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListAttachedIndicesRequestMarshaller implements Marshaller<Request<ListAttachedIndicesRequest>, ListAttachedIndicesRequest> {

    private final SdkJsonMarshallerFactory protocolFactory;

    public ListAttachedIndicesRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ListAttachedIndicesRequest> marshall(ListAttachedIndicesRequest listAttachedIndicesRequest) {

        if (listAttachedIndicesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<ListAttachedIndicesRequest> request = new DefaultRequest<ListAttachedIndicesRequest>(listAttachedIndicesRequest, "AmazonCloudDirectory");

        request.setHttpMethod(HttpMethodName.POST);

        if (listAttachedIndicesRequest.getDirectoryArn() != null) {
            request.addHeader("x-amz-data-partition", StringUtils.fromString(listAttachedIndicesRequest.getDirectoryArn()));
        }

        if (listAttachedIndicesRequest.getConsistencyLevel() != null) {
            request.addHeader("x-amz-consistency-level", StringUtils.fromString(listAttachedIndicesRequest.getConsistencyLevel()));
        }

        String uriResourcePath = "/amazonclouddirectory/2017-01-11/object/indices";

        request.setResourcePath(uriResourcePath);

        try {
            final StructuredJsonGenerator jsonGenerator = protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();

            if (listAttachedIndicesRequest.getTargetReference() != null) {
                jsonGenerator.writeFieldName("TargetReference");
                ObjectReferenceJsonMarshaller.getInstance().marshall(listAttachedIndicesRequest.getTargetReference(), jsonGenerator);
            }
            if (listAttachedIndicesRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(listAttachedIndicesRequest.getNextToken());
            }
            if (listAttachedIndicesRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("MaxResults").writeValue(listAttachedIndicesRequest.getMaxResults());
            }

            jsonGenerator.writeEndObject();

            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", protocolFactory.getContentType());
            }
        } catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }

        return request;
    }

}
