/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.clouddirectory.model.TypedAttributeValue;

public class TypedAttributeValueJsonMarshaller {
    private static TypedAttributeValueJsonMarshaller instance;

    public void marshall(TypedAttributeValue typedAttributeValue, StructuredJsonGenerator jsonGenerator) {
        if (typedAttributeValue == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (typedAttributeValue.getStringValue() != null) {
                jsonGenerator.writeFieldName("StringValue").writeValue(typedAttributeValue.getStringValue());
            }
            if (typedAttributeValue.getBinaryValue() != null) {
                jsonGenerator.writeFieldName("BinaryValue").writeValue(typedAttributeValue.getBinaryValue());
            }
            if (typedAttributeValue.getBooleanValue() != null) {
                jsonGenerator.writeFieldName("BooleanValue").writeValue(typedAttributeValue.getBooleanValue().booleanValue());
            }
            if (typedAttributeValue.getNumberValue() != null) {
                jsonGenerator.writeFieldName("NumberValue").writeValue(typedAttributeValue.getNumberValue());
            }
            if (typedAttributeValue.getDatetimeValue() != null) {
                jsonGenerator.writeFieldName("DatetimeValue").writeValue(typedAttributeValue.getDatetimeValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static TypedAttributeValueJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new TypedAttributeValueJsonMarshaller();
        }
        return instance;
    }
}

