/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.clouddirectory;

import javax.annotation.Generated;

import com.amazonaws.services.clouddirectory.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AmazonCloudDirectory}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonCloudDirectory implements AmazonCloudDirectory {

    protected AbstractAmazonCloudDirectory() {
    }

    @Override
    public void setEndpoint(String endpoint) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void setRegion(com.amazonaws.regions.Region region) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AddFacetToObjectResult addFacetToObject(AddFacetToObjectRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ApplySchemaResult applySchema(ApplySchemaRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AttachObjectResult attachObject(AttachObjectRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AttachPolicyResult attachPolicy(AttachPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AttachToIndexResult attachToIndex(AttachToIndexRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchReadResult batchRead(BatchReadRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchWriteResult batchWrite(BatchWriteRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDirectoryResult createDirectory(CreateDirectoryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateFacetResult createFacet(CreateFacetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateIndexResult createIndex(CreateIndexRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateObjectResult createObject(CreateObjectRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSchemaResult createSchema(CreateSchemaRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDirectoryResult deleteDirectory(DeleteDirectoryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteFacetResult deleteFacet(DeleteFacetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteObjectResult deleteObject(DeleteObjectRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteSchemaResult deleteSchema(DeleteSchemaRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DetachFromIndexResult detachFromIndex(DetachFromIndexRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DetachObjectResult detachObject(DetachObjectRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DetachPolicyResult detachPolicy(DetachPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisableDirectoryResult disableDirectory(DisableDirectoryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public EnableDirectoryResult enableDirectory(EnableDirectoryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDirectoryResult getDirectory(GetDirectoryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetFacetResult getFacet(GetFacetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetObjectInformationResult getObjectInformation(GetObjectInformationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSchemaAsJsonResult getSchemaAsJson(GetSchemaAsJsonRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAppliedSchemaArnsResult listAppliedSchemaArns(ListAppliedSchemaArnsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAttachedIndicesResult listAttachedIndices(ListAttachedIndicesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDevelopmentSchemaArnsResult listDevelopmentSchemaArns(ListDevelopmentSchemaArnsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDirectoriesResult listDirectories(ListDirectoriesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListFacetAttributesResult listFacetAttributes(ListFacetAttributesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListFacetNamesResult listFacetNames(ListFacetNamesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListIndexResult listIndex(ListIndexRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListObjectAttributesResult listObjectAttributes(ListObjectAttributesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListObjectChildrenResult listObjectChildren(ListObjectChildrenRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListObjectParentsResult listObjectParents(ListObjectParentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListObjectPoliciesResult listObjectPolicies(ListObjectPoliciesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPolicyAttachmentsResult listPolicyAttachments(ListPolicyAttachmentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPublishedSchemaArnsResult listPublishedSchemaArns(ListPublishedSchemaArnsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public LookupPolicyResult lookupPolicy(LookupPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PublishSchemaResult publishSchema(PublishSchemaRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutSchemaFromJsonResult putSchemaFromJson(PutSchemaFromJsonRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RemoveFacetFromObjectResult removeFacetFromObject(RemoveFacetFromObjectRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateFacetResult updateFacet(UpdateFacetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateObjectAttributesResult updateObjectAttributes(UpdateObjectAttributesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateSchemaResult updateSchema(UpdateSchemaRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
