/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.clouddirectory.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.clouddirectory.model.*;

import com.amazonaws.protocol.json.*;

/**
 * TypedAttributeValueMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class TypedAttributeValueJsonMarshaller {

    /**
     * Marshall the given parameter object, and output to a SdkJsonGenerator
     */
    public void marshall(TypedAttributeValue typedAttributeValue, StructuredJsonGenerator jsonGenerator) {

        if (typedAttributeValue == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            jsonGenerator.writeStartObject();

            if (typedAttributeValue.getStringValue() != null) {
                jsonGenerator.writeFieldName("StringValue").writeValue(typedAttributeValue.getStringValue());
            }
            if (typedAttributeValue.getBinaryValue() != null) {
                jsonGenerator.writeFieldName("BinaryValue").writeValue(typedAttributeValue.getBinaryValue());
            }
            if (typedAttributeValue.getBooleanValue() != null) {
                jsonGenerator.writeFieldName("BooleanValue").writeValue(typedAttributeValue.getBooleanValue());
            }
            if (typedAttributeValue.getNumberValue() != null) {
                jsonGenerator.writeFieldName("NumberValue").writeValue(typedAttributeValue.getNumberValue());
            }
            if (typedAttributeValue.getDatetimeValue() != null) {
                jsonGenerator.writeFieldName("DatetimeValue").writeValue(typedAttributeValue.getDatetimeValue());
            }

            jsonGenerator.writeEndObject();
        } catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    private static TypedAttributeValueJsonMarshaller instance;

    public static TypedAttributeValueJsonMarshaller getInstance() {
        if (instance == null)
            instance = new TypedAttributeValueJsonMarshaller();
        return instance;
    }

}
