/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudformation.model.Capability;
import com.amazonaws.services.cloudformation.model.OnFailure;
import com.amazonaws.services.cloudformation.model.Parameter;
import com.amazonaws.services.cloudformation.model.Tag;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateStackRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String stackName;
    private String templateBody;
    private String templateURL;
    private SdkInternalList<Parameter> parameters;
    private Boolean disableRollback;
    private Integer timeoutInMinutes;
    private SdkInternalList<String> notificationARNs;
    private SdkInternalList<String> capabilities;
    private SdkInternalList<String> resourceTypes;
    private String roleARN;
    private String onFailure;
    private String stackPolicyBody;
    private String stackPolicyURL;
    private SdkInternalList<Tag> tags;

    public void setStackName(String stackName) {
        this.stackName = stackName;
    }

    public String getStackName() {
        return this.stackName;
    }

    public CreateStackRequest withStackName(String stackName) {
        this.setStackName(stackName);
        return this;
    }

    public void setTemplateBody(String templateBody) {
        this.templateBody = templateBody;
    }

    public String getTemplateBody() {
        return this.templateBody;
    }

    public CreateStackRequest withTemplateBody(String templateBody) {
        this.setTemplateBody(templateBody);
        return this;
    }

    public void setTemplateURL(String templateURL) {
        this.templateURL = templateURL;
    }

    public String getTemplateURL() {
        return this.templateURL;
    }

    public CreateStackRequest withTemplateURL(String templateURL) {
        this.setTemplateURL(templateURL);
        return this;
    }

    public List<Parameter> getParameters() {
        if (this.parameters == null) {
            this.parameters = new SdkInternalList();
        }
        return this.parameters;
    }

    public void setParameters(Collection<Parameter> parameters) {
        if (parameters == null) {
            this.parameters = null;
            return;
        }
        this.parameters = new SdkInternalList(parameters);
    }

    public CreateStackRequest withParameters(Parameter ... parameters) {
        if (this.parameters == null) {
            this.setParameters((Collection<Parameter>)new SdkInternalList(parameters.length));
        }
        for (Parameter ele : parameters) {
            this.parameters.add((Object)ele);
        }
        return this;
    }

    public CreateStackRequest withParameters(Collection<Parameter> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public void setDisableRollback(Boolean disableRollback) {
        this.disableRollback = disableRollback;
    }

    public Boolean getDisableRollback() {
        return this.disableRollback;
    }

    public CreateStackRequest withDisableRollback(Boolean disableRollback) {
        this.setDisableRollback(disableRollback);
        return this;
    }

    public Boolean isDisableRollback() {
        return this.disableRollback;
    }

    public void setTimeoutInMinutes(Integer timeoutInMinutes) {
        this.timeoutInMinutes = timeoutInMinutes;
    }

    public Integer getTimeoutInMinutes() {
        return this.timeoutInMinutes;
    }

    public CreateStackRequest withTimeoutInMinutes(Integer timeoutInMinutes) {
        this.setTimeoutInMinutes(timeoutInMinutes);
        return this;
    }

    public List<String> getNotificationARNs() {
        if (this.notificationARNs == null) {
            this.notificationARNs = new SdkInternalList();
        }
        return this.notificationARNs;
    }

    public void setNotificationARNs(Collection<String> notificationARNs) {
        if (notificationARNs == null) {
            this.notificationARNs = null;
            return;
        }
        this.notificationARNs = new SdkInternalList(notificationARNs);
    }

    public CreateStackRequest withNotificationARNs(String ... notificationARNs) {
        if (this.notificationARNs == null) {
            this.setNotificationARNs((Collection<String>)new SdkInternalList(notificationARNs.length));
        }
        for (String ele : notificationARNs) {
            this.notificationARNs.add((Object)ele);
        }
        return this;
    }

    public CreateStackRequest withNotificationARNs(Collection<String> notificationARNs) {
        this.setNotificationARNs(notificationARNs);
        return this;
    }

    public List<String> getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new SdkInternalList();
        }
        return this.capabilities;
    }

    public void setCapabilities(Collection<String> capabilities) {
        if (capabilities == null) {
            this.capabilities = null;
            return;
        }
        this.capabilities = new SdkInternalList(capabilities);
    }

    public CreateStackRequest withCapabilities(String ... capabilities) {
        if (this.capabilities == null) {
            this.setCapabilities((Collection<String>)new SdkInternalList(capabilities.length));
        }
        for (String ele : capabilities) {
            this.capabilities.add((Object)ele);
        }
        return this;
    }

    public CreateStackRequest withCapabilities(Collection<String> capabilities) {
        this.setCapabilities(capabilities);
        return this;
    }

    public CreateStackRequest withCapabilities(Capability ... capabilities) {
        SdkInternalList capabilitiesCopy = new SdkInternalList(capabilities.length);
        for (Capability value : capabilities) {
            capabilitiesCopy.add((Object)value.toString());
        }
        if (this.getCapabilities() == null) {
            this.setCapabilities((Collection<String>)capabilitiesCopy);
        } else {
            this.getCapabilities().addAll((Collection<String>)capabilitiesCopy);
        }
        return this;
    }

    public List<String> getResourceTypes() {
        if (this.resourceTypes == null) {
            this.resourceTypes = new SdkInternalList();
        }
        return this.resourceTypes;
    }

    public void setResourceTypes(Collection<String> resourceTypes) {
        if (resourceTypes == null) {
            this.resourceTypes = null;
            return;
        }
        this.resourceTypes = new SdkInternalList(resourceTypes);
    }

    public CreateStackRequest withResourceTypes(String ... resourceTypes) {
        if (this.resourceTypes == null) {
            this.setResourceTypes((Collection<String>)new SdkInternalList(resourceTypes.length));
        }
        for (String ele : resourceTypes) {
            this.resourceTypes.add((Object)ele);
        }
        return this;
    }

    public CreateStackRequest withResourceTypes(Collection<String> resourceTypes) {
        this.setResourceTypes(resourceTypes);
        return this;
    }

    public void setRoleARN(String roleARN) {
        this.roleARN = roleARN;
    }

    public String getRoleARN() {
        return this.roleARN;
    }

    public CreateStackRequest withRoleARN(String roleARN) {
        this.setRoleARN(roleARN);
        return this;
    }

    public void setOnFailure(String onFailure) {
        this.onFailure = onFailure;
    }

    public String getOnFailure() {
        return this.onFailure;
    }

    public CreateStackRequest withOnFailure(String onFailure) {
        this.setOnFailure(onFailure);
        return this;
    }

    @JsonIgnore
    public void setOnFailure(OnFailure onFailure) {
        this.onFailure = onFailure.toString();
    }

    public CreateStackRequest withOnFailure(OnFailure onFailure) {
        this.setOnFailure(onFailure);
        return this;
    }

    public void setStackPolicyBody(String stackPolicyBody) {
        this.stackPolicyBody = stackPolicyBody;
    }

    public String getStackPolicyBody() {
        return this.stackPolicyBody;
    }

    public CreateStackRequest withStackPolicyBody(String stackPolicyBody) {
        this.setStackPolicyBody(stackPolicyBody);
        return this;
    }

    public void setStackPolicyURL(String stackPolicyURL) {
        this.stackPolicyURL = stackPolicyURL;
    }

    public String getStackPolicyURL() {
        return this.stackPolicyURL;
    }

    public CreateStackRequest withStackPolicyURL(String stackPolicyURL) {
        this.setStackPolicyURL(stackPolicyURL);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public CreateStackRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public CreateStackRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStackName() != null) {
            sb.append("StackName: ").append(this.getStackName()).append(",");
        }
        if (this.getTemplateBody() != null) {
            sb.append("TemplateBody: ").append(this.getTemplateBody()).append(",");
        }
        if (this.getTemplateURL() != null) {
            sb.append("TemplateURL: ").append(this.getTemplateURL()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters()).append(",");
        }
        if (this.getDisableRollback() != null) {
            sb.append("DisableRollback: ").append(this.getDisableRollback()).append(",");
        }
        if (this.getTimeoutInMinutes() != null) {
            sb.append("TimeoutInMinutes: ").append(this.getTimeoutInMinutes()).append(",");
        }
        if (this.getNotificationARNs() != null) {
            sb.append("NotificationARNs: ").append(this.getNotificationARNs()).append(",");
        }
        if (this.getCapabilities() != null) {
            sb.append("Capabilities: ").append(this.getCapabilities()).append(",");
        }
        if (this.getResourceTypes() != null) {
            sb.append("ResourceTypes: ").append(this.getResourceTypes()).append(",");
        }
        if (this.getRoleARN() != null) {
            sb.append("RoleARN: ").append(this.getRoleARN()).append(",");
        }
        if (this.getOnFailure() != null) {
            sb.append("OnFailure: ").append(this.getOnFailure()).append(",");
        }
        if (this.getStackPolicyBody() != null) {
            sb.append("StackPolicyBody: ").append(this.getStackPolicyBody()).append(",");
        }
        if (this.getStackPolicyURL() != null) {
            sb.append("StackPolicyURL: ").append(this.getStackPolicyURL()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStackRequest)) {
            return false;
        }
        CreateStackRequest other = (CreateStackRequest)obj;
        if (other.getStackName() == null ^ this.getStackName() == null) {
            return false;
        }
        if (other.getStackName() != null && !other.getStackName().equals(this.getStackName())) {
            return false;
        }
        if (other.getTemplateBody() == null ^ this.getTemplateBody() == null) {
            return false;
        }
        if (other.getTemplateBody() != null && !other.getTemplateBody().equals(this.getTemplateBody())) {
            return false;
        }
        if (other.getTemplateURL() == null ^ this.getTemplateURL() == null) {
            return false;
        }
        if (other.getTemplateURL() != null && !other.getTemplateURL().equals(this.getTemplateURL())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        if (other.getParameters() != null && !other.getParameters().equals(this.getParameters())) {
            return false;
        }
        if (other.getDisableRollback() == null ^ this.getDisableRollback() == null) {
            return false;
        }
        if (other.getDisableRollback() != null && !other.getDisableRollback().equals(this.getDisableRollback())) {
            return false;
        }
        if (other.getTimeoutInMinutes() == null ^ this.getTimeoutInMinutes() == null) {
            return false;
        }
        if (other.getTimeoutInMinutes() != null && !other.getTimeoutInMinutes().equals(this.getTimeoutInMinutes())) {
            return false;
        }
        if (other.getNotificationARNs() == null ^ this.getNotificationARNs() == null) {
            return false;
        }
        if (other.getNotificationARNs() != null && !other.getNotificationARNs().equals(this.getNotificationARNs())) {
            return false;
        }
        if (other.getCapabilities() == null ^ this.getCapabilities() == null) {
            return false;
        }
        if (other.getCapabilities() != null && !other.getCapabilities().equals(this.getCapabilities())) {
            return false;
        }
        if (other.getResourceTypes() == null ^ this.getResourceTypes() == null) {
            return false;
        }
        if (other.getResourceTypes() != null && !other.getResourceTypes().equals(this.getResourceTypes())) {
            return false;
        }
        if (other.getRoleARN() == null ^ this.getRoleARN() == null) {
            return false;
        }
        if (other.getRoleARN() != null && !other.getRoleARN().equals(this.getRoleARN())) {
            return false;
        }
        if (other.getOnFailure() == null ^ this.getOnFailure() == null) {
            return false;
        }
        if (other.getOnFailure() != null && !other.getOnFailure().equals(this.getOnFailure())) {
            return false;
        }
        if (other.getStackPolicyBody() == null ^ this.getStackPolicyBody() == null) {
            return false;
        }
        if (other.getStackPolicyBody() != null && !other.getStackPolicyBody().equals(this.getStackPolicyBody())) {
            return false;
        }
        if (other.getStackPolicyURL() == null ^ this.getStackPolicyURL() == null) {
            return false;
        }
        if (other.getStackPolicyURL() != null && !other.getStackPolicyURL().equals(this.getStackPolicyURL())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStackName() == null ? 0 : this.getStackName().hashCode());
        hashCode = 31 * hashCode + (this.getTemplateBody() == null ? 0 : this.getTemplateBody().hashCode());
        hashCode = 31 * hashCode + (this.getTemplateURL() == null ? 0 : this.getTemplateURL().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        hashCode = 31 * hashCode + (this.getDisableRollback() == null ? 0 : this.getDisableRollback().hashCode());
        hashCode = 31 * hashCode + (this.getTimeoutInMinutes() == null ? 0 : this.getTimeoutInMinutes().hashCode());
        hashCode = 31 * hashCode + (this.getNotificationARNs() == null ? 0 : this.getNotificationARNs().hashCode());
        hashCode = 31 * hashCode + (this.getCapabilities() == null ? 0 : this.getCapabilities().hashCode());
        hashCode = 31 * hashCode + (this.getResourceTypes() == null ? 0 : this.getResourceTypes().hashCode());
        hashCode = 31 * hashCode + (this.getRoleARN() == null ? 0 : this.getRoleARN().hashCode());
        hashCode = 31 * hashCode + (this.getOnFailure() == null ? 0 : this.getOnFailure().hashCode());
        hashCode = 31 * hashCode + (this.getStackPolicyBody() == null ? 0 : this.getStackPolicyBody().hashCode());
        hashCode = 31 * hashCode + (this.getStackPolicyURL() == null ? 0 : this.getStackPolicyURL().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateStackRequest clone() {
        return (CreateStackRequest)super.clone();
    }
}

