/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudformation.model.CreateChangeSetRequest;
import com.amazonaws.services.cloudformation.model.Parameter;
import com.amazonaws.services.cloudformation.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateChangeSetRequestMarshaller
implements Marshaller<Request<CreateChangeSetRequest>, CreateChangeSetRequest> {
    public Request<CreateChangeSetRequest> marshall(CreateChangeSetRequest createChangeSetRequest) {
        SdkInternalList tagsList;
        SdkInternalList notificationARNsList;
        SdkInternalList resourceTypesList;
        SdkInternalList capabilitiesList;
        SdkInternalList parametersList;
        if (createChangeSetRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createChangeSetRequest, "AmazonCloudFormation");
        request.addParameter("Action", "CreateChangeSet");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createChangeSetRequest.getStackName() != null) {
            request.addParameter("StackName", StringUtils.fromString((String)createChangeSetRequest.getStackName()));
        }
        if (createChangeSetRequest.getTemplateBody() != null) {
            request.addParameter("TemplateBody", StringUtils.fromString((String)createChangeSetRequest.getTemplateBody()));
        }
        if (createChangeSetRequest.getTemplateURL() != null) {
            request.addParameter("TemplateURL", StringUtils.fromString((String)createChangeSetRequest.getTemplateURL()));
        }
        if (createChangeSetRequest.getUsePreviousTemplate() != null) {
            request.addParameter("UsePreviousTemplate", StringUtils.fromBoolean((Boolean)createChangeSetRequest.getUsePreviousTemplate()));
        }
        if (!(parametersList = (SdkInternalList)createChangeSetRequest.getParameters()).isEmpty() || !parametersList.isAutoConstruct()) {
            int parametersListIndex = 1;
            for (Object parametersListValue : parametersList) {
                if (((Parameter)parametersListValue).getParameterKey() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".ParameterKey", StringUtils.fromString((String)((Parameter)parametersListValue).getParameterKey()));
                }
                if (((Parameter)parametersListValue).getParameterValue() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".ParameterValue", StringUtils.fromString((String)((Parameter)parametersListValue).getParameterValue()));
                }
                if (((Parameter)parametersListValue).getUsePreviousValue() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".UsePreviousValue", StringUtils.fromBoolean((Boolean)((Parameter)parametersListValue).getUsePreviousValue()));
                }
                ++parametersListIndex;
            }
        }
        if (!(capabilitiesList = (SdkInternalList)createChangeSetRequest.getCapabilities()).isEmpty() || !capabilitiesList.isAutoConstruct()) {
            int capabilitiesListIndex = 1;
            for (Object capabilitiesListValue : capabilitiesList) {
                if (capabilitiesListValue != null) {
                    request.addParameter("Capabilities.member." + capabilitiesListIndex, StringUtils.fromString((String)capabilitiesListValue));
                }
                ++capabilitiesListIndex;
            }
        }
        if (!(resourceTypesList = (SdkInternalList)createChangeSetRequest.getResourceTypes()).isEmpty() || !resourceTypesList.isAutoConstruct()) {
            int resourceTypesListIndex = 1;
            for (Object resourceTypesListValue : resourceTypesList) {
                if (resourceTypesListValue != null) {
                    request.addParameter("ResourceTypes.member." + resourceTypesListIndex, StringUtils.fromString((String)resourceTypesListValue));
                }
                ++resourceTypesListIndex;
            }
        }
        if (!(notificationARNsList = (SdkInternalList)createChangeSetRequest.getNotificationARNs()).isEmpty() || !notificationARNsList.isAutoConstruct()) {
            int notificationARNsListIndex = 1;
            for (String notificationARNsListValue : notificationARNsList) {
                if (notificationARNsListValue != null) {
                    request.addParameter("NotificationARNs.member." + notificationARNsListIndex, StringUtils.fromString((String)notificationARNsListValue));
                }
                ++notificationARNsListIndex;
            }
        }
        if (!(tagsList = (SdkInternalList)createChangeSetRequest.getTags()).isEmpty() || !tagsList.isAutoConstruct()) {
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.getKey() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                }
                if (tagsListValue.getValue() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                }
                ++tagsListIndex;
            }
        }
        if (createChangeSetRequest.getChangeSetName() != null) {
            request.addParameter("ChangeSetName", StringUtils.fromString((String)createChangeSetRequest.getChangeSetName()));
        }
        if (createChangeSetRequest.getClientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString((String)createChangeSetRequest.getClientToken()));
        }
        if (createChangeSetRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createChangeSetRequest.getDescription()));
        }
        return request;
    }
}

