/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.auth.policy.actions;

import javax.annotation.Generated;

import com.amazonaws.auth.policy.Action;

/**
 * The available AWS access control policy actions for AWS CloudFormation.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public enum CloudFormationActions implements Action {

    /** Represents any action executed on AWS CloudFormation. */
    AllCloudFormationActions("cloudformation:*"),

    /** Action for the ActivateOrganizationsAccess operation. */
    ActivateOrganizationsAccess("cloudformation:ActivateOrganizationsAccess"),
    /** Action for the ActivateType operation. */
    ActivateType("cloudformation:ActivateType"),
    /** Action for the BatchDescribeTypeConfigurations operation. */
    BatchDescribeTypeConfigurations("cloudformation:BatchDescribeTypeConfigurations"),
    /** Action for the CancelUpdateStack operation. */
    CancelUpdateStack("cloudformation:CancelUpdateStack"),
    /** Action for the ContinueUpdateRollback operation. */
    ContinueUpdateRollback("cloudformation:ContinueUpdateRollback"),
    /** Action for the CreateChangeSet operation. */
    CreateChangeSet("cloudformation:CreateChangeSet"),
    /** Action for the CreateStack operation. */
    CreateStack("cloudformation:CreateStack"),
    /** Action for the CreateStackInstances operation. */
    CreateStackInstances("cloudformation:CreateStackInstances"),
    /** Action for the CreateStackSet operation. */
    CreateStackSet("cloudformation:CreateStackSet"),
    /** Action for the DeactivateOrganizationsAccess operation. */
    DeactivateOrganizationsAccess("cloudformation:DeactivateOrganizationsAccess"),
    /** Action for the DeactivateType operation. */
    DeactivateType("cloudformation:DeactivateType"),
    /** Action for the DeleteChangeSet operation. */
    DeleteChangeSet("cloudformation:DeleteChangeSet"),
    /** Action for the DeleteStack operation. */
    DeleteStack("cloudformation:DeleteStack"),
    /** Action for the DeleteStackInstances operation. */
    DeleteStackInstances("cloudformation:DeleteStackInstances"),
    /** Action for the DeleteStackSet operation. */
    DeleteStackSet("cloudformation:DeleteStackSet"),
    /** Action for the DeregisterType operation. */
    DeregisterType("cloudformation:DeregisterType"),
    /** Action for the DescribeAccountLimits operation. */
    DescribeAccountLimits("cloudformation:DescribeAccountLimits"),
    /** Action for the DescribeChangeSet operation. */
    DescribeChangeSet("cloudformation:DescribeChangeSet"),
    /** Action for the DescribeChangeSetHooks operation. */
    DescribeChangeSetHooks("cloudformation:DescribeChangeSetHooks"),
    /** Action for the DescribeOrganizationsAccess operation. */
    DescribeOrganizationsAccess("cloudformation:DescribeOrganizationsAccess"),
    /** Action for the DescribePublisher operation. */
    DescribePublisher("cloudformation:DescribePublisher"),
    /** Action for the DescribeStackDriftDetectionStatus operation. */
    DescribeStackDriftDetectionStatus("cloudformation:DescribeStackDriftDetectionStatus"),
    /** Action for the DescribeStackEvents operation. */
    DescribeStackEvents("cloudformation:DescribeStackEvents"),
    /** Action for the DescribeStackInstance operation. */
    DescribeStackInstance("cloudformation:DescribeStackInstance"),
    /** Action for the DescribeStackResource operation. */
    DescribeStackResource("cloudformation:DescribeStackResource"),
    /** Action for the DescribeStackResourceDrifts operation. */
    DescribeStackResourceDrifts("cloudformation:DescribeStackResourceDrifts"),
    /** Action for the DescribeStackResources operation. */
    DescribeStackResources("cloudformation:DescribeStackResources"),
    /** Action for the DescribeStackSet operation. */
    DescribeStackSet("cloudformation:DescribeStackSet"),
    /** Action for the DescribeStackSetOperation operation. */
    DescribeStackSetOperation("cloudformation:DescribeStackSetOperation"),
    /** Action for the DescribeStacks operation. */
    DescribeStacks("cloudformation:DescribeStacks"),
    /** Action for the DescribeType operation. */
    DescribeType("cloudformation:DescribeType"),
    /** Action for the DescribeTypeRegistration operation. */
    DescribeTypeRegistration("cloudformation:DescribeTypeRegistration"),
    /** Action for the DetectStackDrift operation. */
    DetectStackDrift("cloudformation:DetectStackDrift"),
    /** Action for the DetectStackResourceDrift operation. */
    DetectStackResourceDrift("cloudformation:DetectStackResourceDrift"),
    /** Action for the DetectStackSetDrift operation. */
    DetectStackSetDrift("cloudformation:DetectStackSetDrift"),
    /** Action for the EstimateTemplateCost operation. */
    EstimateTemplateCost("cloudformation:EstimateTemplateCost"),
    /** Action for the ExecuteChangeSet operation. */
    ExecuteChangeSet("cloudformation:ExecuteChangeSet"),
    /** Action for the GetStackPolicy operation. */
    GetStackPolicy("cloudformation:GetStackPolicy"),
    /** Action for the GetTemplate operation. */
    GetTemplate("cloudformation:GetTemplate"),
    /** Action for the GetTemplateSummary operation. */
    GetTemplateSummary("cloudformation:GetTemplateSummary"),
    /** Action for the ImportStacksToStackSet operation. */
    ImportStacksToStackSet("cloudformation:ImportStacksToStackSet"),
    /** Action for the ListChangeSets operation. */
    ListChangeSets("cloudformation:ListChangeSets"),
    /** Action for the ListExports operation. */
    ListExports("cloudformation:ListExports"),
    /** Action for the ListImports operation. */
    ListImports("cloudformation:ListImports"),
    /** Action for the ListStackInstanceResourceDrifts operation. */
    ListStackInstanceResourceDrifts("cloudformation:ListStackInstanceResourceDrifts"),
    /** Action for the ListStackInstances operation. */
    ListStackInstances("cloudformation:ListStackInstances"),
    /** Action for the ListStackResources operation. */
    ListStackResources("cloudformation:ListStackResources"),
    /** Action for the ListStackSetOperationResults operation. */
    ListStackSetOperationResults("cloudformation:ListStackSetOperationResults"),
    /** Action for the ListStackSetOperations operation. */
    ListStackSetOperations("cloudformation:ListStackSetOperations"),
    /** Action for the ListStackSets operation. */
    ListStackSets("cloudformation:ListStackSets"),
    /** Action for the ListStacks operation. */
    ListStacks("cloudformation:ListStacks"),
    /** Action for the ListTypeRegistrations operation. */
    ListTypeRegistrations("cloudformation:ListTypeRegistrations"),
    /** Action for the ListTypeVersions operation. */
    ListTypeVersions("cloudformation:ListTypeVersions"),
    /** Action for the ListTypes operation. */
    ListTypes("cloudformation:ListTypes"),
    /** Action for the PublishType operation. */
    PublishType("cloudformation:PublishType"),
    /** Action for the RecordHandlerProgress operation. */
    RecordHandlerProgress("cloudformation:RecordHandlerProgress"),
    /** Action for the RegisterPublisher operation. */
    RegisterPublisher("cloudformation:RegisterPublisher"),
    /** Action for the RegisterType operation. */
    RegisterType("cloudformation:RegisterType"),
    /** Action for the RollbackStack operation. */
    RollbackStack("cloudformation:RollbackStack"),
    /** Action for the SetStackPolicy operation. */
    SetStackPolicy("cloudformation:SetStackPolicy"),
    /** Action for the SetTypeConfiguration operation. */
    SetTypeConfiguration("cloudformation:SetTypeConfiguration"),
    /** Action for the SetTypeDefaultVersion operation. */
    SetTypeDefaultVersion("cloudformation:SetTypeDefaultVersion"),
    /** Action for the SignalResource operation. */
    SignalResource("cloudformation:SignalResource"),
    /** Action for the StopStackSetOperation operation. */
    StopStackSetOperation("cloudformation:StopStackSetOperation"),
    /** Action for the TestType operation. */
    TestType("cloudformation:TestType"),
    /** Action for the UpdateStack operation. */
    UpdateStack("cloudformation:UpdateStack"),
    /** Action for the UpdateStackInstances operation. */
    UpdateStackInstances("cloudformation:UpdateStackInstances"),
    /** Action for the UpdateStackSet operation. */
    UpdateStackSet("cloudformation:UpdateStackSet"),
    /** Action for the UpdateTerminationProtection operation. */
    UpdateTerminationProtection("cloudformation:UpdateTerminationProtection"),
    /** Action for the ValidateTemplate operation. */
    ValidateTemplate("cloudformation:ValidateTemplate"),

    ;

    private final String action;

    private CloudFormationActions(String action) {
        this.action = action;
    }

    public String getActionName() {
        return this.action;
    }

    public boolean isNotType() {
        return false;
    }
}
