/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.cloudformation;

import javax.annotation.Generated;

import com.amazonaws.*;
import com.amazonaws.regions.*;

import com.amazonaws.services.cloudformation.model.*;
import com.amazonaws.services.cloudformation.waiters.AmazonCloudFormationWaiters;

/**
 * Interface for accessing AWS CloudFormation.
 * <p>
 * <b>Note:</b> Do not directly implement this interface, new methods are added to it regularly. Extend from
 * {@link com.amazonaws.services.cloudformation.AbstractAmazonCloudFormation} instead.
 * </p>
 * <p>
 * <fullname>CloudFormation</fullname>
 * <p>
 * CloudFormation allows you to create and manage Amazon Web Services infrastructure deployments predictably and
 * repeatedly. You can use CloudFormation to leverage Amazon Web Services products, such as Amazon Elastic Compute
 * Cloud, Amazon Elastic Block Store, Amazon Simple Notification Service, Elastic Load Balancing, and Auto Scaling to
 * build highly reliable, highly scalable, cost-effective applications without creating or configuring the underlying
 * Amazon Web Services infrastructure.
 * </p>
 * <p>
 * With CloudFormation, you declare all your resources and dependencies in a template file. The template defines a
 * collection of resources as a single unit called a stack. CloudFormation creates and deletes all member resources of
 * the stack together and manages all dependencies between the resources for you.
 * </p>
 * <p>
 * For more information about CloudFormation, see the <a href="http://aws.amazon.com/cloudformation/">CloudFormation
 * product page</a>.
 * </p>
 * <p>
 * CloudFormation makes use of other Amazon Web Services products. If you need additional technical information about a
 * specific Amazon Web Services product, you can find the product's technical documentation at <a
 * href="https://docs.aws.amazon.com/">docs.aws.amazon.com</a>.
 * </p>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public interface AmazonCloudFormation {

    /**
     * The region metadata service name for computing region endpoints. You can use this value to retrieve metadata
     * (such as supported regions) of the service.
     *
     * @see RegionUtils#getRegionsForService(String)
     */
    String ENDPOINT_PREFIX = "cloudformation";

    /**
     * Overrides the default endpoint for this client ("https://cloudformation.us-east-1.amazonaws.com"). Callers can
     * use this method to control which AWS region they want to work with.
     * <p>
     * Callers can pass in just the endpoint (ex: "cloudformation.us-east-1.amazonaws.com") or a full URL, including the
     * protocol (ex: "https://cloudformation.us-east-1.amazonaws.com"). If the protocol is not specified here, the
     * default protocol from this client's {@link ClientConfiguration} will be used, which by default is HTTPS.
     * <p>
     * For more information on using AWS regions with the AWS SDK for Java, and a complete list of all available
     * endpoints for all AWS services, see: <a href=
     * "https://docs.aws.amazon.com/sdk-for-java/v1/developer-guide/java-dg-region-selection.html#region-selection-choose-endpoint"
     * > https://docs.aws.amazon.com/sdk-for-java/v1/developer-guide/java-dg-region-selection.html#region-selection-
     * choose-endpoint</a>
     * <p>
     * <b>This method is not threadsafe. An endpoint should be configured when the client is created and before any
     * service requests are made. Changing it afterwards creates inevitable race conditions for any service requests in
     * transit or retrying.</b>
     *
     * @param endpoint
     *        The endpoint (ex: "cloudformation.us-east-1.amazonaws.com") or a full URL, including the protocol (ex:
     *        "https://cloudformation.us-east-1.amazonaws.com") of the region specific AWS endpoint this client will
     *        communicate with.
     * @deprecated use {@link AwsClientBuilder#setEndpointConfiguration(AwsClientBuilder.EndpointConfiguration)} for
     *             example:
     *             {@code builder.setEndpointConfiguration(new EndpointConfiguration(endpoint, signingRegion));}
     */
    @Deprecated
    void setEndpoint(String endpoint);

    /**
     * An alternative to {@link AmazonCloudFormation#setEndpoint(String)}, sets the regional endpoint for this client's
     * service calls. Callers can use this method to control which AWS region they want to work with.
     * <p>
     * By default, all service endpoints in all regions use the https protocol. To use http instead, specify it in the
     * {@link ClientConfiguration} supplied at construction.
     * <p>
     * <b>This method is not threadsafe. A region should be configured when the client is created and before any service
     * requests are made. Changing it afterwards creates inevitable race conditions for any service requests in transit
     * or retrying.</b>
     *
     * @param region
     *        The region this client will communicate with. See {@link Region#getRegion(com.amazonaws.regions.Regions)}
     *        for accessing a given region. Must not be null and must be a region where the service is available.
     *
     * @see Region#getRegion(com.amazonaws.regions.Regions)
     * @see Region#createClient(Class, com.amazonaws.auth.AWSCredentialsProvider, ClientConfiguration)
     * @see Region#isServiceSupported(String)
     * @deprecated use {@link AwsClientBuilder#setRegion(String)}
     */
    @Deprecated
    void setRegion(Region region);

    /**
     * <p>
     * Activate trusted access with Organizations. With trusted access between StackSets and Organizations activated,
     * the management account has permissions to create and manage StackSets for your organization.
     * </p>
     * 
     * @param activateOrganizationsAccessRequest
     * @return Result of the ActivateOrganizationsAccess operation returned by the service.
     * @throws InvalidOperationException
     *         The specified operation isn't valid.
     * @throws OperationNotFoundException
     *         The specified ID refers to an operation that doesn't exist.
     * @sample AmazonCloudFormation.ActivateOrganizationsAccess
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ActivateOrganizationsAccess"
     *      target="_top">AWS API Documentation</a>
     */
    ActivateOrganizationsAccessResult activateOrganizationsAccess(ActivateOrganizationsAccessRequest activateOrganizationsAccessRequest);

    /**
     * <p>
     * Activates a public third-party extension, making it available for use in stack templates. For more information,
     * see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html">Using public
     * extensions</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * <p>
     * Once you have activated a public third-party extension in your account and Region, use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_SetTypeConfiguration.html"
     * >SetTypeConfiguration</a> to specify configuration properties for the extension. For more information, see <a
     * href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-register.html#registry-set-configuration"
     * >Configuring extensions at the account level</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * 
     * @param activateTypeRequest
     * @return Result of the ActivateType operation returned by the service.
     * @throws CFNRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws TypeNotFoundException
     *         The specified extension doesn't exist in the CloudFormation registry.
     * @sample AmazonCloudFormation.ActivateType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ActivateType" target="_top">AWS
     *      API Documentation</a>
     */
    ActivateTypeResult activateType(ActivateTypeRequest activateTypeRequest);

    /**
     * <p>
     * Returns configuration data for the specified CloudFormation extensions, from the CloudFormation registry for the
     * account and Region.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-register.html#registry-set-configuration"
     * >Configuring extensions at the account level</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * 
     * @param batchDescribeTypeConfigurationsRequest
     * @return Result of the BatchDescribeTypeConfigurations operation returned by the service.
     * @throws TypeConfigurationNotFoundException
     *         The specified extension configuration can't be found.
     * @throws CFNRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @sample AmazonCloudFormation.BatchDescribeTypeConfigurations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/BatchDescribeTypeConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    BatchDescribeTypeConfigurationsResult batchDescribeTypeConfigurations(BatchDescribeTypeConfigurationsRequest batchDescribeTypeConfigurationsRequest);

    /**
     * <p>
     * Cancels an update on the specified stack. If the call completes successfully, the stack rolls back the update and
     * reverts to the previous stack configuration.
     * </p>
     * <note>
     * <p>
     * You can cancel only stacks that are in the <code>UPDATE_IN_PROGRESS</code> state.
     * </p>
     * </note>
     * 
     * @param cancelUpdateStackRequest
     *        The input for the <a>CancelUpdateStack</a> action.
     * @return Result of the CancelUpdateStack operation returned by the service.
     * @throws TokenAlreadyExistsException
     *         A client request token already exists.
     * @sample AmazonCloudFormation.CancelUpdateStack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CancelUpdateStack"
     *      target="_top">AWS API Documentation</a>
     */
    CancelUpdateStackResult cancelUpdateStack(CancelUpdateStackRequest cancelUpdateStackRequest);

    /**
     * <p>
     * For a specified stack that's in the <code>UPDATE_ROLLBACK_FAILED</code> state, continues rolling it back to the
     * <code>UPDATE_ROLLBACK_COMPLETE</code> state. Depending on the cause of the failure, you can manually <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/troubleshooting.html#troubleshooting-errors-update-rollback-failed"
     * > fix the error</a> and continue the rollback. By continuing the rollback, you can return your stack to a working
     * state (the <code>UPDATE_ROLLBACK_COMPLETE</code> state), and then try to update the stack again.
     * </p>
     * <p>
     * A stack goes into the <code>UPDATE_ROLLBACK_FAILED</code> state when CloudFormation can't roll back all changes
     * after a failed stack update. For example, you might have a stack that's rolling back to an old database instance
     * that was deleted outside of CloudFormation. Because CloudFormation doesn't know the database was deleted, it
     * assumes that the database instance still exists and attempts to roll back to it, causing the update rollback to
     * fail.
     * </p>
     * 
     * @param continueUpdateRollbackRequest
     *        The input for the <a>ContinueUpdateRollback</a> action.
     * @return Result of the ContinueUpdateRollback operation returned by the service.
     * @throws TokenAlreadyExistsException
     *         A client request token already exists.
     * @sample AmazonCloudFormation.ContinueUpdateRollback
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ContinueUpdateRollback"
     *      target="_top">AWS API Documentation</a>
     */
    ContinueUpdateRollbackResult continueUpdateRollback(ContinueUpdateRollbackRequest continueUpdateRollbackRequest);

    /**
     * <p>
     * Creates a list of changes that will be applied to a stack so that you can review the changes before executing
     * them. You can create a change set for a stack that doesn't exist or an existing stack. If you create a change set
     * for a stack that doesn't exist, the change set shows all of the resources that CloudFormation will create. If you
     * create a change set for an existing stack, CloudFormation compares the stack's information with the information
     * that you submit in the change set and lists the differences. Use change sets to understand which resources
     * CloudFormation will create or change, and how it will change resources in an existing stack, before you create or
     * update a stack.
     * </p>
     * <p>
     * To create a change set for a stack that doesn't exist, for the <code>ChangeSetType</code> parameter, specify
     * <code>CREATE</code>. To create a change set for an existing stack, specify <code>UPDATE</code> for the
     * <code>ChangeSetType</code> parameter. To create a change set for an import operation, specify <code>IMPORT</code>
     * for the <code>ChangeSetType</code> parameter. After the <code>CreateChangeSet</code> call successfully completes,
     * CloudFormation starts creating the change set. To check the status of the change set or to review it, use the
     * <a>DescribeChangeSet</a> action.
     * </p>
     * <p>
     * When you are satisfied with the changes the change set will make, execute the change set by using the
     * <a>ExecuteChangeSet</a> action. CloudFormation doesn't make changes until you execute the change set.
     * </p>
     * <p>
     * To create a change set for the entire stack hierarchy, set <code>IncludeNestedStacks</code> to <code>True</code>.
     * </p>
     * 
     * @param createChangeSetRequest
     *        The input for the <a>CreateChangeSet</a> action.
     * @return Result of the CreateChangeSet operation returned by the service.
     * @throws AlreadyExistsException
     *         The resource with the name requested already exists.
     * @throws InsufficientCapabilitiesException
     *         The template contains resources with capabilities that weren't specified in the Capabilities parameter.
     * @throws LimitExceededException
     *         The quota for the resource has already been reached.</p>
     *         <p>
     *         For information about resource and stack limitations, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html"
     *         >CloudFormation quotas</a> in the <i>CloudFormation User Guide</i>.
     * @sample AmazonCloudFormation.CreateChangeSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet" target="_top">AWS
     *      API Documentation</a>
     */
    CreateChangeSetResult createChangeSet(CreateChangeSetRequest createChangeSetRequest);

    /**
     * <p>
     * Creates a template from existing resources that are not already managed with CloudFormation. You can check the
     * status of the template generation using the <code>DescribeGeneratedTemplate</code> API action.
     * </p>
     * 
     * @param createGeneratedTemplateRequest
     * @return Result of the CreateGeneratedTemplate operation returned by the service.
     * @throws AlreadyExistsException
     *         The resource with the name requested already exists.
     * @throws LimitExceededException
     *         The quota for the resource has already been reached.</p>
     *         <p>
     *         For information about resource and stack limitations, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html"
     *         >CloudFormation quotas</a> in the <i>CloudFormation User Guide</i>.
     * @throws ConcurrentResourcesLimitExceededException
     *         No more than 5 generated templates can be in an <code>InProgress</code> or <code>Pending</code> status at
     *         one time. This error is also returned if a generated template that is in an <code>InProgress</code> or
     *         <code>Pending</code> status is attempted to be updated or deleted.
     * @sample AmazonCloudFormation.CreateGeneratedTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateGeneratedTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    CreateGeneratedTemplateResult createGeneratedTemplate(CreateGeneratedTemplateRequest createGeneratedTemplateRequest);

    /**
     * <p>
     * Creates a stack as specified in the template. After the call completes successfully, the stack creation starts.
     * You can check the status of the stack through the <a>DescribeStacks</a> operation.
     * </p>
     * 
     * @param createStackRequest
     *        The input for <a>CreateStack</a> action.
     * @return Result of the CreateStack operation returned by the service.
     * @throws LimitExceededException
     *         The quota for the resource has already been reached.</p>
     *         <p>
     *         For information about resource and stack limitations, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html"
     *         >CloudFormation quotas</a> in the <i>CloudFormation User Guide</i>.
     * @throws AlreadyExistsException
     *         The resource with the name requested already exists.
     * @throws TokenAlreadyExistsException
     *         A client request token already exists.
     * @throws InsufficientCapabilitiesException
     *         The template contains resources with capabilities that weren't specified in the Capabilities parameter.
     * @sample AmazonCloudFormation.CreateStack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStack" target="_top">AWS API
     *      Documentation</a>
     */
    CreateStackResult createStack(CreateStackRequest createStackRequest);

    /**
     * <p>
     * Creates stack instances for the specified accounts, within the specified Amazon Web Services Regions. A stack
     * instance refers to a stack in a specific account and Region. You must specify at least one value for either
     * <code>Accounts</code> or <code>DeploymentTargets</code>, and you must specify at least one value for
     * <code>Regions</code>.
     * </p>
     * 
     * @param createStackInstancesRequest
     * @return Result of the CreateStackInstances operation returned by the service.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws OperationInProgressException
     *         Another operation is currently in progress for this stack set. Only one operation can be performed for a
     *         stack set at a given time.
     * @throws OperationIdAlreadyExistsException
     *         The specified operation ID already exists.
     * @throws StaleRequestException
     *         Another operation has been performed on this stack set since the specified operation was performed.
     * @throws InvalidOperationException
     *         The specified operation isn't valid.
     * @throws LimitExceededException
     *         The quota for the resource has already been reached.</p>
     *         <p>
     *         For information about resource and stack limitations, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html"
     *         >CloudFormation quotas</a> in the <i>CloudFormation User Guide</i>.
     * @sample AmazonCloudFormation.CreateStackInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStackInstances"
     *      target="_top">AWS API Documentation</a>
     */
    CreateStackInstancesResult createStackInstances(CreateStackInstancesRequest createStackInstancesRequest);

    /**
     * <p>
     * Creates a stack set.
     * </p>
     * 
     * @param createStackSetRequest
     * @return Result of the CreateStackSet operation returned by the service.
     * @throws NameAlreadyExistsException
     *         The specified name is already in use.
     * @throws CreatedButModifiedException
     *         The specified resource exists, but has been changed.
     * @throws LimitExceededException
     *         The quota for the resource has already been reached.</p>
     *         <p>
     *         For information about resource and stack limitations, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html"
     *         >CloudFormation quotas</a> in the <i>CloudFormation User Guide</i>.
     * @sample AmazonCloudFormation.CreateStackSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStackSet" target="_top">AWS
     *      API Documentation</a>
     */
    CreateStackSetResult createStackSet(CreateStackSetRequest createStackSetRequest);

    /**
     * <p>
     * Deactivates trusted access with Organizations. If trusted access is deactivated, the management account does not
     * have permissions to create and manage service-managed StackSets for your organization.
     * </p>
     * 
     * @param deactivateOrganizationsAccessRequest
     * @return Result of the DeactivateOrganizationsAccess operation returned by the service.
     * @throws InvalidOperationException
     *         The specified operation isn't valid.
     * @throws OperationNotFoundException
     *         The specified ID refers to an operation that doesn't exist.
     * @sample AmazonCloudFormation.DeactivateOrganizationsAccess
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeactivateOrganizationsAccess"
     *      target="_top">AWS API Documentation</a>
     */
    DeactivateOrganizationsAccessResult deactivateOrganizationsAccess(DeactivateOrganizationsAccessRequest deactivateOrganizationsAccessRequest);

    /**
     * <p>
     * Deactivates a public extension that was previously activated in this account and Region.
     * </p>
     * <p>
     * Once deactivated, an extension can't be used in any CloudFormation operation. This includes stack update
     * operations where the stack template includes the extension, even if no updates are being made to the extension.
     * In addition, deactivated extensions aren't automatically updated if a new version of the extension is released.
     * </p>
     * 
     * @param deactivateTypeRequest
     * @return Result of the DeactivateType operation returned by the service.
     * @throws CFNRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws TypeNotFoundException
     *         The specified extension doesn't exist in the CloudFormation registry.
     * @sample AmazonCloudFormation.DeactivateType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeactivateType" target="_top">AWS
     *      API Documentation</a>
     */
    DeactivateTypeResult deactivateType(DeactivateTypeRequest deactivateTypeRequest);

    /**
     * <p>
     * Deletes the specified change set. Deleting change sets ensures that no one executes the wrong change set.
     * </p>
     * <p>
     * If the call successfully completes, CloudFormation successfully deleted the change set.
     * </p>
     * <p>
     * If <code>IncludeNestedStacks</code> specifies <code>True</code> during the creation of the nested change set,
     * then <code>DeleteChangeSet</code> will delete all change sets that belong to the stacks hierarchy and will also
     * delete all change sets for nested stacks with the status of <code>REVIEW_IN_PROGRESS</code>.
     * </p>
     * 
     * @param deleteChangeSetRequest
     *        The input for the <a>DeleteChangeSet</a> action.
     * @return Result of the DeleteChangeSet operation returned by the service.
     * @throws InvalidChangeSetStatusException
     *         The specified change set can't be used to update the stack. For example, the change set status might be
     *         <code>CREATE_IN_PROGRESS</code>, or the stack status might be <code>UPDATE_IN_PROGRESS</code>.
     * @sample AmazonCloudFormation.DeleteChangeSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteChangeSet" target="_top">AWS
     *      API Documentation</a>
     */
    DeleteChangeSetResult deleteChangeSet(DeleteChangeSetRequest deleteChangeSetRequest);

    /**
     * <p>
     * Deleted a generated template.
     * </p>
     * 
     * @param deleteGeneratedTemplateRequest
     * @return Result of the DeleteGeneratedTemplate operation returned by the service.
     * @throws GeneratedTemplateNotFoundException
     *         The generated template was not found.
     * @throws ConcurrentResourcesLimitExceededException
     *         No more than 5 generated templates can be in an <code>InProgress</code> or <code>Pending</code> status at
     *         one time. This error is also returned if a generated template that is in an <code>InProgress</code> or
     *         <code>Pending</code> status is attempted to be updated or deleted.
     * @sample AmazonCloudFormation.DeleteGeneratedTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteGeneratedTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    DeleteGeneratedTemplateResult deleteGeneratedTemplate(DeleteGeneratedTemplateRequest deleteGeneratedTemplateRequest);

    /**
     * <p>
     * Deletes a specified stack. Once the call completes successfully, stack deletion starts. Deleted stacks don't show
     * up in the <a>DescribeStacks</a> operation if the deletion has been completed successfully.
     * </p>
     * 
     * @param deleteStackRequest
     *        The input for <a>DeleteStack</a> action.
     * @return Result of the DeleteStack operation returned by the service.
     * @throws TokenAlreadyExistsException
     *         A client request token already exists.
     * @sample AmazonCloudFormation.DeleteStack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStack" target="_top">AWS API
     *      Documentation</a>
     */
    DeleteStackResult deleteStack(DeleteStackRequest deleteStackRequest);

    /**
     * <p>
     * Deletes stack instances for the specified accounts, in the specified Amazon Web Services Regions.
     * </p>
     * 
     * @param deleteStackInstancesRequest
     * @return Result of the DeleteStackInstances operation returned by the service.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws OperationInProgressException
     *         Another operation is currently in progress for this stack set. Only one operation can be performed for a
     *         stack set at a given time.
     * @throws OperationIdAlreadyExistsException
     *         The specified operation ID already exists.
     * @throws StaleRequestException
     *         Another operation has been performed on this stack set since the specified operation was performed.
     * @throws InvalidOperationException
     *         The specified operation isn't valid.
     * @sample AmazonCloudFormation.DeleteStackInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStackInstances"
     *      target="_top">AWS API Documentation</a>
     */
    DeleteStackInstancesResult deleteStackInstances(DeleteStackInstancesRequest deleteStackInstancesRequest);

    /**
     * <p>
     * Deletes a stack set. Before you can delete a stack set, all its member stack instances must be deleted. For more
     * information about how to complete this, see <a>DeleteStackInstances</a>.
     * </p>
     * 
     * @param deleteStackSetRequest
     * @return Result of the DeleteStackSet operation returned by the service.
     * @throws StackSetNotEmptyException
     *         You can't yet delete this stack set, because it still contains one or more stack instances. Delete all
     *         stack instances from the stack set before deleting the stack set.
     * @throws OperationInProgressException
     *         Another operation is currently in progress for this stack set. Only one operation can be performed for a
     *         stack set at a given time.
     * @sample AmazonCloudFormation.DeleteStackSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStackSet" target="_top">AWS
     *      API Documentation</a>
     */
    DeleteStackSetResult deleteStackSet(DeleteStackSetRequest deleteStackSetRequest);

    /**
     * <p>
     * Marks an extension or extension version as <code>DEPRECATED</code> in the CloudFormation registry, removing it
     * from active use. Deprecated extensions or extension versions cannot be used in CloudFormation operations.
     * </p>
     * <p>
     * To deregister an entire extension, you must individually deregister all active versions of that extension. If an
     * extension has only a single active version, deregistering that version results in the extension itself being
     * deregistered and marked as deprecated in the registry.
     * </p>
     * <p>
     * You can't deregister the default version of an extension if there are other active version of that extension. If
     * you do deregister the default version of an extension, the extension type itself is deregistered as well and
     * marked as deprecated.
     * </p>
     * <p>
     * To view the deprecation status of an extension or extension version, use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeType.html">DescribeType</a>.
     * </p>
     * 
     * @param deregisterTypeRequest
     * @return Result of the DeregisterType operation returned by the service.
     * @throws CFNRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws TypeNotFoundException
     *         The specified extension doesn't exist in the CloudFormation registry.
     * @sample AmazonCloudFormation.DeregisterType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeregisterType" target="_top">AWS
     *      API Documentation</a>
     */
    DeregisterTypeResult deregisterType(DeregisterTypeRequest deregisterTypeRequest);

    /**
     * <p>
     * Retrieves your account's CloudFormation limits, such as the maximum number of stacks that you can create in your
     * account. For more information about account limits, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html">CloudFormation
     * Quotas</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * 
     * @param describeAccountLimitsRequest
     *        The input for the <a>DescribeAccountLimits</a> action.
     * @return Result of the DescribeAccountLimits operation returned by the service.
     * @sample AmazonCloudFormation.DescribeAccountLimits
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    DescribeAccountLimitsResult describeAccountLimits(DescribeAccountLimitsRequest describeAccountLimitsRequest);

    /**
     * <p>
     * Returns the inputs for the change set and a list of changes that CloudFormation will make if you execute the
     * change set. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-changesets.html"
     * >Updating Stacks Using Change Sets</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * 
     * @param describeChangeSetRequest
     *        The input for the <a>DescribeChangeSet</a> action.
     * @return Result of the DescribeChangeSet operation returned by the service.
     * @throws ChangeSetNotFoundException
     *         The specified change set name or ID doesn't exit. To view valid change sets for a stack, use the
     *         <code>ListChangeSets</code> operation.
     * @sample AmazonCloudFormation.DescribeChangeSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    DescribeChangeSetResult describeChangeSet(DescribeChangeSetRequest describeChangeSetRequest);

    /**
     * <p>
     * Returns hook-related information for the change set and a list of changes that CloudFormation makes when you run
     * the change set.
     * </p>
     * 
     * @param describeChangeSetHooksRequest
     * @return Result of the DescribeChangeSetHooks operation returned by the service.
     * @throws ChangeSetNotFoundException
     *         The specified change set name or ID doesn't exit. To view valid change sets for a stack, use the
     *         <code>ListChangeSets</code> operation.
     * @sample AmazonCloudFormation.DescribeChangeSetHooks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeChangeSetHooks"
     *      target="_top">AWS API Documentation</a>
     */
    DescribeChangeSetHooksResult describeChangeSetHooks(DescribeChangeSetHooksRequest describeChangeSetHooksRequest);

    /**
     * <p>
     * Describes a generated template. The output includes details about the progress of the creation of a generated
     * template started by a <code>CreateGeneratedTemplate</code> API action or the update of a generated template
     * started with an <code>UpdateGeneratedTemplate</code> API action.
     * </p>
     * 
     * @param describeGeneratedTemplateRequest
     * @return Result of the DescribeGeneratedTemplate operation returned by the service.
     * @throws GeneratedTemplateNotFoundException
     *         The generated template was not found.
     * @sample AmazonCloudFormation.DescribeGeneratedTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeGeneratedTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    DescribeGeneratedTemplateResult describeGeneratedTemplate(DescribeGeneratedTemplateRequest describeGeneratedTemplateRequest);

    /**
     * <p>
     * Retrieves information about the account's <code>OrganizationAccess</code> status. This API can be called either
     * by the management account or the delegated administrator by using the <code>CallAs</code> parameter. This API can
     * also be called without the <code>CallAs</code> parameter by the management account.
     * </p>
     * 
     * @param describeOrganizationsAccessRequest
     * @return Result of the DescribeOrganizationsAccess operation returned by the service.
     * @throws InvalidOperationException
     *         The specified operation isn't valid.
     * @throws OperationNotFoundException
     *         The specified ID refers to an operation that doesn't exist.
     * @sample AmazonCloudFormation.DescribeOrganizationsAccess
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeOrganizationsAccess"
     *      target="_top">AWS API Documentation</a>
     */
    DescribeOrganizationsAccessResult describeOrganizationsAccess(DescribeOrganizationsAccessRequest describeOrganizationsAccessRequest);

    /**
     * <p>
     * Returns information about a CloudFormation extension publisher.
     * </p>
     * <p>
     * If you don't supply a <code>PublisherId</code>, and you have registered as an extension publisher,
     * <code>DescribePublisher</code> returns information about your own publisher account.
     * </p>
     * <p>
     * For more information about registering as a publisher, see:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterPublisher.html">
     * RegisterPublisher</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html">Publishing
     * extensions to make them available for public use</a> in the <i>CloudFormation CLI User Guide</i>
     * </p>
     * </li>
     * </ul>
     * 
     * @param describePublisherRequest
     * @return Result of the DescribePublisher operation returned by the service.
     * @throws CFNRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @sample AmazonCloudFormation.DescribePublisher
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribePublisher"
     *      target="_top">AWS API Documentation</a>
     */
    DescribePublisherResult describePublisher(DescribePublisherRequest describePublisherRequest);

    /**
     * <p>
     * Describes details of a resource scan.
     * </p>
     * 
     * @param describeResourceScanRequest
     * @return Result of the DescribeResourceScan operation returned by the service.
     * @throws ResourceScanNotFoundException
     *         The resource scan was not found.
     * @sample AmazonCloudFormation.DescribeResourceScan
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeResourceScan"
     *      target="_top">AWS API Documentation</a>
     */
    DescribeResourceScanResult describeResourceScan(DescribeResourceScanRequest describeResourceScanRequest);

    /**
     * <p>
     * Returns information about a stack drift detection operation. A stack drift detection operation detects whether a
     * stack's actual configuration differs, or has <i>drifted</i>, from its expected configuration, as defined in the
     * stack template and any values specified as template parameters. A stack is considered to have drifted if one or
     * more of its resources have drifted. For more information about stack and resource drift, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting
     * Unregulated Configuration Changes to Stacks and Resources</a>.
     * </p>
     * <p>
     * Use <a>DetectStackDrift</a> to initiate a stack drift detection operation. <code>DetectStackDrift</code> returns
     * a <code>StackDriftDetectionId</code> you can use to monitor the progress of the operation using
     * <code>DescribeStackDriftDetectionStatus</code>. Once the drift detection operation has completed, use
     * <a>DescribeStackResourceDrifts</a> to return drift information about the stack and its resources.
     * </p>
     * 
     * @param describeStackDriftDetectionStatusRequest
     * @return Result of the DescribeStackDriftDetectionStatus operation returned by the service.
     * @sample AmazonCloudFormation.DescribeStackDriftDetectionStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackDriftDetectionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    DescribeStackDriftDetectionStatusResult describeStackDriftDetectionStatus(DescribeStackDriftDetectionStatusRequest describeStackDriftDetectionStatusRequest);

    /**
     * <p>
     * Returns all stack related events for a specified stack in reverse chronological order. For more information about
     * a stack's event history, go to <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/concept-stack.html">Stacks</a> in the
     * <i>CloudFormation User Guide</i>.
     * </p>
     * <note>
     * <p>
     * You can list events for stacks that have failed to create or have been deleted by specifying the unique stack
     * identifier (stack ID).
     * </p>
     * </note>
     * 
     * @param describeStackEventsRequest
     *        The input for <a>DescribeStackEvents</a> action.
     * @return Result of the DescribeStackEvents operation returned by the service.
     * @sample AmazonCloudFormation.DescribeStackEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackEvents"
     *      target="_top">AWS API Documentation</a>
     */
    DescribeStackEventsResult describeStackEvents(DescribeStackEventsRequest describeStackEventsRequest);

    /**
     * <p>
     * Returns the stack instance that's associated with the specified StackSet, Amazon Web Services account, and Amazon
     * Web Services Region.
     * </p>
     * <p>
     * For a list of stack instances that are associated with a specific StackSet, use <a>ListStackInstances</a>.
     * </p>
     * 
     * @param describeStackInstanceRequest
     * @return Result of the DescribeStackInstance operation returned by the service.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws StackInstanceNotFoundException
     *         The specified stack instance doesn't exist.
     * @sample AmazonCloudFormation.DescribeStackInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackInstance"
     *      target="_top">AWS API Documentation</a>
     */
    DescribeStackInstanceResult describeStackInstance(DescribeStackInstanceRequest describeStackInstanceRequest);

    /**
     * <p>
     * Returns a description of the specified resource in the specified stack.
     * </p>
     * <p>
     * For deleted stacks, DescribeStackResource returns resource information for up to 90 days after the stack has been
     * deleted.
     * </p>
     * 
     * @param describeStackResourceRequest
     *        The input for <a>DescribeStackResource</a> action.
     * @return Result of the DescribeStackResource operation returned by the service.
     * @sample AmazonCloudFormation.DescribeStackResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResource"
     *      target="_top">AWS API Documentation</a>
     */
    DescribeStackResourceResult describeStackResource(DescribeStackResourceRequest describeStackResourceRequest);

    /**
     * <p>
     * Returns drift information for the resources that have been checked for drift in the specified stack. This
     * includes actual and expected configuration values for resources where CloudFormation detects configuration drift.
     * </p>
     * <p>
     * For a given stack, there will be one <code>StackResourceDrift</code> for each stack resource that has been
     * checked for drift. Resources that haven't yet been checked for drift aren't included. Resources that don't
     * currently support drift detection aren't checked, and so not included. For a list of resources that support drift
     * detection, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html"
     * >Resources that Support Drift Detection</a>.
     * </p>
     * <p>
     * Use <a>DetectStackResourceDrift</a> to detect drift on individual resources, or <a>DetectStackDrift</a> to detect
     * drift on all supported resources for a given stack.
     * </p>
     * 
     * @param describeStackResourceDriftsRequest
     * @return Result of the DescribeStackResourceDrifts operation returned by the service.
     * @sample AmazonCloudFormation.DescribeStackResourceDrifts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResourceDrifts"
     *      target="_top">AWS API Documentation</a>
     */
    DescribeStackResourceDriftsResult describeStackResourceDrifts(DescribeStackResourceDriftsRequest describeStackResourceDriftsRequest);

    /**
     * <p>
     * Returns Amazon Web Services resource descriptions for running and deleted stacks. If <code>StackName</code> is
     * specified, all the associated resources that are part of the stack are returned. If
     * <code>PhysicalResourceId</code> is specified, the associated resources of the stack that the resource belongs to
     * are returned.
     * </p>
     * <note>
     * <p>
     * Only the first 100 resources will be returned. If your stack has more resources than this, you should use
     * <code>ListStackResources</code> instead.
     * </p>
     * </note>
     * <p>
     * For deleted stacks, <code>DescribeStackResources</code> returns resource information for up to 90 days after the
     * stack has been deleted.
     * </p>
     * <p>
     * You must specify either <code>StackName</code> or <code>PhysicalResourceId</code>, but not both. In addition, you
     * can specify <code>LogicalResourceId</code> to filter the returned result. For more information about resources,
     * the <code>LogicalResourceId</code> and <code>PhysicalResourceId</code>, go to the <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/">CloudFormation User Guide</a>.
     * </p>
     * <note>
     * <p>
     * A <code>ValidationError</code> is returned if you specify both <code>StackName</code> and
     * <code>PhysicalResourceId</code> in the same request.
     * </p>
     * </note>
     * 
     * @param describeStackResourcesRequest
     *        The input for <a>DescribeStackResources</a> action.
     * @return Result of the DescribeStackResources operation returned by the service.
     * @sample AmazonCloudFormation.DescribeStackResources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResources"
     *      target="_top">AWS API Documentation</a>
     */
    DescribeStackResourcesResult describeStackResources(DescribeStackResourcesRequest describeStackResourcesRequest);

    /**
     * <p>
     * Returns the description of the specified StackSet.
     * </p>
     * 
     * @param describeStackSetRequest
     * @return Result of the DescribeStackSet operation returned by the service.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @sample AmazonCloudFormation.DescribeStackSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackSet"
     *      target="_top">AWS API Documentation</a>
     */
    DescribeStackSetResult describeStackSet(DescribeStackSetRequest describeStackSetRequest);

    /**
     * <p>
     * Returns the description of the specified StackSet operation.
     * </p>
     * 
     * @param describeStackSetOperationRequest
     * @return Result of the DescribeStackSetOperation operation returned by the service.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws OperationNotFoundException
     *         The specified ID refers to an operation that doesn't exist.
     * @sample AmazonCloudFormation.DescribeStackSetOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackSetOperation"
     *      target="_top">AWS API Documentation</a>
     */
    DescribeStackSetOperationResult describeStackSetOperation(DescribeStackSetOperationRequest describeStackSetOperationRequest);

    /**
     * <p>
     * Returns the description for the specified stack; if no stack name was specified, then it returns the description
     * for all the stacks created.
     * </p>
     * <note>
     * <p>
     * If the stack doesn't exist, a <code>ValidationError</code> is returned.
     * </p>
     * </note>
     * 
     * @param describeStacksRequest
     *        The input for <a>DescribeStacks</a> action.
     * @return Result of the DescribeStacks operation returned by the service.
     * @sample AmazonCloudFormation.DescribeStacks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStacks" target="_top">AWS
     *      API Documentation</a>
     */
    DescribeStacksResult describeStacks(DescribeStacksRequest describeStacksRequest);

    /**
     * Simplified method form for invoking the DescribeStacks operation.
     *
     * @see #describeStacks(DescribeStacksRequest)
     */
    DescribeStacksResult describeStacks();

    /**
     * <p>
     * Returns detailed information about an extension that has been registered.
     * </p>
     * <p>
     * If you specify a <code>VersionId</code>, <code>DescribeType</code> returns information about that specific
     * extension version. Otherwise, it returns information about the default extension version.
     * </p>
     * 
     * @param describeTypeRequest
     * @return Result of the DescribeType operation returned by the service.
     * @throws CFNRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws TypeNotFoundException
     *         The specified extension doesn't exist in the CloudFormation registry.
     * @sample AmazonCloudFormation.DescribeType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeType" target="_top">AWS
     *      API Documentation</a>
     */
    DescribeTypeResult describeType(DescribeTypeRequest describeTypeRequest);

    /**
     * <p>
     * Returns information about an extension's registration, including its current status and type and version
     * identifiers.
     * </p>
     * <p>
     * When you initiate a registration request using <a>RegisterType</a>, you can then use
     * <a>DescribeTypeRegistration</a> to monitor the progress of that registration request.
     * </p>
     * <p>
     * Once the registration request has completed, use <a>DescribeType</a> to return detailed information about an
     * extension.
     * </p>
     * 
     * @param describeTypeRegistrationRequest
     * @return Result of the DescribeTypeRegistration operation returned by the service.
     * @throws CFNRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @sample AmazonCloudFormation.DescribeTypeRegistration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeTypeRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    DescribeTypeRegistrationResult describeTypeRegistration(DescribeTypeRegistrationRequest describeTypeRegistrationRequest);

    /**
     * <p>
     * Detects whether a stack's actual configuration differs, or has <i>drifted</i>, from its expected configuration,
     * as defined in the stack template and any values specified as template parameters. For each resource in the stack
     * that supports drift detection, CloudFormation compares the actual configuration of the resource with its expected
     * template configuration. Only resource properties explicitly defined in the stack template are checked for drift.
     * A stack is considered to have drifted if one or more of its resources differ from their expected template
     * configurations. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting
     * Unregulated Configuration Changes to Stacks and Resources</a>.
     * </p>
     * <p>
     * Use <code>DetectStackDrift</code> to detect drift on all supported resources for a given stack, or
     * <a>DetectStackResourceDrift</a> to detect drift on individual resources.
     * </p>
     * <p>
     * For a list of stack resources that currently support drift detection, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html"
     * >Resources that Support Drift Detection</a>.
     * </p>
     * <p>
     * <code>DetectStackDrift</code> can take up to several minutes, depending on the number of resources contained
     * within the stack. Use <a>DescribeStackDriftDetectionStatus</a> to monitor the progress of a detect stack drift
     * operation. Once the drift detection operation has completed, use <a>DescribeStackResourceDrifts</a> to return
     * drift information about the stack and its resources.
     * </p>
     * <p>
     * When detecting drift on a stack, CloudFormation doesn't detect drift on any nested stacks belonging to that
     * stack. Perform <code>DetectStackDrift</code> directly on the nested stack itself.
     * </p>
     * 
     * @param detectStackDriftRequest
     * @return Result of the DetectStackDrift operation returned by the service.
     * @sample AmazonCloudFormation.DetectStackDrift
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DetectStackDrift"
     *      target="_top">AWS API Documentation</a>
     */
    DetectStackDriftResult detectStackDrift(DetectStackDriftRequest detectStackDriftRequest);

    /**
     * <p>
     * Returns information about whether a resource's actual configuration differs, or has <i>drifted</i>, from its
     * expected configuration, as defined in the stack template and any values specified as template parameters. This
     * information includes actual and expected property values for resources in which CloudFormation detects drift.
     * Only resource properties explicitly defined in the stack template are checked for drift. For more information
     * about stack and resource drift, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting
     * Unregulated Configuration Changes to Stacks and Resources</a>.
     * </p>
     * <p>
     * Use <code>DetectStackResourceDrift</code> to detect drift on individual resources, or <a>DetectStackDrift</a> to
     * detect drift on all resources in a given stack that support drift detection.
     * </p>
     * <p>
     * Resources that don't currently support drift detection can't be checked. For a list of resources that support
     * drift detection, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html"
     * >Resources that Support Drift Detection</a>.
     * </p>
     * 
     * @param detectStackResourceDriftRequest
     * @return Result of the DetectStackResourceDrift operation returned by the service.
     * @sample AmazonCloudFormation.DetectStackResourceDrift
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DetectStackResourceDrift"
     *      target="_top">AWS API Documentation</a>
     */
    DetectStackResourceDriftResult detectStackResourceDrift(DetectStackResourceDriftRequest detectStackResourceDriftRequest);

    /**
     * <p>
     * Detect drift on a stack set. When CloudFormation performs drift detection on a stack set, it performs drift
     * detection on the stack associated with each stack instance in the stack set. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html">How CloudFormation
     * performs drift detection on a stack set</a>.
     * </p>
     * <p>
     * <code>DetectStackSetDrift</code> returns the <code>OperationId</code> of the stack set drift detection operation.
     * Use this operation id with <a>DescribeStackSetOperation</a> to monitor the progress of the drift detection
     * operation. The drift detection operation may take some time, depending on the number of stack instances included
     * in the stack set, in addition to the number of resources included in each stack.
     * </p>
     * <p>
     * Once the operation has completed, use the following actions to return drift information:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use <a>DescribeStackSet</a> to return detailed information about the stack set, including detailed information
     * about the last <i>completed</i> drift operation performed on the stack set. (Information about drift operations
     * that are in progress isn't included.)
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <a>ListStackInstances</a> to return a list of stack instances belonging to the stack set, including the drift
     * status and last drift time checked of each instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <a>DescribeStackInstance</a> to return detailed information about a specific stack instance, including its
     * drift status and last drift time checked.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about performing a drift detection operation on a stack set, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html">Detecting unmanaged
     * changes in stack sets</a>.
     * </p>
     * <p>
     * You can only run a single drift detection operation on a given stack set at one time.
     * </p>
     * <p>
     * To stop a drift detection stack set operation, use <a>StopStackSetOperation</a>.
     * </p>
     * 
     * @param detectStackSetDriftRequest
     * @return Result of the DetectStackSetDrift operation returned by the service.
     * @throws InvalidOperationException
     *         The specified operation isn't valid.
     * @throws OperationInProgressException
     *         Another operation is currently in progress for this stack set. Only one operation can be performed for a
     *         stack set at a given time.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @sample AmazonCloudFormation.DetectStackSetDrift
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DetectStackSetDrift"
     *      target="_top">AWS API Documentation</a>
     */
    DetectStackSetDriftResult detectStackSetDrift(DetectStackSetDriftRequest detectStackSetDriftRequest);

    /**
     * <p>
     * Returns the estimated monthly cost of a template. The return value is an Amazon Web Services Simple Monthly
     * Calculator URL with a query string that describes the resources required to run the template.
     * </p>
     * 
     * @param estimateTemplateCostRequest
     *        The input for an <a>EstimateTemplateCost</a> action.
     * @return Result of the EstimateTemplateCost operation returned by the service.
     * @sample AmazonCloudFormation.EstimateTemplateCost
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/EstimateTemplateCost"
     *      target="_top">AWS API Documentation</a>
     */
    EstimateTemplateCostResult estimateTemplateCost(EstimateTemplateCostRequest estimateTemplateCostRequest);

    /**
     * Simplified method form for invoking the EstimateTemplateCost operation.
     *
     * @see #estimateTemplateCost(EstimateTemplateCostRequest)
     */
    EstimateTemplateCostResult estimateTemplateCost();

    /**
     * <p>
     * Updates a stack using the input information that was provided when the specified change set was created. After
     * the call successfully completes, CloudFormation starts updating the stack. Use the <a>DescribeStacks</a> action
     * to view the status of the update.
     * </p>
     * <p>
     * When you execute a change set, CloudFormation deletes all other change sets associated with the stack because
     * they aren't valid for the updated stack.
     * </p>
     * <p>
     * If a stack policy is associated with the stack, CloudFormation enforces the policy during the update. You can't
     * specify a temporary stack policy that overrides the current policy.
     * </p>
     * <p>
     * To create a change set for the entire stack hierarchy, <code>IncludeNestedStacks</code> must have been set to
     * <code>True</code>.
     * </p>
     * 
     * @param executeChangeSetRequest
     *        The input for the <a>ExecuteChangeSet</a> action.
     * @return Result of the ExecuteChangeSet operation returned by the service.
     * @throws InvalidChangeSetStatusException
     *         The specified change set can't be used to update the stack. For example, the change set status might be
     *         <code>CREATE_IN_PROGRESS</code>, or the stack status might be <code>UPDATE_IN_PROGRESS</code>.
     * @throws ChangeSetNotFoundException
     *         The specified change set name or ID doesn't exit. To view valid change sets for a stack, use the
     *         <code>ListChangeSets</code> operation.
     * @throws InsufficientCapabilitiesException
     *         The template contains resources with capabilities that weren't specified in the Capabilities parameter.
     * @throws TokenAlreadyExistsException
     *         A client request token already exists.
     * @sample AmazonCloudFormation.ExecuteChangeSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ExecuteChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    ExecuteChangeSetResult executeChangeSet(ExecuteChangeSetRequest executeChangeSetRequest);

    /**
     * <p>
     * Retrieves a generated template. If the template is in an <code>InProgress</code> or <code>Pending</code> status
     * then the template returned will be the template when the template was last in a <code>Complete</code> status. If
     * the template has not yet been in a <code>Complete</code> status then an empty template will be returned.
     * </p>
     * 
     * @param getGeneratedTemplateRequest
     * @return Result of the GetGeneratedTemplate operation returned by the service.
     * @throws GeneratedTemplateNotFoundException
     *         The generated template was not found.
     * @sample AmazonCloudFormation.GetGeneratedTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetGeneratedTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    GetGeneratedTemplateResult getGeneratedTemplate(GetGeneratedTemplateRequest getGeneratedTemplateRequest);

    /**
     * <p>
     * Returns the stack policy for a specified stack. If a stack doesn't have a policy, a null value is returned.
     * </p>
     * 
     * @param getStackPolicyRequest
     *        The input for the <a>GetStackPolicy</a> action.
     * @return Result of the GetStackPolicy operation returned by the service.
     * @sample AmazonCloudFormation.GetStackPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetStackPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    GetStackPolicyResult getStackPolicy(GetStackPolicyRequest getStackPolicyRequest);

    /**
     * <p>
     * Returns the template body for a specified stack. You can get the template for running or deleted stacks.
     * </p>
     * <p>
     * For deleted stacks, <code>GetTemplate</code> returns the template for up to 90 days after the stack has been
     * deleted.
     * </p>
     * <note>
     * <p>
     * If the template doesn't exist, a <code>ValidationError</code> is returned.
     * </p>
     * </note>
     * 
     * @param getTemplateRequest
     *        The input for a <a>GetTemplate</a> action.
     * @return Result of the GetTemplate operation returned by the service.
     * @throws ChangeSetNotFoundException
     *         The specified change set name or ID doesn't exit. To view valid change sets for a stack, use the
     *         <code>ListChangeSets</code> operation.
     * @sample AmazonCloudFormation.GetTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    GetTemplateResult getTemplate(GetTemplateRequest getTemplateRequest);

    /**
     * <p>
     * Returns information about a new or existing template. The <code>GetTemplateSummary</code> action is useful for
     * viewing parameter information, such as default parameter values and parameter types, before you create or update
     * a stack or stack set.
     * </p>
     * <p>
     * You can use the <code>GetTemplateSummary</code> action when you submit a template, or you can get template
     * information for a stack set, or a running or deleted stack.
     * </p>
     * <p>
     * For deleted stacks, <code>GetTemplateSummary</code> returns the template information for up to 90 days after the
     * stack has been deleted. If the template doesn't exist, a <code>ValidationError</code> is returned.
     * </p>
     * 
     * @param getTemplateSummaryRequest
     *        The input for the <a>GetTemplateSummary</a> action.
     * @return Result of the GetTemplateSummary operation returned by the service.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @sample AmazonCloudFormation.GetTemplateSummary
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetTemplateSummary"
     *      target="_top">AWS API Documentation</a>
     */
    GetTemplateSummaryResult getTemplateSummary(GetTemplateSummaryRequest getTemplateSummaryRequest);

    /**
     * Simplified method form for invoking the GetTemplateSummary operation.
     *
     * @see #getTemplateSummary(GetTemplateSummaryRequest)
     */
    GetTemplateSummaryResult getTemplateSummary();

    /**
     * <p>
     * Import existing stacks into a new stack sets. Use the stack import operation to import up to 10 stacks into a new
     * stack set in the same account as the source stack or in a different administrator account and Region, by
     * specifying the stack ID of the stack you intend to import.
     * </p>
     * 
     * @param importStacksToStackSetRequest
     * @return Result of the ImportStacksToStackSet operation returned by the service.
     * @throws LimitExceededException
     *         The quota for the resource has already been reached.</p>
     *         <p>
     *         For information about resource and stack limitations, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html"
     *         >CloudFormation quotas</a> in the <i>CloudFormation User Guide</i>.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws InvalidOperationException
     *         The specified operation isn't valid.
     * @throws OperationInProgressException
     *         Another operation is currently in progress for this stack set. Only one operation can be performed for a
     *         stack set at a given time.
     * @throws OperationIdAlreadyExistsException
     *         The specified operation ID already exists.
     * @throws StackNotFoundException
     *         The specified stack ARN doesn't exist or stack doesn't exist corresponding to the ARN in input.
     * @throws StaleRequestException
     *         Another operation has been performed on this stack set since the specified operation was performed.
     * @sample AmazonCloudFormation.ImportStacksToStackSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ImportStacksToStackSet"
     *      target="_top">AWS API Documentation</a>
     */
    ImportStacksToStackSetResult importStacksToStackSet(ImportStacksToStackSetRequest importStacksToStackSetRequest);

    /**
     * <p>
     * Returns the ID and status of each active change set for a stack. For example, CloudFormation lists change sets
     * that are in the <code>CREATE_IN_PROGRESS</code> or <code>CREATE_PENDING</code> state.
     * </p>
     * 
     * @param listChangeSetsRequest
     *        The input for the <a>ListChangeSets</a> action.
     * @return Result of the ListChangeSets operation returned by the service.
     * @sample AmazonCloudFormation.ListChangeSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListChangeSets" target="_top">AWS
     *      API Documentation</a>
     */
    ListChangeSetsResult listChangeSets(ListChangeSetsRequest listChangeSetsRequest);

    /**
     * <p>
     * Lists all exported output values in the account and Region in which you call this action. Use this action to see
     * the exported output values that you can import into other stacks. To import values, use the <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html">
     * Fn::ImportValue</a> function.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-exports.html">
     * CloudFormation export stack output values</a>.
     * </p>
     * 
     * @param listExportsRequest
     * @return Result of the ListExports operation returned by the service.
     * @sample AmazonCloudFormation.ListExports
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListExports" target="_top">AWS API
     *      Documentation</a>
     */
    ListExportsResult listExports(ListExportsRequest listExportsRequest);

    /**
     * <p>
     * Lists your generated templates in this Region.
     * </p>
     * 
     * @param listGeneratedTemplatesRequest
     * @return Result of the ListGeneratedTemplates operation returned by the service.
     * @sample AmazonCloudFormation.ListGeneratedTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListGeneratedTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    ListGeneratedTemplatesResult listGeneratedTemplates(ListGeneratedTemplatesRequest listGeneratedTemplatesRequest);

    /**
     * <p>
     * Lists all stacks that are importing an exported output value. To modify or remove an exported output value, first
     * use this action to see which stacks are using it. To see the exported output values in your account, see
     * <a>ListExports</a>.
     * </p>
     * <p>
     * For more information about importing an exported output value, see the <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html"
     * >Fn::ImportValue</a> function.
     * </p>
     * 
     * @param listImportsRequest
     * @return Result of the ListImports operation returned by the service.
     * @sample AmazonCloudFormation.ListImports
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListImports" target="_top">AWS API
     *      Documentation</a>
     */
    ListImportsResult listImports(ListImportsRequest listImportsRequest);

    /**
     * <p>
     * Lists the related resources for a list of resources from a resource scan. The response indicates whether each
     * returned resource is already managed by CloudFormation.
     * </p>
     * 
     * @param listResourceScanRelatedResourcesRequest
     * @return Result of the ListResourceScanRelatedResources operation returned by the service.
     * @throws ResourceScanNotFoundException
     *         The resource scan was not found.
     * @throws ResourceScanInProgressException
     *         A resource scan is currently in progress. Only one can be run at a time for an account in a Region.
     * @sample AmazonCloudFormation.ListResourceScanRelatedResources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListResourceScanRelatedResources"
     *      target="_top">AWS API Documentation</a>
     */
    ListResourceScanRelatedResourcesResult listResourceScanRelatedResources(ListResourceScanRelatedResourcesRequest listResourceScanRelatedResourcesRequest);

    /**
     * <p>
     * Lists the resources from a resource scan. The results can be filtered by resource identifier, resource type
     * prefix, tag key, and tag value. Only resources that match all specified filters are returned. The response
     * indicates whether each returned resource is already managed by CloudFormation.
     * </p>
     * 
     * @param listResourceScanResourcesRequest
     * @return Result of the ListResourceScanResources operation returned by the service.
     * @throws ResourceScanNotFoundException
     *         The resource scan was not found.
     * @throws ResourceScanInProgressException
     *         A resource scan is currently in progress. Only one can be run at a time for an account in a Region.
     * @sample AmazonCloudFormation.ListResourceScanResources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListResourceScanResources"
     *      target="_top">AWS API Documentation</a>
     */
    ListResourceScanResourcesResult listResourceScanResources(ListResourceScanResourcesRequest listResourceScanResourcesRequest);

    /**
     * <p>
     * List the resource scans from newest to oldest. By default it will return up to 10 resource scans.
     * </p>
     * 
     * @param listResourceScansRequest
     * @return Result of the ListResourceScans operation returned by the service.
     * @sample AmazonCloudFormation.ListResourceScans
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListResourceScans"
     *      target="_top">AWS API Documentation</a>
     */
    ListResourceScansResult listResourceScans(ListResourceScansRequest listResourceScansRequest);

    /**
     * <p>
     * Returns drift information for resources in a stack instance.
     * </p>
     * <note>
     * <p>
     * <code>ListStackInstanceResourceDrifts</code> returns drift information for the most recent drift detection
     * operation. If an operation is in progress, it may only return partial results.
     * </p>
     * </note>
     * 
     * @param listStackInstanceResourceDriftsRequest
     * @return Result of the ListStackInstanceResourceDrifts operation returned by the service.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws StackInstanceNotFoundException
     *         The specified stack instance doesn't exist.
     * @throws OperationNotFoundException
     *         The specified ID refers to an operation that doesn't exist.
     * @sample AmazonCloudFormation.ListStackInstanceResourceDrifts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackInstanceResourceDrifts"
     *      target="_top">AWS API Documentation</a>
     */
    ListStackInstanceResourceDriftsResult listStackInstanceResourceDrifts(ListStackInstanceResourceDriftsRequest listStackInstanceResourceDriftsRequest);

    /**
     * <p>
     * Returns summary information about stack instances that are associated with the specified stack set. You can
     * filter for stack instances that are associated with a specific Amazon Web Services account name or Region, or
     * that have a specific status.
     * </p>
     * 
     * @param listStackInstancesRequest
     * @return Result of the ListStackInstances operation returned by the service.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @sample AmazonCloudFormation.ListStackInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackInstances"
     *      target="_top">AWS API Documentation</a>
     */
    ListStackInstancesResult listStackInstances(ListStackInstancesRequest listStackInstancesRequest);

    /**
     * <p>
     * Returns descriptions of all resources of the specified stack.
     * </p>
     * <p>
     * For deleted stacks, ListStackResources returns resource information for up to 90 days after the stack has been
     * deleted.
     * </p>
     * 
     * @param listStackResourcesRequest
     *        The input for the <a>ListStackResource</a> action.
     * @return Result of the ListStackResources operation returned by the service.
     * @sample AmazonCloudFormation.ListStackResources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackResources"
     *      target="_top">AWS API Documentation</a>
     */
    ListStackResourcesResult listStackResources(ListStackResourcesRequest listStackResourcesRequest);

    /**
     * <p>
     * Returns summary information about the results of a stack set operation.
     * </p>
     * 
     * @param listStackSetOperationResultsRequest
     * @return Result of the ListStackSetOperationResults operation returned by the service.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws OperationNotFoundException
     *         The specified ID refers to an operation that doesn't exist.
     * @sample AmazonCloudFormation.ListStackSetOperationResults
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetOperationResults"
     *      target="_top">AWS API Documentation</a>
     */
    ListStackSetOperationResultsResult listStackSetOperationResults(ListStackSetOperationResultsRequest listStackSetOperationResultsRequest);

    /**
     * <p>
     * Returns summary information about operations performed on a stack set.
     * </p>
     * 
     * @param listStackSetOperationsRequest
     * @return Result of the ListStackSetOperations operation returned by the service.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @sample AmazonCloudFormation.ListStackSetOperations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetOperations"
     *      target="_top">AWS API Documentation</a>
     */
    ListStackSetOperationsResult listStackSetOperations(ListStackSetOperationsRequest listStackSetOperationsRequest);

    /**
     * <p>
     * Returns summary information about stack sets that are associated with the user.
     * </p>
     * <ul>
     * <li>
     * <p>
     * [Self-managed permissions] If you set the <code>CallAs</code> parameter to <code>SELF</code> while signed in to
     * your Amazon Web Services account, <code>ListStackSets</code> returns all self-managed stack sets in your Amazon
     * Web Services account.
     * </p>
     * </li>
     * <li>
     * <p>
     * [Service-managed permissions] If you set the <code>CallAs</code> parameter to <code>SELF</code> while signed in
     * to the organization's management account, <code>ListStackSets</code> returns all stack sets in the management
     * account.
     * </p>
     * </li>
     * <li>
     * <p>
     * [Service-managed permissions] If you set the <code>CallAs</code> parameter to <code>DELEGATED_ADMIN</code> while
     * signed in to your member account, <code>ListStackSets</code> returns all stack sets with service-managed
     * permissions in the management account.
     * </p>
     * </li>
     * </ul>
     * 
     * @param listStackSetsRequest
     * @return Result of the ListStackSets operation returned by the service.
     * @sample AmazonCloudFormation.ListStackSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSets" target="_top">AWS
     *      API Documentation</a>
     */
    ListStackSetsResult listStackSets(ListStackSetsRequest listStackSetsRequest);

    /**
     * <p>
     * Returns the summary information for stacks whose status matches the specified StackStatusFilter. Summary
     * information for stacks that have been deleted is kept for 90 days after the stack is deleted. If no
     * StackStatusFilter is specified, summary information for all stacks is returned (including existing stacks and
     * stacks that have been deleted).
     * </p>
     * 
     * @param listStacksRequest
     *        The input for <a>ListStacks</a> action.
     * @return Result of the ListStacks operation returned by the service.
     * @sample AmazonCloudFormation.ListStacks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStacks" target="_top">AWS API
     *      Documentation</a>
     */
    ListStacksResult listStacks(ListStacksRequest listStacksRequest);

    /**
     * Simplified method form for invoking the ListStacks operation.
     *
     * @see #listStacks(ListStacksRequest)
     */
    ListStacksResult listStacks();

    /**
     * <p>
     * Returns a list of registration tokens for the specified extension(s).
     * </p>
     * 
     * @param listTypeRegistrationsRequest
     * @return Result of the ListTypeRegistrations operation returned by the service.
     * @throws CFNRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @sample AmazonCloudFormation.ListTypeRegistrations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypeRegistrations"
     *      target="_top">AWS API Documentation</a>
     */
    ListTypeRegistrationsResult listTypeRegistrations(ListTypeRegistrationsRequest listTypeRegistrationsRequest);

    /**
     * <p>
     * Returns summary information about the versions of an extension.
     * </p>
     * 
     * @param listTypeVersionsRequest
     * @return Result of the ListTypeVersions operation returned by the service.
     * @throws CFNRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @sample AmazonCloudFormation.ListTypeVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypeVersions"
     *      target="_top">AWS API Documentation</a>
     */
    ListTypeVersionsResult listTypeVersions(ListTypeVersionsRequest listTypeVersionsRequest);

    /**
     * <p>
     * Returns summary information about extension that have been registered with CloudFormation.
     * </p>
     * 
     * @param listTypesRequest
     * @return Result of the ListTypes operation returned by the service.
     * @throws CFNRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @sample AmazonCloudFormation.ListTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypes" target="_top">AWS API
     *      Documentation</a>
     */
    ListTypesResult listTypes(ListTypesRequest listTypesRequest);

    /**
     * <p>
     * Publishes the specified extension to the CloudFormation registry as a public extension in this Region. Public
     * extensions are available for use by all CloudFormation users. For more information about publishing extensions,
     * see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html">Publishing
     * extensions to make them available for public use</a> in the <i>CloudFormation CLI User Guide</i>.
     * </p>
     * <p>
     * To publish an extension, you must be registered as a publisher with CloudFormation. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterPublisher.html">
     * RegisterPublisher</a>.
     * </p>
     * 
     * @param publishTypeRequest
     * @return Result of the PublishType operation returned by the service.
     * @throws CFNRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws TypeNotFoundException
     *         The specified extension doesn't exist in the CloudFormation registry.
     * @sample AmazonCloudFormation.PublishType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/PublishType" target="_top">AWS API
     *      Documentation</a>
     */
    PublishTypeResult publishType(PublishTypeRequest publishTypeRequest);

    /**
     * <p>
     * Reports progress of a resource handler to CloudFormation.
     * </p>
     * <p>
     * Reserved for use by the <a
     * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
     * >CloudFormation CLI</a>. Don't use this API in your code.
     * </p>
     * 
     * @param recordHandlerProgressRequest
     * @return Result of the RecordHandlerProgress operation returned by the service.
     * @throws InvalidStateTransitionException
     *         Error reserved for use by the <a
     *         href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
     *         >CloudFormation CLI</a>. CloudFormation doesn't return this error to users.
     * @throws OperationStatusCheckFailedException
     *         Error reserved for use by the <a
     *         href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
     *         >CloudFormation CLI</a>. CloudFormation doesn't return this error to users.
     * @sample AmazonCloudFormation.RecordHandlerProgress
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RecordHandlerProgress"
     *      target="_top">AWS API Documentation</a>
     */
    RecordHandlerProgressResult recordHandlerProgress(RecordHandlerProgressRequest recordHandlerProgressRequest);

    /**
     * <p>
     * Registers your account as a publisher of public extensions in the CloudFormation registry. Public extensions are
     * available for use by all CloudFormation users. This publisher ID applies to your account in all Amazon Web
     * Services Regions.
     * </p>
     * <p>
     * For information about requirements for registering as a public extension publisher, see <a href=
     * "https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html#publish-extension-prereqs"
     * >Registering your account to publish CloudFormation extensions</a> in the <i>CloudFormation CLI User Guide</i>.
     * </p>
     * <p/>
     * 
     * @param registerPublisherRequest
     * @return Result of the RegisterPublisher operation returned by the service.
     * @throws CFNRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @sample AmazonCloudFormation.RegisterPublisher
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RegisterPublisher"
     *      target="_top">AWS API Documentation</a>
     */
    RegisterPublisherResult registerPublisher(RegisterPublisherRequest registerPublisherRequest);

    /**
     * <p>
     * Registers an extension with the CloudFormation service. Registering an extension makes it available for use in
     * CloudFormation templates in your Amazon Web Services account, and includes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Validating the extension schema.
     * </p>
     * </li>
     * <li>
     * <p>
     * Determining which handlers, if any, have been specified for the extension.
     * </p>
     * </li>
     * <li>
     * <p>
     * Making the extension available for use in your account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about how to develop extensions and ready them for registration, see <a
     * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-types.html">Creating Resource
     * Providers</a> in the <i>CloudFormation CLI User Guide</i>.
     * </p>
     * <p>
     * You can have a maximum of 50 resource extension versions registered at a time. This maximum is per account and
     * per Region. Use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeregisterType.html"
     * >DeregisterType</a> to deregister specific extension versions if necessary.
     * </p>
     * <p>
     * Once you have initiated a registration request using <a>RegisterType</a>, you can use
     * <a>DescribeTypeRegistration</a> to monitor the progress of the registration request.
     * </p>
     * <p>
     * Once you have registered a private extension in your account and Region, use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_SetTypeConfiguration.html"
     * >SetTypeConfiguration</a> to specify configuration properties for the extension. For more information, see <a
     * href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-register.html#registry-set-configuration"
     * >Configuring extensions at the account level</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * 
     * @param registerTypeRequest
     * @return Result of the RegisterType operation returned by the service.
     * @throws CFNRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @sample AmazonCloudFormation.RegisterType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RegisterType" target="_top">AWS
     *      API Documentation</a>
     */
    RegisterTypeResult registerType(RegisterTypeRequest registerTypeRequest);

    /**
     * <p>
     * When specifying <code>RollbackStack</code>, you preserve the state of previously provisioned resources when an
     * operation fails. You can check the status of the stack through the <a>DescribeStacks</a> operation.
     * </p>
     * <p>
     * Rolls back the specified stack to the last known stable state from <code>CREATE_FAILED</code> or
     * <code>UPDATE_FAILED</code> stack statuses.
     * </p>
     * <p>
     * This operation will delete a stack if it doesn't contain a last known stable state. A last known stable state
     * includes any status in a <code>*_COMPLETE</code>. This includes the following stack statuses.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE_COMPLETE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_COMPLETE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_ROLLBACK_COMPLETE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IMPORT_COMPLETE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IMPORT_ROLLBACK_COMPLETE</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @param rollbackStackRequest
     * @return Result of the RollbackStack operation returned by the service.
     * @throws TokenAlreadyExistsException
     *         A client request token already exists.
     * @sample AmazonCloudFormation.RollbackStack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackStack" target="_top">AWS
     *      API Documentation</a>
     */
    RollbackStackResult rollbackStack(RollbackStackRequest rollbackStackRequest);

    /**
     * <p>
     * Sets a stack policy for a specified stack.
     * </p>
     * 
     * @param setStackPolicyRequest
     *        The input for the <a>SetStackPolicy</a> action.
     * @return Result of the SetStackPolicy operation returned by the service.
     * @sample AmazonCloudFormation.SetStackPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SetStackPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    SetStackPolicyResult setStackPolicy(SetStackPolicyRequest setStackPolicyRequest);

    /**
     * <p>
     * Specifies the configuration data for a registered CloudFormation extension, in the given account and Region.
     * </p>
     * <p>
     * To view the current configuration data for an extension, refer to the <code>ConfigurationSchema</code> element of
     * <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeType.html">DescribeType</a>.
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-register.html#registry-set-configuration"
     * >Configuring extensions at the account level</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * <important>
     * <p>
     * It's strongly recommended that you use dynamic references to restrict sensitive configuration definitions, such
     * as third-party credentials. For more details on dynamic references, see <a
     * href="https://docs.aws.amazon.com/">Using dynamic references to specify template values</a> in the
     * <i>CloudFormation User Guide</i>.
     * </p>
     * </important>
     * 
     * @param setTypeConfigurationRequest
     * @return Result of the SetTypeConfiguration operation returned by the service.
     * @throws CFNRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws TypeNotFoundException
     *         The specified extension doesn't exist in the CloudFormation registry.
     * @sample AmazonCloudFormation.SetTypeConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SetTypeConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    SetTypeConfigurationResult setTypeConfiguration(SetTypeConfigurationRequest setTypeConfigurationRequest);

    /**
     * <p>
     * Specify the default version of an extension. The default version of an extension will be used in CloudFormation
     * operations.
     * </p>
     * 
     * @param setTypeDefaultVersionRequest
     * @return Result of the SetTypeDefaultVersion operation returned by the service.
     * @throws CFNRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws TypeNotFoundException
     *         The specified extension doesn't exist in the CloudFormation registry.
     * @sample AmazonCloudFormation.SetTypeDefaultVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SetTypeDefaultVersion"
     *      target="_top">AWS API Documentation</a>
     */
    SetTypeDefaultVersionResult setTypeDefaultVersion(SetTypeDefaultVersionRequest setTypeDefaultVersionRequest);

    /**
     * <p>
     * Sends a signal to the specified resource with a success or failure status. You can use the
     * <code>SignalResource</code> operation in conjunction with a creation policy or update policy. CloudFormation
     * doesn't proceed with a stack creation or update until resources receive the required number of signals or the
     * timeout period is exceeded. The <code>SignalResource</code> operation is useful in cases where you want to send
     * signals from anywhere other than an Amazon EC2 instance.
     * </p>
     * 
     * @param signalResourceRequest
     *        The input for the <a>SignalResource</a> action.
     * @return Result of the SignalResource operation returned by the service.
     * @sample AmazonCloudFormation.SignalResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SignalResource" target="_top">AWS
     *      API Documentation</a>
     */
    SignalResourceResult signalResource(SignalResourceRequest signalResourceRequest);

    /**
     * <p>
     * Starts a scan of the resources in this account in this Region. You can the status of a scan using the
     * <code>ListResourceScans</code> API action.
     * </p>
     * 
     * @param startResourceScanRequest
     * @return Result of the StartResourceScan operation returned by the service.
     * @throws ResourceScanInProgressException
     *         A resource scan is currently in progress. Only one can be run at a time for an account in a Region.
     * @throws ResourceScanLimitExceededException
     *         The limit on resource scans has been exceeded. Reasons include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Exceeded the daily quota for resource scans.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A resource scan recently failed. You must wait 10 minutes before starting a new resource scan.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The last resource scan failed after exceeding 100,000 resources. When this happens, you must wait 24
     *         hours before starting a new resource scan.
     *         </p>
     *         </li>
     * @sample AmazonCloudFormation.StartResourceScan
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StartResourceScan"
     *      target="_top">AWS API Documentation</a>
     */
    StartResourceScanResult startResourceScan(StartResourceScanRequest startResourceScanRequest);

    /**
     * <p>
     * Stops an in-progress operation on a stack set and its associated stack instances. StackSets will cancel all the
     * unstarted stack instance deployments and wait for those are in-progress to complete.
     * </p>
     * 
     * @param stopStackSetOperationRequest
     * @return Result of the StopStackSetOperation operation returned by the service.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws OperationNotFoundException
     *         The specified ID refers to an operation that doesn't exist.
     * @throws InvalidOperationException
     *         The specified operation isn't valid.
     * @sample AmazonCloudFormation.StopStackSetOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StopStackSetOperation"
     *      target="_top">AWS API Documentation</a>
     */
    StopStackSetOperationResult stopStackSetOperation(StopStackSetOperationRequest stopStackSetOperationRequest);

    /**
     * <p>
     * Tests a registered extension to make sure it meets all necessary requirements for being published in the
     * CloudFormation registry.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For resource types, this includes passing all contracts tests defined for the type.
     * </p>
     * </li>
     * <li>
     * <p>
     * For modules, this includes determining if the module's model meets all necessary requirements.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html#publish-extension-testing"
     * >Testing your public extension prior to publishing</a> in the <i>CloudFormation CLI User Guide</i>.
     * </p>
     * <p>
     * If you don't specify a version, CloudFormation uses the default version of the extension in your account and
     * Region for testing.
     * </p>
     * <p>
     * To perform testing, CloudFormation assumes the execution role specified when the type was registered. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">RegisterType</a>.
     * </p>
     * <p>
     * Once you've initiated testing on an extension using <code>TestType</code>, you can pass the returned
     * <code>TypeVersionArn</code> into <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeType.html">DescribeType</a>
     * to monitor the current test status and test status description for the extension.
     * </p>
     * <p>
     * An extension must have a test status of <code>PASSED</code> before it can be published. For more information, see
     * <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-publish.html">Publishing
     * extensions to make them available for public use</a> in the <i>CloudFormation CLI User Guide</i>.
     * </p>
     * 
     * @param testTypeRequest
     * @return Result of the TestType operation returned by the service.
     * @throws CFNRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws TypeNotFoundException
     *         The specified extension doesn't exist in the CloudFormation registry.
     * @sample AmazonCloudFormation.TestType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/TestType" target="_top">AWS API
     *      Documentation</a>
     */
    TestTypeResult testType(TestTypeRequest testTypeRequest);

    /**
     * <p>
     * Updates a generated template. This can be used to change the name, add and remove resources, refresh resources,
     * and change the <code>DeletionPolicy</code> and <code>UpdateReplacePolicy</code> settings. You can check the
     * status of the update to the generated template using the <code>DescribeGeneratedTemplate</code> API action.
     * </p>
     * 
     * @param updateGeneratedTemplateRequest
     * @return Result of the UpdateGeneratedTemplate operation returned by the service.
     * @throws AlreadyExistsException
     *         The resource with the name requested already exists.
     * @throws GeneratedTemplateNotFoundException
     *         The generated template was not found.
     * @throws LimitExceededException
     *         The quota for the resource has already been reached.</p>
     *         <p>
     *         For information about resource and stack limitations, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html"
     *         >CloudFormation quotas</a> in the <i>CloudFormation User Guide</i>.
     * @sample AmazonCloudFormation.UpdateGeneratedTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateGeneratedTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    UpdateGeneratedTemplateResult updateGeneratedTemplate(UpdateGeneratedTemplateRequest updateGeneratedTemplateRequest);

    /**
     * <p>
     * Updates a stack as specified in the template. After the call completes successfully, the stack update starts. You
     * can check the status of the stack through the <a>DescribeStacks</a> action.
     * </p>
     * <p>
     * To get a copy of the template for an existing stack, you can use the <a>GetTemplate</a> action.
     * </p>
     * <p>
     * For more information about creating an update template, updating a stack, and monitoring the progress of the
     * update, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks.html">Updating a
     * Stack</a>.
     * </p>
     * 
     * @param updateStackRequest
     *        The input for an <a>UpdateStack</a> action.
     * @return Result of the UpdateStack operation returned by the service.
     * @throws InsufficientCapabilitiesException
     *         The template contains resources with capabilities that weren't specified in the Capabilities parameter.
     * @throws TokenAlreadyExistsException
     *         A client request token already exists.
     * @sample AmazonCloudFormation.UpdateStack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStack" target="_top">AWS API
     *      Documentation</a>
     */
    UpdateStackResult updateStack(UpdateStackRequest updateStackRequest);

    /**
     * <p>
     * Updates the parameter values for stack instances for the specified accounts, within the specified Amazon Web
     * Services Regions. A stack instance refers to a stack in a specific account and Region.
     * </p>
     * <p>
     * You can only update stack instances in Amazon Web Services Regions and accounts where they already exist; to
     * create additional stack instances, use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateStackInstances.html"
     * >CreateStackInstances</a>.
     * </p>
     * <p>
     * During stack set updates, any parameters overridden for a stack instance aren't updated, but retain their
     * overridden value.
     * </p>
     * <p>
     * You can only update the parameter <i>values</i> that are specified in the stack set; to add or delete a parameter
     * itself, use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html">UpdateStackSet
     * </a> to update the stack set template. If you add a parameter to a template, before you can override the
     * parameter value specified in the stack set you must first use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html"
     * >UpdateStackSet</a> to update all stack instances with the updated template and parameter value specified in the
     * stack set. Once a stack instance has been updated with the new parameter, you can then override the parameter
     * value using <code>UpdateStackInstances</code>.
     * </p>
     * 
     * @param updateStackInstancesRequest
     * @return Result of the UpdateStackInstances operation returned by the service.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws StackInstanceNotFoundException
     *         The specified stack instance doesn't exist.
     * @throws OperationInProgressException
     *         Another operation is currently in progress for this stack set. Only one operation can be performed for a
     *         stack set at a given time.
     * @throws OperationIdAlreadyExistsException
     *         The specified operation ID already exists.
     * @throws StaleRequestException
     *         Another operation has been performed on this stack set since the specified operation was performed.
     * @throws InvalidOperationException
     *         The specified operation isn't valid.
     * @sample AmazonCloudFormation.UpdateStackInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStackInstances"
     *      target="_top">AWS API Documentation</a>
     */
    UpdateStackInstancesResult updateStackInstances(UpdateStackInstancesRequest updateStackInstancesRequest);

    /**
     * <p>
     * Updates the stack set, and associated stack instances in the specified accounts and Amazon Web Services Regions.
     * </p>
     * <p>
     * Even if the stack set operation created by updating the stack set fails (completely or partially, below or above
     * a specified failure tolerance), the stack set is updated with your changes. Subsequent
     * <a>CreateStackInstances</a> calls on the specified stack set use the updated stack set.
     * </p>
     * 
     * @param updateStackSetRequest
     * @return Result of the UpdateStackSet operation returned by the service.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws OperationInProgressException
     *         Another operation is currently in progress for this stack set. Only one operation can be performed for a
     *         stack set at a given time.
     * @throws OperationIdAlreadyExistsException
     *         The specified operation ID already exists.
     * @throws StaleRequestException
     *         Another operation has been performed on this stack set since the specified operation was performed.
     * @throws InvalidOperationException
     *         The specified operation isn't valid.
     * @throws StackInstanceNotFoundException
     *         The specified stack instance doesn't exist.
     * @sample AmazonCloudFormation.UpdateStackSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStackSet" target="_top">AWS
     *      API Documentation</a>
     */
    UpdateStackSetResult updateStackSet(UpdateStackSetRequest updateStackSetRequest);

    /**
     * <p>
     * Updates termination protection for the specified stack. If a user attempts to delete a stack with termination
     * protection enabled, the operation fails and the stack remains unchanged. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html">Protecting a
     * Stack From Being Deleted</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * <p>
     * For <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">nested
     * stacks</a>, termination protection is set on the root stack and can't be changed directly on the nested stack.
     * </p>
     * 
     * @param updateTerminationProtectionRequest
     * @return Result of the UpdateTerminationProtection operation returned by the service.
     * @sample AmazonCloudFormation.UpdateTerminationProtection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateTerminationProtection"
     *      target="_top">AWS API Documentation</a>
     */
    UpdateTerminationProtectionResult updateTerminationProtection(UpdateTerminationProtectionRequest updateTerminationProtectionRequest);

    /**
     * <p>
     * Validates a specified template. CloudFormation first checks if the template is valid JSON. If it isn't,
     * CloudFormation checks if the template is valid YAML. If both these checks fail, CloudFormation returns a template
     * validation error.
     * </p>
     * 
     * @param validateTemplateRequest
     *        The input for <a>ValidateTemplate</a> action.
     * @return Result of the ValidateTemplate operation returned by the service.
     * @sample AmazonCloudFormation.ValidateTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ValidateTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    ValidateTemplateResult validateTemplate(ValidateTemplateRequest validateTemplateRequest);

    /**
     * Shuts down this client object, releasing any resources that might be held open. This is an optional method, and
     * callers are not expected to call it, but can if they want to explicitly release any open resources. Once a client
     * has been shutdown, it should not be used to make any more requests.
     */
    void shutdown();

    /**
     * Returns additional metadata for a previously executed successful request, typically used for debugging issues
     * where a service isn't acting as expected. This data isn't considered part of the result data returned by an
     * operation, so it's available through this separate, diagnostic interface.
     * <p>
     * Response metadata is only cached for a limited period of time, so if you need to access this extra diagnostic
     * information for an executed request, you should use this method to retrieve it as soon as possible after
     * executing a request.
     *
     * @param request
     *        The originally executed request.
     *
     * @return The response metadata for the specified request, or null if none is available.
     */
    ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request);

    AmazonCloudFormationWaiters waiters();

}
