/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.cloudformation.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStackSet" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CreateStackSetRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The name to associate with the stack set. The name must be unique in the Region where you create your stack set.
     * </p>
     * <note>
     * <p>
     * A stack name can contain only alphanumeric characters (case-sensitive) and hyphens. It must start with an
     * alphabetic character and can't be longer than 128 characters.
     * </p>
     * </note>
     */
    private String stackSetName;
    /**
     * <p>
     * A description of the stack set. You can use the description to identify the stack set's purpose or other
     * important information.
     * </p>
     */
    private String description;
    /**
     * <p>
     * The structure that contains the template body, with a minimum length of 1 byte and a maximum length of 51,200
     * bytes. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
     * in the <i>CloudFormation User Guide</i>.
     * </p>
     * <p>
     * Conditional: You must specify either the TemplateBody or the TemplateURL parameter, but not both.
     * </p>
     */
    private String templateBody;
    /**
     * <p>
     * The location of the file that contains the template body. The URL must point to a template (maximum size: 460,800
     * bytes) that's located in an Amazon S3 bucket or a Systems Manager document. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
     * in the <i>CloudFormation User Guide</i>.
     * </p>
     * <p>
     * Conditional: You must specify either the TemplateBody or the TemplateURL parameter, but not both.
     * </p>
     */
    private String templateURL;
    /**
     * <p>
     * The stack ID you are importing into a new stack set. Specify the Amazon Resource Name (ARN) of the stack.
     * </p>
     */
    private String stackId;
    /**
     * <p>
     * The input parameters for the stack set template.
     * </p>
     */
    private com.amazonaws.internal.SdkInternalList<Parameter> parameters;
    /**
     * <p>
     * In some cases, you must explicitly acknowledge that your stack set template contains certain capabilities in
     * order for CloudFormation to create the stack set and related stack instances.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
     * </p>
     * <p>
     * Some stack templates might include resources that can affect permissions in your Amazon Web Services account; for
     * example, by creating new Identity and Access Management (IAM) users. For those stack sets, you must explicitly
     * acknowledge this by specifying one of these capabilities.
     * </p>
     * <p>
     * The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
     * <code>CAPABILITY_NAMED_IAM</code> capability.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you have IAM resources, you can specify either capability.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you don't specify either of these capabilities, CloudFormation returns an
     * <code>InsufficientCapabilities</code> error.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If your stack template contains these resources, we recommend that you review all permissions associated with
     * them and edit their permissions if necessary.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
     * <code>AWS::IAM::AccessKey</code> </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
     * <code>AWS::IAM::Group</code> </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
     * <code>AWS::IAM::InstanceProfile</code> </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
     * <code>AWS::IAM::Policy</code> </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
     * <code>AWS::IAM::Role</code> </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
     * <code>AWS::IAM::User</code> </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
     * <code>AWS::IAM::UserToGroupAddition</code> </a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
     * >Acknowledging IAM Resources in CloudFormation Templates</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CAPABILITY_AUTO_EXPAND</code>
     * </p>
     * <p>
     * Some templates reference macros. If your stack set template references one or more macros, you must create the
     * stack set directly from the processed template, without first reviewing the resulting changes in a change set. To
     * create the stack set directly, you must acknowledge this capability. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using CloudFormation
     * Macros to Perform Custom Processing on Templates</a>.
     * </p>
     * <important>
     * <p>
     * Stack sets with service-managed permissions don't currently support the use of macros in templates. (This
     * includes the <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
     * > <code>AWS::Include</code> </a> and <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html">
     * <code>AWS::Serverless</code> </a> transforms, which are macros hosted by CloudFormation.) Even if you specify
     * this capability for a stack set with service-managed permissions, if you reference a macro in your template the
     * stack set operation will fail.
     * </p>
     * </important></li>
     * </ul>
     */
    private com.amazonaws.internal.SdkInternalList<String> capabilities;
    /**
     * <p>
     * The key-value pairs to associate with this stack set and the stacks created from it. CloudFormation also
     * propagates these tags to supported resources that are created in the stacks. A maximum number of 50 tags can be
     * specified.
     * </p>
     * <p>
     * If you specify tags as part of a <code>CreateStackSet</code> action, CloudFormation checks to see if you have the
     * required IAM permission to tag resources. If you don't, the entire <code>CreateStackSet</code> action fails with
     * an <code>access denied</code> error, and the stack set is not created.
     * </p>
     */
    private com.amazonaws.internal.SdkInternalList<Tag> tags;
    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role to use to create this stack set.
     * </p>
     * <p>
     * Specify an IAM role only if you are using customized administrator roles to control which users or groups can
     * manage specific stack sets within the same administrator account. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html">Prerequisites:
     * Granting Permissions for Stack Set Operations</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     */
    private String administrationRoleARN;
    /**
     * <p>
     * The name of the IAM execution role to use to create the stack set. If you do not specify an execution role,
     * CloudFormation uses the <code>AWSCloudFormationStackSetExecutionRole</code> role for the stack set operation.
     * </p>
     * <p>
     * Specify an IAM role only if you are using customized execution roles to control which stack resources users and
     * groups can include in their stack sets.
     * </p>
     */
    private String executionRoleName;
    /**
     * <p>
     * Describes how the IAM roles required for stack set operations are created. By default, <code>SELF-MANAGED</code>
     * is specified.
     * </p>
     * <ul>
     * <li>
     * <p>
     * With <code>self-managed</code> permissions, you must create the administrator and execution roles required to
     * deploy to target accounts. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html">Grant
     * Self-Managed Stack Set Permissions</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * With <code>service-managed</code> permissions, StackSets automatically creates the IAM roles required to deploy
     * to accounts managed by Organizations. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html"
     * >Grant Service-Managed Stack Set Permissions</a>.
     * </p>
     * </li>
     * </ul>
     */
    private String permissionModel;
    /**
     * <p>
     * Describes whether StackSets automatically deploys to Organizations accounts that are added to the target
     * organization or organizational unit (OU). Specify only if <code>PermissionModel</code> is
     * <code>SERVICE_MANAGED</code>.
     * </p>
     */
    private AutoDeployment autoDeployment;
    /**
     * <p>
     * [Service-managed permissions] Specifies whether you are acting as an account administrator in the organization's
     * management account or as a delegated administrator in a member account.
     * </p>
     * <p>
     * By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed permissions.
     * </p>
     * <ul>
     * <li>
     * <p>
     * To create a stack set with service-managed permissions while signed in to the management account, specify
     * <code>SELF</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To create a stack set with service-managed permissions while signed in to a delegated administrator account,
     * specify <code>DELEGATED_ADMIN</code>.
     * </p>
     * <p>
     * Your Amazon Web Services account must be registered as a delegated admin in the management account. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html"
     * >Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Stack sets with service-managed permissions are created in the management account, including stack sets that are
     * created by delegated administrators.
     * </p>
     */
    private String callAs;
    /**
     * <p>
     * A unique identifier for this <code>CreateStackSet</code> request. Specify this token if you plan to retry
     * requests so that CloudFormation knows that you're not attempting to create another stack set with the same name.
     * You might retry <code>CreateStackSet</code> requests to ensure that CloudFormation successfully received them.
     * </p>
     * <p>
     * If you don't specify an operation ID, the SDK generates one automatically.
     * </p>
     */
    private String clientRequestToken;
    /**
     * <p>
     * Describes whether StackSets performs non-conflicting operations concurrently and queues conflicting operations.
     * </p>
     */
    private ManagedExecution managedExecution;

    /**
     * <p>
     * The name to associate with the stack set. The name must be unique in the Region where you create your stack set.
     * </p>
     * <note>
     * <p>
     * A stack name can contain only alphanumeric characters (case-sensitive) and hyphens. It must start with an
     * alphabetic character and can't be longer than 128 characters.
     * </p>
     * </note>
     * 
     * @param stackSetName
     *        The name to associate with the stack set. The name must be unique in the Region where you create your
     *        stack set.</p> <note>
     *        <p>
     *        A stack name can contain only alphanumeric characters (case-sensitive) and hyphens. It must start with an
     *        alphabetic character and can't be longer than 128 characters.
     *        </p>
     */

    public void setStackSetName(String stackSetName) {
        this.stackSetName = stackSetName;
    }

    /**
     * <p>
     * The name to associate with the stack set. The name must be unique in the Region where you create your stack set.
     * </p>
     * <note>
     * <p>
     * A stack name can contain only alphanumeric characters (case-sensitive) and hyphens. It must start with an
     * alphabetic character and can't be longer than 128 characters.
     * </p>
     * </note>
     * 
     * @return The name to associate with the stack set. The name must be unique in the Region where you create your
     *         stack set.</p> <note>
     *         <p>
     *         A stack name can contain only alphanumeric characters (case-sensitive) and hyphens. It must start with an
     *         alphabetic character and can't be longer than 128 characters.
     *         </p>
     */

    public String getStackSetName() {
        return this.stackSetName;
    }

    /**
     * <p>
     * The name to associate with the stack set. The name must be unique in the Region where you create your stack set.
     * </p>
     * <note>
     * <p>
     * A stack name can contain only alphanumeric characters (case-sensitive) and hyphens. It must start with an
     * alphabetic character and can't be longer than 128 characters.
     * </p>
     * </note>
     * 
     * @param stackSetName
     *        The name to associate with the stack set. The name must be unique in the Region where you create your
     *        stack set.</p> <note>
     *        <p>
     *        A stack name can contain only alphanumeric characters (case-sensitive) and hyphens. It must start with an
     *        alphabetic character and can't be longer than 128 characters.
     *        </p>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateStackSetRequest withStackSetName(String stackSetName) {
        setStackSetName(stackSetName);
        return this;
    }

    /**
     * <p>
     * A description of the stack set. You can use the description to identify the stack set's purpose or other
     * important information.
     * </p>
     * 
     * @param description
     *        A description of the stack set. You can use the description to identify the stack set's purpose or other
     *        important information.
     */

    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * <p>
     * A description of the stack set. You can use the description to identify the stack set's purpose or other
     * important information.
     * </p>
     * 
     * @return A description of the stack set. You can use the description to identify the stack set's purpose or other
     *         important information.
     */

    public String getDescription() {
        return this.description;
    }

    /**
     * <p>
     * A description of the stack set. You can use the description to identify the stack set's purpose or other
     * important information.
     * </p>
     * 
     * @param description
     *        A description of the stack set. You can use the description to identify the stack set's purpose or other
     *        important information.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateStackSetRequest withDescription(String description) {
        setDescription(description);
        return this;
    }

    /**
     * <p>
     * The structure that contains the template body, with a minimum length of 1 byte and a maximum length of 51,200
     * bytes. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
     * in the <i>CloudFormation User Guide</i>.
     * </p>
     * <p>
     * Conditional: You must specify either the TemplateBody or the TemplateURL parameter, but not both.
     * </p>
     * 
     * @param templateBody
     *        The structure that contains the template body, with a minimum length of 1 byte and a maximum length of
     *        51,200 bytes. For more information, see <a
     *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
     *        Anatomy</a> in the <i>CloudFormation User Guide</i>.</p>
     *        <p>
     *        Conditional: You must specify either the TemplateBody or the TemplateURL parameter, but not both.
     */

    public void setTemplateBody(String templateBody) {
        this.templateBody = templateBody;
    }

    /**
     * <p>
     * The structure that contains the template body, with a minimum length of 1 byte and a maximum length of 51,200
     * bytes. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
     * in the <i>CloudFormation User Guide</i>.
     * </p>
     * <p>
     * Conditional: You must specify either the TemplateBody or the TemplateURL parameter, but not both.
     * </p>
     * 
     * @return The structure that contains the template body, with a minimum length of 1 byte and a maximum length of
     *         51,200 bytes. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
     *         Anatomy</a> in the <i>CloudFormation User Guide</i>.</p>
     *         <p>
     *         Conditional: You must specify either the TemplateBody or the TemplateURL parameter, but not both.
     */

    public String getTemplateBody() {
        return this.templateBody;
    }

    /**
     * <p>
     * The structure that contains the template body, with a minimum length of 1 byte and a maximum length of 51,200
     * bytes. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
     * in the <i>CloudFormation User Guide</i>.
     * </p>
     * <p>
     * Conditional: You must specify either the TemplateBody or the TemplateURL parameter, but not both.
     * </p>
     * 
     * @param templateBody
     *        The structure that contains the template body, with a minimum length of 1 byte and a maximum length of
     *        51,200 bytes. For more information, see <a
     *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
     *        Anatomy</a> in the <i>CloudFormation User Guide</i>.</p>
     *        <p>
     *        Conditional: You must specify either the TemplateBody or the TemplateURL parameter, but not both.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateStackSetRequest withTemplateBody(String templateBody) {
        setTemplateBody(templateBody);
        return this;
    }

    /**
     * <p>
     * The location of the file that contains the template body. The URL must point to a template (maximum size: 460,800
     * bytes) that's located in an Amazon S3 bucket or a Systems Manager document. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
     * in the <i>CloudFormation User Guide</i>.
     * </p>
     * <p>
     * Conditional: You must specify either the TemplateBody or the TemplateURL parameter, but not both.
     * </p>
     * 
     * @param templateURL
     *        The location of the file that contains the template body. The URL must point to a template (maximum size:
     *        460,800 bytes) that's located in an Amazon S3 bucket or a Systems Manager document. For more information,
     *        see <a
     *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
     *        Anatomy</a> in the <i>CloudFormation User Guide</i>.</p>
     *        <p>
     *        Conditional: You must specify either the TemplateBody or the TemplateURL parameter, but not both.
     */

    public void setTemplateURL(String templateURL) {
        this.templateURL = templateURL;
    }

    /**
     * <p>
     * The location of the file that contains the template body. The URL must point to a template (maximum size: 460,800
     * bytes) that's located in an Amazon S3 bucket or a Systems Manager document. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
     * in the <i>CloudFormation User Guide</i>.
     * </p>
     * <p>
     * Conditional: You must specify either the TemplateBody or the TemplateURL parameter, but not both.
     * </p>
     * 
     * @return The location of the file that contains the template body. The URL must point to a template (maximum size:
     *         460,800 bytes) that's located in an Amazon S3 bucket or a Systems Manager document. For more information,
     *         see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
     *         Anatomy</a> in the <i>CloudFormation User Guide</i>.</p>
     *         <p>
     *         Conditional: You must specify either the TemplateBody or the TemplateURL parameter, but not both.
     */

    public String getTemplateURL() {
        return this.templateURL;
    }

    /**
     * <p>
     * The location of the file that contains the template body. The URL must point to a template (maximum size: 460,800
     * bytes) that's located in an Amazon S3 bucket or a Systems Manager document. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
     * in the <i>CloudFormation User Guide</i>.
     * </p>
     * <p>
     * Conditional: You must specify either the TemplateBody or the TemplateURL parameter, but not both.
     * </p>
     * 
     * @param templateURL
     *        The location of the file that contains the template body. The URL must point to a template (maximum size:
     *        460,800 bytes) that's located in an Amazon S3 bucket or a Systems Manager document. For more information,
     *        see <a
     *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
     *        Anatomy</a> in the <i>CloudFormation User Guide</i>.</p>
     *        <p>
     *        Conditional: You must specify either the TemplateBody or the TemplateURL parameter, but not both.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateStackSetRequest withTemplateURL(String templateURL) {
        setTemplateURL(templateURL);
        return this;
    }

    /**
     * <p>
     * The stack ID you are importing into a new stack set. Specify the Amazon Resource Name (ARN) of the stack.
     * </p>
     * 
     * @param stackId
     *        The stack ID you are importing into a new stack set. Specify the Amazon Resource Name (ARN) of the stack.
     */

    public void setStackId(String stackId) {
        this.stackId = stackId;
    }

    /**
     * <p>
     * The stack ID you are importing into a new stack set. Specify the Amazon Resource Name (ARN) of the stack.
     * </p>
     * 
     * @return The stack ID you are importing into a new stack set. Specify the Amazon Resource Name (ARN) of the stack.
     */

    public String getStackId() {
        return this.stackId;
    }

    /**
     * <p>
     * The stack ID you are importing into a new stack set. Specify the Amazon Resource Name (ARN) of the stack.
     * </p>
     * 
     * @param stackId
     *        The stack ID you are importing into a new stack set. Specify the Amazon Resource Name (ARN) of the stack.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateStackSetRequest withStackId(String stackId) {
        setStackId(stackId);
        return this;
    }

    /**
     * <p>
     * The input parameters for the stack set template.
     * </p>
     * 
     * @return The input parameters for the stack set template.
     */

    public java.util.List<Parameter> getParameters() {
        if (parameters == null) {
            parameters = new com.amazonaws.internal.SdkInternalList<Parameter>();
        }
        return parameters;
    }

    /**
     * <p>
     * The input parameters for the stack set template.
     * </p>
     * 
     * @param parameters
     *        The input parameters for the stack set template.
     */

    public void setParameters(java.util.Collection<Parameter> parameters) {
        if (parameters == null) {
            this.parameters = null;
            return;
        }

        this.parameters = new com.amazonaws.internal.SdkInternalList<Parameter>(parameters);
    }

    /**
     * <p>
     * The input parameters for the stack set template.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setParameters(java.util.Collection)} or {@link #withParameters(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param parameters
     *        The input parameters for the stack set template.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateStackSetRequest withParameters(Parameter... parameters) {
        if (this.parameters == null) {
            setParameters(new com.amazonaws.internal.SdkInternalList<Parameter>(parameters.length));
        }
        for (Parameter ele : parameters) {
            this.parameters.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The input parameters for the stack set template.
     * </p>
     * 
     * @param parameters
     *        The input parameters for the stack set template.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateStackSetRequest withParameters(java.util.Collection<Parameter> parameters) {
        setParameters(parameters);
        return this;
    }

    /**
     * <p>
     * In some cases, you must explicitly acknowledge that your stack set template contains certain capabilities in
     * order for CloudFormation to create the stack set and related stack instances.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
     * </p>
     * <p>
     * Some stack templates might include resources that can affect permissions in your Amazon Web Services account; for
     * example, by creating new Identity and Access Management (IAM) users. For those stack sets, you must explicitly
     * acknowledge this by specifying one of these capabilities.
     * </p>
     * <p>
     * The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
     * <code>CAPABILITY_NAMED_IAM</code> capability.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you have IAM resources, you can specify either capability.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you don't specify either of these capabilities, CloudFormation returns an
     * <code>InsufficientCapabilities</code> error.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If your stack template contains these resources, we recommend that you review all permissions associated with
     * them and edit their permissions if necessary.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
     * <code>AWS::IAM::AccessKey</code> </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
     * <code>AWS::IAM::Group</code> </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
     * <code>AWS::IAM::InstanceProfile</code> </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
     * <code>AWS::IAM::Policy</code> </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
     * <code>AWS::IAM::Role</code> </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
     * <code>AWS::IAM::User</code> </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
     * <code>AWS::IAM::UserToGroupAddition</code> </a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
     * >Acknowledging IAM Resources in CloudFormation Templates</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CAPABILITY_AUTO_EXPAND</code>
     * </p>
     * <p>
     * Some templates reference macros. If your stack set template references one or more macros, you must create the
     * stack set directly from the processed template, without first reviewing the resulting changes in a change set. To
     * create the stack set directly, you must acknowledge this capability. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using CloudFormation
     * Macros to Perform Custom Processing on Templates</a>.
     * </p>
     * <important>
     * <p>
     * Stack sets with service-managed permissions don't currently support the use of macros in templates. (This
     * includes the <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
     * > <code>AWS::Include</code> </a> and <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html">
     * <code>AWS::Serverless</code> </a> transforms, which are macros hosted by CloudFormation.) Even if you specify
     * this capability for a stack set with service-managed permissions, if you reference a macro in your template the
     * stack set operation will fail.
     * </p>
     * </important></li>
     * </ul>
     * 
     * @return In some cases, you must explicitly acknowledge that your stack set template contains certain capabilities
     *         in order for CloudFormation to create the stack set and related stack instances.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
     *         </p>
     *         <p>
     *         Some stack templates might include resources that can affect permissions in your Amazon Web Services
     *         account; for example, by creating new Identity and Access Management (IAM) users. For those stack sets,
     *         you must explicitly acknowledge this by specifying one of these capabilities.
     *         </p>
     *         <p>
     *         The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
     *         <code>CAPABILITY_NAMED_IAM</code> capability.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you have IAM resources, you can specify either capability.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you don't specify either of these capabilities, CloudFormation returns an
     *         <code>InsufficientCapabilities</code> error.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If your stack template contains these resources, we recommend that you review all permissions associated
     *         with them and edit their permissions if necessary.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
     *         <code>AWS::IAM::AccessKey</code> </a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
     *         <code>AWS::IAM::Group</code> </a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
     *         <code>AWS::IAM::InstanceProfile</code> </a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
     *         <code>AWS::IAM::Policy</code> </a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
     *         <code>AWS::IAM::Role</code> </a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
     *         <code>AWS::IAM::User</code> </a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
     *         <code>AWS::IAM::UserToGroupAddition</code> </a>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
     *         >Acknowledging IAM Resources in CloudFormation Templates</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CAPABILITY_AUTO_EXPAND</code>
     *         </p>
     *         <p>
     *         Some templates reference macros. If your stack set template references one or more macros, you must
     *         create the stack set directly from the processed template, without first reviewing the resulting changes
     *         in a change set. To create the stack set directly, you must acknowledge this capability. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using
     *         CloudFormation Macros to Perform Custom Processing on Templates</a>.
     *         </p>
     *         <important>
     *         <p>
     *         Stack sets with service-managed permissions don't currently support the use of macros in templates. (This
     *         includes the <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
     *         > <code>AWS::Include</code> </a> and <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html">
     *         <code>AWS::Serverless</code> </a> transforms, which are macros hosted by CloudFormation.) Even if you
     *         specify this capability for a stack set with service-managed permissions, if you reference a macro in
     *         your template the stack set operation will fail.
     *         </p>
     *         </important></li>
     * @see Capability
     */

    public java.util.List<String> getCapabilities() {
        if (capabilities == null) {
            capabilities = new com.amazonaws.internal.SdkInternalList<String>();
        }
        return capabilities;
    }

    /**
     * <p>
     * In some cases, you must explicitly acknowledge that your stack set template contains certain capabilities in
     * order for CloudFormation to create the stack set and related stack instances.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
     * </p>
     * <p>
     * Some stack templates might include resources that can affect permissions in your Amazon Web Services account; for
     * example, by creating new Identity and Access Management (IAM) users. For those stack sets, you must explicitly
     * acknowledge this by specifying one of these capabilities.
     * </p>
     * <p>
     * The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
     * <code>CAPABILITY_NAMED_IAM</code> capability.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you have IAM resources, you can specify either capability.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you don't specify either of these capabilities, CloudFormation returns an
     * <code>InsufficientCapabilities</code> error.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If your stack template contains these resources, we recommend that you review all permissions associated with
     * them and edit their permissions if necessary.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
     * <code>AWS::IAM::AccessKey</code> </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
     * <code>AWS::IAM::Group</code> </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
     * <code>AWS::IAM::InstanceProfile</code> </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
     * <code>AWS::IAM::Policy</code> </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
     * <code>AWS::IAM::Role</code> </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
     * <code>AWS::IAM::User</code> </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
     * <code>AWS::IAM::UserToGroupAddition</code> </a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
     * >Acknowledging IAM Resources in CloudFormation Templates</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CAPABILITY_AUTO_EXPAND</code>
     * </p>
     * <p>
     * Some templates reference macros. If your stack set template references one or more macros, you must create the
     * stack set directly from the processed template, without first reviewing the resulting changes in a change set. To
     * create the stack set directly, you must acknowledge this capability. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using CloudFormation
     * Macros to Perform Custom Processing on Templates</a>.
     * </p>
     * <important>
     * <p>
     * Stack sets with service-managed permissions don't currently support the use of macros in templates. (This
     * includes the <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
     * > <code>AWS::Include</code> </a> and <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html">
     * <code>AWS::Serverless</code> </a> transforms, which are macros hosted by CloudFormation.) Even if you specify
     * this capability for a stack set with service-managed permissions, if you reference a macro in your template the
     * stack set operation will fail.
     * </p>
     * </important></li>
     * </ul>
     * 
     * @param capabilities
     *        In some cases, you must explicitly acknowledge that your stack set template contains certain capabilities
     *        in order for CloudFormation to create the stack set and related stack instances.</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
     *        </p>
     *        <p>
     *        Some stack templates might include resources that can affect permissions in your Amazon Web Services
     *        account; for example, by creating new Identity and Access Management (IAM) users. For those stack sets,
     *        you must explicitly acknowledge this by specifying one of these capabilities.
     *        </p>
     *        <p>
     *        The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
     *        <code>CAPABILITY_NAMED_IAM</code> capability.
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        If you have IAM resources, you can specify either capability.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        If you don't specify either of these capabilities, CloudFormation returns an
     *        <code>InsufficientCapabilities</code> error.
     *        </p>
     *        </li>
     *        </ul>
     *        <p>
     *        If your stack template contains these resources, we recommend that you review all permissions associated
     *        with them and edit their permissions if necessary.
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <a
     *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
     *        <code>AWS::IAM::AccessKey</code> </a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
     *        <code>AWS::IAM::Group</code> </a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a href=
     *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
     *        <code>AWS::IAM::InstanceProfile</code> </a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
     *        <code>AWS::IAM::Policy</code> </a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
     *        <code>AWS::IAM::Role</code> </a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
     *        <code>AWS::IAM::User</code> </a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a href=
     *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
     *        <code>AWS::IAM::UserToGroupAddition</code> </a>
     *        </p>
     *        </li>
     *        </ul>
     *        <p>
     *        For more information, see <a href=
     *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
     *        >Acknowledging IAM Resources in CloudFormation Templates</a>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>CAPABILITY_AUTO_EXPAND</code>
     *        </p>
     *        <p>
     *        Some templates reference macros. If your stack set template references one or more macros, you must create
     *        the stack set directly from the processed template, without first reviewing the resulting changes in a
     *        change set. To create the stack set directly, you must acknowledge this capability. For more information,
     *        see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using
     *        CloudFormation Macros to Perform Custom Processing on Templates</a>.
     *        </p>
     *        <important>
     *        <p>
     *        Stack sets with service-managed permissions don't currently support the use of macros in templates. (This
     *        includes the <a href=
     *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
     *        > <code>AWS::Include</code> </a> and <a
     *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html">
     *        <code>AWS::Serverless</code> </a> transforms, which are macros hosted by CloudFormation.) Even if you
     *        specify this capability for a stack set with service-managed permissions, if you reference a macro in your
     *        template the stack set operation will fail.
     *        </p>
     *        </important></li>
     * @see Capability
     */

    public void setCapabilities(java.util.Collection<String> capabilities) {
        if (capabilities == null) {
            this.capabilities = null;
            return;
        }

        this.capabilities = new com.amazonaws.internal.SdkInternalList<String>(capabilities);
    }

    /**
     * <p>
     * In some cases, you must explicitly acknowledge that your stack set template contains certain capabilities in
     * order for CloudFormation to create the stack set and related stack instances.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
     * </p>
     * <p>
     * Some stack templates might include resources that can affect permissions in your Amazon Web Services account; for
     * example, by creating new Identity and Access Management (IAM) users. For those stack sets, you must explicitly
     * acknowledge this by specifying one of these capabilities.
     * </p>
     * <p>
     * The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
     * <code>CAPABILITY_NAMED_IAM</code> capability.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you have IAM resources, you can specify either capability.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you don't specify either of these capabilities, CloudFormation returns an
     * <code>InsufficientCapabilities</code> error.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If your stack template contains these resources, we recommend that you review all permissions associated with
     * them and edit their permissions if necessary.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
     * <code>AWS::IAM::AccessKey</code> </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
     * <code>AWS::IAM::Group</code> </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
     * <code>AWS::IAM::InstanceProfile</code> </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
     * <code>AWS::IAM::Policy</code> </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
     * <code>AWS::IAM::Role</code> </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
     * <code>AWS::IAM::User</code> </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
     * <code>AWS::IAM::UserToGroupAddition</code> </a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
     * >Acknowledging IAM Resources in CloudFormation Templates</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CAPABILITY_AUTO_EXPAND</code>
     * </p>
     * <p>
     * Some templates reference macros. If your stack set template references one or more macros, you must create the
     * stack set directly from the processed template, without first reviewing the resulting changes in a change set. To
     * create the stack set directly, you must acknowledge this capability. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using CloudFormation
     * Macros to Perform Custom Processing on Templates</a>.
     * </p>
     * <important>
     * <p>
     * Stack sets with service-managed permissions don't currently support the use of macros in templates. (This
     * includes the <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
     * > <code>AWS::Include</code> </a> and <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html">
     * <code>AWS::Serverless</code> </a> transforms, which are macros hosted by CloudFormation.) Even if you specify
     * this capability for a stack set with service-managed permissions, if you reference a macro in your template the
     * stack set operation will fail.
     * </p>
     * </important></li>
     * </ul>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setCapabilities(java.util.Collection)} or {@link #withCapabilities(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param capabilities
     *        In some cases, you must explicitly acknowledge that your stack set template contains certain capabilities
     *        in order for CloudFormation to create the stack set and related stack instances.</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
     *        </p>
     *        <p>
     *        Some stack templates might include resources that can affect permissions in your Amazon Web Services
     *        account; for example, by creating new Identity and Access Management (IAM) users. For those stack sets,
     *        you must explicitly acknowledge this by specifying one of these capabilities.
     *        </p>
     *        <p>
     *        The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
     *        <code>CAPABILITY_NAMED_IAM</code> capability.
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        If you have IAM resources, you can specify either capability.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        If you don't specify either of these capabilities, CloudFormation returns an
     *        <code>InsufficientCapabilities</code> error.
     *        </p>
     *        </li>
     *        </ul>
     *        <p>
     *        If your stack template contains these resources, we recommend that you review all permissions associated
     *        with them and edit their permissions if necessary.
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <a
     *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
     *        <code>AWS::IAM::AccessKey</code> </a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
     *        <code>AWS::IAM::Group</code> </a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a href=
     *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
     *        <code>AWS::IAM::InstanceProfile</code> </a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
     *        <code>AWS::IAM::Policy</code> </a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
     *        <code>AWS::IAM::Role</code> </a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
     *        <code>AWS::IAM::User</code> </a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a href=
     *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
     *        <code>AWS::IAM::UserToGroupAddition</code> </a>
     *        </p>
     *        </li>
     *        </ul>
     *        <p>
     *        For more information, see <a href=
     *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
     *        >Acknowledging IAM Resources in CloudFormation Templates</a>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>CAPABILITY_AUTO_EXPAND</code>
     *        </p>
     *        <p>
     *        Some templates reference macros. If your stack set template references one or more macros, you must create
     *        the stack set directly from the processed template, without first reviewing the resulting changes in a
     *        change set. To create the stack set directly, you must acknowledge this capability. For more information,
     *        see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using
     *        CloudFormation Macros to Perform Custom Processing on Templates</a>.
     *        </p>
     *        <important>
     *        <p>
     *        Stack sets with service-managed permissions don't currently support the use of macros in templates. (This
     *        includes the <a href=
     *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
     *        > <code>AWS::Include</code> </a> and <a
     *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html">
     *        <code>AWS::Serverless</code> </a> transforms, which are macros hosted by CloudFormation.) Even if you
     *        specify this capability for a stack set with service-managed permissions, if you reference a macro in your
     *        template the stack set operation will fail.
     *        </p>
     *        </important></li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see Capability
     */

    public CreateStackSetRequest withCapabilities(String... capabilities) {
        if (this.capabilities == null) {
            setCapabilities(new com.amazonaws.internal.SdkInternalList<String>(capabilities.length));
        }
        for (String ele : capabilities) {
            this.capabilities.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * In some cases, you must explicitly acknowledge that your stack set template contains certain capabilities in
     * order for CloudFormation to create the stack set and related stack instances.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
     * </p>
     * <p>
     * Some stack templates might include resources that can affect permissions in your Amazon Web Services account; for
     * example, by creating new Identity and Access Management (IAM) users. For those stack sets, you must explicitly
     * acknowledge this by specifying one of these capabilities.
     * </p>
     * <p>
     * The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
     * <code>CAPABILITY_NAMED_IAM</code> capability.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you have IAM resources, you can specify either capability.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you don't specify either of these capabilities, CloudFormation returns an
     * <code>InsufficientCapabilities</code> error.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If your stack template contains these resources, we recommend that you review all permissions associated with
     * them and edit their permissions if necessary.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
     * <code>AWS::IAM::AccessKey</code> </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
     * <code>AWS::IAM::Group</code> </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
     * <code>AWS::IAM::InstanceProfile</code> </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
     * <code>AWS::IAM::Policy</code> </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
     * <code>AWS::IAM::Role</code> </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
     * <code>AWS::IAM::User</code> </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
     * <code>AWS::IAM::UserToGroupAddition</code> </a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
     * >Acknowledging IAM Resources in CloudFormation Templates</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CAPABILITY_AUTO_EXPAND</code>
     * </p>
     * <p>
     * Some templates reference macros. If your stack set template references one or more macros, you must create the
     * stack set directly from the processed template, without first reviewing the resulting changes in a change set. To
     * create the stack set directly, you must acknowledge this capability. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using CloudFormation
     * Macros to Perform Custom Processing on Templates</a>.
     * </p>
     * <important>
     * <p>
     * Stack sets with service-managed permissions don't currently support the use of macros in templates. (This
     * includes the <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
     * > <code>AWS::Include</code> </a> and <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html">
     * <code>AWS::Serverless</code> </a> transforms, which are macros hosted by CloudFormation.) Even if you specify
     * this capability for a stack set with service-managed permissions, if you reference a macro in your template the
     * stack set operation will fail.
     * </p>
     * </important></li>
     * </ul>
     * 
     * @param capabilities
     *        In some cases, you must explicitly acknowledge that your stack set template contains certain capabilities
     *        in order for CloudFormation to create the stack set and related stack instances.</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
     *        </p>
     *        <p>
     *        Some stack templates might include resources that can affect permissions in your Amazon Web Services
     *        account; for example, by creating new Identity and Access Management (IAM) users. For those stack sets,
     *        you must explicitly acknowledge this by specifying one of these capabilities.
     *        </p>
     *        <p>
     *        The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
     *        <code>CAPABILITY_NAMED_IAM</code> capability.
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        If you have IAM resources, you can specify either capability.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        If you don't specify either of these capabilities, CloudFormation returns an
     *        <code>InsufficientCapabilities</code> error.
     *        </p>
     *        </li>
     *        </ul>
     *        <p>
     *        If your stack template contains these resources, we recommend that you review all permissions associated
     *        with them and edit their permissions if necessary.
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <a
     *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
     *        <code>AWS::IAM::AccessKey</code> </a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
     *        <code>AWS::IAM::Group</code> </a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a href=
     *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
     *        <code>AWS::IAM::InstanceProfile</code> </a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
     *        <code>AWS::IAM::Policy</code> </a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
     *        <code>AWS::IAM::Role</code> </a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
     *        <code>AWS::IAM::User</code> </a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a href=
     *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
     *        <code>AWS::IAM::UserToGroupAddition</code> </a>
     *        </p>
     *        </li>
     *        </ul>
     *        <p>
     *        For more information, see <a href=
     *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
     *        >Acknowledging IAM Resources in CloudFormation Templates</a>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>CAPABILITY_AUTO_EXPAND</code>
     *        </p>
     *        <p>
     *        Some templates reference macros. If your stack set template references one or more macros, you must create
     *        the stack set directly from the processed template, without first reviewing the resulting changes in a
     *        change set. To create the stack set directly, you must acknowledge this capability. For more information,
     *        see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using
     *        CloudFormation Macros to Perform Custom Processing on Templates</a>.
     *        </p>
     *        <important>
     *        <p>
     *        Stack sets with service-managed permissions don't currently support the use of macros in templates. (This
     *        includes the <a href=
     *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
     *        > <code>AWS::Include</code> </a> and <a
     *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html">
     *        <code>AWS::Serverless</code> </a> transforms, which are macros hosted by CloudFormation.) Even if you
     *        specify this capability for a stack set with service-managed permissions, if you reference a macro in your
     *        template the stack set operation will fail.
     *        </p>
     *        </important></li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see Capability
     */

    public CreateStackSetRequest withCapabilities(java.util.Collection<String> capabilities) {
        setCapabilities(capabilities);
        return this;
    }

    /**
     * <p>
     * In some cases, you must explicitly acknowledge that your stack set template contains certain capabilities in
     * order for CloudFormation to create the stack set and related stack instances.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
     * </p>
     * <p>
     * Some stack templates might include resources that can affect permissions in your Amazon Web Services account; for
     * example, by creating new Identity and Access Management (IAM) users. For those stack sets, you must explicitly
     * acknowledge this by specifying one of these capabilities.
     * </p>
     * <p>
     * The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
     * <code>CAPABILITY_NAMED_IAM</code> capability.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you have IAM resources, you can specify either capability.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you don't specify either of these capabilities, CloudFormation returns an
     * <code>InsufficientCapabilities</code> error.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If your stack template contains these resources, we recommend that you review all permissions associated with
     * them and edit their permissions if necessary.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
     * <code>AWS::IAM::AccessKey</code> </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
     * <code>AWS::IAM::Group</code> </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
     * <code>AWS::IAM::InstanceProfile</code> </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
     * <code>AWS::IAM::Policy</code> </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
     * <code>AWS::IAM::Role</code> </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
     * <code>AWS::IAM::User</code> </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
     * <code>AWS::IAM::UserToGroupAddition</code> </a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
     * >Acknowledging IAM Resources in CloudFormation Templates</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CAPABILITY_AUTO_EXPAND</code>
     * </p>
     * <p>
     * Some templates reference macros. If your stack set template references one or more macros, you must create the
     * stack set directly from the processed template, without first reviewing the resulting changes in a change set. To
     * create the stack set directly, you must acknowledge this capability. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using CloudFormation
     * Macros to Perform Custom Processing on Templates</a>.
     * </p>
     * <important>
     * <p>
     * Stack sets with service-managed permissions don't currently support the use of macros in templates. (This
     * includes the <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
     * > <code>AWS::Include</code> </a> and <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html">
     * <code>AWS::Serverless</code> </a> transforms, which are macros hosted by CloudFormation.) Even if you specify
     * this capability for a stack set with service-managed permissions, if you reference a macro in your template the
     * stack set operation will fail.
     * </p>
     * </important></li>
     * </ul>
     * 
     * @param capabilities
     *        In some cases, you must explicitly acknowledge that your stack set template contains certain capabilities
     *        in order for CloudFormation to create the stack set and related stack instances.</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
     *        </p>
     *        <p>
     *        Some stack templates might include resources that can affect permissions in your Amazon Web Services
     *        account; for example, by creating new Identity and Access Management (IAM) users. For those stack sets,
     *        you must explicitly acknowledge this by specifying one of these capabilities.
     *        </p>
     *        <p>
     *        The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
     *        <code>CAPABILITY_NAMED_IAM</code> capability.
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        If you have IAM resources, you can specify either capability.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        If you don't specify either of these capabilities, CloudFormation returns an
     *        <code>InsufficientCapabilities</code> error.
     *        </p>
     *        </li>
     *        </ul>
     *        <p>
     *        If your stack template contains these resources, we recommend that you review all permissions associated
     *        with them and edit their permissions if necessary.
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <a
     *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
     *        <code>AWS::IAM::AccessKey</code> </a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
     *        <code>AWS::IAM::Group</code> </a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a href=
     *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
     *        <code>AWS::IAM::InstanceProfile</code> </a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
     *        <code>AWS::IAM::Policy</code> </a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
     *        <code>AWS::IAM::Role</code> </a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
     *        <code>AWS::IAM::User</code> </a>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <a href=
     *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
     *        <code>AWS::IAM::UserToGroupAddition</code> </a>
     *        </p>
     *        </li>
     *        </ul>
     *        <p>
     *        For more information, see <a href=
     *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
     *        >Acknowledging IAM Resources in CloudFormation Templates</a>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>CAPABILITY_AUTO_EXPAND</code>
     *        </p>
     *        <p>
     *        Some templates reference macros. If your stack set template references one or more macros, you must create
     *        the stack set directly from the processed template, without first reviewing the resulting changes in a
     *        change set. To create the stack set directly, you must acknowledge this capability. For more information,
     *        see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using
     *        CloudFormation Macros to Perform Custom Processing on Templates</a>.
     *        </p>
     *        <important>
     *        <p>
     *        Stack sets with service-managed permissions don't currently support the use of macros in templates. (This
     *        includes the <a href=
     *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
     *        > <code>AWS::Include</code> </a> and <a
     *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html">
     *        <code>AWS::Serverless</code> </a> transforms, which are macros hosted by CloudFormation.) Even if you
     *        specify this capability for a stack set with service-managed permissions, if you reference a macro in your
     *        template the stack set operation will fail.
     *        </p>
     *        </important></li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see Capability
     */

    public CreateStackSetRequest withCapabilities(Capability... capabilities) {
        com.amazonaws.internal.SdkInternalList<String> capabilitiesCopy = new com.amazonaws.internal.SdkInternalList<String>(capabilities.length);
        for (Capability value : capabilities) {
            capabilitiesCopy.add(value.toString());
        }
        if (getCapabilities() == null) {
            setCapabilities(capabilitiesCopy);
        } else {
            getCapabilities().addAll(capabilitiesCopy);
        }
        return this;
    }

    /**
     * <p>
     * The key-value pairs to associate with this stack set and the stacks created from it. CloudFormation also
     * propagates these tags to supported resources that are created in the stacks. A maximum number of 50 tags can be
     * specified.
     * </p>
     * <p>
     * If you specify tags as part of a <code>CreateStackSet</code> action, CloudFormation checks to see if you have the
     * required IAM permission to tag resources. If you don't, the entire <code>CreateStackSet</code> action fails with
     * an <code>access denied</code> error, and the stack set is not created.
     * </p>
     * 
     * @return The key-value pairs to associate with this stack set and the stacks created from it. CloudFormation also
     *         propagates these tags to supported resources that are created in the stacks. A maximum number of 50 tags
     *         can be specified.</p>
     *         <p>
     *         If you specify tags as part of a <code>CreateStackSet</code> action, CloudFormation checks to see if you
     *         have the required IAM permission to tag resources. If you don't, the entire <code>CreateStackSet</code>
     *         action fails with an <code>access denied</code> error, and the stack set is not created.
     */

    public java.util.List<Tag> getTags() {
        if (tags == null) {
            tags = new com.amazonaws.internal.SdkInternalList<Tag>();
        }
        return tags;
    }

    /**
     * <p>
     * The key-value pairs to associate with this stack set and the stacks created from it. CloudFormation also
     * propagates these tags to supported resources that are created in the stacks. A maximum number of 50 tags can be
     * specified.
     * </p>
     * <p>
     * If you specify tags as part of a <code>CreateStackSet</code> action, CloudFormation checks to see if you have the
     * required IAM permission to tag resources. If you don't, the entire <code>CreateStackSet</code> action fails with
     * an <code>access denied</code> error, and the stack set is not created.
     * </p>
     * 
     * @param tags
     *        The key-value pairs to associate with this stack set and the stacks created from it. CloudFormation also
     *        propagates these tags to supported resources that are created in the stacks. A maximum number of 50 tags
     *        can be specified.</p>
     *        <p>
     *        If you specify tags as part of a <code>CreateStackSet</code> action, CloudFormation checks to see if you
     *        have the required IAM permission to tag resources. If you don't, the entire <code>CreateStackSet</code>
     *        action fails with an <code>access denied</code> error, and the stack set is not created.
     */

    public void setTags(java.util.Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }

        this.tags = new com.amazonaws.internal.SdkInternalList<Tag>(tags);
    }

    /**
     * <p>
     * The key-value pairs to associate with this stack set and the stacks created from it. CloudFormation also
     * propagates these tags to supported resources that are created in the stacks. A maximum number of 50 tags can be
     * specified.
     * </p>
     * <p>
     * If you specify tags as part of a <code>CreateStackSet</code> action, CloudFormation checks to see if you have the
     * required IAM permission to tag resources. If you don't, the entire <code>CreateStackSet</code> action fails with
     * an <code>access denied</code> error, and the stack set is not created.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setTags(java.util.Collection)} or {@link #withTags(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param tags
     *        The key-value pairs to associate with this stack set and the stacks created from it. CloudFormation also
     *        propagates these tags to supported resources that are created in the stacks. A maximum number of 50 tags
     *        can be specified.</p>
     *        <p>
     *        If you specify tags as part of a <code>CreateStackSet</code> action, CloudFormation checks to see if you
     *        have the required IAM permission to tag resources. If you don't, the entire <code>CreateStackSet</code>
     *        action fails with an <code>access denied</code> error, and the stack set is not created.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateStackSetRequest withTags(Tag... tags) {
        if (this.tags == null) {
            setTags(new com.amazonaws.internal.SdkInternalList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The key-value pairs to associate with this stack set and the stacks created from it. CloudFormation also
     * propagates these tags to supported resources that are created in the stacks. A maximum number of 50 tags can be
     * specified.
     * </p>
     * <p>
     * If you specify tags as part of a <code>CreateStackSet</code> action, CloudFormation checks to see if you have the
     * required IAM permission to tag resources. If you don't, the entire <code>CreateStackSet</code> action fails with
     * an <code>access denied</code> error, and the stack set is not created.
     * </p>
     * 
     * @param tags
     *        The key-value pairs to associate with this stack set and the stacks created from it. CloudFormation also
     *        propagates these tags to supported resources that are created in the stacks. A maximum number of 50 tags
     *        can be specified.</p>
     *        <p>
     *        If you specify tags as part of a <code>CreateStackSet</code> action, CloudFormation checks to see if you
     *        have the required IAM permission to tag resources. If you don't, the entire <code>CreateStackSet</code>
     *        action fails with an <code>access denied</code> error, and the stack set is not created.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateStackSetRequest withTags(java.util.Collection<Tag> tags) {
        setTags(tags);
        return this;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role to use to create this stack set.
     * </p>
     * <p>
     * Specify an IAM role only if you are using customized administrator roles to control which users or groups can
     * manage specific stack sets within the same administrator account. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html">Prerequisites:
     * Granting Permissions for Stack Set Operations</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * 
     * @param administrationRoleARN
     *        The Amazon Resource Name (ARN) of the IAM role to use to create this stack set.</p>
     *        <p>
     *        Specify an IAM role only if you are using customized administrator roles to control which users or groups
     *        can manage specific stack sets within the same administrator account. For more information, see <a
     *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html"
     *        >Prerequisites: Granting Permissions for Stack Set Operations</a> in the <i>CloudFormation User Guide</i>.
     */

    public void setAdministrationRoleARN(String administrationRoleARN) {
        this.administrationRoleARN = administrationRoleARN;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role to use to create this stack set.
     * </p>
     * <p>
     * Specify an IAM role only if you are using customized administrator roles to control which users or groups can
     * manage specific stack sets within the same administrator account. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html">Prerequisites:
     * Granting Permissions for Stack Set Operations</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role to use to create this stack set.</p>
     *         <p>
     *         Specify an IAM role only if you are using customized administrator roles to control which users or groups
     *         can manage specific stack sets within the same administrator account. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html"
     *         >Prerequisites: Granting Permissions for Stack Set Operations</a> in the <i>CloudFormation User
     *         Guide</i>.
     */

    public String getAdministrationRoleARN() {
        return this.administrationRoleARN;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role to use to create this stack set.
     * </p>
     * <p>
     * Specify an IAM role only if you are using customized administrator roles to control which users or groups can
     * manage specific stack sets within the same administrator account. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html">Prerequisites:
     * Granting Permissions for Stack Set Operations</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * 
     * @param administrationRoleARN
     *        The Amazon Resource Name (ARN) of the IAM role to use to create this stack set.</p>
     *        <p>
     *        Specify an IAM role only if you are using customized administrator roles to control which users or groups
     *        can manage specific stack sets within the same administrator account. For more information, see <a
     *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html"
     *        >Prerequisites: Granting Permissions for Stack Set Operations</a> in the <i>CloudFormation User Guide</i>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateStackSetRequest withAdministrationRoleARN(String administrationRoleARN) {
        setAdministrationRoleARN(administrationRoleARN);
        return this;
    }

    /**
     * <p>
     * The name of the IAM execution role to use to create the stack set. If you do not specify an execution role,
     * CloudFormation uses the <code>AWSCloudFormationStackSetExecutionRole</code> role for the stack set operation.
     * </p>
     * <p>
     * Specify an IAM role only if you are using customized execution roles to control which stack resources users and
     * groups can include in their stack sets.
     * </p>
     * 
     * @param executionRoleName
     *        The name of the IAM execution role to use to create the stack set. If you do not specify an execution
     *        role, CloudFormation uses the <code>AWSCloudFormationStackSetExecutionRole</code> role for the stack set
     *        operation.</p>
     *        <p>
     *        Specify an IAM role only if you are using customized execution roles to control which stack resources
     *        users and groups can include in their stack sets.
     */

    public void setExecutionRoleName(String executionRoleName) {
        this.executionRoleName = executionRoleName;
    }

    /**
     * <p>
     * The name of the IAM execution role to use to create the stack set. If you do not specify an execution role,
     * CloudFormation uses the <code>AWSCloudFormationStackSetExecutionRole</code> role for the stack set operation.
     * </p>
     * <p>
     * Specify an IAM role only if you are using customized execution roles to control which stack resources users and
     * groups can include in their stack sets.
     * </p>
     * 
     * @return The name of the IAM execution role to use to create the stack set. If you do not specify an execution
     *         role, CloudFormation uses the <code>AWSCloudFormationStackSetExecutionRole</code> role for the stack set
     *         operation.</p>
     *         <p>
     *         Specify an IAM role only if you are using customized execution roles to control which stack resources
     *         users and groups can include in their stack sets.
     */

    public String getExecutionRoleName() {
        return this.executionRoleName;
    }

    /**
     * <p>
     * The name of the IAM execution role to use to create the stack set. If you do not specify an execution role,
     * CloudFormation uses the <code>AWSCloudFormationStackSetExecutionRole</code> role for the stack set operation.
     * </p>
     * <p>
     * Specify an IAM role only if you are using customized execution roles to control which stack resources users and
     * groups can include in their stack sets.
     * </p>
     * 
     * @param executionRoleName
     *        The name of the IAM execution role to use to create the stack set. If you do not specify an execution
     *        role, CloudFormation uses the <code>AWSCloudFormationStackSetExecutionRole</code> role for the stack set
     *        operation.</p>
     *        <p>
     *        Specify an IAM role only if you are using customized execution roles to control which stack resources
     *        users and groups can include in their stack sets.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateStackSetRequest withExecutionRoleName(String executionRoleName) {
        setExecutionRoleName(executionRoleName);
        return this;
    }

    /**
     * <p>
     * Describes how the IAM roles required for stack set operations are created. By default, <code>SELF-MANAGED</code>
     * is specified.
     * </p>
     * <ul>
     * <li>
     * <p>
     * With <code>self-managed</code> permissions, you must create the administrator and execution roles required to
     * deploy to target accounts. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html">Grant
     * Self-Managed Stack Set Permissions</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * With <code>service-managed</code> permissions, StackSets automatically creates the IAM roles required to deploy
     * to accounts managed by Organizations. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html"
     * >Grant Service-Managed Stack Set Permissions</a>.
     * </p>
     * </li>
     * </ul>
     * 
     * @param permissionModel
     *        Describes how the IAM roles required for stack set operations are created. By default,
     *        <code>SELF-MANAGED</code> is specified.</p>
     *        <ul>
     *        <li>
     *        <p>
     *        With <code>self-managed</code> permissions, you must create the administrator and execution roles required
     *        to deploy to target accounts. For more information, see <a href=
     *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html">Grant
     *        Self-Managed Stack Set Permissions</a>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        With <code>service-managed</code> permissions, StackSets automatically creates the IAM roles required to
     *        deploy to accounts managed by Organizations. For more information, see <a href=
     *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html"
     *        >Grant Service-Managed Stack Set Permissions</a>.
     *        </p>
     *        </li>
     * @see PermissionModels
     */

    public void setPermissionModel(String permissionModel) {
        this.permissionModel = permissionModel;
    }

    /**
     * <p>
     * Describes how the IAM roles required for stack set operations are created. By default, <code>SELF-MANAGED</code>
     * is specified.
     * </p>
     * <ul>
     * <li>
     * <p>
     * With <code>self-managed</code> permissions, you must create the administrator and execution roles required to
     * deploy to target accounts. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html">Grant
     * Self-Managed Stack Set Permissions</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * With <code>service-managed</code> permissions, StackSets automatically creates the IAM roles required to deploy
     * to accounts managed by Organizations. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html"
     * >Grant Service-Managed Stack Set Permissions</a>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Describes how the IAM roles required for stack set operations are created. By default,
     *         <code>SELF-MANAGED</code> is specified.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         With <code>self-managed</code> permissions, you must create the administrator and execution roles
     *         required to deploy to target accounts. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html"
     *         >Grant Self-Managed Stack Set Permissions</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         With <code>service-managed</code> permissions, StackSets automatically creates the IAM roles required to
     *         deploy to accounts managed by Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html"
     *         >Grant Service-Managed Stack Set Permissions</a>.
     *         </p>
     *         </li>
     * @see PermissionModels
     */

    public String getPermissionModel() {
        return this.permissionModel;
    }

    /**
     * <p>
     * Describes how the IAM roles required for stack set operations are created. By default, <code>SELF-MANAGED</code>
     * is specified.
     * </p>
     * <ul>
     * <li>
     * <p>
     * With <code>self-managed</code> permissions, you must create the administrator and execution roles required to
     * deploy to target accounts. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html">Grant
     * Self-Managed Stack Set Permissions</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * With <code>service-managed</code> permissions, StackSets automatically creates the IAM roles required to deploy
     * to accounts managed by Organizations. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html"
     * >Grant Service-Managed Stack Set Permissions</a>.
     * </p>
     * </li>
     * </ul>
     * 
     * @param permissionModel
     *        Describes how the IAM roles required for stack set operations are created. By default,
     *        <code>SELF-MANAGED</code> is specified.</p>
     *        <ul>
     *        <li>
     *        <p>
     *        With <code>self-managed</code> permissions, you must create the administrator and execution roles required
     *        to deploy to target accounts. For more information, see <a href=
     *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html">Grant
     *        Self-Managed Stack Set Permissions</a>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        With <code>service-managed</code> permissions, StackSets automatically creates the IAM roles required to
     *        deploy to accounts managed by Organizations. For more information, see <a href=
     *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html"
     *        >Grant Service-Managed Stack Set Permissions</a>.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see PermissionModels
     */

    public CreateStackSetRequest withPermissionModel(String permissionModel) {
        setPermissionModel(permissionModel);
        return this;
    }

    /**
     * <p>
     * Describes how the IAM roles required for stack set operations are created. By default, <code>SELF-MANAGED</code>
     * is specified.
     * </p>
     * <ul>
     * <li>
     * <p>
     * With <code>self-managed</code> permissions, you must create the administrator and execution roles required to
     * deploy to target accounts. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html">Grant
     * Self-Managed Stack Set Permissions</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * With <code>service-managed</code> permissions, StackSets automatically creates the IAM roles required to deploy
     * to accounts managed by Organizations. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html"
     * >Grant Service-Managed Stack Set Permissions</a>.
     * </p>
     * </li>
     * </ul>
     * 
     * @param permissionModel
     *        Describes how the IAM roles required for stack set operations are created. By default,
     *        <code>SELF-MANAGED</code> is specified.</p>
     *        <ul>
     *        <li>
     *        <p>
     *        With <code>self-managed</code> permissions, you must create the administrator and execution roles required
     *        to deploy to target accounts. For more information, see <a href=
     *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html">Grant
     *        Self-Managed Stack Set Permissions</a>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        With <code>service-managed</code> permissions, StackSets automatically creates the IAM roles required to
     *        deploy to accounts managed by Organizations. For more information, see <a href=
     *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html"
     *        >Grant Service-Managed Stack Set Permissions</a>.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see PermissionModels
     */

    public CreateStackSetRequest withPermissionModel(PermissionModels permissionModel) {
        this.permissionModel = permissionModel.toString();
        return this;
    }

    /**
     * <p>
     * Describes whether StackSets automatically deploys to Organizations accounts that are added to the target
     * organization or organizational unit (OU). Specify only if <code>PermissionModel</code> is
     * <code>SERVICE_MANAGED</code>.
     * </p>
     * 
     * @param autoDeployment
     *        Describes whether StackSets automatically deploys to Organizations accounts that are added to the target
     *        organization or organizational unit (OU). Specify only if <code>PermissionModel</code> is
     *        <code>SERVICE_MANAGED</code>.
     */

    public void setAutoDeployment(AutoDeployment autoDeployment) {
        this.autoDeployment = autoDeployment;
    }

    /**
     * <p>
     * Describes whether StackSets automatically deploys to Organizations accounts that are added to the target
     * organization or organizational unit (OU). Specify only if <code>PermissionModel</code> is
     * <code>SERVICE_MANAGED</code>.
     * </p>
     * 
     * @return Describes whether StackSets automatically deploys to Organizations accounts that are added to the target
     *         organization or organizational unit (OU). Specify only if <code>PermissionModel</code> is
     *         <code>SERVICE_MANAGED</code>.
     */

    public AutoDeployment getAutoDeployment() {
        return this.autoDeployment;
    }

    /**
     * <p>
     * Describes whether StackSets automatically deploys to Organizations accounts that are added to the target
     * organization or organizational unit (OU). Specify only if <code>PermissionModel</code> is
     * <code>SERVICE_MANAGED</code>.
     * </p>
     * 
     * @param autoDeployment
     *        Describes whether StackSets automatically deploys to Organizations accounts that are added to the target
     *        organization or organizational unit (OU). Specify only if <code>PermissionModel</code> is
     *        <code>SERVICE_MANAGED</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateStackSetRequest withAutoDeployment(AutoDeployment autoDeployment) {
        setAutoDeployment(autoDeployment);
        return this;
    }

    /**
     * <p>
     * [Service-managed permissions] Specifies whether you are acting as an account administrator in the organization's
     * management account or as a delegated administrator in a member account.
     * </p>
     * <p>
     * By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed permissions.
     * </p>
     * <ul>
     * <li>
     * <p>
     * To create a stack set with service-managed permissions while signed in to the management account, specify
     * <code>SELF</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To create a stack set with service-managed permissions while signed in to a delegated administrator account,
     * specify <code>DELEGATED_ADMIN</code>.
     * </p>
     * <p>
     * Your Amazon Web Services account must be registered as a delegated admin in the management account. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html"
     * >Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Stack sets with service-managed permissions are created in the management account, including stack sets that are
     * created by delegated administrators.
     * </p>
     * 
     * @param callAs
     *        [Service-managed permissions] Specifies whether you are acting as an account administrator in the
     *        organization's management account or as a delegated administrator in a member account.</p>
     *        <p>
     *        By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed
     *        permissions.
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        To create a stack set with service-managed permissions while signed in to the management account, specify
     *        <code>SELF</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        To create a stack set with service-managed permissions while signed in to a delegated administrator
     *        account, specify <code>DELEGATED_ADMIN</code>.
     *        </p>
     *        <p>
     *        Your Amazon Web Services account must be registered as a delegated admin in the management account. For
     *        more information, see <a href=
     *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html"
     *        >Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.
     *        </p>
     *        </li>
     *        </ul>
     *        <p>
     *        Stack sets with service-managed permissions are created in the management account, including stack sets
     *        that are created by delegated administrators.
     * @see CallAs
     */

    public void setCallAs(String callAs) {
        this.callAs = callAs;
    }

    /**
     * <p>
     * [Service-managed permissions] Specifies whether you are acting as an account administrator in the organization's
     * management account or as a delegated administrator in a member account.
     * </p>
     * <p>
     * By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed permissions.
     * </p>
     * <ul>
     * <li>
     * <p>
     * To create a stack set with service-managed permissions while signed in to the management account, specify
     * <code>SELF</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To create a stack set with service-managed permissions while signed in to a delegated administrator account,
     * specify <code>DELEGATED_ADMIN</code>.
     * </p>
     * <p>
     * Your Amazon Web Services account must be registered as a delegated admin in the management account. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html"
     * >Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Stack sets with service-managed permissions are created in the management account, including stack sets that are
     * created by delegated administrators.
     * </p>
     * 
     * @return [Service-managed permissions] Specifies whether you are acting as an account administrator in the
     *         organization's management account or as a delegated administrator in a member account.</p>
     *         <p>
     *         By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed
     *         permissions.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         To create a stack set with service-managed permissions while signed in to the management account, specify
     *         <code>SELF</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To create a stack set with service-managed permissions while signed in to a delegated administrator
     *         account, specify <code>DELEGATED_ADMIN</code>.
     *         </p>
     *         <p>
     *         Your Amazon Web Services account must be registered as a delegated admin in the management account. For
     *         more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html"
     *         >Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Stack sets with service-managed permissions are created in the management account, including stack sets
     *         that are created by delegated administrators.
     * @see CallAs
     */

    public String getCallAs() {
        return this.callAs;
    }

    /**
     * <p>
     * [Service-managed permissions] Specifies whether you are acting as an account administrator in the organization's
     * management account or as a delegated administrator in a member account.
     * </p>
     * <p>
     * By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed permissions.
     * </p>
     * <ul>
     * <li>
     * <p>
     * To create a stack set with service-managed permissions while signed in to the management account, specify
     * <code>SELF</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To create a stack set with service-managed permissions while signed in to a delegated administrator account,
     * specify <code>DELEGATED_ADMIN</code>.
     * </p>
     * <p>
     * Your Amazon Web Services account must be registered as a delegated admin in the management account. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html"
     * >Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Stack sets with service-managed permissions are created in the management account, including stack sets that are
     * created by delegated administrators.
     * </p>
     * 
     * @param callAs
     *        [Service-managed permissions] Specifies whether you are acting as an account administrator in the
     *        organization's management account or as a delegated administrator in a member account.</p>
     *        <p>
     *        By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed
     *        permissions.
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        To create a stack set with service-managed permissions while signed in to the management account, specify
     *        <code>SELF</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        To create a stack set with service-managed permissions while signed in to a delegated administrator
     *        account, specify <code>DELEGATED_ADMIN</code>.
     *        </p>
     *        <p>
     *        Your Amazon Web Services account must be registered as a delegated admin in the management account. For
     *        more information, see <a href=
     *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html"
     *        >Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.
     *        </p>
     *        </li>
     *        </ul>
     *        <p>
     *        Stack sets with service-managed permissions are created in the management account, including stack sets
     *        that are created by delegated administrators.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see CallAs
     */

    public CreateStackSetRequest withCallAs(String callAs) {
        setCallAs(callAs);
        return this;
    }

    /**
     * <p>
     * [Service-managed permissions] Specifies whether you are acting as an account administrator in the organization's
     * management account or as a delegated administrator in a member account.
     * </p>
     * <p>
     * By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed permissions.
     * </p>
     * <ul>
     * <li>
     * <p>
     * To create a stack set with service-managed permissions while signed in to the management account, specify
     * <code>SELF</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To create a stack set with service-managed permissions while signed in to a delegated administrator account,
     * specify <code>DELEGATED_ADMIN</code>.
     * </p>
     * <p>
     * Your Amazon Web Services account must be registered as a delegated admin in the management account. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html"
     * >Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Stack sets with service-managed permissions are created in the management account, including stack sets that are
     * created by delegated administrators.
     * </p>
     * 
     * @param callAs
     *        [Service-managed permissions] Specifies whether you are acting as an account administrator in the
     *        organization's management account or as a delegated administrator in a member account.</p>
     *        <p>
     *        By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed
     *        permissions.
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        To create a stack set with service-managed permissions while signed in to the management account, specify
     *        <code>SELF</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        To create a stack set with service-managed permissions while signed in to a delegated administrator
     *        account, specify <code>DELEGATED_ADMIN</code>.
     *        </p>
     *        <p>
     *        Your Amazon Web Services account must be registered as a delegated admin in the management account. For
     *        more information, see <a href=
     *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html"
     *        >Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.
     *        </p>
     *        </li>
     *        </ul>
     *        <p>
     *        Stack sets with service-managed permissions are created in the management account, including stack sets
     *        that are created by delegated administrators.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see CallAs
     */

    public CreateStackSetRequest withCallAs(CallAs callAs) {
        this.callAs = callAs.toString();
        return this;
    }

    /**
     * <p>
     * A unique identifier for this <code>CreateStackSet</code> request. Specify this token if you plan to retry
     * requests so that CloudFormation knows that you're not attempting to create another stack set with the same name.
     * You might retry <code>CreateStackSet</code> requests to ensure that CloudFormation successfully received them.
     * </p>
     * <p>
     * If you don't specify an operation ID, the SDK generates one automatically.
     * </p>
     * 
     * @param clientRequestToken
     *        A unique identifier for this <code>CreateStackSet</code> request. Specify this token if you plan to retry
     *        requests so that CloudFormation knows that you're not attempting to create another stack set with the same
     *        name. You might retry <code>CreateStackSet</code> requests to ensure that CloudFormation successfully
     *        received them.</p>
     *        <p>
     *        If you don't specify an operation ID, the SDK generates one automatically.
     */

    public void setClientRequestToken(String clientRequestToken) {
        this.clientRequestToken = clientRequestToken;
    }

    /**
     * <p>
     * A unique identifier for this <code>CreateStackSet</code> request. Specify this token if you plan to retry
     * requests so that CloudFormation knows that you're not attempting to create another stack set with the same name.
     * You might retry <code>CreateStackSet</code> requests to ensure that CloudFormation successfully received them.
     * </p>
     * <p>
     * If you don't specify an operation ID, the SDK generates one automatically.
     * </p>
     * 
     * @return A unique identifier for this <code>CreateStackSet</code> request. Specify this token if you plan to retry
     *         requests so that CloudFormation knows that you're not attempting to create another stack set with the
     *         same name. You might retry <code>CreateStackSet</code> requests to ensure that CloudFormation
     *         successfully received them.</p>
     *         <p>
     *         If you don't specify an operation ID, the SDK generates one automatically.
     */

    public String getClientRequestToken() {
        return this.clientRequestToken;
    }

    /**
     * <p>
     * A unique identifier for this <code>CreateStackSet</code> request. Specify this token if you plan to retry
     * requests so that CloudFormation knows that you're not attempting to create another stack set with the same name.
     * You might retry <code>CreateStackSet</code> requests to ensure that CloudFormation successfully received them.
     * </p>
     * <p>
     * If you don't specify an operation ID, the SDK generates one automatically.
     * </p>
     * 
     * @param clientRequestToken
     *        A unique identifier for this <code>CreateStackSet</code> request. Specify this token if you plan to retry
     *        requests so that CloudFormation knows that you're not attempting to create another stack set with the same
     *        name. You might retry <code>CreateStackSet</code> requests to ensure that CloudFormation successfully
     *        received them.</p>
     *        <p>
     *        If you don't specify an operation ID, the SDK generates one automatically.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateStackSetRequest withClientRequestToken(String clientRequestToken) {
        setClientRequestToken(clientRequestToken);
        return this;
    }

    /**
     * <p>
     * Describes whether StackSets performs non-conflicting operations concurrently and queues conflicting operations.
     * </p>
     * 
     * @param managedExecution
     *        Describes whether StackSets performs non-conflicting operations concurrently and queues conflicting
     *        operations.
     */

    public void setManagedExecution(ManagedExecution managedExecution) {
        this.managedExecution = managedExecution;
    }

    /**
     * <p>
     * Describes whether StackSets performs non-conflicting operations concurrently and queues conflicting operations.
     * </p>
     * 
     * @return Describes whether StackSets performs non-conflicting operations concurrently and queues conflicting
     *         operations.
     */

    public ManagedExecution getManagedExecution() {
        return this.managedExecution;
    }

    /**
     * <p>
     * Describes whether StackSets performs non-conflicting operations concurrently and queues conflicting operations.
     * </p>
     * 
     * @param managedExecution
     *        Describes whether StackSets performs non-conflicting operations concurrently and queues conflicting
     *        operations.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateStackSetRequest withManagedExecution(ManagedExecution managedExecution) {
        setManagedExecution(managedExecution);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getStackSetName() != null)
            sb.append("StackSetName: ").append(getStackSetName()).append(",");
        if (getDescription() != null)
            sb.append("Description: ").append(getDescription()).append(",");
        if (getTemplateBody() != null)
            sb.append("TemplateBody: ").append(getTemplateBody()).append(",");
        if (getTemplateURL() != null)
            sb.append("TemplateURL: ").append(getTemplateURL()).append(",");
        if (getStackId() != null)
            sb.append("StackId: ").append(getStackId()).append(",");
        if (getParameters() != null)
            sb.append("Parameters: ").append(getParameters()).append(",");
        if (getCapabilities() != null)
            sb.append("Capabilities: ").append(getCapabilities()).append(",");
        if (getTags() != null)
            sb.append("Tags: ").append(getTags()).append(",");
        if (getAdministrationRoleARN() != null)
            sb.append("AdministrationRoleARN: ").append(getAdministrationRoleARN()).append(",");
        if (getExecutionRoleName() != null)
            sb.append("ExecutionRoleName: ").append(getExecutionRoleName()).append(",");
        if (getPermissionModel() != null)
            sb.append("PermissionModel: ").append(getPermissionModel()).append(",");
        if (getAutoDeployment() != null)
            sb.append("AutoDeployment: ").append(getAutoDeployment()).append(",");
        if (getCallAs() != null)
            sb.append("CallAs: ").append(getCallAs()).append(",");
        if (getClientRequestToken() != null)
            sb.append("ClientRequestToken: ").append(getClientRequestToken()).append(",");
        if (getManagedExecution() != null)
            sb.append("ManagedExecution: ").append(getManagedExecution());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CreateStackSetRequest == false)
            return false;
        CreateStackSetRequest other = (CreateStackSetRequest) obj;
        if (other.getStackSetName() == null ^ this.getStackSetName() == null)
            return false;
        if (other.getStackSetName() != null && other.getStackSetName().equals(this.getStackSetName()) == false)
            return false;
        if (other.getDescription() == null ^ this.getDescription() == null)
            return false;
        if (other.getDescription() != null && other.getDescription().equals(this.getDescription()) == false)
            return false;
        if (other.getTemplateBody() == null ^ this.getTemplateBody() == null)
            return false;
        if (other.getTemplateBody() != null && other.getTemplateBody().equals(this.getTemplateBody()) == false)
            return false;
        if (other.getTemplateURL() == null ^ this.getTemplateURL() == null)
            return false;
        if (other.getTemplateURL() != null && other.getTemplateURL().equals(this.getTemplateURL()) == false)
            return false;
        if (other.getStackId() == null ^ this.getStackId() == null)
            return false;
        if (other.getStackId() != null && other.getStackId().equals(this.getStackId()) == false)
            return false;
        if (other.getParameters() == null ^ this.getParameters() == null)
            return false;
        if (other.getParameters() != null && other.getParameters().equals(this.getParameters()) == false)
            return false;
        if (other.getCapabilities() == null ^ this.getCapabilities() == null)
            return false;
        if (other.getCapabilities() != null && other.getCapabilities().equals(this.getCapabilities()) == false)
            return false;
        if (other.getTags() == null ^ this.getTags() == null)
            return false;
        if (other.getTags() != null && other.getTags().equals(this.getTags()) == false)
            return false;
        if (other.getAdministrationRoleARN() == null ^ this.getAdministrationRoleARN() == null)
            return false;
        if (other.getAdministrationRoleARN() != null && other.getAdministrationRoleARN().equals(this.getAdministrationRoleARN()) == false)
            return false;
        if (other.getExecutionRoleName() == null ^ this.getExecutionRoleName() == null)
            return false;
        if (other.getExecutionRoleName() != null && other.getExecutionRoleName().equals(this.getExecutionRoleName()) == false)
            return false;
        if (other.getPermissionModel() == null ^ this.getPermissionModel() == null)
            return false;
        if (other.getPermissionModel() != null && other.getPermissionModel().equals(this.getPermissionModel()) == false)
            return false;
        if (other.getAutoDeployment() == null ^ this.getAutoDeployment() == null)
            return false;
        if (other.getAutoDeployment() != null && other.getAutoDeployment().equals(this.getAutoDeployment()) == false)
            return false;
        if (other.getCallAs() == null ^ this.getCallAs() == null)
            return false;
        if (other.getCallAs() != null && other.getCallAs().equals(this.getCallAs()) == false)
            return false;
        if (other.getClientRequestToken() == null ^ this.getClientRequestToken() == null)
            return false;
        if (other.getClientRequestToken() != null && other.getClientRequestToken().equals(this.getClientRequestToken()) == false)
            return false;
        if (other.getManagedExecution() == null ^ this.getManagedExecution() == null)
            return false;
        if (other.getManagedExecution() != null && other.getManagedExecution().equals(this.getManagedExecution()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getStackSetName() == null) ? 0 : getStackSetName().hashCode());
        hashCode = prime * hashCode + ((getDescription() == null) ? 0 : getDescription().hashCode());
        hashCode = prime * hashCode + ((getTemplateBody() == null) ? 0 : getTemplateBody().hashCode());
        hashCode = prime * hashCode + ((getTemplateURL() == null) ? 0 : getTemplateURL().hashCode());
        hashCode = prime * hashCode + ((getStackId() == null) ? 0 : getStackId().hashCode());
        hashCode = prime * hashCode + ((getParameters() == null) ? 0 : getParameters().hashCode());
        hashCode = prime * hashCode + ((getCapabilities() == null) ? 0 : getCapabilities().hashCode());
        hashCode = prime * hashCode + ((getTags() == null) ? 0 : getTags().hashCode());
        hashCode = prime * hashCode + ((getAdministrationRoleARN() == null) ? 0 : getAdministrationRoleARN().hashCode());
        hashCode = prime * hashCode + ((getExecutionRoleName() == null) ? 0 : getExecutionRoleName().hashCode());
        hashCode = prime * hashCode + ((getPermissionModel() == null) ? 0 : getPermissionModel().hashCode());
        hashCode = prime * hashCode + ((getAutoDeployment() == null) ? 0 : getAutoDeployment().hashCode());
        hashCode = prime * hashCode + ((getCallAs() == null) ? 0 : getCallAs().hashCode());
        hashCode = prime * hashCode + ((getClientRequestToken() == null) ? 0 : getClientRequestToken().hashCode());
        hashCode = prime * hashCode + ((getManagedExecution() == null) ? 0 : getManagedExecution().hashCode());
        return hashCode;
    }

    @Override
    public CreateStackSetRequest clone() {
        return (CreateStackSetRequest) super.clone();
    }

}
