/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.cloudformation.model;

import javax.annotation.Generated;

/**
 * <p>
 * No more than 5 generated templates can be in an <code>InProgress</code> or <code>Pending</code> status at one time.
 * This error is also returned if a generated template that is in an <code>InProgress</code> or <code>Pending</code>
 * status is attempted to be updated or deleted.
 * </p>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ConcurrentResourcesLimitExceededException extends com.amazonaws.services.cloudformation.model.AmazonCloudFormationException {
    private static final long serialVersionUID = 1L;

    /**
     * Constructs a new ConcurrentResourcesLimitExceededException with the specified error message.
     *
     * @param message
     *        Describes the error encountered.
     */
    public ConcurrentResourcesLimitExceededException(String message) {
        super(message);
    }

}
