/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudfront.model.ListStreamingDistributionsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListStreamingDistributionsRequestMarshaller
implements Marshaller<Request<ListStreamingDistributionsRequest>, ListStreamingDistributionsRequest> {
    public Request<ListStreamingDistributionsRequest> marshall(ListStreamingDistributionsRequest listStreamingDistributionsRequest) {
        String maxItems;
        String marker;
        if (listStreamingDistributionsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listStreamingDistributionsRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2016-01-28/streaming-distribution";
        request.setResourcePath(uriResourcePath);
        String string = marker = listStreamingDistributionsRequest.getMarker() == null ? null : StringUtils.fromString((String)listStreamingDistributionsRequest.getMarker());
        if (marker != null) {
            request.addParameter("Marker", marker);
        }
        String string2 = maxItems = listStreamingDistributionsRequest.getMaxItems() == null ? null : StringUtils.fromString((String)listStreamingDistributionsRequest.getMaxItems());
        if (maxItems != null) {
            request.addParameter("MaxItems", maxItems);
        }
        return request;
    }
}

