/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model;

import com.amazonaws.services.cloudfront.model.AllowedMethods;
import com.amazonaws.services.cloudfront.model.ForwardedValues;
import com.amazonaws.services.cloudfront.model.LambdaFunctionAssociations;
import com.amazonaws.services.cloudfront.model.TrustedSigners;
import com.amazonaws.services.cloudfront.model.ViewerProtocolPolicy;
import java.io.Serializable;

public class CacheBehavior
implements Serializable,
Cloneable {
    private String pathPattern;
    private String targetOriginId;
    private TrustedSigners trustedSigners;
    private String viewerProtocolPolicy;
    private AllowedMethods allowedMethods;
    private Boolean smoothStreaming;
    private Boolean compress;
    private LambdaFunctionAssociations lambdaFunctionAssociations;
    private String fieldLevelEncryptionId;
    private String cachePolicyId;
    private String originRequestPolicyId;
    @Deprecated
    private ForwardedValues forwardedValues;
    @Deprecated
    private Long minTTL;
    @Deprecated
    private Long defaultTTL;
    @Deprecated
    private Long maxTTL;

    public void setPathPattern(String pathPattern) {
        this.pathPattern = pathPattern;
    }

    public String getPathPattern() {
        return this.pathPattern;
    }

    public CacheBehavior withPathPattern(String pathPattern) {
        this.setPathPattern(pathPattern);
        return this;
    }

    public void setTargetOriginId(String targetOriginId) {
        this.targetOriginId = targetOriginId;
    }

    public String getTargetOriginId() {
        return this.targetOriginId;
    }

    public CacheBehavior withTargetOriginId(String targetOriginId) {
        this.setTargetOriginId(targetOriginId);
        return this;
    }

    public void setTrustedSigners(TrustedSigners trustedSigners) {
        this.trustedSigners = trustedSigners;
    }

    public TrustedSigners getTrustedSigners() {
        return this.trustedSigners;
    }

    public CacheBehavior withTrustedSigners(TrustedSigners trustedSigners) {
        this.setTrustedSigners(trustedSigners);
        return this;
    }

    public void setViewerProtocolPolicy(String viewerProtocolPolicy) {
        this.viewerProtocolPolicy = viewerProtocolPolicy;
    }

    public String getViewerProtocolPolicy() {
        return this.viewerProtocolPolicy;
    }

    public CacheBehavior withViewerProtocolPolicy(String viewerProtocolPolicy) {
        this.setViewerProtocolPolicy(viewerProtocolPolicy);
        return this;
    }

    public void setViewerProtocolPolicy(ViewerProtocolPolicy viewerProtocolPolicy) {
        this.withViewerProtocolPolicy(viewerProtocolPolicy);
    }

    public CacheBehavior withViewerProtocolPolicy(ViewerProtocolPolicy viewerProtocolPolicy) {
        this.viewerProtocolPolicy = viewerProtocolPolicy.toString();
        return this;
    }

    public void setAllowedMethods(AllowedMethods allowedMethods) {
        this.allowedMethods = allowedMethods;
    }

    public AllowedMethods getAllowedMethods() {
        return this.allowedMethods;
    }

    public CacheBehavior withAllowedMethods(AllowedMethods allowedMethods) {
        this.setAllowedMethods(allowedMethods);
        return this;
    }

    public void setSmoothStreaming(Boolean smoothStreaming) {
        this.smoothStreaming = smoothStreaming;
    }

    public Boolean getSmoothStreaming() {
        return this.smoothStreaming;
    }

    public CacheBehavior withSmoothStreaming(Boolean smoothStreaming) {
        this.setSmoothStreaming(smoothStreaming);
        return this;
    }

    public Boolean isSmoothStreaming() {
        return this.smoothStreaming;
    }

    public void setCompress(Boolean compress) {
        this.compress = compress;
    }

    public Boolean getCompress() {
        return this.compress;
    }

    public CacheBehavior withCompress(Boolean compress) {
        this.setCompress(compress);
        return this;
    }

    public Boolean isCompress() {
        return this.compress;
    }

    public void setLambdaFunctionAssociations(LambdaFunctionAssociations lambdaFunctionAssociations) {
        this.lambdaFunctionAssociations = lambdaFunctionAssociations;
    }

    public LambdaFunctionAssociations getLambdaFunctionAssociations() {
        return this.lambdaFunctionAssociations;
    }

    public CacheBehavior withLambdaFunctionAssociations(LambdaFunctionAssociations lambdaFunctionAssociations) {
        this.setLambdaFunctionAssociations(lambdaFunctionAssociations);
        return this;
    }

    public void setFieldLevelEncryptionId(String fieldLevelEncryptionId) {
        this.fieldLevelEncryptionId = fieldLevelEncryptionId;
    }

    public String getFieldLevelEncryptionId() {
        return this.fieldLevelEncryptionId;
    }

    public CacheBehavior withFieldLevelEncryptionId(String fieldLevelEncryptionId) {
        this.setFieldLevelEncryptionId(fieldLevelEncryptionId);
        return this;
    }

    public void setCachePolicyId(String cachePolicyId) {
        this.cachePolicyId = cachePolicyId;
    }

    public String getCachePolicyId() {
        return this.cachePolicyId;
    }

    public CacheBehavior withCachePolicyId(String cachePolicyId) {
        this.setCachePolicyId(cachePolicyId);
        return this;
    }

    public void setOriginRequestPolicyId(String originRequestPolicyId) {
        this.originRequestPolicyId = originRequestPolicyId;
    }

    public String getOriginRequestPolicyId() {
        return this.originRequestPolicyId;
    }

    public CacheBehavior withOriginRequestPolicyId(String originRequestPolicyId) {
        this.setOriginRequestPolicyId(originRequestPolicyId);
        return this;
    }

    @Deprecated
    public void setForwardedValues(ForwardedValues forwardedValues) {
        this.forwardedValues = forwardedValues;
    }

    @Deprecated
    public ForwardedValues getForwardedValues() {
        return this.forwardedValues;
    }

    @Deprecated
    public CacheBehavior withForwardedValues(ForwardedValues forwardedValues) {
        this.setForwardedValues(forwardedValues);
        return this;
    }

    @Deprecated
    public void setMinTTL(Long minTTL) {
        this.minTTL = minTTL;
    }

    @Deprecated
    public Long getMinTTL() {
        return this.minTTL;
    }

    @Deprecated
    public CacheBehavior withMinTTL(Long minTTL) {
        this.setMinTTL(minTTL);
        return this;
    }

    @Deprecated
    public void setDefaultTTL(Long defaultTTL) {
        this.defaultTTL = defaultTTL;
    }

    @Deprecated
    public Long getDefaultTTL() {
        return this.defaultTTL;
    }

    @Deprecated
    public CacheBehavior withDefaultTTL(Long defaultTTL) {
        this.setDefaultTTL(defaultTTL);
        return this;
    }

    @Deprecated
    public void setMaxTTL(Long maxTTL) {
        this.maxTTL = maxTTL;
    }

    @Deprecated
    public Long getMaxTTL() {
        return this.maxTTL;
    }

    @Deprecated
    public CacheBehavior withMaxTTL(Long maxTTL) {
        this.setMaxTTL(maxTTL);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPathPattern() != null) {
            sb.append("PathPattern: ").append(this.getPathPattern()).append(",");
        }
        if (this.getTargetOriginId() != null) {
            sb.append("TargetOriginId: ").append(this.getTargetOriginId()).append(",");
        }
        if (this.getTrustedSigners() != null) {
            sb.append("TrustedSigners: ").append(this.getTrustedSigners()).append(",");
        }
        if (this.getViewerProtocolPolicy() != null) {
            sb.append("ViewerProtocolPolicy: ").append(this.getViewerProtocolPolicy()).append(",");
        }
        if (this.getAllowedMethods() != null) {
            sb.append("AllowedMethods: ").append(this.getAllowedMethods()).append(",");
        }
        if (this.getSmoothStreaming() != null) {
            sb.append("SmoothStreaming: ").append(this.getSmoothStreaming()).append(",");
        }
        if (this.getCompress() != null) {
            sb.append("Compress: ").append(this.getCompress()).append(",");
        }
        if (this.getLambdaFunctionAssociations() != null) {
            sb.append("LambdaFunctionAssociations: ").append(this.getLambdaFunctionAssociations()).append(",");
        }
        if (this.getFieldLevelEncryptionId() != null) {
            sb.append("FieldLevelEncryptionId: ").append(this.getFieldLevelEncryptionId()).append(",");
        }
        if (this.getCachePolicyId() != null) {
            sb.append("CachePolicyId: ").append(this.getCachePolicyId()).append(",");
        }
        if (this.getOriginRequestPolicyId() != null) {
            sb.append("OriginRequestPolicyId: ").append(this.getOriginRequestPolicyId()).append(",");
        }
        if (this.getForwardedValues() != null) {
            sb.append("ForwardedValues: ").append(this.getForwardedValues()).append(",");
        }
        if (this.getMinTTL() != null) {
            sb.append("MinTTL: ").append(this.getMinTTL()).append(",");
        }
        if (this.getDefaultTTL() != null) {
            sb.append("DefaultTTL: ").append(this.getDefaultTTL()).append(",");
        }
        if (this.getMaxTTL() != null) {
            sb.append("MaxTTL: ").append(this.getMaxTTL());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CacheBehavior)) {
            return false;
        }
        CacheBehavior other = (CacheBehavior)obj;
        if (other.getPathPattern() == null ^ this.getPathPattern() == null) {
            return false;
        }
        if (other.getPathPattern() != null && !other.getPathPattern().equals(this.getPathPattern())) {
            return false;
        }
        if (other.getTargetOriginId() == null ^ this.getTargetOriginId() == null) {
            return false;
        }
        if (other.getTargetOriginId() != null && !other.getTargetOriginId().equals(this.getTargetOriginId())) {
            return false;
        }
        if (other.getTrustedSigners() == null ^ this.getTrustedSigners() == null) {
            return false;
        }
        if (other.getTrustedSigners() != null && !other.getTrustedSigners().equals(this.getTrustedSigners())) {
            return false;
        }
        if (other.getViewerProtocolPolicy() == null ^ this.getViewerProtocolPolicy() == null) {
            return false;
        }
        if (other.getViewerProtocolPolicy() != null && !other.getViewerProtocolPolicy().equals(this.getViewerProtocolPolicy())) {
            return false;
        }
        if (other.getAllowedMethods() == null ^ this.getAllowedMethods() == null) {
            return false;
        }
        if (other.getAllowedMethods() != null && !other.getAllowedMethods().equals(this.getAllowedMethods())) {
            return false;
        }
        if (other.getSmoothStreaming() == null ^ this.getSmoothStreaming() == null) {
            return false;
        }
        if (other.getSmoothStreaming() != null && !other.getSmoothStreaming().equals(this.getSmoothStreaming())) {
            return false;
        }
        if (other.getCompress() == null ^ this.getCompress() == null) {
            return false;
        }
        if (other.getCompress() != null && !other.getCompress().equals(this.getCompress())) {
            return false;
        }
        if (other.getLambdaFunctionAssociations() == null ^ this.getLambdaFunctionAssociations() == null) {
            return false;
        }
        if (other.getLambdaFunctionAssociations() != null && !other.getLambdaFunctionAssociations().equals(this.getLambdaFunctionAssociations())) {
            return false;
        }
        if (other.getFieldLevelEncryptionId() == null ^ this.getFieldLevelEncryptionId() == null) {
            return false;
        }
        if (other.getFieldLevelEncryptionId() != null && !other.getFieldLevelEncryptionId().equals(this.getFieldLevelEncryptionId())) {
            return false;
        }
        if (other.getCachePolicyId() == null ^ this.getCachePolicyId() == null) {
            return false;
        }
        if (other.getCachePolicyId() != null && !other.getCachePolicyId().equals(this.getCachePolicyId())) {
            return false;
        }
        if (other.getOriginRequestPolicyId() == null ^ this.getOriginRequestPolicyId() == null) {
            return false;
        }
        if (other.getOriginRequestPolicyId() != null && !other.getOriginRequestPolicyId().equals(this.getOriginRequestPolicyId())) {
            return false;
        }
        if (other.getForwardedValues() == null ^ this.getForwardedValues() == null) {
            return false;
        }
        if (other.getForwardedValues() != null && !other.getForwardedValues().equals(this.getForwardedValues())) {
            return false;
        }
        if (other.getMinTTL() == null ^ this.getMinTTL() == null) {
            return false;
        }
        if (other.getMinTTL() != null && !other.getMinTTL().equals(this.getMinTTL())) {
            return false;
        }
        if (other.getDefaultTTL() == null ^ this.getDefaultTTL() == null) {
            return false;
        }
        if (other.getDefaultTTL() != null && !other.getDefaultTTL().equals(this.getDefaultTTL())) {
            return false;
        }
        if (other.getMaxTTL() == null ^ this.getMaxTTL() == null) {
            return false;
        }
        return other.getMaxTTL() == null || other.getMaxTTL().equals(this.getMaxTTL());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPathPattern() == null ? 0 : this.getPathPattern().hashCode());
        hashCode = 31 * hashCode + (this.getTargetOriginId() == null ? 0 : this.getTargetOriginId().hashCode());
        hashCode = 31 * hashCode + (this.getTrustedSigners() == null ? 0 : this.getTrustedSigners().hashCode());
        hashCode = 31 * hashCode + (this.getViewerProtocolPolicy() == null ? 0 : this.getViewerProtocolPolicy().hashCode());
        hashCode = 31 * hashCode + (this.getAllowedMethods() == null ? 0 : this.getAllowedMethods().hashCode());
        hashCode = 31 * hashCode + (this.getSmoothStreaming() == null ? 0 : this.getSmoothStreaming().hashCode());
        hashCode = 31 * hashCode + (this.getCompress() == null ? 0 : this.getCompress().hashCode());
        hashCode = 31 * hashCode + (this.getLambdaFunctionAssociations() == null ? 0 : this.getLambdaFunctionAssociations().hashCode());
        hashCode = 31 * hashCode + (this.getFieldLevelEncryptionId() == null ? 0 : this.getFieldLevelEncryptionId().hashCode());
        hashCode = 31 * hashCode + (this.getCachePolicyId() == null ? 0 : this.getCachePolicyId().hashCode());
        hashCode = 31 * hashCode + (this.getOriginRequestPolicyId() == null ? 0 : this.getOriginRequestPolicyId().hashCode());
        hashCode = 31 * hashCode + (this.getForwardedValues() == null ? 0 : this.getForwardedValues().hashCode());
        hashCode = 31 * hashCode + (this.getMinTTL() == null ? 0 : this.getMinTTL().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultTTL() == null ? 0 : this.getDefaultTTL().hashCode());
        hashCode = 31 * hashCode + (this.getMaxTTL() == null ? 0 : this.getMaxTTL().hashCode());
        return hashCode;
    }

    public CacheBehavior clone() {
        try {
            return (CacheBehavior)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

