/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfrontkeyvaluestore;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.cloudfrontkeyvaluestore.AmazonCloudFrontKeyValueStore;
import com.amazonaws.services.cloudfrontkeyvaluestore.AmazonCloudFrontKeyValueStoreClientBuilder;
import com.amazonaws.services.cloudfrontkeyvaluestore.model.AmazonCloudFrontKeyValueStoreException;
import com.amazonaws.services.cloudfrontkeyvaluestore.model.DeleteKeyRequest;
import com.amazonaws.services.cloudfrontkeyvaluestore.model.DeleteKeyResult;
import com.amazonaws.services.cloudfrontkeyvaluestore.model.DescribeKeyValueStoreRequest;
import com.amazonaws.services.cloudfrontkeyvaluestore.model.DescribeKeyValueStoreResult;
import com.amazonaws.services.cloudfrontkeyvaluestore.model.GetKeyRequest;
import com.amazonaws.services.cloudfrontkeyvaluestore.model.GetKeyResult;
import com.amazonaws.services.cloudfrontkeyvaluestore.model.ListKeysRequest;
import com.amazonaws.services.cloudfrontkeyvaluestore.model.ListKeysResult;
import com.amazonaws.services.cloudfrontkeyvaluestore.model.PutKeyRequest;
import com.amazonaws.services.cloudfrontkeyvaluestore.model.PutKeyResult;
import com.amazonaws.services.cloudfrontkeyvaluestore.model.UpdateKeysRequest;
import com.amazonaws.services.cloudfrontkeyvaluestore.model.UpdateKeysResult;
import com.amazonaws.services.cloudfrontkeyvaluestore.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.cloudfrontkeyvaluestore.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.cloudfrontkeyvaluestore.model.transform.DeleteKeyRequestProtocolMarshaller;
import com.amazonaws.services.cloudfrontkeyvaluestore.model.transform.DeleteKeyResultJsonUnmarshaller;
import com.amazonaws.services.cloudfrontkeyvaluestore.model.transform.DescribeKeyValueStoreRequestProtocolMarshaller;
import com.amazonaws.services.cloudfrontkeyvaluestore.model.transform.DescribeKeyValueStoreResultJsonUnmarshaller;
import com.amazonaws.services.cloudfrontkeyvaluestore.model.transform.GetKeyRequestProtocolMarshaller;
import com.amazonaws.services.cloudfrontkeyvaluestore.model.transform.GetKeyResultJsonUnmarshaller;
import com.amazonaws.services.cloudfrontkeyvaluestore.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.cloudfrontkeyvaluestore.model.transform.ListKeysRequestProtocolMarshaller;
import com.amazonaws.services.cloudfrontkeyvaluestore.model.transform.ListKeysResultJsonUnmarshaller;
import com.amazonaws.services.cloudfrontkeyvaluestore.model.transform.PutKeyRequestProtocolMarshaller;
import com.amazonaws.services.cloudfrontkeyvaluestore.model.transform.PutKeyResultJsonUnmarshaller;
import com.amazonaws.services.cloudfrontkeyvaluestore.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.cloudfrontkeyvaluestore.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.cloudfrontkeyvaluestore.model.transform.UpdateKeysRequestProtocolMarshaller;
import com.amazonaws.services.cloudfrontkeyvaluestore.model.transform.UpdateKeysResultJsonUnmarshaller;
import com.amazonaws.services.cloudfrontkeyvaluestore.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonCloudFrontKeyValueStoreClient
extends AmazonWebServiceClient
implements AmazonCloudFrontKeyValueStore {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonCloudFrontKeyValueStore.class);
    private static final String DEFAULT_SIGNING_NAME = "cloudfront-keyvaluestore";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonCloudFrontKeyValueStoreException.class));

    public static AmazonCloudFrontKeyValueStoreClientBuilder builder() {
        return AmazonCloudFrontKeyValueStoreClientBuilder.standard();
    }

    AmazonCloudFrontKeyValueStoreClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonCloudFrontKeyValueStoreClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("cloudfront-keyvaluestore.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/cloudfrontkeyvaluestore/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/cloudfrontkeyvaluestore/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public DeleteKeyResult deleteKey(DeleteKeyRequest request) {
        request = (DeleteKeyRequest)this.beforeClientExecution(request);
        return this.executeDeleteKey(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteKeyResult executeDeleteKey(DeleteKeyRequest deleteKeyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteKeyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteKeyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteKeyRequestProtocolMarshaller(protocolFactory).marshall((DeleteKeyRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteKeyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudFront KeyValueStore");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteKey");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteKeyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteKeyResult deleteKeyResult = (DeleteKeyResult)response.getAwsResponse();
            return deleteKeyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeKeyValueStoreResult describeKeyValueStore(DescribeKeyValueStoreRequest request) {
        request = (DescribeKeyValueStoreRequest)this.beforeClientExecution(request);
        return this.executeDescribeKeyValueStore(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeKeyValueStoreResult executeDescribeKeyValueStore(DescribeKeyValueStoreRequest describeKeyValueStoreRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeKeyValueStoreRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeKeyValueStoreRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeKeyValueStoreRequestProtocolMarshaller(protocolFactory).marshall((DescribeKeyValueStoreRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeKeyValueStoreRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudFront KeyValueStore");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeKeyValueStore");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeKeyValueStoreResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeKeyValueStoreResult describeKeyValueStoreResult = (DescribeKeyValueStoreResult)response.getAwsResponse();
            return describeKeyValueStoreResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetKeyResult getKey(GetKeyRequest request) {
        request = (GetKeyRequest)this.beforeClientExecution(request);
        return this.executeGetKey(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetKeyResult executeGetKey(GetKeyRequest getKeyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getKeyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetKeyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetKeyRequestProtocolMarshaller(protocolFactory).marshall((GetKeyRequest)super.beforeMarshalling((AmazonWebServiceRequest)getKeyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudFront KeyValueStore");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetKey");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetKeyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetKeyResult getKeyResult = (GetKeyResult)response.getAwsResponse();
            return getKeyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListKeysResult listKeys(ListKeysRequest request) {
        request = (ListKeysRequest)this.beforeClientExecution(request);
        return this.executeListKeys(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListKeysResult executeListKeys(ListKeysRequest listKeysRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listKeysRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListKeysRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListKeysRequestProtocolMarshaller(protocolFactory).marshall((ListKeysRequest)super.beforeMarshalling((AmazonWebServiceRequest)listKeysRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudFront KeyValueStore");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListKeys");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListKeysResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListKeysResult listKeysResult = (ListKeysResult)response.getAwsResponse();
            return listKeysResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutKeyResult putKey(PutKeyRequest request) {
        request = (PutKeyRequest)this.beforeClientExecution(request);
        return this.executePutKey(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutKeyResult executePutKey(PutKeyRequest putKeyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putKeyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutKeyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutKeyRequestProtocolMarshaller(protocolFactory).marshall((PutKeyRequest)super.beforeMarshalling((AmazonWebServiceRequest)putKeyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudFront KeyValueStore");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutKey");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutKeyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutKeyResult putKeyResult = (PutKeyResult)response.getAwsResponse();
            return putKeyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateKeysResult updateKeys(UpdateKeysRequest request) {
        request = (UpdateKeysRequest)this.beforeClientExecution(request);
        return this.executeUpdateKeys(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateKeysResult executeUpdateKeys(UpdateKeysRequest updateKeysRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateKeysRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateKeysRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateKeysRequestProtocolMarshaller(protocolFactory).marshall((UpdateKeysRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateKeysRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudFront KeyValueStore");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateKeys");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateKeysResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateKeysResult updateKeysResult = (UpdateKeysResult)response.getAwsResponse();
            return updateKeysResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

