/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfrontkeyvaluestore;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.cloudfrontkeyvaluestore.AmazonCloudFrontKeyValueStoreAsync;
import com.amazonaws.services.cloudfrontkeyvaluestore.AmazonCloudFrontKeyValueStoreAsyncClientBuilder;
import com.amazonaws.services.cloudfrontkeyvaluestore.AmazonCloudFrontKeyValueStoreClient;
import com.amazonaws.services.cloudfrontkeyvaluestore.model.DeleteKeyRequest;
import com.amazonaws.services.cloudfrontkeyvaluestore.model.DeleteKeyResult;
import com.amazonaws.services.cloudfrontkeyvaluestore.model.DescribeKeyValueStoreRequest;
import com.amazonaws.services.cloudfrontkeyvaluestore.model.DescribeKeyValueStoreResult;
import com.amazonaws.services.cloudfrontkeyvaluestore.model.GetKeyRequest;
import com.amazonaws.services.cloudfrontkeyvaluestore.model.GetKeyResult;
import com.amazonaws.services.cloudfrontkeyvaluestore.model.ListKeysRequest;
import com.amazonaws.services.cloudfrontkeyvaluestore.model.ListKeysResult;
import com.amazonaws.services.cloudfrontkeyvaluestore.model.PutKeyRequest;
import com.amazonaws.services.cloudfrontkeyvaluestore.model.PutKeyResult;
import com.amazonaws.services.cloudfrontkeyvaluestore.model.UpdateKeysRequest;
import com.amazonaws.services.cloudfrontkeyvaluestore.model.UpdateKeysResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonCloudFrontKeyValueStoreAsyncClient
extends AmazonCloudFrontKeyValueStoreClient
implements AmazonCloudFrontKeyValueStoreAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonCloudFrontKeyValueStoreAsyncClientBuilder asyncBuilder() {
        return AmazonCloudFrontKeyValueStoreAsyncClientBuilder.standard();
    }

    AmazonCloudFrontKeyValueStoreAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonCloudFrontKeyValueStoreAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<DeleteKeyResult> deleteKeyAsync(DeleteKeyRequest request) {
        return this.deleteKeyAsync(request, null);
    }

    @Override
    public Future<DeleteKeyResult> deleteKeyAsync(DeleteKeyRequest request, final AsyncHandler<DeleteKeyRequest, DeleteKeyResult> asyncHandler) {
        final DeleteKeyRequest finalRequest = (DeleteKeyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteKeyResult>(){

            @Override
            public DeleteKeyResult call() throws Exception {
                DeleteKeyResult result = null;
                try {
                    result = AmazonCloudFrontKeyValueStoreAsyncClient.this.executeDeleteKey(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeKeyValueStoreResult> describeKeyValueStoreAsync(DescribeKeyValueStoreRequest request) {
        return this.describeKeyValueStoreAsync(request, null);
    }

    @Override
    public Future<DescribeKeyValueStoreResult> describeKeyValueStoreAsync(DescribeKeyValueStoreRequest request, final AsyncHandler<DescribeKeyValueStoreRequest, DescribeKeyValueStoreResult> asyncHandler) {
        final DescribeKeyValueStoreRequest finalRequest = (DescribeKeyValueStoreRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeKeyValueStoreResult>(){

            @Override
            public DescribeKeyValueStoreResult call() throws Exception {
                DescribeKeyValueStoreResult result = null;
                try {
                    result = AmazonCloudFrontKeyValueStoreAsyncClient.this.executeDescribeKeyValueStore(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetKeyResult> getKeyAsync(GetKeyRequest request) {
        return this.getKeyAsync(request, null);
    }

    @Override
    public Future<GetKeyResult> getKeyAsync(GetKeyRequest request, final AsyncHandler<GetKeyRequest, GetKeyResult> asyncHandler) {
        final GetKeyRequest finalRequest = (GetKeyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetKeyResult>(){

            @Override
            public GetKeyResult call() throws Exception {
                GetKeyResult result = null;
                try {
                    result = AmazonCloudFrontKeyValueStoreAsyncClient.this.executeGetKey(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListKeysResult> listKeysAsync(ListKeysRequest request) {
        return this.listKeysAsync(request, null);
    }

    @Override
    public Future<ListKeysResult> listKeysAsync(ListKeysRequest request, final AsyncHandler<ListKeysRequest, ListKeysResult> asyncHandler) {
        final ListKeysRequest finalRequest = (ListKeysRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListKeysResult>(){

            @Override
            public ListKeysResult call() throws Exception {
                ListKeysResult result = null;
                try {
                    result = AmazonCloudFrontKeyValueStoreAsyncClient.this.executeListKeys(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutKeyResult> putKeyAsync(PutKeyRequest request) {
        return this.putKeyAsync(request, null);
    }

    @Override
    public Future<PutKeyResult> putKeyAsync(PutKeyRequest request, final AsyncHandler<PutKeyRequest, PutKeyResult> asyncHandler) {
        final PutKeyRequest finalRequest = (PutKeyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutKeyResult>(){

            @Override
            public PutKeyResult call() throws Exception {
                PutKeyResult result = null;
                try {
                    result = AmazonCloudFrontKeyValueStoreAsyncClient.this.executePutKey(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateKeysResult> updateKeysAsync(UpdateKeysRequest request) {
        return this.updateKeysAsync(request, null);
    }

    @Override
    public Future<UpdateKeysResult> updateKeysAsync(UpdateKeysRequest request, final AsyncHandler<UpdateKeysRequest, UpdateKeysResult> asyncHandler) {
        final UpdateKeysRequest finalRequest = (UpdateKeysRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateKeysResult>(){

            @Override
            public UpdateKeysResult call() throws Exception {
                UpdateKeysResult result = null;
                try {
                    result = AmazonCloudFrontKeyValueStoreAsyncClient.this.executeUpdateKeys(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

