/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudhsm;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.cloudhsm.AWSCloudHSMAsync;
import com.amazonaws.services.cloudhsm.AWSCloudHSMClient;
import com.amazonaws.services.cloudhsm.model.CreateHapgRequest;
import com.amazonaws.services.cloudhsm.model.CreateHapgResult;
import com.amazonaws.services.cloudhsm.model.CreateHsmRequest;
import com.amazonaws.services.cloudhsm.model.CreateHsmResult;
import com.amazonaws.services.cloudhsm.model.CreateLunaClientRequest;
import com.amazonaws.services.cloudhsm.model.CreateLunaClientResult;
import com.amazonaws.services.cloudhsm.model.DeleteHapgRequest;
import com.amazonaws.services.cloudhsm.model.DeleteHapgResult;
import com.amazonaws.services.cloudhsm.model.DeleteHsmRequest;
import com.amazonaws.services.cloudhsm.model.DeleteHsmResult;
import com.amazonaws.services.cloudhsm.model.DeleteLunaClientRequest;
import com.amazonaws.services.cloudhsm.model.DeleteLunaClientResult;
import com.amazonaws.services.cloudhsm.model.DescribeHapgRequest;
import com.amazonaws.services.cloudhsm.model.DescribeHapgResult;
import com.amazonaws.services.cloudhsm.model.DescribeHsmRequest;
import com.amazonaws.services.cloudhsm.model.DescribeHsmResult;
import com.amazonaws.services.cloudhsm.model.DescribeLunaClientRequest;
import com.amazonaws.services.cloudhsm.model.DescribeLunaClientResult;
import com.amazonaws.services.cloudhsm.model.GetConfigRequest;
import com.amazonaws.services.cloudhsm.model.GetConfigResult;
import com.amazonaws.services.cloudhsm.model.ListAvailableZonesRequest;
import com.amazonaws.services.cloudhsm.model.ListAvailableZonesResult;
import com.amazonaws.services.cloudhsm.model.ListHapgsRequest;
import com.amazonaws.services.cloudhsm.model.ListHapgsResult;
import com.amazonaws.services.cloudhsm.model.ListHsmsRequest;
import com.amazonaws.services.cloudhsm.model.ListHsmsResult;
import com.amazonaws.services.cloudhsm.model.ListLunaClientsRequest;
import com.amazonaws.services.cloudhsm.model.ListLunaClientsResult;
import com.amazonaws.services.cloudhsm.model.ModifyHapgRequest;
import com.amazonaws.services.cloudhsm.model.ModifyHapgResult;
import com.amazonaws.services.cloudhsm.model.ModifyHsmRequest;
import com.amazonaws.services.cloudhsm.model.ModifyHsmResult;
import com.amazonaws.services.cloudhsm.model.ModifyLunaClientRequest;
import com.amazonaws.services.cloudhsm.model.ModifyLunaClientResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSCloudHSMAsyncClient
extends AWSCloudHSMClient
implements AWSCloudHSMAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AWSCloudHSMAsyncClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    public AWSCloudHSMAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSCloudHSMAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AWSCloudHSMAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    public AWSCloudHSMAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AWSCloudHSMAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AWSCloudHSMAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSCloudHSMAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    public AWSCloudHSMAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateHapgResult> createHapgAsync(CreateHapgRequest request) {
        return this.createHapgAsync(request, null);
    }

    @Override
    public Future<CreateHapgResult> createHapgAsync(final CreateHapgRequest request, final AsyncHandler<CreateHapgRequest, CreateHapgResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateHapgResult>(){

            @Override
            public CreateHapgResult call() throws Exception {
                CreateHapgResult result;
                try {
                    result = AWSCloudHSMAsyncClient.this.createHapg(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateHsmResult> createHsmAsync(CreateHsmRequest request) {
        return this.createHsmAsync(request, null);
    }

    @Override
    public Future<CreateHsmResult> createHsmAsync(final CreateHsmRequest request, final AsyncHandler<CreateHsmRequest, CreateHsmResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateHsmResult>(){

            @Override
            public CreateHsmResult call() throws Exception {
                CreateHsmResult result;
                try {
                    result = AWSCloudHSMAsyncClient.this.createHsm(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateLunaClientResult> createLunaClientAsync(CreateLunaClientRequest request) {
        return this.createLunaClientAsync(request, null);
    }

    @Override
    public Future<CreateLunaClientResult> createLunaClientAsync(final CreateLunaClientRequest request, final AsyncHandler<CreateLunaClientRequest, CreateLunaClientResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateLunaClientResult>(){

            @Override
            public CreateLunaClientResult call() throws Exception {
                CreateLunaClientResult result;
                try {
                    result = AWSCloudHSMAsyncClient.this.createLunaClient(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteHapgResult> deleteHapgAsync(DeleteHapgRequest request) {
        return this.deleteHapgAsync(request, null);
    }

    @Override
    public Future<DeleteHapgResult> deleteHapgAsync(final DeleteHapgRequest request, final AsyncHandler<DeleteHapgRequest, DeleteHapgResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteHapgResult>(){

            @Override
            public DeleteHapgResult call() throws Exception {
                DeleteHapgResult result;
                try {
                    result = AWSCloudHSMAsyncClient.this.deleteHapg(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteHsmResult> deleteHsmAsync(DeleteHsmRequest request) {
        return this.deleteHsmAsync(request, null);
    }

    @Override
    public Future<DeleteHsmResult> deleteHsmAsync(final DeleteHsmRequest request, final AsyncHandler<DeleteHsmRequest, DeleteHsmResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteHsmResult>(){

            @Override
            public DeleteHsmResult call() throws Exception {
                DeleteHsmResult result;
                try {
                    result = AWSCloudHSMAsyncClient.this.deleteHsm(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteLunaClientResult> deleteLunaClientAsync(DeleteLunaClientRequest request) {
        return this.deleteLunaClientAsync(request, null);
    }

    @Override
    public Future<DeleteLunaClientResult> deleteLunaClientAsync(final DeleteLunaClientRequest request, final AsyncHandler<DeleteLunaClientRequest, DeleteLunaClientResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteLunaClientResult>(){

            @Override
            public DeleteLunaClientResult call() throws Exception {
                DeleteLunaClientResult result;
                try {
                    result = AWSCloudHSMAsyncClient.this.deleteLunaClient(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeHapgResult> describeHapgAsync(DescribeHapgRequest request) {
        return this.describeHapgAsync(request, null);
    }

    @Override
    public Future<DescribeHapgResult> describeHapgAsync(final DescribeHapgRequest request, final AsyncHandler<DescribeHapgRequest, DescribeHapgResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeHapgResult>(){

            @Override
            public DescribeHapgResult call() throws Exception {
                DescribeHapgResult result;
                try {
                    result = AWSCloudHSMAsyncClient.this.describeHapg(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeHsmResult> describeHsmAsync(DescribeHsmRequest request) {
        return this.describeHsmAsync(request, null);
    }

    @Override
    public Future<DescribeHsmResult> describeHsmAsync(final DescribeHsmRequest request, final AsyncHandler<DescribeHsmRequest, DescribeHsmResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeHsmResult>(){

            @Override
            public DescribeHsmResult call() throws Exception {
                DescribeHsmResult result;
                try {
                    result = AWSCloudHSMAsyncClient.this.describeHsm(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeHsmResult> describeHsmAsync() {
        return this.describeHsmAsync(new DescribeHsmRequest());
    }

    @Override
    public Future<DescribeHsmResult> describeHsmAsync(AsyncHandler<DescribeHsmRequest, DescribeHsmResult> asyncHandler) {
        return this.describeHsmAsync(new DescribeHsmRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeLunaClientResult> describeLunaClientAsync(DescribeLunaClientRequest request) {
        return this.describeLunaClientAsync(request, null);
    }

    @Override
    public Future<DescribeLunaClientResult> describeLunaClientAsync(final DescribeLunaClientRequest request, final AsyncHandler<DescribeLunaClientRequest, DescribeLunaClientResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeLunaClientResult>(){

            @Override
            public DescribeLunaClientResult call() throws Exception {
                DescribeLunaClientResult result;
                try {
                    result = AWSCloudHSMAsyncClient.this.describeLunaClient(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeLunaClientResult> describeLunaClientAsync() {
        return this.describeLunaClientAsync(new DescribeLunaClientRequest());
    }

    @Override
    public Future<DescribeLunaClientResult> describeLunaClientAsync(AsyncHandler<DescribeLunaClientRequest, DescribeLunaClientResult> asyncHandler) {
        return this.describeLunaClientAsync(new DescribeLunaClientRequest(), asyncHandler);
    }

    @Override
    public Future<GetConfigResult> getConfigAsync(GetConfigRequest request) {
        return this.getConfigAsync(request, null);
    }

    @Override
    public Future<GetConfigResult> getConfigAsync(final GetConfigRequest request, final AsyncHandler<GetConfigRequest, GetConfigResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetConfigResult>(){

            @Override
            public GetConfigResult call() throws Exception {
                GetConfigResult result;
                try {
                    result = AWSCloudHSMAsyncClient.this.getConfig(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAvailableZonesResult> listAvailableZonesAsync(ListAvailableZonesRequest request) {
        return this.listAvailableZonesAsync(request, null);
    }

    @Override
    public Future<ListAvailableZonesResult> listAvailableZonesAsync(final ListAvailableZonesRequest request, final AsyncHandler<ListAvailableZonesRequest, ListAvailableZonesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListAvailableZonesResult>(){

            @Override
            public ListAvailableZonesResult call() throws Exception {
                ListAvailableZonesResult result;
                try {
                    result = AWSCloudHSMAsyncClient.this.listAvailableZones(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAvailableZonesResult> listAvailableZonesAsync() {
        return this.listAvailableZonesAsync(new ListAvailableZonesRequest());
    }

    @Override
    public Future<ListAvailableZonesResult> listAvailableZonesAsync(AsyncHandler<ListAvailableZonesRequest, ListAvailableZonesResult> asyncHandler) {
        return this.listAvailableZonesAsync(new ListAvailableZonesRequest(), asyncHandler);
    }

    @Override
    public Future<ListHapgsResult> listHapgsAsync(ListHapgsRequest request) {
        return this.listHapgsAsync(request, null);
    }

    @Override
    public Future<ListHapgsResult> listHapgsAsync(final ListHapgsRequest request, final AsyncHandler<ListHapgsRequest, ListHapgsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListHapgsResult>(){

            @Override
            public ListHapgsResult call() throws Exception {
                ListHapgsResult result;
                try {
                    result = AWSCloudHSMAsyncClient.this.listHapgs(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListHapgsResult> listHapgsAsync() {
        return this.listHapgsAsync(new ListHapgsRequest());
    }

    @Override
    public Future<ListHapgsResult> listHapgsAsync(AsyncHandler<ListHapgsRequest, ListHapgsResult> asyncHandler) {
        return this.listHapgsAsync(new ListHapgsRequest(), asyncHandler);
    }

    @Override
    public Future<ListHsmsResult> listHsmsAsync(ListHsmsRequest request) {
        return this.listHsmsAsync(request, null);
    }

    @Override
    public Future<ListHsmsResult> listHsmsAsync(final ListHsmsRequest request, final AsyncHandler<ListHsmsRequest, ListHsmsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListHsmsResult>(){

            @Override
            public ListHsmsResult call() throws Exception {
                ListHsmsResult result;
                try {
                    result = AWSCloudHSMAsyncClient.this.listHsms(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListHsmsResult> listHsmsAsync() {
        return this.listHsmsAsync(new ListHsmsRequest());
    }

    @Override
    public Future<ListHsmsResult> listHsmsAsync(AsyncHandler<ListHsmsRequest, ListHsmsResult> asyncHandler) {
        return this.listHsmsAsync(new ListHsmsRequest(), asyncHandler);
    }

    @Override
    public Future<ListLunaClientsResult> listLunaClientsAsync(ListLunaClientsRequest request) {
        return this.listLunaClientsAsync(request, null);
    }

    @Override
    public Future<ListLunaClientsResult> listLunaClientsAsync(final ListLunaClientsRequest request, final AsyncHandler<ListLunaClientsRequest, ListLunaClientsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListLunaClientsResult>(){

            @Override
            public ListLunaClientsResult call() throws Exception {
                ListLunaClientsResult result;
                try {
                    result = AWSCloudHSMAsyncClient.this.listLunaClients(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListLunaClientsResult> listLunaClientsAsync() {
        return this.listLunaClientsAsync(new ListLunaClientsRequest());
    }

    @Override
    public Future<ListLunaClientsResult> listLunaClientsAsync(AsyncHandler<ListLunaClientsRequest, ListLunaClientsResult> asyncHandler) {
        return this.listLunaClientsAsync(new ListLunaClientsRequest(), asyncHandler);
    }

    @Override
    public Future<ModifyHapgResult> modifyHapgAsync(ModifyHapgRequest request) {
        return this.modifyHapgAsync(request, null);
    }

    @Override
    public Future<ModifyHapgResult> modifyHapgAsync(final ModifyHapgRequest request, final AsyncHandler<ModifyHapgRequest, ModifyHapgResult> asyncHandler) {
        return this.executorService.submit(new Callable<ModifyHapgResult>(){

            @Override
            public ModifyHapgResult call() throws Exception {
                ModifyHapgResult result;
                try {
                    result = AWSCloudHSMAsyncClient.this.modifyHapg(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ModifyHsmResult> modifyHsmAsync(ModifyHsmRequest request) {
        return this.modifyHsmAsync(request, null);
    }

    @Override
    public Future<ModifyHsmResult> modifyHsmAsync(final ModifyHsmRequest request, final AsyncHandler<ModifyHsmRequest, ModifyHsmResult> asyncHandler) {
        return this.executorService.submit(new Callable<ModifyHsmResult>(){

            @Override
            public ModifyHsmResult call() throws Exception {
                ModifyHsmResult result;
                try {
                    result = AWSCloudHSMAsyncClient.this.modifyHsm(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ModifyLunaClientResult> modifyLunaClientAsync(ModifyLunaClientRequest request) {
        return this.modifyLunaClientAsync(request, null);
    }

    @Override
    public Future<ModifyLunaClientResult> modifyLunaClientAsync(final ModifyLunaClientRequest request, final AsyncHandler<ModifyLunaClientRequest, ModifyLunaClientResult> asyncHandler) {
        return this.executorService.submit(new Callable<ModifyLunaClientResult>(){

            @Override
            public ModifyLunaClientResult call() throws Exception {
                ModifyLunaClientResult result;
                try {
                    result = AWSCloudHSMAsyncClient.this.modifyLunaClient(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

