/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudhsmv2;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.cloudhsmv2.AWSCloudHSMV2Async;
import com.amazonaws.services.cloudhsmv2.AWSCloudHSMV2AsyncClientBuilder;
import com.amazonaws.services.cloudhsmv2.AWSCloudHSMV2Client;
import com.amazonaws.services.cloudhsmv2.model.CopyBackupToRegionRequest;
import com.amazonaws.services.cloudhsmv2.model.CopyBackupToRegionResult;
import com.amazonaws.services.cloudhsmv2.model.CreateClusterRequest;
import com.amazonaws.services.cloudhsmv2.model.CreateClusterResult;
import com.amazonaws.services.cloudhsmv2.model.CreateHsmRequest;
import com.amazonaws.services.cloudhsmv2.model.CreateHsmResult;
import com.amazonaws.services.cloudhsmv2.model.DeleteBackupRequest;
import com.amazonaws.services.cloudhsmv2.model.DeleteBackupResult;
import com.amazonaws.services.cloudhsmv2.model.DeleteClusterRequest;
import com.amazonaws.services.cloudhsmv2.model.DeleteClusterResult;
import com.amazonaws.services.cloudhsmv2.model.DeleteHsmRequest;
import com.amazonaws.services.cloudhsmv2.model.DeleteHsmResult;
import com.amazonaws.services.cloudhsmv2.model.DescribeBackupsRequest;
import com.amazonaws.services.cloudhsmv2.model.DescribeBackupsResult;
import com.amazonaws.services.cloudhsmv2.model.DescribeClustersRequest;
import com.amazonaws.services.cloudhsmv2.model.DescribeClustersResult;
import com.amazonaws.services.cloudhsmv2.model.InitializeClusterRequest;
import com.amazonaws.services.cloudhsmv2.model.InitializeClusterResult;
import com.amazonaws.services.cloudhsmv2.model.ListTagsRequest;
import com.amazonaws.services.cloudhsmv2.model.ListTagsResult;
import com.amazonaws.services.cloudhsmv2.model.ModifyBackupAttributesRequest;
import com.amazonaws.services.cloudhsmv2.model.ModifyBackupAttributesResult;
import com.amazonaws.services.cloudhsmv2.model.ModifyClusterRequest;
import com.amazonaws.services.cloudhsmv2.model.ModifyClusterResult;
import com.amazonaws.services.cloudhsmv2.model.RestoreBackupRequest;
import com.amazonaws.services.cloudhsmv2.model.RestoreBackupResult;
import com.amazonaws.services.cloudhsmv2.model.TagResourceRequest;
import com.amazonaws.services.cloudhsmv2.model.TagResourceResult;
import com.amazonaws.services.cloudhsmv2.model.UntagResourceRequest;
import com.amazonaws.services.cloudhsmv2.model.UntagResourceResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSCloudHSMV2AsyncClient
extends AWSCloudHSMV2Client
implements AWSCloudHSMV2Async {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSCloudHSMV2AsyncClientBuilder asyncBuilder() {
        return AWSCloudHSMV2AsyncClientBuilder.standard();
    }

    AWSCloudHSMV2AsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSCloudHSMV2AsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CopyBackupToRegionResult> copyBackupToRegionAsync(CopyBackupToRegionRequest request) {
        return this.copyBackupToRegionAsync(request, null);
    }

    @Override
    public Future<CopyBackupToRegionResult> copyBackupToRegionAsync(CopyBackupToRegionRequest request, final AsyncHandler<CopyBackupToRegionRequest, CopyBackupToRegionResult> asyncHandler) {
        final CopyBackupToRegionRequest finalRequest = (CopyBackupToRegionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CopyBackupToRegionResult>(){

            @Override
            public CopyBackupToRegionResult call() throws Exception {
                CopyBackupToRegionResult result = null;
                try {
                    result = AWSCloudHSMV2AsyncClient.this.executeCopyBackupToRegion(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateClusterResult> createClusterAsync(CreateClusterRequest request) {
        return this.createClusterAsync(request, null);
    }

    @Override
    public Future<CreateClusterResult> createClusterAsync(CreateClusterRequest request, final AsyncHandler<CreateClusterRequest, CreateClusterResult> asyncHandler) {
        final CreateClusterRequest finalRequest = (CreateClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateClusterResult>(){

            @Override
            public CreateClusterResult call() throws Exception {
                CreateClusterResult result = null;
                try {
                    result = AWSCloudHSMV2AsyncClient.this.executeCreateCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateHsmResult> createHsmAsync(CreateHsmRequest request) {
        return this.createHsmAsync(request, null);
    }

    @Override
    public Future<CreateHsmResult> createHsmAsync(CreateHsmRequest request, final AsyncHandler<CreateHsmRequest, CreateHsmResult> asyncHandler) {
        final CreateHsmRequest finalRequest = (CreateHsmRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateHsmResult>(){

            @Override
            public CreateHsmResult call() throws Exception {
                CreateHsmResult result = null;
                try {
                    result = AWSCloudHSMV2AsyncClient.this.executeCreateHsm(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteBackupResult> deleteBackupAsync(DeleteBackupRequest request) {
        return this.deleteBackupAsync(request, null);
    }

    @Override
    public Future<DeleteBackupResult> deleteBackupAsync(DeleteBackupRequest request, final AsyncHandler<DeleteBackupRequest, DeleteBackupResult> asyncHandler) {
        final DeleteBackupRequest finalRequest = (DeleteBackupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteBackupResult>(){

            @Override
            public DeleteBackupResult call() throws Exception {
                DeleteBackupResult result = null;
                try {
                    result = AWSCloudHSMV2AsyncClient.this.executeDeleteBackup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteClusterResult> deleteClusterAsync(DeleteClusterRequest request) {
        return this.deleteClusterAsync(request, null);
    }

    @Override
    public Future<DeleteClusterResult> deleteClusterAsync(DeleteClusterRequest request, final AsyncHandler<DeleteClusterRequest, DeleteClusterResult> asyncHandler) {
        final DeleteClusterRequest finalRequest = (DeleteClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteClusterResult>(){

            @Override
            public DeleteClusterResult call() throws Exception {
                DeleteClusterResult result = null;
                try {
                    result = AWSCloudHSMV2AsyncClient.this.executeDeleteCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteHsmResult> deleteHsmAsync(DeleteHsmRequest request) {
        return this.deleteHsmAsync(request, null);
    }

    @Override
    public Future<DeleteHsmResult> deleteHsmAsync(DeleteHsmRequest request, final AsyncHandler<DeleteHsmRequest, DeleteHsmResult> asyncHandler) {
        final DeleteHsmRequest finalRequest = (DeleteHsmRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteHsmResult>(){

            @Override
            public DeleteHsmResult call() throws Exception {
                DeleteHsmResult result = null;
                try {
                    result = AWSCloudHSMV2AsyncClient.this.executeDeleteHsm(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeBackupsResult> describeBackupsAsync(DescribeBackupsRequest request) {
        return this.describeBackupsAsync(request, null);
    }

    @Override
    public Future<DescribeBackupsResult> describeBackupsAsync(DescribeBackupsRequest request, final AsyncHandler<DescribeBackupsRequest, DescribeBackupsResult> asyncHandler) {
        final DescribeBackupsRequest finalRequest = (DescribeBackupsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeBackupsResult>(){

            @Override
            public DescribeBackupsResult call() throws Exception {
                DescribeBackupsResult result = null;
                try {
                    result = AWSCloudHSMV2AsyncClient.this.executeDescribeBackups(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeClustersResult> describeClustersAsync(DescribeClustersRequest request) {
        return this.describeClustersAsync(request, null);
    }

    @Override
    public Future<DescribeClustersResult> describeClustersAsync(DescribeClustersRequest request, final AsyncHandler<DescribeClustersRequest, DescribeClustersResult> asyncHandler) {
        final DescribeClustersRequest finalRequest = (DescribeClustersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeClustersResult>(){

            @Override
            public DescribeClustersResult call() throws Exception {
                DescribeClustersResult result = null;
                try {
                    result = AWSCloudHSMV2AsyncClient.this.executeDescribeClusters(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<InitializeClusterResult> initializeClusterAsync(InitializeClusterRequest request) {
        return this.initializeClusterAsync(request, null);
    }

    @Override
    public Future<InitializeClusterResult> initializeClusterAsync(InitializeClusterRequest request, final AsyncHandler<InitializeClusterRequest, InitializeClusterResult> asyncHandler) {
        final InitializeClusterRequest finalRequest = (InitializeClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<InitializeClusterResult>(){

            @Override
            public InitializeClusterResult call() throws Exception {
                InitializeClusterResult result = null;
                try {
                    result = AWSCloudHSMV2AsyncClient.this.executeInitializeCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsResult> listTagsAsync(ListTagsRequest request) {
        return this.listTagsAsync(request, null);
    }

    @Override
    public Future<ListTagsResult> listTagsAsync(ListTagsRequest request, final AsyncHandler<ListTagsRequest, ListTagsResult> asyncHandler) {
        final ListTagsRequest finalRequest = (ListTagsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsResult>(){

            @Override
            public ListTagsResult call() throws Exception {
                ListTagsResult result = null;
                try {
                    result = AWSCloudHSMV2AsyncClient.this.executeListTags(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ModifyBackupAttributesResult> modifyBackupAttributesAsync(ModifyBackupAttributesRequest request) {
        return this.modifyBackupAttributesAsync(request, null);
    }

    @Override
    public Future<ModifyBackupAttributesResult> modifyBackupAttributesAsync(ModifyBackupAttributesRequest request, final AsyncHandler<ModifyBackupAttributesRequest, ModifyBackupAttributesResult> asyncHandler) {
        final ModifyBackupAttributesRequest finalRequest = (ModifyBackupAttributesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ModifyBackupAttributesResult>(){

            @Override
            public ModifyBackupAttributesResult call() throws Exception {
                ModifyBackupAttributesResult result = null;
                try {
                    result = AWSCloudHSMV2AsyncClient.this.executeModifyBackupAttributes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ModifyClusterResult> modifyClusterAsync(ModifyClusterRequest request) {
        return this.modifyClusterAsync(request, null);
    }

    @Override
    public Future<ModifyClusterResult> modifyClusterAsync(ModifyClusterRequest request, final AsyncHandler<ModifyClusterRequest, ModifyClusterResult> asyncHandler) {
        final ModifyClusterRequest finalRequest = (ModifyClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ModifyClusterResult>(){

            @Override
            public ModifyClusterResult call() throws Exception {
                ModifyClusterResult result = null;
                try {
                    result = AWSCloudHSMV2AsyncClient.this.executeModifyCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RestoreBackupResult> restoreBackupAsync(RestoreBackupRequest request) {
        return this.restoreBackupAsync(request, null);
    }

    @Override
    public Future<RestoreBackupResult> restoreBackupAsync(RestoreBackupRequest request, final AsyncHandler<RestoreBackupRequest, RestoreBackupResult> asyncHandler) {
        final RestoreBackupRequest finalRequest = (RestoreBackupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RestoreBackupResult>(){

            @Override
            public RestoreBackupResult call() throws Exception {
                RestoreBackupResult result = null;
                try {
                    result = AWSCloudHSMV2AsyncClient.this.executeRestoreBackup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSCloudHSMV2AsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSCloudHSMV2AsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

