/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchdomain.model;

import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.services.cloudsearchdomain.model.BucketInfo;
import com.amazonaws.services.cloudsearchdomain.model.Hits;
import com.amazonaws.services.cloudsearchdomain.model.SearchStatus;
import java.io.Serializable;
import java.util.Map;

public class SearchResult
implements Serializable,
Cloneable {
    private SearchStatus status;
    private Hits hits;
    private SdkInternalMap<String, BucketInfo> facets;

    public void setStatus(SearchStatus status) {
        this.status = status;
    }

    public SearchStatus getStatus() {
        return this.status;
    }

    public SearchResult withStatus(SearchStatus status) {
        this.setStatus(status);
        return this;
    }

    public void setHits(Hits hits) {
        this.hits = hits;
    }

    public Hits getHits() {
        return this.hits;
    }

    public SearchResult withHits(Hits hits) {
        this.setHits(hits);
        return this;
    }

    public Map<String, BucketInfo> getFacets() {
        if (this.facets == null) {
            this.facets = new SdkInternalMap();
        }
        return this.facets;
    }

    public void setFacets(Map<String, BucketInfo> facets) {
        this.facets = facets == null ? null : new SdkInternalMap(facets);
    }

    public SearchResult withFacets(Map<String, BucketInfo> facets) {
        this.setFacets(facets);
        return this;
    }

    public SearchResult addFacetsEntry(String key, BucketInfo value) {
        if (null == this.facets) {
            this.facets = new SdkInternalMap();
        }
        if (this.facets.containsKey((Object)key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.facets.put((Object)key, (Object)value);
        return this;
    }

    public SearchResult clearFacetsEntries() {
        this.facets = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStatus() != null) {
            sb.append("Status: " + this.getStatus() + ",");
        }
        if (this.getHits() != null) {
            sb.append("Hits: " + this.getHits() + ",");
        }
        if (this.getFacets() != null) {
            sb.append("Facets: " + this.getFacets());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchResult)) {
            return false;
        }
        SearchResult other = (SearchResult)obj;
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getHits() == null ^ this.getHits() == null) {
            return false;
        }
        if (other.getHits() != null && !other.getHits().equals(this.getHits())) {
            return false;
        }
        if (other.getFacets() == null ^ this.getFacets() == null) {
            return false;
        }
        return other.getFacets() == null || other.getFacets().equals(this.getFacets());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getHits() == null ? 0 : this.getHits().hashCode());
        hashCode = 31 * hashCode + (this.getFacets() == null ? 0 : this.getFacets().hashCode());
        return hashCode;
    }

    public SearchResult clone() {
        try {
            return (SearchResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

