/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchdomain.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudsearchdomain.model.Hit;
import com.amazonaws.services.cloudsearchdomain.model.Hits;
import com.amazonaws.services.cloudsearchdomain.model.transform.HitJsonMarshaller;
import com.amazonaws.util.json.SdkJsonGenerator;

public class HitsJsonMarshaller {
    private static HitsJsonMarshaller instance;

    public void marshall(Hits hits, SdkJsonGenerator jsonGenerator) {
        if (hits == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList hitList;
            jsonGenerator.writeStartObject();
            if (hits.getFound() != null) {
                jsonGenerator.writeFieldName("found").writeValue(hits.getFound().longValue());
            }
            if (hits.getStart() != null) {
                jsonGenerator.writeFieldName("start").writeValue(hits.getStart().longValue());
            }
            if (hits.getCursor() != null) {
                jsonGenerator.writeFieldName("cursor").writeValue(hits.getCursor());
            }
            if (!(hitList = (SdkInternalList)hits.getHit()).isEmpty() || !hitList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("hit");
                jsonGenerator.writeStartArray();
                for (Hit hitListValue : hitList) {
                    if (hitListValue == null) continue;
                    HitJsonMarshaller.getInstance().marshall(hitListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static HitsJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new HitsJsonMarshaller();
        }
        return instance;
    }
}

