/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudsearchv2.model.DescribeSuggestersRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeSuggestersRequestMarshaller
implements Marshaller<Request<DescribeSuggestersRequest>, DescribeSuggestersRequest> {
    public Request<DescribeSuggestersRequest> marshall(DescribeSuggestersRequest describeSuggestersRequest) {
        SdkInternalList suggesterNamesList;
        if (describeSuggestersRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeSuggestersRequest, "AmazonCloudSearchv2");
        request.addParameter("Action", "DescribeSuggesters");
        request.addParameter("Version", "2013-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeSuggestersRequest.getDomainName() != null) {
            request.addParameter("DomainName", StringUtils.fromString((String)describeSuggestersRequest.getDomainName()));
        }
        if (!(suggesterNamesList = (SdkInternalList)describeSuggestersRequest.getSuggesterNames()).isEmpty() || !suggesterNamesList.isAutoConstruct()) {
            int suggesterNamesListIndex = 1;
            for (String suggesterNamesListValue : suggesterNamesList) {
                if (suggesterNamesListValue != null) {
                    request.addParameter("SuggesterNames.member." + suggesterNamesListIndex, StringUtils.fromString((String)suggesterNamesListValue));
                }
                ++suggesterNamesListIndex;
            }
        }
        if (describeSuggestersRequest.getDeployed() != null) {
            request.addParameter("Deployed", StringUtils.fromBoolean((Boolean)describeSuggestersRequest.getDeployed()));
        }
        return request;
    }
}

