/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchv2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudsearchv2.model.DescribeExpressionsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeExpressionsRequestMarshaller
implements Marshaller<Request<DescribeExpressionsRequest>, DescribeExpressionsRequest> {
    public Request<DescribeExpressionsRequest> marshall(DescribeExpressionsRequest describeExpressionsRequest) {
        SdkInternalList expressionNamesList;
        if (describeExpressionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeExpressionsRequest, "AmazonCloudSearchv2");
        request.addParameter("Action", "DescribeExpressions");
        request.addParameter("Version", "2013-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeExpressionsRequest.getDomainName() != null) {
            request.addParameter("DomainName", StringUtils.fromString((String)describeExpressionsRequest.getDomainName()));
        }
        if (!(expressionNamesList = (SdkInternalList)describeExpressionsRequest.getExpressionNames()).isEmpty() || !expressionNamesList.isAutoConstruct()) {
            int expressionNamesListIndex = 1;
            for (String expressionNamesListValue : expressionNamesList) {
                if (expressionNamesListValue != null) {
                    request.addParameter("ExpressionNames.member." + expressionNamesListIndex, StringUtils.fromString((String)expressionNamesListValue));
                }
                ++expressionNamesListIndex;
            }
        }
        if (describeExpressionsRequest.getDeployed() != null) {
            request.addParameter("Deployed", StringUtils.fromBoolean((Boolean)describeExpressionsRequest.getDeployed()));
        }
        return request;
    }
}

