/*
 * Copyright 2011-2016 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not
 * use this file except in compliance with the License. A copy of the License is
 * located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package com.amazonaws.services.cloudsearchv2.model.transform;

import java.util.Map;
import java.util.HashMap;
import java.util.ArrayList;
import java.util.Map.Entry;

import javax.xml.stream.events.XMLEvent;

import com.amazonaws.services.cloudsearchv2.model.*;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.transform.MapEntry;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ListDomainNamesResult StAX Unmarshaller
 */
public class ListDomainNamesResultStaxUnmarshaller implements
        Unmarshaller<ListDomainNamesResult, StaxUnmarshallerContext> {

    private static class DomainNamesMapEntryUnmarshaller implements
            Unmarshaller<Map.Entry<String, String>, StaxUnmarshallerContext> {

        @Override
        public Entry<String, String> unmarshall(StaxUnmarshallerContext context)
                throws Exception {
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;

            MapEntry<String, String> entry = new MapEntry<String, String>();

            while (true) {
                XMLEvent xmlEvent = context.nextEvent();
                if (xmlEvent.isEndDocument())
                    return entry;

                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("key", targetDepth)) {
                        entry.setKey(StringStaxUnmarshaller.getInstance()
                                .unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("value", targetDepth)) {
                        entry.setValue(StringStaxUnmarshaller.getInstance()
                                .unmarshall(context));
                        continue;
                    }
                } else if (xmlEvent.isEndElement()) {
                    if (context.getCurrentDepth() < originalDepth)
                        return entry;
                }
            }
        }

        private static DomainNamesMapEntryUnmarshaller instance;

        public static DomainNamesMapEntryUnmarshaller getInstance() {
            if (instance == null)
                instance = new DomainNamesMapEntryUnmarshaller();
            return instance;
        }

    }

    public ListDomainNamesResult unmarshall(StaxUnmarshallerContext context)
            throws Exception {
        ListDomainNamesResult listDomainNamesResult = new ListDomainNamesResult();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 2;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument())
                return listDomainNamesResult;

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("DomainNames/entry", targetDepth)) {
                    Entry<String, String> entry = DomainNamesMapEntryUnmarshaller
                            .getInstance().unmarshall(context);
                    listDomainNamesResult.addDomainNamesEntry(entry.getKey(),
                            entry.getValue());
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    return listDomainNamesResult;
                }
            }
        }
    }

    private static ListDomainNamesResultStaxUnmarshaller instance;

    public static ListDomainNamesResultStaxUnmarshaller getInstance() {
        if (instance == null)
            instance = new ListDomainNamesResultStaxUnmarshaller();
        return instance;
    }
}
