/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchv2.model.transform;

import com.amazonaws.services.cloudsearchv2.model.Limits;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class LimitsStaxUnmarshaller
implements Unmarshaller<Limits, StaxUnmarshallerContext> {
    private static LimitsStaxUnmarshaller instance;

    public Limits unmarshall(StaxUnmarshallerContext context) throws Exception {
        Limits limits = new Limits();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return limits;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("MaximumReplicationCount", targetDepth)) {
                    limits.setMaximumReplicationCount(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("MaximumPartitionCount", targetDepth)) continue;
                limits.setMaximumPartitionCount(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return limits;
    }

    public static LimitsStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new LimitsStaxUnmarshaller();
        }
        return instance;
    }
}

