/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.cloudsearchv2;

import javax.annotation.Generated;

import com.amazonaws.services.cloudsearchv2.model.*;

/**
 * Abstract implementation of {@code AmazonCloudSearchAsync}. Convenient method forms pass through to the corresponding
 * overload that takes a request object and an {@code AsyncHandler}, which throws an
 * {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonCloudSearchAsync extends AbstractAmazonCloudSearch implements AmazonCloudSearchAsync {

    protected AbstractAmazonCloudSearchAsync() {
    }

    @Override
    public java.util.concurrent.Future<BuildSuggestersResult> buildSuggestersAsync(BuildSuggestersRequest request) {

        return buildSuggestersAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<BuildSuggestersResult> buildSuggestersAsync(BuildSuggestersRequest request,
            com.amazonaws.handlers.AsyncHandler<BuildSuggestersRequest, BuildSuggestersResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateDomainResult> createDomainAsync(CreateDomainRequest request) {

        return createDomainAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateDomainResult> createDomainAsync(CreateDomainRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateDomainRequest, CreateDomainResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DefineAnalysisSchemeResult> defineAnalysisSchemeAsync(DefineAnalysisSchemeRequest request) {

        return defineAnalysisSchemeAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DefineAnalysisSchemeResult> defineAnalysisSchemeAsync(DefineAnalysisSchemeRequest request,
            com.amazonaws.handlers.AsyncHandler<DefineAnalysisSchemeRequest, DefineAnalysisSchemeResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DefineExpressionResult> defineExpressionAsync(DefineExpressionRequest request) {

        return defineExpressionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DefineExpressionResult> defineExpressionAsync(DefineExpressionRequest request,
            com.amazonaws.handlers.AsyncHandler<DefineExpressionRequest, DefineExpressionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DefineIndexFieldResult> defineIndexFieldAsync(DefineIndexFieldRequest request) {

        return defineIndexFieldAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DefineIndexFieldResult> defineIndexFieldAsync(DefineIndexFieldRequest request,
            com.amazonaws.handlers.AsyncHandler<DefineIndexFieldRequest, DefineIndexFieldResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DefineSuggesterResult> defineSuggesterAsync(DefineSuggesterRequest request) {

        return defineSuggesterAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DefineSuggesterResult> defineSuggesterAsync(DefineSuggesterRequest request,
            com.amazonaws.handlers.AsyncHandler<DefineSuggesterRequest, DefineSuggesterResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteAnalysisSchemeResult> deleteAnalysisSchemeAsync(DeleteAnalysisSchemeRequest request) {

        return deleteAnalysisSchemeAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteAnalysisSchemeResult> deleteAnalysisSchemeAsync(DeleteAnalysisSchemeRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteAnalysisSchemeRequest, DeleteAnalysisSchemeResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteDomainResult> deleteDomainAsync(DeleteDomainRequest request) {

        return deleteDomainAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteDomainResult> deleteDomainAsync(DeleteDomainRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteDomainRequest, DeleteDomainResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteExpressionResult> deleteExpressionAsync(DeleteExpressionRequest request) {

        return deleteExpressionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteExpressionResult> deleteExpressionAsync(DeleteExpressionRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteExpressionRequest, DeleteExpressionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteIndexFieldResult> deleteIndexFieldAsync(DeleteIndexFieldRequest request) {

        return deleteIndexFieldAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteIndexFieldResult> deleteIndexFieldAsync(DeleteIndexFieldRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteIndexFieldRequest, DeleteIndexFieldResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteSuggesterResult> deleteSuggesterAsync(DeleteSuggesterRequest request) {

        return deleteSuggesterAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteSuggesterResult> deleteSuggesterAsync(DeleteSuggesterRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteSuggesterRequest, DeleteSuggesterResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeAnalysisSchemesResult> describeAnalysisSchemesAsync(DescribeAnalysisSchemesRequest request) {

        return describeAnalysisSchemesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeAnalysisSchemesResult> describeAnalysisSchemesAsync(DescribeAnalysisSchemesRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeAnalysisSchemesRequest, DescribeAnalysisSchemesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeAvailabilityOptionsResult> describeAvailabilityOptionsAsync(DescribeAvailabilityOptionsRequest request) {

        return describeAvailabilityOptionsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeAvailabilityOptionsResult> describeAvailabilityOptionsAsync(DescribeAvailabilityOptionsRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeAvailabilityOptionsRequest, DescribeAvailabilityOptionsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeDomainsResult> describeDomainsAsync(DescribeDomainsRequest request) {

        return describeDomainsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeDomainsResult> describeDomainsAsync(DescribeDomainsRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeDomainsRequest, DescribeDomainsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * Simplified method form for invoking the DescribeDomains operation.
     *
     * @see #describeDomainsAsync(DescribeDomainsRequest)
     */
    @Override
    public java.util.concurrent.Future<DescribeDomainsResult> describeDomainsAsync() {

        return describeDomainsAsync(new DescribeDomainsRequest());
    }

    /**
     * Simplified method form for invoking the DescribeDomains operation with an AsyncHandler.
     *
     * @see #describeDomainsAsync(DescribeDomainsRequest, com.amazonaws.handlers.AsyncHandler)
     */
    @Override
    public java.util.concurrent.Future<DescribeDomainsResult> describeDomainsAsync(
            com.amazonaws.handlers.AsyncHandler<DescribeDomainsRequest, DescribeDomainsResult> asyncHandler) {

        return describeDomainsAsync(new DescribeDomainsRequest(), asyncHandler);
    }

    @Override
    public java.util.concurrent.Future<DescribeExpressionsResult> describeExpressionsAsync(DescribeExpressionsRequest request) {

        return describeExpressionsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeExpressionsResult> describeExpressionsAsync(DescribeExpressionsRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeExpressionsRequest, DescribeExpressionsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeIndexFieldsResult> describeIndexFieldsAsync(DescribeIndexFieldsRequest request) {

        return describeIndexFieldsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeIndexFieldsResult> describeIndexFieldsAsync(DescribeIndexFieldsRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeIndexFieldsRequest, DescribeIndexFieldsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeScalingParametersResult> describeScalingParametersAsync(DescribeScalingParametersRequest request) {

        return describeScalingParametersAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeScalingParametersResult> describeScalingParametersAsync(DescribeScalingParametersRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeScalingParametersRequest, DescribeScalingParametersResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeServiceAccessPoliciesResult> describeServiceAccessPoliciesAsync(DescribeServiceAccessPoliciesRequest request) {

        return describeServiceAccessPoliciesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeServiceAccessPoliciesResult> describeServiceAccessPoliciesAsync(DescribeServiceAccessPoliciesRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeServiceAccessPoliciesRequest, DescribeServiceAccessPoliciesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeSuggestersResult> describeSuggestersAsync(DescribeSuggestersRequest request) {

        return describeSuggestersAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeSuggestersResult> describeSuggestersAsync(DescribeSuggestersRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeSuggestersRequest, DescribeSuggestersResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<IndexDocumentsResult> indexDocumentsAsync(IndexDocumentsRequest request) {

        return indexDocumentsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<IndexDocumentsResult> indexDocumentsAsync(IndexDocumentsRequest request,
            com.amazonaws.handlers.AsyncHandler<IndexDocumentsRequest, IndexDocumentsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListDomainNamesResult> listDomainNamesAsync(ListDomainNamesRequest request) {

        return listDomainNamesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListDomainNamesResult> listDomainNamesAsync(ListDomainNamesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListDomainNamesRequest, ListDomainNamesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * Simplified method form for invoking the ListDomainNames operation.
     *
     * @see #listDomainNamesAsync(ListDomainNamesRequest)
     */
    @Override
    public java.util.concurrent.Future<ListDomainNamesResult> listDomainNamesAsync() {

        return listDomainNamesAsync(new ListDomainNamesRequest());
    }

    /**
     * Simplified method form for invoking the ListDomainNames operation with an AsyncHandler.
     *
     * @see #listDomainNamesAsync(ListDomainNamesRequest, com.amazonaws.handlers.AsyncHandler)
     */
    @Override
    public java.util.concurrent.Future<ListDomainNamesResult> listDomainNamesAsync(
            com.amazonaws.handlers.AsyncHandler<ListDomainNamesRequest, ListDomainNamesResult> asyncHandler) {

        return listDomainNamesAsync(new ListDomainNamesRequest(), asyncHandler);
    }

    @Override
    public java.util.concurrent.Future<UpdateAvailabilityOptionsResult> updateAvailabilityOptionsAsync(UpdateAvailabilityOptionsRequest request) {

        return updateAvailabilityOptionsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateAvailabilityOptionsResult> updateAvailabilityOptionsAsync(UpdateAvailabilityOptionsRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateAvailabilityOptionsRequest, UpdateAvailabilityOptionsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateScalingParametersResult> updateScalingParametersAsync(UpdateScalingParametersRequest request) {

        return updateScalingParametersAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateScalingParametersResult> updateScalingParametersAsync(UpdateScalingParametersRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateScalingParametersRequest, UpdateScalingParametersResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateServiceAccessPoliciesResult> updateServiceAccessPoliciesAsync(UpdateServiceAccessPoliciesRequest request) {

        return updateServiceAccessPoliciesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateServiceAccessPoliciesResult> updateServiceAccessPoliciesAsync(UpdateServiceAccessPoliciesRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateServiceAccessPoliciesRequest, UpdateServiceAccessPoliciesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

}
