/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchdomain.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.cloudsearchdomain.model.UploadDocumentsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.UriResourcePathUtils;

public class UploadDocumentsRequestMarshaller
implements Marshaller<Request<UploadDocumentsRequest>, UploadDocumentsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public UploadDocumentsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<UploadDocumentsRequest> marshall(UploadDocumentsRequest uploadDocumentsRequest) {
        if (uploadDocumentsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)uploadDocumentsRequest, "AmazonCloudSearchDomain");
        request.setHttpMethod(HttpMethodName.POST);
        if (uploadDocumentsRequest.getContentType() != null) {
            request.addHeader("Content-Type", StringUtils.fromString((String)uploadDocumentsRequest.getContentType()));
        }
        if (uploadDocumentsRequest.getContentLength() != null) {
            request.addHeader("Content-Length", StringUtils.fromLong((Long)uploadDocumentsRequest.getContentLength()));
        }
        String uriResourcePath = "/2013-01-01/documents/batch?format=sdk";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParamtersToRequest((Request)request, (String)uriResourcePath);
        request.setResourcePath(uriResourcePath);
        request.setContent(uploadDocumentsRequest.getDocuments());
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

