/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmsForMetricRequest;
import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeAlarmsForMetricRequestMarshaller
implements Marshaller<Request<DescribeAlarmsForMetricRequest>, DescribeAlarmsForMetricRequest> {
    public Request<DescribeAlarmsForMetricRequest> marshall(DescribeAlarmsForMetricRequest describeAlarmsForMetricRequest) {
        SdkInternalList dimensionsList;
        if (describeAlarmsForMetricRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeAlarmsForMetricRequest, "AmazonCloudWatch");
        request.addParameter("Action", "DescribeAlarmsForMetric");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeAlarmsForMetricRequest.getMetricName() != null) {
            request.addParameter("MetricName", StringUtils.fromString((String)describeAlarmsForMetricRequest.getMetricName()));
        }
        if (describeAlarmsForMetricRequest.getNamespace() != null) {
            request.addParameter("Namespace", StringUtils.fromString((String)describeAlarmsForMetricRequest.getNamespace()));
        }
        if (describeAlarmsForMetricRequest.getStatistic() != null) {
            request.addParameter("Statistic", StringUtils.fromString((String)describeAlarmsForMetricRequest.getStatistic()));
        }
        if (!(dimensionsList = (SdkInternalList)describeAlarmsForMetricRequest.getDimensions()).isEmpty() || !dimensionsList.isAutoConstruct()) {
            int dimensionsListIndex = 1;
            for (Dimension dimensionsListValue : dimensionsList) {
                if (dimensionsListValue.getName() != null) {
                    request.addParameter("Dimensions.member." + dimensionsListIndex + ".Name", StringUtils.fromString((String)dimensionsListValue.getName()));
                }
                if (dimensionsListValue.getValue() != null) {
                    request.addParameter("Dimensions.member." + dimensionsListIndex + ".Value", StringUtils.fromString((String)dimensionsListValue.getValue()));
                }
                ++dimensionsListIndex;
            }
        }
        if (describeAlarmsForMetricRequest.getPeriod() != null) {
            request.addParameter("Period", StringUtils.fromInteger((Integer)describeAlarmsForMetricRequest.getPeriod()));
        }
        if (describeAlarmsForMetricRequest.getUnit() != null) {
            request.addParameter("Unit", StringUtils.fromString((String)describeAlarmsForMetricRequest.getUnit()));
        }
        return request;
    }
}

