/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchAsync;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchClient;
import com.amazonaws.services.cloudwatch.model.DeleteAlarmsRequest;
import com.amazonaws.services.cloudwatch.model.DeleteAlarmsResult;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmHistoryRequest;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmHistoryResult;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmsForMetricRequest;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmsForMetricResult;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmsRequest;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmsResult;
import com.amazonaws.services.cloudwatch.model.DisableAlarmActionsRequest;
import com.amazonaws.services.cloudwatch.model.DisableAlarmActionsResult;
import com.amazonaws.services.cloudwatch.model.EnableAlarmActionsRequest;
import com.amazonaws.services.cloudwatch.model.EnableAlarmActionsResult;
import com.amazonaws.services.cloudwatch.model.GetMetricStatisticsRequest;
import com.amazonaws.services.cloudwatch.model.GetMetricStatisticsResult;
import com.amazonaws.services.cloudwatch.model.ListMetricsRequest;
import com.amazonaws.services.cloudwatch.model.ListMetricsResult;
import com.amazonaws.services.cloudwatch.model.PutMetricAlarmRequest;
import com.amazonaws.services.cloudwatch.model.PutMetricAlarmResult;
import com.amazonaws.services.cloudwatch.model.PutMetricDataRequest;
import com.amazonaws.services.cloudwatch.model.PutMetricDataResult;
import com.amazonaws.services.cloudwatch.model.SetAlarmStateRequest;
import com.amazonaws.services.cloudwatch.model.SetAlarmStateResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonCloudWatchAsyncClient
extends AmazonCloudWatchClient
implements AmazonCloudWatchAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AmazonCloudWatchAsyncClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    public AmazonCloudWatchAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonCloudWatchAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonCloudWatchAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    public AmazonCloudWatchAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonCloudWatchAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonCloudWatchAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonCloudWatchAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    public AmazonCloudWatchAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    AmazonCloudWatchAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<DeleteAlarmsResult> deleteAlarmsAsync(DeleteAlarmsRequest request) {
        return this.deleteAlarmsAsync(request, null);
    }

    @Override
    public Future<DeleteAlarmsResult> deleteAlarmsAsync(final DeleteAlarmsRequest request, final AsyncHandler<DeleteAlarmsRequest, DeleteAlarmsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteAlarmsResult>(){

            @Override
            public DeleteAlarmsResult call() throws Exception {
                DeleteAlarmsResult result;
                try {
                    result = AmazonCloudWatchAsyncClient.this.deleteAlarms(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAlarmHistoryResult> describeAlarmHistoryAsync(DescribeAlarmHistoryRequest request) {
        return this.describeAlarmHistoryAsync(request, null);
    }

    @Override
    public Future<DescribeAlarmHistoryResult> describeAlarmHistoryAsync(final DescribeAlarmHistoryRequest request, final AsyncHandler<DescribeAlarmHistoryRequest, DescribeAlarmHistoryResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeAlarmHistoryResult>(){

            @Override
            public DescribeAlarmHistoryResult call() throws Exception {
                DescribeAlarmHistoryResult result;
                try {
                    result = AmazonCloudWatchAsyncClient.this.describeAlarmHistory(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAlarmHistoryResult> describeAlarmHistoryAsync() {
        return this.describeAlarmHistoryAsync(new DescribeAlarmHistoryRequest());
    }

    @Override
    public Future<DescribeAlarmHistoryResult> describeAlarmHistoryAsync(AsyncHandler<DescribeAlarmHistoryRequest, DescribeAlarmHistoryResult> asyncHandler) {
        return this.describeAlarmHistoryAsync(new DescribeAlarmHistoryRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeAlarmsResult> describeAlarmsAsync(DescribeAlarmsRequest request) {
        return this.describeAlarmsAsync(request, null);
    }

    @Override
    public Future<DescribeAlarmsResult> describeAlarmsAsync(final DescribeAlarmsRequest request, final AsyncHandler<DescribeAlarmsRequest, DescribeAlarmsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeAlarmsResult>(){

            @Override
            public DescribeAlarmsResult call() throws Exception {
                DescribeAlarmsResult result;
                try {
                    result = AmazonCloudWatchAsyncClient.this.describeAlarms(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAlarmsResult> describeAlarmsAsync() {
        return this.describeAlarmsAsync(new DescribeAlarmsRequest());
    }

    @Override
    public Future<DescribeAlarmsResult> describeAlarmsAsync(AsyncHandler<DescribeAlarmsRequest, DescribeAlarmsResult> asyncHandler) {
        return this.describeAlarmsAsync(new DescribeAlarmsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeAlarmsForMetricResult> describeAlarmsForMetricAsync(DescribeAlarmsForMetricRequest request) {
        return this.describeAlarmsForMetricAsync(request, null);
    }

    @Override
    public Future<DescribeAlarmsForMetricResult> describeAlarmsForMetricAsync(final DescribeAlarmsForMetricRequest request, final AsyncHandler<DescribeAlarmsForMetricRequest, DescribeAlarmsForMetricResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeAlarmsForMetricResult>(){

            @Override
            public DescribeAlarmsForMetricResult call() throws Exception {
                DescribeAlarmsForMetricResult result;
                try {
                    result = AmazonCloudWatchAsyncClient.this.describeAlarmsForMetric(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisableAlarmActionsResult> disableAlarmActionsAsync(DisableAlarmActionsRequest request) {
        return this.disableAlarmActionsAsync(request, null);
    }

    @Override
    public Future<DisableAlarmActionsResult> disableAlarmActionsAsync(final DisableAlarmActionsRequest request, final AsyncHandler<DisableAlarmActionsRequest, DisableAlarmActionsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DisableAlarmActionsResult>(){

            @Override
            public DisableAlarmActionsResult call() throws Exception {
                DisableAlarmActionsResult result;
                try {
                    result = AmazonCloudWatchAsyncClient.this.disableAlarmActions(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EnableAlarmActionsResult> enableAlarmActionsAsync(EnableAlarmActionsRequest request) {
        return this.enableAlarmActionsAsync(request, null);
    }

    @Override
    public Future<EnableAlarmActionsResult> enableAlarmActionsAsync(final EnableAlarmActionsRequest request, final AsyncHandler<EnableAlarmActionsRequest, EnableAlarmActionsResult> asyncHandler) {
        return this.executorService.submit(new Callable<EnableAlarmActionsResult>(){

            @Override
            public EnableAlarmActionsResult call() throws Exception {
                EnableAlarmActionsResult result;
                try {
                    result = AmazonCloudWatchAsyncClient.this.enableAlarmActions(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetMetricStatisticsResult> getMetricStatisticsAsync(GetMetricStatisticsRequest request) {
        return this.getMetricStatisticsAsync(request, null);
    }

    @Override
    public Future<GetMetricStatisticsResult> getMetricStatisticsAsync(final GetMetricStatisticsRequest request, final AsyncHandler<GetMetricStatisticsRequest, GetMetricStatisticsResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetMetricStatisticsResult>(){

            @Override
            public GetMetricStatisticsResult call() throws Exception {
                GetMetricStatisticsResult result;
                try {
                    result = AmazonCloudWatchAsyncClient.this.getMetricStatistics(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListMetricsResult> listMetricsAsync(ListMetricsRequest request) {
        return this.listMetricsAsync(request, null);
    }

    @Override
    public Future<ListMetricsResult> listMetricsAsync(final ListMetricsRequest request, final AsyncHandler<ListMetricsRequest, ListMetricsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListMetricsResult>(){

            @Override
            public ListMetricsResult call() throws Exception {
                ListMetricsResult result;
                try {
                    result = AmazonCloudWatchAsyncClient.this.listMetrics(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListMetricsResult> listMetricsAsync() {
        return this.listMetricsAsync(new ListMetricsRequest());
    }

    @Override
    public Future<ListMetricsResult> listMetricsAsync(AsyncHandler<ListMetricsRequest, ListMetricsResult> asyncHandler) {
        return this.listMetricsAsync(new ListMetricsRequest(), asyncHandler);
    }

    @Override
    public Future<PutMetricAlarmResult> putMetricAlarmAsync(PutMetricAlarmRequest request) {
        return this.putMetricAlarmAsync(request, null);
    }

    @Override
    public Future<PutMetricAlarmResult> putMetricAlarmAsync(final PutMetricAlarmRequest request, final AsyncHandler<PutMetricAlarmRequest, PutMetricAlarmResult> asyncHandler) {
        return this.executorService.submit(new Callable<PutMetricAlarmResult>(){

            @Override
            public PutMetricAlarmResult call() throws Exception {
                PutMetricAlarmResult result;
                try {
                    result = AmazonCloudWatchAsyncClient.this.putMetricAlarm(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutMetricDataResult> putMetricDataAsync(PutMetricDataRequest request) {
        return this.putMetricDataAsync(request, null);
    }

    @Override
    public Future<PutMetricDataResult> putMetricDataAsync(final PutMetricDataRequest request, final AsyncHandler<PutMetricDataRequest, PutMetricDataResult> asyncHandler) {
        return this.executorService.submit(new Callable<PutMetricDataResult>(){

            @Override
            public PutMetricDataResult call() throws Exception {
                PutMetricDataResult result;
                try {
                    result = AmazonCloudWatchAsyncClient.this.putMetricData(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SetAlarmStateResult> setAlarmStateAsync(SetAlarmStateRequest request) {
        return this.setAlarmStateAsync(request, null);
    }

    @Override
    public Future<SetAlarmStateResult> setAlarmStateAsync(final SetAlarmStateRequest request, final AsyncHandler<SetAlarmStateRequest, SetAlarmStateResult> asyncHandler) {
        return this.executorService.submit(new Callable<SetAlarmStateResult>(){

            @Override
            public SetAlarmStateResult call() throws Exception {
                SetAlarmStateResult result;
                try {
                    result = AmazonCloudWatchAsyncClient.this.setAlarmState(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

