/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.cloudwatch.waiters.AlarmExists;
import com.amazonaws.services.cloudwatch.waiters.DescribeAlarmsFunction;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.SdkFunction;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class AmazonCloudWatchWaiters {
    private final AmazonCloudWatch client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public AmazonCloudWatchWaiters(AmazonCloudWatch client) {
        this.client = client;
    }

    public Waiter alarmExists() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeAlarmsFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new AlarmExists.IsTrueMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }
}

