/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.MetricDatum;
import com.amazonaws.services.cloudwatch.model.PutMetricDataRequest;
import com.amazonaws.services.cloudwatch.model.StatisticSet;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Date;

public class PutMetricDataRequestMarshaller
implements Marshaller<Request<PutMetricDataRequest>, PutMetricDataRequest> {
    public Request<PutMetricDataRequest> marshall(PutMetricDataRequest putMetricDataRequest) {
        if (putMetricDataRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putMetricDataRequest, "AmazonCloudWatch");
        request.addParameter("Action", "PutMetricData");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (putMetricDataRequest.getNamespace() != null) {
            request.addParameter("Namespace", StringUtils.fromString((String)putMetricDataRequest.getNamespace()));
        }
        if (!putMetricDataRequest.getMetricData().isEmpty() || !((SdkInternalList)putMetricDataRequest.getMetricData()).isAutoConstruct()) {
            SdkInternalList metricDataList = (SdkInternalList)putMetricDataRequest.getMetricData();
            int metricDataListIndex = 1;
            for (MetricDatum metricDataListValue : metricDataList) {
                StatisticSet statisticValues;
                if (metricDataListValue.getMetricName() != null) {
                    request.addParameter("MetricData.member." + metricDataListIndex + ".MetricName", StringUtils.fromString((String)metricDataListValue.getMetricName()));
                }
                if (!metricDataListValue.getDimensions().isEmpty() || !((SdkInternalList)metricDataListValue.getDimensions()).isAutoConstruct()) {
                    SdkInternalList dimensionsList = (SdkInternalList)metricDataListValue.getDimensions();
                    int dimensionsListIndex = 1;
                    for (Dimension dimensionsListValue : dimensionsList) {
                        if (dimensionsListValue.getName() != null) {
                            request.addParameter("MetricData.member." + metricDataListIndex + ".Dimensions.member." + dimensionsListIndex + ".Name", StringUtils.fromString((String)dimensionsListValue.getName()));
                        }
                        if (dimensionsListValue.getValue() != null) {
                            request.addParameter("MetricData.member." + metricDataListIndex + ".Dimensions.member." + dimensionsListIndex + ".Value", StringUtils.fromString((String)dimensionsListValue.getValue()));
                        }
                        ++dimensionsListIndex;
                    }
                }
                if (metricDataListValue.getTimestamp() != null) {
                    request.addParameter("MetricData.member." + metricDataListIndex + ".Timestamp", StringUtils.fromDate((Date)metricDataListValue.getTimestamp()));
                }
                if (metricDataListValue.getValue() != null) {
                    request.addParameter("MetricData.member." + metricDataListIndex + ".Value", StringUtils.fromDouble((Double)metricDataListValue.getValue()));
                }
                if ((statisticValues = metricDataListValue.getStatisticValues()) != null) {
                    if (statisticValues.getSampleCount() != null) {
                        request.addParameter("MetricData.member." + metricDataListIndex + ".StatisticValues.SampleCount", StringUtils.fromDouble((Double)statisticValues.getSampleCount()));
                    }
                    if (statisticValues.getSum() != null) {
                        request.addParameter("MetricData.member." + metricDataListIndex + ".StatisticValues.Sum", StringUtils.fromDouble((Double)statisticValues.getSum()));
                    }
                    if (statisticValues.getMinimum() != null) {
                        request.addParameter("MetricData.member." + metricDataListIndex + ".StatisticValues.Minimum", StringUtils.fromDouble((Double)statisticValues.getMinimum()));
                    }
                    if (statisticValues.getMaximum() != null) {
                        request.addParameter("MetricData.member." + metricDataListIndex + ".StatisticValues.Maximum", StringUtils.fromDouble((Double)statisticValues.getMaximum()));
                    }
                }
                if (metricDataListValue.getUnit() != null) {
                    request.addParameter("MetricData.member." + metricDataListIndex + ".Unit", StringUtils.fromString((String)metricDataListValue.getUnit()));
                }
                if (metricDataListValue.getStorageResolution() != null) {
                    request.addParameter("MetricData.member." + metricDataListIndex + ".StorageResolution", StringUtils.fromInteger((Integer)metricDataListValue.getStorageResolution()));
                }
                ++metricDataListIndex;
            }
        }
        return request;
    }
}

