/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.services.cloudwatch.model.Datapoint;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class DatapointStaxUnmarshaller
implements Unmarshaller<Datapoint, StaxUnmarshallerContext> {
    private static DatapointStaxUnmarshaller instance;

    public Datapoint unmarshall(StaxUnmarshallerContext context) throws Exception {
        Datapoint datapoint = new Datapoint();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return datapoint;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Timestamp", targetDepth)) {
                    datapoint.setTimestamp(SimpleTypeStaxUnmarshallers.DateStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SampleCount", targetDepth)) {
                    datapoint.setSampleCount(SimpleTypeStaxUnmarshallers.DoubleStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Average", targetDepth)) {
                    datapoint.setAverage(SimpleTypeStaxUnmarshallers.DoubleStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Sum", targetDepth)) {
                    datapoint.setSum(SimpleTypeStaxUnmarshallers.DoubleStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Minimum", targetDepth)) {
                    datapoint.setMinimum(SimpleTypeStaxUnmarshallers.DoubleStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Maximum", targetDepth)) {
                    datapoint.setMaximum(SimpleTypeStaxUnmarshallers.DoubleStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Unit", targetDepth)) continue;
                datapoint.setUnit(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return datapoint;
    }

    public static DatapointStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DatapointStaxUnmarshaller();
        }
        return instance;
    }
}

