/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.Metric;
import com.amazonaws.services.cloudwatch.model.MetricDataQuery;
import com.amazonaws.services.cloudwatch.model.MetricStat;
import com.amazonaws.services.cloudwatch.model.PutMetricAlarmRequest;
import com.amazonaws.services.cloudwatch.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class PutMetricAlarmRequestMarshaller
implements Marshaller<Request<PutMetricAlarmRequest>, PutMetricAlarmRequest> {
    public Request<PutMetricAlarmRequest> marshall(PutMetricAlarmRequest putMetricAlarmRequest) {
        if (putMetricAlarmRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putMetricAlarmRequest, "AmazonCloudWatch");
        request.addParameter("Action", "PutMetricAlarm");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (putMetricAlarmRequest.getAlarmName() != null) {
            request.addParameter("AlarmName", StringUtils.fromString((String)putMetricAlarmRequest.getAlarmName()));
        }
        if (putMetricAlarmRequest.getAlarmDescription() != null) {
            request.addParameter("AlarmDescription", StringUtils.fromString((String)putMetricAlarmRequest.getAlarmDescription()));
        }
        if (putMetricAlarmRequest.getActionsEnabled() != null) {
            request.addParameter("ActionsEnabled", StringUtils.fromBoolean((Boolean)putMetricAlarmRequest.getActionsEnabled()));
        }
        if (!putMetricAlarmRequest.getOKActions().isEmpty() || !((SdkInternalList)putMetricAlarmRequest.getOKActions()).isAutoConstruct()) {
            SdkInternalList oKActionsList = (SdkInternalList)putMetricAlarmRequest.getOKActions();
            int oKActionsListIndex = 1;
            for (String oKActionsListValue : oKActionsList) {
                if (oKActionsListValue != null) {
                    request.addParameter("OKActions.member." + oKActionsListIndex, StringUtils.fromString((String)oKActionsListValue));
                }
                ++oKActionsListIndex;
            }
        }
        if (!putMetricAlarmRequest.getAlarmActions().isEmpty() || !((SdkInternalList)putMetricAlarmRequest.getAlarmActions()).isAutoConstruct()) {
            SdkInternalList alarmActionsList = (SdkInternalList)putMetricAlarmRequest.getAlarmActions();
            int alarmActionsListIndex = 1;
            for (String alarmActionsListValue : alarmActionsList) {
                if (alarmActionsListValue != null) {
                    request.addParameter("AlarmActions.member." + alarmActionsListIndex, StringUtils.fromString((String)alarmActionsListValue));
                }
                ++alarmActionsListIndex;
            }
        }
        if (!putMetricAlarmRequest.getInsufficientDataActions().isEmpty() || !((SdkInternalList)putMetricAlarmRequest.getInsufficientDataActions()).isAutoConstruct()) {
            SdkInternalList insufficientDataActionsList = (SdkInternalList)putMetricAlarmRequest.getInsufficientDataActions();
            int insufficientDataActionsListIndex = 1;
            for (String insufficientDataActionsListValue : insufficientDataActionsList) {
                if (insufficientDataActionsListValue != null) {
                    request.addParameter("InsufficientDataActions.member." + insufficientDataActionsListIndex, StringUtils.fromString((String)insufficientDataActionsListValue));
                }
                ++insufficientDataActionsListIndex;
            }
        }
        if (putMetricAlarmRequest.getMetricName() != null) {
            request.addParameter("MetricName", StringUtils.fromString((String)putMetricAlarmRequest.getMetricName()));
        }
        if (putMetricAlarmRequest.getNamespace() != null) {
            request.addParameter("Namespace", StringUtils.fromString((String)putMetricAlarmRequest.getNamespace()));
        }
        if (putMetricAlarmRequest.getStatistic() != null) {
            request.addParameter("Statistic", StringUtils.fromString((String)putMetricAlarmRequest.getStatistic()));
        }
        if (putMetricAlarmRequest.getExtendedStatistic() != null) {
            request.addParameter("ExtendedStatistic", StringUtils.fromString((String)putMetricAlarmRequest.getExtendedStatistic()));
        }
        if (!putMetricAlarmRequest.getDimensions().isEmpty() || !((SdkInternalList)putMetricAlarmRequest.getDimensions()).isAutoConstruct()) {
            SdkInternalList dimensionsList = (SdkInternalList)putMetricAlarmRequest.getDimensions();
            int dimensionsListIndex = 1;
            for (Dimension dimensionsListValue : dimensionsList) {
                if (dimensionsListValue.getName() != null) {
                    request.addParameter("Dimensions.member." + dimensionsListIndex + ".Name", StringUtils.fromString((String)dimensionsListValue.getName()));
                }
                if (dimensionsListValue.getValue() != null) {
                    request.addParameter("Dimensions.member." + dimensionsListIndex + ".Value", StringUtils.fromString((String)dimensionsListValue.getValue()));
                }
                ++dimensionsListIndex;
            }
        }
        if (putMetricAlarmRequest.getPeriod() != null) {
            request.addParameter("Period", StringUtils.fromInteger((Integer)putMetricAlarmRequest.getPeriod()));
        }
        if (putMetricAlarmRequest.getUnit() != null) {
            request.addParameter("Unit", StringUtils.fromString((String)putMetricAlarmRequest.getUnit()));
        }
        if (putMetricAlarmRequest.getEvaluationPeriods() != null) {
            request.addParameter("EvaluationPeriods", StringUtils.fromInteger((Integer)putMetricAlarmRequest.getEvaluationPeriods()));
        }
        if (putMetricAlarmRequest.getDatapointsToAlarm() != null) {
            request.addParameter("DatapointsToAlarm", StringUtils.fromInteger((Integer)putMetricAlarmRequest.getDatapointsToAlarm()));
        }
        if (putMetricAlarmRequest.getThreshold() != null) {
            request.addParameter("Threshold", StringUtils.fromDouble((Double)putMetricAlarmRequest.getThreshold()));
        }
        if (putMetricAlarmRequest.getComparisonOperator() != null) {
            request.addParameter("ComparisonOperator", StringUtils.fromString((String)putMetricAlarmRequest.getComparisonOperator()));
        }
        if (putMetricAlarmRequest.getTreatMissingData() != null) {
            request.addParameter("TreatMissingData", StringUtils.fromString((String)putMetricAlarmRequest.getTreatMissingData()));
        }
        if (putMetricAlarmRequest.getEvaluateLowSampleCountPercentile() != null) {
            request.addParameter("EvaluateLowSampleCountPercentile", StringUtils.fromString((String)putMetricAlarmRequest.getEvaluateLowSampleCountPercentile()));
        }
        if (!putMetricAlarmRequest.getMetrics().isEmpty() || !((SdkInternalList)putMetricAlarmRequest.getMetrics()).isAutoConstruct()) {
            SdkInternalList metricsList = (SdkInternalList)putMetricAlarmRequest.getMetrics();
            int metricsListIndex = 1;
            for (MetricDataQuery metricsListValue : metricsList) {
                MetricStat metricStat;
                if (metricsListValue.getId() != null) {
                    request.addParameter("Metrics.member." + metricsListIndex + ".Id", StringUtils.fromString((String)metricsListValue.getId()));
                }
                if ((metricStat = metricsListValue.getMetricStat()) != null) {
                    Metric metric = metricStat.getMetric();
                    if (metric != null) {
                        if (metric.getNamespace() != null) {
                            request.addParameter("Metrics.member." + metricsListIndex + ".MetricStat.Metric.Namespace", StringUtils.fromString((String)metric.getNamespace()));
                        }
                        if (metric.getMetricName() != null) {
                            request.addParameter("Metrics.member." + metricsListIndex + ".MetricStat.Metric.MetricName", StringUtils.fromString((String)metric.getMetricName()));
                        }
                        if (!metric.getDimensions().isEmpty() || !((SdkInternalList)metric.getDimensions()).isAutoConstruct()) {
                            SdkInternalList dimensionsList = (SdkInternalList)metric.getDimensions();
                            int dimensionsListIndex = 1;
                            for (Dimension dimensionsListValue : dimensionsList) {
                                if (dimensionsListValue.getName() != null) {
                                    request.addParameter("Metrics.member." + metricsListIndex + ".MetricStat.Metric.Dimensions.member." + dimensionsListIndex + ".Name", StringUtils.fromString((String)dimensionsListValue.getName()));
                                }
                                if (dimensionsListValue.getValue() != null) {
                                    request.addParameter("Metrics.member." + metricsListIndex + ".MetricStat.Metric.Dimensions.member." + dimensionsListIndex + ".Value", StringUtils.fromString((String)dimensionsListValue.getValue()));
                                }
                                ++dimensionsListIndex;
                            }
                        }
                    }
                    if (metricStat.getPeriod() != null) {
                        request.addParameter("Metrics.member." + metricsListIndex + ".MetricStat.Period", StringUtils.fromInteger((Integer)metricStat.getPeriod()));
                    }
                    if (metricStat.getStat() != null) {
                        request.addParameter("Metrics.member." + metricsListIndex + ".MetricStat.Stat", StringUtils.fromString((String)metricStat.getStat()));
                    }
                    if (metricStat.getUnit() != null) {
                        request.addParameter("Metrics.member." + metricsListIndex + ".MetricStat.Unit", StringUtils.fromString((String)metricStat.getUnit()));
                    }
                }
                if (metricsListValue.getExpression() != null) {
                    request.addParameter("Metrics.member." + metricsListIndex + ".Expression", StringUtils.fromString((String)metricsListValue.getExpression()));
                }
                if (metricsListValue.getLabel() != null) {
                    request.addParameter("Metrics.member." + metricsListIndex + ".Label", StringUtils.fromString((String)metricsListValue.getLabel()));
                }
                if (metricsListValue.getReturnData() != null) {
                    request.addParameter("Metrics.member." + metricsListIndex + ".ReturnData", StringUtils.fromBoolean((Boolean)metricsListValue.getReturnData()));
                }
                ++metricsListIndex;
            }
        }
        if (!putMetricAlarmRequest.getTags().isEmpty() || !((SdkInternalList)putMetricAlarmRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)putMetricAlarmRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.getKey() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                }
                if (tagsListValue.getValue() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

